/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateDataSourceRequest extends KendraRequest implements
        ToCopyableBuilder<CreateDataSourceRequest.Builder, CreateDataSourceRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreateDataSourceRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> INDEX_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IndexId").getter(getter(CreateDataSourceRequest::indexId)).setter(setter(Builder::indexId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexId").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(CreateDataSourceRequest::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<DataSourceConfiguration> CONFIGURATION_FIELD = SdkField
            .<DataSourceConfiguration> builder(MarshallingType.SDK_POJO).memberName("Configuration")
            .getter(getter(CreateDataSourceRequest::configuration)).setter(setter(Builder::configuration))
            .constructor(DataSourceConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Configuration").build()).build();

    private static final SdkField<DataSourceVpcConfiguration> VPC_CONFIGURATION_FIELD = SdkField
            .<DataSourceVpcConfiguration> builder(MarshallingType.SDK_POJO).memberName("VpcConfiguration")
            .getter(getter(CreateDataSourceRequest::vpcConfiguration)).setter(setter(Builder::vpcConfiguration))
            .constructor(DataSourceVpcConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcConfiguration").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CreateDataSourceRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> SCHEDULE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Schedule").getter(getter(CreateDataSourceRequest::schedule)).setter(setter(Builder::schedule))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Schedule").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(CreateDataSourceRequest::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateDataSourceRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(CreateDataSourceRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> LANGUAGE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LanguageCode").getter(getter(CreateDataSourceRequest::languageCode))
            .setter(setter(Builder::languageCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LanguageCode").build()).build();

    private static final SdkField<CustomDocumentEnrichmentConfiguration> CUSTOM_DOCUMENT_ENRICHMENT_CONFIGURATION_FIELD = SdkField
            .<CustomDocumentEnrichmentConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("CustomDocumentEnrichmentConfiguration")
            .getter(getter(CreateDataSourceRequest::customDocumentEnrichmentConfiguration))
            .setter(setter(Builder::customDocumentEnrichmentConfiguration))
            .constructor(CustomDocumentEnrichmentConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("CustomDocumentEnrichmentConfiguration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, INDEX_ID_FIELD,
            TYPE_FIELD, CONFIGURATION_FIELD, VPC_CONFIGURATION_FIELD, DESCRIPTION_FIELD, SCHEDULE_FIELD, ROLE_ARN_FIELD,
            TAGS_FIELD, CLIENT_TOKEN_FIELD, LANGUAGE_CODE_FIELD, CUSTOM_DOCUMENT_ENRICHMENT_CONFIGURATION_FIELD));

    private final String name;

    private final String indexId;

    private final String type;

    private final DataSourceConfiguration configuration;

    private final DataSourceVpcConfiguration vpcConfiguration;

    private final String description;

    private final String schedule;

    private final String roleArn;

    private final List<Tag> tags;

    private final String clientToken;

    private final String languageCode;

    private final CustomDocumentEnrichmentConfiguration customDocumentEnrichmentConfiguration;

    private CreateDataSourceRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.indexId = builder.indexId;
        this.type = builder.type;
        this.configuration = builder.configuration;
        this.vpcConfiguration = builder.vpcConfiguration;
        this.description = builder.description;
        this.schedule = builder.schedule;
        this.roleArn = builder.roleArn;
        this.tags = builder.tags;
        this.clientToken = builder.clientToken;
        this.languageCode = builder.languageCode;
        this.customDocumentEnrichmentConfiguration = builder.customDocumentEnrichmentConfiguration;
    }

    /**
     * <p>
     * A name for the data source connector.
     * </p>
     * 
     * @return A name for the data source connector.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The identifier of the index you want to use with the data source connector.
     * </p>
     * 
     * @return The identifier of the index you want to use with the data source connector.
     */
    public final String indexId() {
        return indexId;
    }

    /**
     * <p>
     * The type of data source repository. For example, <code>SHAREPOINT</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link DataSourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of data source repository. For example, <code>SHAREPOINT</code>.
     * @see DataSourceType
     */
    public final DataSourceType type() {
        return DataSourceType.fromValue(type);
    }

    /**
     * <p>
     * The type of data source repository. For example, <code>SHAREPOINT</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link DataSourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of data source repository. For example, <code>SHAREPOINT</code>.
     * @see DataSourceType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * Configuration information to connect to your data source repository.
     * </p>
     * <p>
     * You can't specify the <code>Configuration</code> parameter when the <code>Type</code> parameter is set to
     * <code>CUSTOM</code>. If you do, you receive a <code>ValidationException</code> exception.
     * </p>
     * <p>
     * The <code>Configuration</code> parameter is required for all other data sources.
     * </p>
     * 
     * @return Configuration information to connect to your data source repository.</p>
     *         <p>
     *         You can't specify the <code>Configuration</code> parameter when the <code>Type</code> parameter is set to
     *         <code>CUSTOM</code>. If you do, you receive a <code>ValidationException</code> exception.
     *         </p>
     *         <p>
     *         The <code>Configuration</code> parameter is required for all other data sources.
     */
    public final DataSourceConfiguration configuration() {
        return configuration;
    }

    /**
     * <p>
     * Configuration information for an Amazon Virtual Private Cloud to connect to your data source. For more
     * information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/vpc-configuration.html">Configuring a
     * VPC</a>.
     * </p>
     * 
     * @return Configuration information for an Amazon Virtual Private Cloud to connect to your data source. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/kendra/latest/dg/vpc-configuration.html">Configuring a VPC</a>.
     */
    public final DataSourceVpcConfiguration vpcConfiguration() {
        return vpcConfiguration;
    }

    /**
     * <p>
     * A description for the data source connector.
     * </p>
     * 
     * @return A description for the data source connector.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Sets the frequency for Amazon Kendra to check the documents in your data source repository and update the index.
     * If you don't set a schedule Amazon Kendra will not periodically update the index. You can call the
     * <code>StartDataSourceSyncJob</code> API to update the index.
     * </p>
     * <p>
     * You can't specify the <code>Schedule</code> parameter when the <code>Type</code> parameter is set to
     * <code>CUSTOM</code>. If you do, you receive a <code>ValidationException</code> exception.
     * </p>
     * 
     * @return Sets the frequency for Amazon Kendra to check the documents in your data source repository and update the
     *         index. If you don't set a schedule Amazon Kendra will not periodically update the index. You can call the
     *         <code>StartDataSourceSyncJob</code> API to update the index.</p>
     *         <p>
     *         You can't specify the <code>Schedule</code> parameter when the <code>Type</code> parameter is set to
     *         <code>CUSTOM</code>. If you do, you receive a <code>ValidationException</code> exception.
     */
    public final String schedule() {
        return schedule;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of a role with permission to access the data source connector. For more
     * information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html">IAM Roles for Amazon
     * Kendra</a>.
     * </p>
     * <p>
     * You can't specify the <code>RoleArn</code> parameter when the <code>Type</code> parameter is set to
     * <code>CUSTOM</code>. If you do, you receive a <code>ValidationException</code> exception.
     * </p>
     * <p>
     * The <code>RoleArn</code> parameter is required for all other data sources.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of a role with permission to access the data source connector. For more
     *         information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html">IAM Roles for
     *         Amazon Kendra</a>.</p>
     *         <p>
     *         You can't specify the <code>RoleArn</code> parameter when the <code>Type</code> parameter is set to
     *         <code>CUSTOM</code>. If you do, you receive a <code>ValidationException</code> exception.
     *         </p>
     *         <p>
     *         The <code>RoleArn</code> parameter is required for all other data sources.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of key-value pairs that identify the data source connector. You can use the tags to identify and organize
     * your resources and to control access to resources.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A list of key-value pairs that identify the data source connector. You can use the tags to identify and
     *         organize your resources and to control access to resources.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * A token that you provide to identify the request to create a data source connector. Multiple calls to the
     * <code>CreateDataSource</code> API with the same client token will create only one data source connector.
     * </p>
     * 
     * @return A token that you provide to identify the request to create a data source connector. Multiple calls to the
     *         <code>CreateDataSource</code> API with the same client token will create only one data source connector.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The code for a language. This allows you to support a language for all documents when creating the data source
     * connector. English is supported by default. For more information on supported languages, including their codes,
     * see <a href="https://docs.aws.amazon.com/kendra/latest/dg/in-adding-languages.html">Adding documents in languages
     * other than English</a>.
     * </p>
     * 
     * @return The code for a language. This allows you to support a language for all documents when creating the data
     *         source connector. English is supported by default. For more information on supported languages, including
     *         their codes, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/in-adding-languages.html">Adding
     *         documents in languages other than English</a>.
     */
    public final String languageCode() {
        return languageCode;
    }

    /**
     * <p>
     * Configuration information for altering document metadata and content during the document ingestion process.
     * </p>
     * <p>
     * For more information on how to create, modify and delete document metadata, or make other content alterations
     * when you ingest documents into Amazon Kendra, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/custom-document-enrichment.html">Customizing document metadata
     * during the ingestion process</a>.
     * </p>
     * 
     * @return Configuration information for altering document metadata and content during the document ingestion
     *         process.</p>
     *         <p>
     *         For more information on how to create, modify and delete document metadata, or make other content
     *         alterations when you ingest documents into Amazon Kendra, see <a
     *         href="https://docs.aws.amazon.com/kendra/latest/dg/custom-document-enrichment.html">Customizing document
     *         metadata during the ingestion process</a>.
     */
    public final CustomDocumentEnrichmentConfiguration customDocumentEnrichmentConfiguration() {
        return customDocumentEnrichmentConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(indexId());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(configuration());
        hashCode = 31 * hashCode + Objects.hashCode(vpcConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(schedule());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(languageCode());
        hashCode = 31 * hashCode + Objects.hashCode(customDocumentEnrichmentConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDataSourceRequest)) {
            return false;
        }
        CreateDataSourceRequest other = (CreateDataSourceRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(indexId(), other.indexId())
                && Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(configuration(), other.configuration())
                && Objects.equals(vpcConfiguration(), other.vpcConfiguration())
                && Objects.equals(description(), other.description()) && Objects.equals(schedule(), other.schedule())
                && Objects.equals(roleArn(), other.roleArn()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(languageCode(), other.languageCode())
                && Objects.equals(customDocumentEnrichmentConfiguration(), other.customDocumentEnrichmentConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateDataSourceRequest").add("Name", name()).add("IndexId", indexId())
                .add("Type", typeAsString()).add("Configuration", configuration()).add("VpcConfiguration", vpcConfiguration())
                .add("Description", description()).add("Schedule", schedule()).add("RoleArn", roleArn())
                .add("Tags", hasTags() ? tags() : null).add("ClientToken", clientToken()).add("LanguageCode", languageCode())
                .add("CustomDocumentEnrichmentConfiguration", customDocumentEnrichmentConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "IndexId":
            return Optional.ofNullable(clazz.cast(indexId()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "Configuration":
            return Optional.ofNullable(clazz.cast(configuration()));
        case "VpcConfiguration":
            return Optional.ofNullable(clazz.cast(vpcConfiguration()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Schedule":
            return Optional.ofNullable(clazz.cast(schedule()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "LanguageCode":
            return Optional.ofNullable(clazz.cast(languageCode()));
        case "CustomDocumentEnrichmentConfiguration":
            return Optional.ofNullable(clazz.cast(customDocumentEnrichmentConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateDataSourceRequest, T> g) {
        return obj -> g.apply((CreateDataSourceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KendraRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateDataSourceRequest> {
        /**
         * <p>
         * A name for the data source connector.
         * </p>
         * 
         * @param name
         *        A name for the data source connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The identifier of the index you want to use with the data source connector.
         * </p>
         * 
         * @param indexId
         *        The identifier of the index you want to use with the data source connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexId(String indexId);

        /**
         * <p>
         * The type of data source repository. For example, <code>SHAREPOINT</code>.
         * </p>
         * 
         * @param type
         *        The type of data source repository. For example, <code>SHAREPOINT</code>.
         * @see DataSourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataSourceType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of data source repository. For example, <code>SHAREPOINT</code>.
         * </p>
         * 
         * @param type
         *        The type of data source repository. For example, <code>SHAREPOINT</code>.
         * @see DataSourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataSourceType
         */
        Builder type(DataSourceType type);

        /**
         * <p>
         * Configuration information to connect to your data source repository.
         * </p>
         * <p>
         * You can't specify the <code>Configuration</code> parameter when the <code>Type</code> parameter is set to
         * <code>CUSTOM</code>. If you do, you receive a <code>ValidationException</code> exception.
         * </p>
         * <p>
         * The <code>Configuration</code> parameter is required for all other data sources.
         * </p>
         * 
         * @param configuration
         *        Configuration information to connect to your data source repository.</p>
         *        <p>
         *        You can't specify the <code>Configuration</code> parameter when the <code>Type</code> parameter is set
         *        to <code>CUSTOM</code>. If you do, you receive a <code>ValidationException</code> exception.
         *        </p>
         *        <p>
         *        The <code>Configuration</code> parameter is required for all other data sources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuration(DataSourceConfiguration configuration);

        /**
         * <p>
         * Configuration information to connect to your data source repository.
         * </p>
         * <p>
         * You can't specify the <code>Configuration</code> parameter when the <code>Type</code> parameter is set to
         * <code>CUSTOM</code>. If you do, you receive a <code>ValidationException</code> exception.
         * </p>
         * <p>
         * The <code>Configuration</code> parameter is required for all other data sources.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataSourceConfiguration.Builder} avoiding
         * the need to create one manually via {@link DataSourceConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link DataSourceConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #configuration(DataSourceConfiguration)}.
         * 
         * @param configuration
         *        a consumer that will call methods on {@link DataSourceConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configuration(DataSourceConfiguration)
         */
        default Builder configuration(Consumer<DataSourceConfiguration.Builder> configuration) {
            return configuration(DataSourceConfiguration.builder().applyMutation(configuration).build());
        }

        /**
         * <p>
         * Configuration information for an Amazon Virtual Private Cloud to connect to your data source. For more
         * information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/vpc-configuration.html">Configuring a
         * VPC</a>.
         * </p>
         * 
         * @param vpcConfiguration
         *        Configuration information for an Amazon Virtual Private Cloud to connect to your data source. For more
         *        information, see <a
         *        href="https://docs.aws.amazon.com/kendra/latest/dg/vpc-configuration.html">Configuring a VPC</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcConfiguration(DataSourceVpcConfiguration vpcConfiguration);

        /**
         * <p>
         * Configuration information for an Amazon Virtual Private Cloud to connect to your data source. For more
         * information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/vpc-configuration.html">Configuring a
         * VPC</a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataSourceVpcConfiguration.Builder}
         * avoiding the need to create one manually via {@link DataSourceVpcConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link DataSourceVpcConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #vpcConfiguration(DataSourceVpcConfiguration)}.
         * 
         * @param vpcConfiguration
         *        a consumer that will call methods on {@link DataSourceVpcConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcConfiguration(DataSourceVpcConfiguration)
         */
        default Builder vpcConfiguration(Consumer<DataSourceVpcConfiguration.Builder> vpcConfiguration) {
            return vpcConfiguration(DataSourceVpcConfiguration.builder().applyMutation(vpcConfiguration).build());
        }

        /**
         * <p>
         * A description for the data source connector.
         * </p>
         * 
         * @param description
         *        A description for the data source connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Sets the frequency for Amazon Kendra to check the documents in your data source repository and update the
         * index. If you don't set a schedule Amazon Kendra will not periodically update the index. You can call the
         * <code>StartDataSourceSyncJob</code> API to update the index.
         * </p>
         * <p>
         * You can't specify the <code>Schedule</code> parameter when the <code>Type</code> parameter is set to
         * <code>CUSTOM</code>. If you do, you receive a <code>ValidationException</code> exception.
         * </p>
         * 
         * @param schedule
         *        Sets the frequency for Amazon Kendra to check the documents in your data source repository and update
         *        the index. If you don't set a schedule Amazon Kendra will not periodically update the index. You can
         *        call the <code>StartDataSourceSyncJob</code> API to update the index.</p>
         *        <p>
         *        You can't specify the <code>Schedule</code> parameter when the <code>Type</code> parameter is set to
         *        <code>CUSTOM</code>. If you do, you receive a <code>ValidationException</code> exception.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schedule(String schedule);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of a role with permission to access the data source connector. For more
         * information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html">IAM Roles for Amazon
         * Kendra</a>.
         * </p>
         * <p>
         * You can't specify the <code>RoleArn</code> parameter when the <code>Type</code> parameter is set to
         * <code>CUSTOM</code>. If you do, you receive a <code>ValidationException</code> exception.
         * </p>
         * <p>
         * The <code>RoleArn</code> parameter is required for all other data sources.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of a role with permission to access the data source connector. For more
         *        information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html">IAM Roles for
         *        Amazon Kendra</a>.</p>
         *        <p>
         *        You can't specify the <code>RoleArn</code> parameter when the <code>Type</code> parameter is set to
         *        <code>CUSTOM</code>. If you do, you receive a <code>ValidationException</code> exception.
         *        </p>
         *        <p>
         *        The <code>RoleArn</code> parameter is required for all other data sources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * A list of key-value pairs that identify the data source connector. You can use the tags to identify and
         * organize your resources and to control access to resources.
         * </p>
         * 
         * @param tags
         *        A list of key-value pairs that identify the data source connector. You can use the tags to identify
         *        and organize your resources and to control access to resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * A list of key-value pairs that identify the data source connector. You can use the tags to identify and
         * organize your resources and to control access to resources.
         * </p>
         * 
         * @param tags
         *        A list of key-value pairs that identify the data source connector. You can use the tags to identify
         *        and organize your resources and to control access to resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * A list of key-value pairs that identify the data source connector. You can use the tags to identify and
         * organize your resources and to control access to resources.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<Tag>.Builder} avoiding the need to
         * create one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * A token that you provide to identify the request to create a data source connector. Multiple calls to the
         * <code>CreateDataSource</code> API with the same client token will create only one data source connector.
         * </p>
         * 
         * @param clientToken
         *        A token that you provide to identify the request to create a data source connector. Multiple calls to
         *        the <code>CreateDataSource</code> API with the same client token will create only one data source
         *        connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The code for a language. This allows you to support a language for all documents when creating the data
         * source connector. English is supported by default. For more information on supported languages, including
         * their codes, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/in-adding-languages.html">Adding
         * documents in languages other than English</a>.
         * </p>
         * 
         * @param languageCode
         *        The code for a language. This allows you to support a language for all documents when creating the
         *        data source connector. English is supported by default. For more information on supported languages,
         *        including their codes, see <a
         *        href="https://docs.aws.amazon.com/kendra/latest/dg/in-adding-languages.html">Adding documents in
         *        languages other than English</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder languageCode(String languageCode);

        /**
         * <p>
         * Configuration information for altering document metadata and content during the document ingestion process.
         * </p>
         * <p>
         * For more information on how to create, modify and delete document metadata, or make other content alterations
         * when you ingest documents into Amazon Kendra, see <a
         * href="https://docs.aws.amazon.com/kendra/latest/dg/custom-document-enrichment.html">Customizing document
         * metadata during the ingestion process</a>.
         * </p>
         * 
         * @param customDocumentEnrichmentConfiguration
         *        Configuration information for altering document metadata and content during the document ingestion
         *        process.</p>
         *        <p>
         *        For more information on how to create, modify and delete document metadata, or make other content
         *        alterations when you ingest documents into Amazon Kendra, see <a
         *        href="https://docs.aws.amazon.com/kendra/latest/dg/custom-document-enrichment.html">Customizing
         *        document metadata during the ingestion process</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customDocumentEnrichmentConfiguration(CustomDocumentEnrichmentConfiguration customDocumentEnrichmentConfiguration);

        /**
         * <p>
         * Configuration information for altering document metadata and content during the document ingestion process.
         * </p>
         * <p>
         * For more information on how to create, modify and delete document metadata, or make other content alterations
         * when you ingest documents into Amazon Kendra, see <a
         * href="https://docs.aws.amazon.com/kendra/latest/dg/custom-document-enrichment.html">Customizing document
         * metadata during the ingestion process</a>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link CustomDocumentEnrichmentConfiguration.Builder} avoiding the need to create one manually via
         * {@link CustomDocumentEnrichmentConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link CustomDocumentEnrichmentConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #customDocumentEnrichmentConfiguration(CustomDocumentEnrichmentConfiguration)}.
         * 
         * @param customDocumentEnrichmentConfiguration
         *        a consumer that will call methods on {@link CustomDocumentEnrichmentConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customDocumentEnrichmentConfiguration(CustomDocumentEnrichmentConfiguration)
         */
        default Builder customDocumentEnrichmentConfiguration(
                Consumer<CustomDocumentEnrichmentConfiguration.Builder> customDocumentEnrichmentConfiguration) {
            return customDocumentEnrichmentConfiguration(CustomDocumentEnrichmentConfiguration.builder()
                    .applyMutation(customDocumentEnrichmentConfiguration).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends KendraRequest.BuilderImpl implements Builder {
        private String name;

        private String indexId;

        private String type;

        private DataSourceConfiguration configuration;

        private DataSourceVpcConfiguration vpcConfiguration;

        private String description;

        private String schedule;

        private String roleArn;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private String clientToken;

        private String languageCode;

        private CustomDocumentEnrichmentConfiguration customDocumentEnrichmentConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDataSourceRequest model) {
            super(model);
            name(model.name);
            indexId(model.indexId);
            type(model.type);
            configuration(model.configuration);
            vpcConfiguration(model.vpcConfiguration);
            description(model.description);
            schedule(model.schedule);
            roleArn(model.roleArn);
            tags(model.tags);
            clientToken(model.clientToken);
            languageCode(model.languageCode);
            customDocumentEnrichmentConfiguration(model.customDocumentEnrichmentConfiguration);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getIndexId() {
            return indexId;
        }

        public final void setIndexId(String indexId) {
            this.indexId = indexId;
        }

        @Override
        public final Builder indexId(String indexId) {
            this.indexId = indexId;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(DataSourceType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final DataSourceConfiguration.Builder getConfiguration() {
            return configuration != null ? configuration.toBuilder() : null;
        }

        public final void setConfiguration(DataSourceConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public final Builder configuration(DataSourceConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public final DataSourceVpcConfiguration.Builder getVpcConfiguration() {
            return vpcConfiguration != null ? vpcConfiguration.toBuilder() : null;
        }

        public final void setVpcConfiguration(DataSourceVpcConfiguration.BuilderImpl vpcConfiguration) {
            this.vpcConfiguration = vpcConfiguration != null ? vpcConfiguration.build() : null;
        }

        @Override
        public final Builder vpcConfiguration(DataSourceVpcConfiguration vpcConfiguration) {
            this.vpcConfiguration = vpcConfiguration;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getSchedule() {
            return schedule;
        }

        public final void setSchedule(String schedule) {
            this.schedule = schedule;
        }

        @Override
        public final Builder schedule(String schedule) {
            this.schedule = schedule;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getLanguageCode() {
            return languageCode;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        @Override
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        public final CustomDocumentEnrichmentConfiguration.Builder getCustomDocumentEnrichmentConfiguration() {
            return customDocumentEnrichmentConfiguration != null ? customDocumentEnrichmentConfiguration.toBuilder() : null;
        }

        public final void setCustomDocumentEnrichmentConfiguration(
                CustomDocumentEnrichmentConfiguration.BuilderImpl customDocumentEnrichmentConfiguration) {
            this.customDocumentEnrichmentConfiguration = customDocumentEnrichmentConfiguration != null ? customDocumentEnrichmentConfiguration
                    .build() : null;
        }

        @Override
        public final Builder customDocumentEnrichmentConfiguration(
                CustomDocumentEnrichmentConfiguration customDocumentEnrichmentConfiguration) {
            this.customDocumentEnrichmentConfiguration = customDocumentEnrichmentConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDataSourceRequest build() {
            return new CreateDataSourceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
