/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchGetDocumentStatusRequest extends KendraRequest implements
        ToCopyableBuilder<BatchGetDocumentStatusRequest.Builder, BatchGetDocumentStatusRequest> {
    private static final SdkField<String> INDEX_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IndexId").getter(getter(BatchGetDocumentStatusRequest::indexId)).setter(setter(Builder::indexId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexId").build()).build();

    private static final SdkField<List<DocumentInfo>> DOCUMENT_INFO_LIST_FIELD = SdkField
            .<List<DocumentInfo>> builder(MarshallingType.LIST)
            .memberName("DocumentInfoList")
            .getter(getter(BatchGetDocumentStatusRequest::documentInfoList))
            .setter(setter(Builder::documentInfoList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentInfoList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DocumentInfo> builder(MarshallingType.SDK_POJO)
                                            .constructor(DocumentInfo::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INDEX_ID_FIELD,
            DOCUMENT_INFO_LIST_FIELD));

    private final String indexId;

    private final List<DocumentInfo> documentInfoList;

    private BatchGetDocumentStatusRequest(BuilderImpl builder) {
        super(builder);
        this.indexId = builder.indexId;
        this.documentInfoList = builder.documentInfoList;
    }

    /**
     * <p>
     * The identifier of the index to add documents to. The index ID is returned by the <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/API_CreateIndex.html">CreateIndex </a> API.
     * </p>
     * 
     * @return The identifier of the index to add documents to. The index ID is returned by the <a
     *         href="https://docs.aws.amazon.com/kendra/latest/dg/API_CreateIndex.html">CreateIndex </a> API.
     */
    public final String indexId() {
        return indexId;
    }

    /**
     * For responses, this returns true if the service returned a value for the DocumentInfoList property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDocumentInfoList() {
        return documentInfoList != null && !(documentInfoList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>DocumentInfo</code> objects that identify the documents for which to get the status. You identify
     * the documents by their document ID and optional attributes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDocumentInfoList} method.
     * </p>
     * 
     * @return A list of <code>DocumentInfo</code> objects that identify the documents for which to get the status. You
     *         identify the documents by their document ID and optional attributes.
     */
    public final List<DocumentInfo> documentInfoList() {
        return documentInfoList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(indexId());
        hashCode = 31 * hashCode + Objects.hashCode(hasDocumentInfoList() ? documentInfoList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetDocumentStatusRequest)) {
            return false;
        }
        BatchGetDocumentStatusRequest other = (BatchGetDocumentStatusRequest) obj;
        return Objects.equals(indexId(), other.indexId()) && hasDocumentInfoList() == other.hasDocumentInfoList()
                && Objects.equals(documentInfoList(), other.documentInfoList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchGetDocumentStatusRequest").add("IndexId", indexId())
                .add("DocumentInfoList", hasDocumentInfoList() ? documentInfoList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IndexId":
            return Optional.ofNullable(clazz.cast(indexId()));
        case "DocumentInfoList":
            return Optional.ofNullable(clazz.cast(documentInfoList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetDocumentStatusRequest, T> g) {
        return obj -> g.apply((BatchGetDocumentStatusRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KendraRequest.Builder, SdkPojo, CopyableBuilder<Builder, BatchGetDocumentStatusRequest> {
        /**
         * <p>
         * The identifier of the index to add documents to. The index ID is returned by the <a
         * href="https://docs.aws.amazon.com/kendra/latest/dg/API_CreateIndex.html">CreateIndex </a> API.
         * </p>
         * 
         * @param indexId
         *        The identifier of the index to add documents to. The index ID is returned by the <a
         *        href="https://docs.aws.amazon.com/kendra/latest/dg/API_CreateIndex.html">CreateIndex </a> API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexId(String indexId);

        /**
         * <p>
         * A list of <code>DocumentInfo</code> objects that identify the documents for which to get the status. You
         * identify the documents by their document ID and optional attributes.
         * </p>
         * 
         * @param documentInfoList
         *        A list of <code>DocumentInfo</code> objects that identify the documents for which to get the status.
         *        You identify the documents by their document ID and optional attributes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentInfoList(Collection<DocumentInfo> documentInfoList);

        /**
         * <p>
         * A list of <code>DocumentInfo</code> objects that identify the documents for which to get the status. You
         * identify the documents by their document ID and optional attributes.
         * </p>
         * 
         * @param documentInfoList
         *        A list of <code>DocumentInfo</code> objects that identify the documents for which to get the status.
         *        You identify the documents by their document ID and optional attributes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentInfoList(DocumentInfo... documentInfoList);

        /**
         * <p>
         * A list of <code>DocumentInfo</code> objects that identify the documents for which to get the status. You
         * identify the documents by their document ID and optional attributes.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<DocumentInfo>.Builder} avoiding the
         * need to create one manually via {@link List<DocumentInfo>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DocumentInfo>.Builder#build()} is called immediately and its
         * result is passed to {@link #documentInfoList(List<DocumentInfo>)}.
         * 
         * @param documentInfoList
         *        a consumer that will call methods on {@link List<DocumentInfo>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #documentInfoList(List<DocumentInfo>)
         */
        Builder documentInfoList(Consumer<DocumentInfo.Builder>... documentInfoList);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends KendraRequest.BuilderImpl implements Builder {
        private String indexId;

        private List<DocumentInfo> documentInfoList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetDocumentStatusRequest model) {
            super(model);
            indexId(model.indexId);
            documentInfoList(model.documentInfoList);
        }

        public final String getIndexId() {
            return indexId;
        }

        public final void setIndexId(String indexId) {
            this.indexId = indexId;
        }

        @Override
        public final Builder indexId(String indexId) {
            this.indexId = indexId;
            return this;
        }

        public final List<DocumentInfo.Builder> getDocumentInfoList() {
            List<DocumentInfo.Builder> result = DocumentInfoListCopier.copyToBuilder(this.documentInfoList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDocumentInfoList(Collection<DocumentInfo.BuilderImpl> documentInfoList) {
            this.documentInfoList = DocumentInfoListCopier.copyFromBuilder(documentInfoList);
        }

        @Override
        public final Builder documentInfoList(Collection<DocumentInfo> documentInfoList) {
            this.documentInfoList = DocumentInfoListCopier.copy(documentInfoList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder documentInfoList(DocumentInfo... documentInfoList) {
            documentInfoList(Arrays.asList(documentInfoList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder documentInfoList(Consumer<DocumentInfo.Builder>... documentInfoList) {
            documentInfoList(Stream.of(documentInfoList).map(c -> DocumentInfo.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchGetDocumentStatusRequest build() {
            return new BatchGetDocumentStatusRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
