/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a document attribute. You can use document attributes as facets.
 * </p>
 * <p>
 * For example, the document attribute or facet "Department" includes the values "HR", "Engineering", and "Accounting".
 * You can display these values in the search results so that documents can be searched by department.
 * </p>
 * <p>
 * You can display up to 10 facet values per facet for a query. If you want to increase this limit, contact <a
 * href="http://aws.amazon.com/contact-us/">Support</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Facet implements SdkPojo, Serializable, ToCopyableBuilder<Facet.Builder, Facet> {
    private static final SdkField<String> DOCUMENT_ATTRIBUTE_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DocumentAttributeKey").getter(getter(Facet::documentAttributeKey))
            .setter(setter(Builder::documentAttributeKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentAttributeKey").build())
            .build();

    private static final SdkField<List<Facet>> FACETS_FIELD = SdkField
            .<List<Facet>> builder(MarshallingType.LIST)
            .memberName("Facets")
            .getter(getter(Facet::facets))
            .setter(setter(Builder::facets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Facets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Facet> builder(MarshallingType.SDK_POJO)
                                            .constructor(Facet::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(Facet::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOCUMENT_ATTRIBUTE_KEY_FIELD,
            FACETS_FIELD, MAX_RESULTS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String documentAttributeKey;

    private final List<Facet> facets;

    private final Integer maxResults;

    private Facet(BuilderImpl builder) {
        this.documentAttributeKey = builder.documentAttributeKey;
        this.facets = builder.facets;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * The unique key for the document attribute.
     * </p>
     * 
     * @return The unique key for the document attribute.
     */
    public final String documentAttributeKey() {
        return documentAttributeKey;
    }

    /**
     * For responses, this returns true if the service returned a value for the Facets property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFacets() {
        return facets != null && !(facets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of document attributes that are nested facets within a facet.
     * </p>
     * <p>
     * For example, the document attribute or facet "Department" includes a value called "Engineering". In addition, the
     * document attribute or facet "SubDepartment" includes the values "Frontend" and "Backend" for documents assigned
     * to "Engineering". You can display nested facets in the search results so that documents can be searched not only
     * by department but also by a sub department within a department. This helps your users further narrow their
     * search.
     * </p>
     * <p>
     * You can only have one nested facet within a facet. If you want to increase this limit, contact <a
     * href="http://aws.amazon.com/contact-us/">Support</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFacets} method.
     * </p>
     * 
     * @return An array of document attributes that are nested facets within a facet.</p>
     *         <p>
     *         For example, the document attribute or facet "Department" includes a value called "Engineering". In
     *         addition, the document attribute or facet "SubDepartment" includes the values "Frontend" and "Backend"
     *         for documents assigned to "Engineering". You can display nested facets in the search results so that
     *         documents can be searched not only by department but also by a sub department within a department. This
     *         helps your users further narrow their search.
     *         </p>
     *         <p>
     *         You can only have one nested facet within a facet. If you want to increase this limit, contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a>.
     */
    public final List<Facet> facets() {
        return facets;
    }

    /**
     * <p>
     * Maximum number of facet values per facet. The default is 10. You can use this to limit the number of facet values
     * to less than 10. If you want to increase the default, contact <a
     * href="http://aws.amazon.com/contact-us/">Support</a>.
     * </p>
     * 
     * @return Maximum number of facet values per facet. The default is 10. You can use this to limit the number of
     *         facet values to less than 10. If you want to increase the default, contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a>.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(documentAttributeKey());
        hashCode = 31 * hashCode + Objects.hashCode(hasFacets() ? facets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Facet)) {
            return false;
        }
        Facet other = (Facet) obj;
        return Objects.equals(documentAttributeKey(), other.documentAttributeKey()) && hasFacets() == other.hasFacets()
                && Objects.equals(facets(), other.facets()) && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Facet").add("DocumentAttributeKey", documentAttributeKey())
                .add("Facets", hasFacets() ? facets() : null).add("MaxResults", maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DocumentAttributeKey":
            return Optional.ofNullable(clazz.cast(documentAttributeKey()));
        case "Facets":
            return Optional.ofNullable(clazz.cast(facets()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Facet, T> g) {
        return obj -> g.apply((Facet) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Facet> {
        /**
         * <p>
         * The unique key for the document attribute.
         * </p>
         * 
         * @param documentAttributeKey
         *        The unique key for the document attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentAttributeKey(String documentAttributeKey);

        /**
         * <p>
         * An array of document attributes that are nested facets within a facet.
         * </p>
         * <p>
         * For example, the document attribute or facet "Department" includes a value called "Engineering". In addition,
         * the document attribute or facet "SubDepartment" includes the values "Frontend" and "Backend" for documents
         * assigned to "Engineering". You can display nested facets in the search results so that documents can be
         * searched not only by department but also by a sub department within a department. This helps your users
         * further narrow their search.
         * </p>
         * <p>
         * You can only have one nested facet within a facet. If you want to increase this limit, contact <a
         * href="http://aws.amazon.com/contact-us/">Support</a>.
         * </p>
         * 
         * @param facets
         *        An array of document attributes that are nested facets within a facet.</p>
         *        <p>
         *        For example, the document attribute or facet "Department" includes a value called "Engineering". In
         *        addition, the document attribute or facet "SubDepartment" includes the values "Frontend" and "Backend"
         *        for documents assigned to "Engineering". You can display nested facets in the search results so that
         *        documents can be searched not only by department but also by a sub department within a department.
         *        This helps your users further narrow their search.
         *        </p>
         *        <p>
         *        You can only have one nested facet within a facet. If you want to increase this limit, contact <a
         *        href="http://aws.amazon.com/contact-us/">Support</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder facets(Collection<Facet> facets);

        /**
         * <p>
         * An array of document attributes that are nested facets within a facet.
         * </p>
         * <p>
         * For example, the document attribute or facet "Department" includes a value called "Engineering". In addition,
         * the document attribute or facet "SubDepartment" includes the values "Frontend" and "Backend" for documents
         * assigned to "Engineering". You can display nested facets in the search results so that documents can be
         * searched not only by department but also by a sub department within a department. This helps your users
         * further narrow their search.
         * </p>
         * <p>
         * You can only have one nested facet within a facet. If you want to increase this limit, contact <a
         * href="http://aws.amazon.com/contact-us/">Support</a>.
         * </p>
         * 
         * @param facets
         *        An array of document attributes that are nested facets within a facet.</p>
         *        <p>
         *        For example, the document attribute or facet "Department" includes a value called "Engineering". In
         *        addition, the document attribute or facet "SubDepartment" includes the values "Frontend" and "Backend"
         *        for documents assigned to "Engineering". You can display nested facets in the search results so that
         *        documents can be searched not only by department but also by a sub department within a department.
         *        This helps your users further narrow their search.
         *        </p>
         *        <p>
         *        You can only have one nested facet within a facet. If you want to increase this limit, contact <a
         *        href="http://aws.amazon.com/contact-us/">Support</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder facets(Facet... facets);

        /**
         * <p>
         * An array of document attributes that are nested facets within a facet.
         * </p>
         * <p>
         * For example, the document attribute or facet "Department" includes a value called "Engineering". In addition,
         * the document attribute or facet "SubDepartment" includes the values "Frontend" and "Backend" for documents
         * assigned to "Engineering". You can display nested facets in the search results so that documents can be
         * searched not only by department but also by a sub department within a department. This helps your users
         * further narrow their search.
         * </p>
         * <p>
         * You can only have one nested facet within a facet. If you want to increase this limit, contact <a
         * href="http://aws.amazon.com/contact-us/">Support</a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<Facet>.Builder} avoiding the need to
         * create one manually via {@link List<Facet>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Facet>.Builder#build()} is called immediately and its result
         * is passed to {@link #facets(List<Facet>)}.
         * 
         * @param facets
         *        a consumer that will call methods on {@link List<Facet>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #facets(List<Facet>)
         */
        Builder facets(Consumer<Builder>... facets);

        /**
         * <p>
         * Maximum number of facet values per facet. The default is 10. You can use this to limit the number of facet
         * values to less than 10. If you want to increase the default, contact <a
         * href="http://aws.amazon.com/contact-us/">Support</a>.
         * </p>
         * 
         * @param maxResults
         *        Maximum number of facet values per facet. The default is 10. You can use this to limit the number of
         *        facet values to less than 10. If you want to increase the default, contact <a
         *        href="http://aws.amazon.com/contact-us/">Support</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);
    }

    static final class BuilderImpl implements Builder {
        private String documentAttributeKey;

        private List<Facet> facets = DefaultSdkAutoConstructList.getInstance();

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(Facet model) {
            documentAttributeKey(model.documentAttributeKey);
            facets(model.facets);
            maxResults(model.maxResults);
        }

        public final String getDocumentAttributeKey() {
            return documentAttributeKey;
        }

        public final void setDocumentAttributeKey(String documentAttributeKey) {
            this.documentAttributeKey = documentAttributeKey;
        }

        @Override
        public final Builder documentAttributeKey(String documentAttributeKey) {
            this.documentAttributeKey = documentAttributeKey;
            return this;
        }

        public final List<Builder> getFacets() {
            List<Builder> result = FacetListCopier.copyToBuilder(this.facets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFacets(Collection<BuilderImpl> facets) {
            this.facets = FacetListCopier.copyFromBuilder(facets);
        }

        @Override
        public final Builder facets(Collection<Facet> facets) {
            this.facets = FacetListCopier.copy(facets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder facets(Facet... facets) {
            facets(Arrays.asList(facets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder facets(Consumer<Builder>... facets) {
            facets(Stream.of(facets).map(c -> Facet.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Facet build() {
            return new Facet(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
