/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Maps a particular data source sync job to a particular data source.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataSourceSyncJobMetricTarget implements SdkPojo, Serializable,
        ToCopyableBuilder<DataSourceSyncJobMetricTarget.Builder, DataSourceSyncJobMetricTarget> {
    private static final SdkField<String> DATA_SOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataSourceId").getter(getter(DataSourceSyncJobMetricTarget::dataSourceId))
            .setter(setter(Builder::dataSourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSourceId").build()).build();

    private static final SdkField<String> DATA_SOURCE_SYNC_JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataSourceSyncJobId").getter(getter(DataSourceSyncJobMetricTarget::dataSourceSyncJobId))
            .setter(setter(Builder::dataSourceSyncJobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSourceSyncJobId").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SOURCE_ID_FIELD,
            DATA_SOURCE_SYNC_JOB_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String dataSourceId;

    private final String dataSourceSyncJobId;

    private DataSourceSyncJobMetricTarget(BuilderImpl builder) {
        this.dataSourceId = builder.dataSourceId;
        this.dataSourceSyncJobId = builder.dataSourceSyncJobId;
    }

    /**
     * <p>
     * The ID of the data source that is running the sync job.
     * </p>
     * 
     * @return The ID of the data source that is running the sync job.
     */
    public final String dataSourceId() {
        return dataSourceId;
    }

    /**
     * <p>
     * The ID of the sync job that is running on the data source.
     * </p>
     * <p>
     * If the ID of a sync job is not provided and there is a sync job running, then the ID of this sync job is used and
     * metrics are generated for this sync job.
     * </p>
     * <p>
     * If the ID of a sync job is not provided and there is no sync job running, then no metrics are generated and
     * documents are indexed/deleted at the index level without sync job metrics included.
     * </p>
     * 
     * @return The ID of the sync job that is running on the data source.</p>
     *         <p>
     *         If the ID of a sync job is not provided and there is a sync job running, then the ID of this sync job is
     *         used and metrics are generated for this sync job.
     *         </p>
     *         <p>
     *         If the ID of a sync job is not provided and there is no sync job running, then no metrics are generated
     *         and documents are indexed/deleted at the index level without sync job metrics included.
     */
    public final String dataSourceSyncJobId() {
        return dataSourceSyncJobId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dataSourceId());
        hashCode = 31 * hashCode + Objects.hashCode(dataSourceSyncJobId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataSourceSyncJobMetricTarget)) {
            return false;
        }
        DataSourceSyncJobMetricTarget other = (DataSourceSyncJobMetricTarget) obj;
        return Objects.equals(dataSourceId(), other.dataSourceId())
                && Objects.equals(dataSourceSyncJobId(), other.dataSourceSyncJobId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataSourceSyncJobMetricTarget").add("DataSourceId", dataSourceId())
                .add("DataSourceSyncJobId", dataSourceSyncJobId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DataSourceId":
            return Optional.ofNullable(clazz.cast(dataSourceId()));
        case "DataSourceSyncJobId":
            return Optional.ofNullable(clazz.cast(dataSourceSyncJobId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DataSourceSyncJobMetricTarget, T> g) {
        return obj -> g.apply((DataSourceSyncJobMetricTarget) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataSourceSyncJobMetricTarget> {
        /**
         * <p>
         * The ID of the data source that is running the sync job.
         * </p>
         * 
         * @param dataSourceId
         *        The ID of the data source that is running the sync job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSourceId(String dataSourceId);

        /**
         * <p>
         * The ID of the sync job that is running on the data source.
         * </p>
         * <p>
         * If the ID of a sync job is not provided and there is a sync job running, then the ID of this sync job is used
         * and metrics are generated for this sync job.
         * </p>
         * <p>
         * If the ID of a sync job is not provided and there is no sync job running, then no metrics are generated and
         * documents are indexed/deleted at the index level without sync job metrics included.
         * </p>
         * 
         * @param dataSourceSyncJobId
         *        The ID of the sync job that is running on the data source.</p>
         *        <p>
         *        If the ID of a sync job is not provided and there is a sync job running, then the ID of this sync job
         *        is used and metrics are generated for this sync job.
         *        </p>
         *        <p>
         *        If the ID of a sync job is not provided and there is no sync job running, then no metrics are
         *        generated and documents are indexed/deleted at the index level without sync job metrics included.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSourceSyncJobId(String dataSourceSyncJobId);
    }

    static final class BuilderImpl implements Builder {
        private String dataSourceId;

        private String dataSourceSyncJobId;

        private BuilderImpl() {
        }

        private BuilderImpl(DataSourceSyncJobMetricTarget model) {
            dataSourceId(model.dataSourceId);
            dataSourceSyncJobId(model.dataSourceSyncJobId);
        }

        public final String getDataSourceId() {
            return dataSourceId;
        }

        public final void setDataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
        }

        @Override
        @Transient
        public final Builder dataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
            return this;
        }

        public final String getDataSourceSyncJobId() {
            return dataSourceSyncJobId;
        }

        public final void setDataSourceSyncJobId(String dataSourceSyncJobId) {
            this.dataSourceSyncJobId = dataSourceSyncJobId;
        }

        @Override
        @Transient
        public final Builder dataSourceSyncJobId(String dataSourceSyncJobId) {
            this.dataSourceSyncJobId = dataSourceSyncJobId;
            return this;
        }

        @Override
        public DataSourceSyncJobMetricTarget build() {
            return new DataSourceSyncJobMetricTarget(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
