/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateQuerySuggestionsConfigRequest extends KendraRequest implements
        ToCopyableBuilder<UpdateQuerySuggestionsConfigRequest.Builder, UpdateQuerySuggestionsConfigRequest> {
    private static final SdkField<String> INDEX_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IndexId").getter(getter(UpdateQuerySuggestionsConfigRequest::indexId)).setter(setter(Builder::indexId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexId").build()).build();

    private static final SdkField<String> MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Mode")
            .getter(getter(UpdateQuerySuggestionsConfigRequest::modeAsString)).setter(setter(Builder::mode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Mode").build()).build();

    private static final SdkField<Integer> QUERY_LOG_LOOK_BACK_WINDOW_IN_DAYS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("QueryLogLookBackWindowInDays")
            .getter(getter(UpdateQuerySuggestionsConfigRequest::queryLogLookBackWindowInDays))
            .setter(setter(Builder::queryLogLookBackWindowInDays))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryLogLookBackWindowInDays")
                    .build()).build();

    private static final SdkField<Boolean> INCLUDE_QUERIES_WITHOUT_USER_INFORMATION_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IncludeQueriesWithoutUserInformation")
            .getter(getter(UpdateQuerySuggestionsConfigRequest::includeQueriesWithoutUserInformation))
            .setter(setter(Builder::includeQueriesWithoutUserInformation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("IncludeQueriesWithoutUserInformation").build()).build();

    private static final SdkField<Integer> MINIMUM_NUMBER_OF_QUERYING_USERS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("MinimumNumberOfQueryingUsers")
            .getter(getter(UpdateQuerySuggestionsConfigRequest::minimumNumberOfQueryingUsers))
            .setter(setter(Builder::minimumNumberOfQueryingUsers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinimumNumberOfQueryingUsers")
                    .build()).build();

    private static final SdkField<Integer> MINIMUM_QUERY_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MinimumQueryCount").getter(getter(UpdateQuerySuggestionsConfigRequest::minimumQueryCount))
            .setter(setter(Builder::minimumQueryCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinimumQueryCount").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INDEX_ID_FIELD, MODE_FIELD,
            QUERY_LOG_LOOK_BACK_WINDOW_IN_DAYS_FIELD, INCLUDE_QUERIES_WITHOUT_USER_INFORMATION_FIELD,
            MINIMUM_NUMBER_OF_QUERYING_USERS_FIELD, MINIMUM_QUERY_COUNT_FIELD));

    private final String indexId;

    private final String mode;

    private final Integer queryLogLookBackWindowInDays;

    private final Boolean includeQueriesWithoutUserInformation;

    private final Integer minimumNumberOfQueryingUsers;

    private final Integer minimumQueryCount;

    private UpdateQuerySuggestionsConfigRequest(BuilderImpl builder) {
        super(builder);
        this.indexId = builder.indexId;
        this.mode = builder.mode;
        this.queryLogLookBackWindowInDays = builder.queryLogLookBackWindowInDays;
        this.includeQueriesWithoutUserInformation = builder.includeQueriesWithoutUserInformation;
        this.minimumNumberOfQueryingUsers = builder.minimumNumberOfQueryingUsers;
        this.minimumQueryCount = builder.minimumQueryCount;
    }

    /**
     * <p>
     * The identifier of the index you want to update query suggestions settings for.
     * </p>
     * 
     * @return The identifier of the index you want to update query suggestions settings for.
     */
    public final String indexId() {
        return indexId;
    }

    /**
     * <p>
     * Set the mode to <code>ENABLED</code> or <code>LEARN_ONLY</code>.
     * </p>
     * <p>
     * By default, Amazon Kendra enables query suggestions. <code>LEARN_ONLY</code> mode allows you to turn off query
     * suggestions. You can to update this at any time.
     * </p>
     * <p>
     * In <code>LEARN_ONLY</code> mode, Amazon Kendra continues to learn from new queries to keep suggestions up to date
     * for when you are ready to switch to ENABLED mode again.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mode} will return
     * {@link Mode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #modeAsString}.
     * </p>
     * 
     * @return Set the mode to <code>ENABLED</code> or <code>LEARN_ONLY</code>.</p>
     *         <p>
     *         By default, Amazon Kendra enables query suggestions. <code>LEARN_ONLY</code> mode allows you to turn off
     *         query suggestions. You can to update this at any time.
     *         </p>
     *         <p>
     *         In <code>LEARN_ONLY</code> mode, Amazon Kendra continues to learn from new queries to keep suggestions up
     *         to date for when you are ready to switch to ENABLED mode again.
     * @see Mode
     */
    public final Mode mode() {
        return Mode.fromValue(mode);
    }

    /**
     * <p>
     * Set the mode to <code>ENABLED</code> or <code>LEARN_ONLY</code>.
     * </p>
     * <p>
     * By default, Amazon Kendra enables query suggestions. <code>LEARN_ONLY</code> mode allows you to turn off query
     * suggestions. You can to update this at any time.
     * </p>
     * <p>
     * In <code>LEARN_ONLY</code> mode, Amazon Kendra continues to learn from new queries to keep suggestions up to date
     * for when you are ready to switch to ENABLED mode again.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mode} will return
     * {@link Mode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #modeAsString}.
     * </p>
     * 
     * @return Set the mode to <code>ENABLED</code> or <code>LEARN_ONLY</code>.</p>
     *         <p>
     *         By default, Amazon Kendra enables query suggestions. <code>LEARN_ONLY</code> mode allows you to turn off
     *         query suggestions. You can to update this at any time.
     *         </p>
     *         <p>
     *         In <code>LEARN_ONLY</code> mode, Amazon Kendra continues to learn from new queries to keep suggestions up
     *         to date for when you are ready to switch to ENABLED mode again.
     * @see Mode
     */
    public final String modeAsString() {
        return mode;
    }

    /**
     * <p>
     * How recent your queries are in your query log time window.
     * </p>
     * <p>
     * The time window is the number of days from current day to past days.
     * </p>
     * <p>
     * By default, Amazon Kendra sets this to 180.
     * </p>
     * 
     * @return How recent your queries are in your query log time window.</p>
     *         <p>
     *         The time window is the number of days from current day to past days.
     *         </p>
     *         <p>
     *         By default, Amazon Kendra sets this to 180.
     */
    public final Integer queryLogLookBackWindowInDays() {
        return queryLogLookBackWindowInDays;
    }

    /**
     * <p>
     * <code>TRUE</code> to include queries without user information (i.e. all queries, irrespective of the user),
     * otherwise <code>FALSE</code> to only include queries with user information.
     * </p>
     * <p>
     * If you pass user information to Amazon Kendra along with the queries, you can set this flag to <code>FALSE</code>
     * and instruct Amazon Kendra to only consider queries with user information.
     * </p>
     * <p>
     * If you set to <code>FALSE</code>, Amazon Kendra only considers queries searched at least
     * <code>MinimumQueryCount</code> times across <code>MinimumNumberOfQueryingUsers</code> unique users for
     * suggestions.
     * </p>
     * <p>
     * If you set to <code>TRUE</code>, Amazon Kendra ignores all user information and learns from all queries.
     * </p>
     * 
     * @return <code>TRUE</code> to include queries without user information (i.e. all queries, irrespective of the
     *         user), otherwise <code>FALSE</code> to only include queries with user information.</p>
     *         <p>
     *         If you pass user information to Amazon Kendra along with the queries, you can set this flag to
     *         <code>FALSE</code> and instruct Amazon Kendra to only consider queries with user information.
     *         </p>
     *         <p>
     *         If you set to <code>FALSE</code>, Amazon Kendra only considers queries searched at least
     *         <code>MinimumQueryCount</code> times across <code>MinimumNumberOfQueryingUsers</code> unique users for
     *         suggestions.
     *         </p>
     *         <p>
     *         If you set to <code>TRUE</code>, Amazon Kendra ignores all user information and learns from all queries.
     */
    public final Boolean includeQueriesWithoutUserInformation() {
        return includeQueriesWithoutUserInformation;
    }

    /**
     * <p>
     * The minimum number of unique users who must search a query in order for the query to be eligible to suggest to
     * your users.
     * </p>
     * <p>
     * Increasing this number might decrease the number of suggestions. However, this ensures a query is searched by
     * many users and is truly popular to suggest to users.
     * </p>
     * <p>
     * How you tune this setting depends on your specific needs.
     * </p>
     * 
     * @return The minimum number of unique users who must search a query in order for the query to be eligible to
     *         suggest to your users.</p>
     *         <p>
     *         Increasing this number might decrease the number of suggestions. However, this ensures a query is
     *         searched by many users and is truly popular to suggest to users.
     *         </p>
     *         <p>
     *         How you tune this setting depends on your specific needs.
     */
    public final Integer minimumNumberOfQueryingUsers() {
        return minimumNumberOfQueryingUsers;
    }

    /**
     * <p>
     * The the minimum number of times a query must be searched in order to be eligible to suggest to your users.
     * </p>
     * <p>
     * Decreasing this number increases the number of suggestions. However, this affects the quality of suggestions as
     * it sets a low bar for a query to be considered popular to suggest to users.
     * </p>
     * <p>
     * How you tune this setting depends on your specific needs.
     * </p>
     * 
     * @return The the minimum number of times a query must be searched in order to be eligible to suggest to your
     *         users.</p>
     *         <p>
     *         Decreasing this number increases the number of suggestions. However, this affects the quality of
     *         suggestions as it sets a low bar for a query to be considered popular to suggest to users.
     *         </p>
     *         <p>
     *         How you tune this setting depends on your specific needs.
     */
    public final Integer minimumQueryCount() {
        return minimumQueryCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(indexId());
        hashCode = 31 * hashCode + Objects.hashCode(modeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(queryLogLookBackWindowInDays());
        hashCode = 31 * hashCode + Objects.hashCode(includeQueriesWithoutUserInformation());
        hashCode = 31 * hashCode + Objects.hashCode(minimumNumberOfQueryingUsers());
        hashCode = 31 * hashCode + Objects.hashCode(minimumQueryCount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateQuerySuggestionsConfigRequest)) {
            return false;
        }
        UpdateQuerySuggestionsConfigRequest other = (UpdateQuerySuggestionsConfigRequest) obj;
        return Objects.equals(indexId(), other.indexId()) && Objects.equals(modeAsString(), other.modeAsString())
                && Objects.equals(queryLogLookBackWindowInDays(), other.queryLogLookBackWindowInDays())
                && Objects.equals(includeQueriesWithoutUserInformation(), other.includeQueriesWithoutUserInformation())
                && Objects.equals(minimumNumberOfQueryingUsers(), other.minimumNumberOfQueryingUsers())
                && Objects.equals(minimumQueryCount(), other.minimumQueryCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateQuerySuggestionsConfigRequest").add("IndexId", indexId()).add("Mode", modeAsString())
                .add("QueryLogLookBackWindowInDays", queryLogLookBackWindowInDays())
                .add("IncludeQueriesWithoutUserInformation", includeQueriesWithoutUserInformation())
                .add("MinimumNumberOfQueryingUsers", minimumNumberOfQueryingUsers())
                .add("MinimumQueryCount", minimumQueryCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IndexId":
            return Optional.ofNullable(clazz.cast(indexId()));
        case "Mode":
            return Optional.ofNullable(clazz.cast(modeAsString()));
        case "QueryLogLookBackWindowInDays":
            return Optional.ofNullable(clazz.cast(queryLogLookBackWindowInDays()));
        case "IncludeQueriesWithoutUserInformation":
            return Optional.ofNullable(clazz.cast(includeQueriesWithoutUserInformation()));
        case "MinimumNumberOfQueryingUsers":
            return Optional.ofNullable(clazz.cast(minimumNumberOfQueryingUsers()));
        case "MinimumQueryCount":
            return Optional.ofNullable(clazz.cast(minimumQueryCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateQuerySuggestionsConfigRequest, T> g) {
        return obj -> g.apply((UpdateQuerySuggestionsConfigRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KendraRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateQuerySuggestionsConfigRequest> {
        /**
         * <p>
         * The identifier of the index you want to update query suggestions settings for.
         * </p>
         * 
         * @param indexId
         *        The identifier of the index you want to update query suggestions settings for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexId(String indexId);

        /**
         * <p>
         * Set the mode to <code>ENABLED</code> or <code>LEARN_ONLY</code>.
         * </p>
         * <p>
         * By default, Amazon Kendra enables query suggestions. <code>LEARN_ONLY</code> mode allows you to turn off
         * query suggestions. You can to update this at any time.
         * </p>
         * <p>
         * In <code>LEARN_ONLY</code> mode, Amazon Kendra continues to learn from new queries to keep suggestions up to
         * date for when you are ready to switch to ENABLED mode again.
         * </p>
         * 
         * @param mode
         *        Set the mode to <code>ENABLED</code> or <code>LEARN_ONLY</code>.</p>
         *        <p>
         *        By default, Amazon Kendra enables query suggestions. <code>LEARN_ONLY</code> mode allows you to turn
         *        off query suggestions. You can to update this at any time.
         *        </p>
         *        <p>
         *        In <code>LEARN_ONLY</code> mode, Amazon Kendra continues to learn from new queries to keep suggestions
         *        up to date for when you are ready to switch to ENABLED mode again.
         * @see Mode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Mode
         */
        Builder mode(String mode);

        /**
         * <p>
         * Set the mode to <code>ENABLED</code> or <code>LEARN_ONLY</code>.
         * </p>
         * <p>
         * By default, Amazon Kendra enables query suggestions. <code>LEARN_ONLY</code> mode allows you to turn off
         * query suggestions. You can to update this at any time.
         * </p>
         * <p>
         * In <code>LEARN_ONLY</code> mode, Amazon Kendra continues to learn from new queries to keep suggestions up to
         * date for when you are ready to switch to ENABLED mode again.
         * </p>
         * 
         * @param mode
         *        Set the mode to <code>ENABLED</code> or <code>LEARN_ONLY</code>.</p>
         *        <p>
         *        By default, Amazon Kendra enables query suggestions. <code>LEARN_ONLY</code> mode allows you to turn
         *        off query suggestions. You can to update this at any time.
         *        </p>
         *        <p>
         *        In <code>LEARN_ONLY</code> mode, Amazon Kendra continues to learn from new queries to keep suggestions
         *        up to date for when you are ready to switch to ENABLED mode again.
         * @see Mode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Mode
         */
        Builder mode(Mode mode);

        /**
         * <p>
         * How recent your queries are in your query log time window.
         * </p>
         * <p>
         * The time window is the number of days from current day to past days.
         * </p>
         * <p>
         * By default, Amazon Kendra sets this to 180.
         * </p>
         * 
         * @param queryLogLookBackWindowInDays
         *        How recent your queries are in your query log time window.</p>
         *        <p>
         *        The time window is the number of days from current day to past days.
         *        </p>
         *        <p>
         *        By default, Amazon Kendra sets this to 180.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryLogLookBackWindowInDays(Integer queryLogLookBackWindowInDays);

        /**
         * <p>
         * <code>TRUE</code> to include queries without user information (i.e. all queries, irrespective of the user),
         * otherwise <code>FALSE</code> to only include queries with user information.
         * </p>
         * <p>
         * If you pass user information to Amazon Kendra along with the queries, you can set this flag to
         * <code>FALSE</code> and instruct Amazon Kendra to only consider queries with user information.
         * </p>
         * <p>
         * If you set to <code>FALSE</code>, Amazon Kendra only considers queries searched at least
         * <code>MinimumQueryCount</code> times across <code>MinimumNumberOfQueryingUsers</code> unique users for
         * suggestions.
         * </p>
         * <p>
         * If you set to <code>TRUE</code>, Amazon Kendra ignores all user information and learns from all queries.
         * </p>
         * 
         * @param includeQueriesWithoutUserInformation
         *        <code>TRUE</code> to include queries without user information (i.e. all queries, irrespective of the
         *        user), otherwise <code>FALSE</code> to only include queries with user information.</p>
         *        <p>
         *        If you pass user information to Amazon Kendra along with the queries, you can set this flag to
         *        <code>FALSE</code> and instruct Amazon Kendra to only consider queries with user information.
         *        </p>
         *        <p>
         *        If you set to <code>FALSE</code>, Amazon Kendra only considers queries searched at least
         *        <code>MinimumQueryCount</code> times across <code>MinimumNumberOfQueryingUsers</code> unique users for
         *        suggestions.
         *        </p>
         *        <p>
         *        If you set to <code>TRUE</code>, Amazon Kendra ignores all user information and learns from all
         *        queries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeQueriesWithoutUserInformation(Boolean includeQueriesWithoutUserInformation);

        /**
         * <p>
         * The minimum number of unique users who must search a query in order for the query to be eligible to suggest
         * to your users.
         * </p>
         * <p>
         * Increasing this number might decrease the number of suggestions. However, this ensures a query is searched by
         * many users and is truly popular to suggest to users.
         * </p>
         * <p>
         * How you tune this setting depends on your specific needs.
         * </p>
         * 
         * @param minimumNumberOfQueryingUsers
         *        The minimum number of unique users who must search a query in order for the query to be eligible to
         *        suggest to your users.</p>
         *        <p>
         *        Increasing this number might decrease the number of suggestions. However, this ensures a query is
         *        searched by many users and is truly popular to suggest to users.
         *        </p>
         *        <p>
         *        How you tune this setting depends on your specific needs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minimumNumberOfQueryingUsers(Integer minimumNumberOfQueryingUsers);

        /**
         * <p>
         * The the minimum number of times a query must be searched in order to be eligible to suggest to your users.
         * </p>
         * <p>
         * Decreasing this number increases the number of suggestions. However, this affects the quality of suggestions
         * as it sets a low bar for a query to be considered popular to suggest to users.
         * </p>
         * <p>
         * How you tune this setting depends on your specific needs.
         * </p>
         * 
         * @param minimumQueryCount
         *        The the minimum number of times a query must be searched in order to be eligible to suggest to your
         *        users.</p>
         *        <p>
         *        Decreasing this number increases the number of suggestions. However, this affects the quality of
         *        suggestions as it sets a low bar for a query to be considered popular to suggest to users.
         *        </p>
         *        <p>
         *        How you tune this setting depends on your specific needs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minimumQueryCount(Integer minimumQueryCount);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends KendraRequest.BuilderImpl implements Builder {
        private String indexId;

        private String mode;

        private Integer queryLogLookBackWindowInDays;

        private Boolean includeQueriesWithoutUserInformation;

        private Integer minimumNumberOfQueryingUsers;

        private Integer minimumQueryCount;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateQuerySuggestionsConfigRequest model) {
            super(model);
            indexId(model.indexId);
            mode(model.mode);
            queryLogLookBackWindowInDays(model.queryLogLookBackWindowInDays);
            includeQueriesWithoutUserInformation(model.includeQueriesWithoutUserInformation);
            minimumNumberOfQueryingUsers(model.minimumNumberOfQueryingUsers);
            minimumQueryCount(model.minimumQueryCount);
        }

        public final String getIndexId() {
            return indexId;
        }

        public final void setIndexId(String indexId) {
            this.indexId = indexId;
        }

        @Override
        @Transient
        public final Builder indexId(String indexId) {
            this.indexId = indexId;
            return this;
        }

        public final String getMode() {
            return mode;
        }

        public final void setMode(String mode) {
            this.mode = mode;
        }

        @Override
        @Transient
        public final Builder mode(String mode) {
            this.mode = mode;
            return this;
        }

        @Override
        @Transient
        public final Builder mode(Mode mode) {
            this.mode(mode == null ? null : mode.toString());
            return this;
        }

        public final Integer getQueryLogLookBackWindowInDays() {
            return queryLogLookBackWindowInDays;
        }

        public final void setQueryLogLookBackWindowInDays(Integer queryLogLookBackWindowInDays) {
            this.queryLogLookBackWindowInDays = queryLogLookBackWindowInDays;
        }

        @Override
        @Transient
        public final Builder queryLogLookBackWindowInDays(Integer queryLogLookBackWindowInDays) {
            this.queryLogLookBackWindowInDays = queryLogLookBackWindowInDays;
            return this;
        }

        public final Boolean getIncludeQueriesWithoutUserInformation() {
            return includeQueriesWithoutUserInformation;
        }

        public final void setIncludeQueriesWithoutUserInformation(Boolean includeQueriesWithoutUserInformation) {
            this.includeQueriesWithoutUserInformation = includeQueriesWithoutUserInformation;
        }

        @Override
        @Transient
        public final Builder includeQueriesWithoutUserInformation(Boolean includeQueriesWithoutUserInformation) {
            this.includeQueriesWithoutUserInformation = includeQueriesWithoutUserInformation;
            return this;
        }

        public final Integer getMinimumNumberOfQueryingUsers() {
            return minimumNumberOfQueryingUsers;
        }

        public final void setMinimumNumberOfQueryingUsers(Integer minimumNumberOfQueryingUsers) {
            this.minimumNumberOfQueryingUsers = minimumNumberOfQueryingUsers;
        }

        @Override
        @Transient
        public final Builder minimumNumberOfQueryingUsers(Integer minimumNumberOfQueryingUsers) {
            this.minimumNumberOfQueryingUsers = minimumNumberOfQueryingUsers;
            return this;
        }

        public final Integer getMinimumQueryCount() {
            return minimumQueryCount;
        }

        public final void setMinimumQueryCount(Integer minimumQueryCount) {
            this.minimumQueryCount = minimumQueryCount;
        }

        @Override
        @Transient
        public final Builder minimumQueryCount(Integer minimumQueryCount) {
            this.minimumQueryCount = minimumQueryCount;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateQuerySuggestionsConfigRequest build() {
            return new UpdateQuerySuggestionsConfigRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
