/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summary information for users or groups in your Amazon Web Services SSO identity source. This applies to users and
 * groups with specific permissions that define their level of access to your Amazon Kendra experience. You can create
 * an Amazon Kendra experience such as a search application. For more information on creating a search application
 * experience, see <a
 * href="https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html">Building a search
 * experience with no code</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PersonasSummary implements SdkPojo, Serializable, ToCopyableBuilder<PersonasSummary.Builder, PersonasSummary> {
    private static final SdkField<String> ENTITY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EntityId").getter(getter(PersonasSummary::entityId)).setter(setter(Builder::entityId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntityId").build()).build();

    private static final SdkField<String> PERSONA_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Persona")
            .getter(getter(PersonasSummary::personaAsString)).setter(setter(Builder::persona))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Persona").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedAt").getter(getter(PersonasSummary::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("UpdatedAt").getter(getter(PersonasSummary::updatedAt)).setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedAt").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTITY_ID_FIELD,
            PERSONA_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String entityId;

    private final String persona;

    private final Instant createdAt;

    private final Instant updatedAt;

    private PersonasSummary(BuilderImpl builder) {
        this.entityId = builder.entityId;
        this.persona = builder.persona;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
    }

    /**
     * <p>
     * The identifier of a user or group in your Amazon Web Services SSO identity source. For example, a user ID could
     * be an email.
     * </p>
     * 
     * @return The identifier of a user or group in your Amazon Web Services SSO identity source. For example, a user ID
     *         could be an email.
     */
    public final String entityId() {
        return entityId;
    }

    /**
     * <p>
     * The persona that defines the specific permissions of the user or group in your Amazon Web Services SSO identity
     * source. The available personas or access roles are <code>Owner</code> and <code>Viewer</code>. For more
     * information on these personas, see <a href=
     * "https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html#access-search-experience"
     * >Providing access to your search page</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #persona} will
     * return {@link Persona#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #personaAsString}.
     * </p>
     * 
     * @return The persona that defines the specific permissions of the user or group in your Amazon Web Services SSO
     *         identity source. The available personas or access roles are <code>Owner</code> and <code>Viewer</code>.
     *         For more information on these personas, see <a href=
     *         "https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html#access-search-experience"
     *         >Providing access to your search page</a>.
     * @see Persona
     */
    public final Persona persona() {
        return Persona.fromValue(persona);
    }

    /**
     * <p>
     * The persona that defines the specific permissions of the user or group in your Amazon Web Services SSO identity
     * source. The available personas or access roles are <code>Owner</code> and <code>Viewer</code>. For more
     * information on these personas, see <a href=
     * "https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html#access-search-experience"
     * >Providing access to your search page</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #persona} will
     * return {@link Persona#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #personaAsString}.
     * </p>
     * 
     * @return The persona that defines the specific permissions of the user or group in your Amazon Web Services SSO
     *         identity source. The available personas or access roles are <code>Owner</code> and <code>Viewer</code>.
     *         For more information on these personas, see <a href=
     *         "https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html#access-search-experience"
     *         >Providing access to your search page</a>.
     * @see Persona
     */
    public final String personaAsString() {
        return persona;
    }

    /**
     * <p>
     * The date-time the summary information was created.
     * </p>
     * 
     * @return The date-time the summary information was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The date-time the summary information was last updated.
     * </p>
     * 
     * @return The date-time the summary information was last updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(entityId());
        hashCode = 31 * hashCode + Objects.hashCode(personaAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PersonasSummary)) {
            return false;
        }
        PersonasSummary other = (PersonasSummary) obj;
        return Objects.equals(entityId(), other.entityId()) && Objects.equals(personaAsString(), other.personaAsString())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(updatedAt(), other.updatedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PersonasSummary").add("EntityId", entityId()).add("Persona", personaAsString())
                .add("CreatedAt", createdAt()).add("UpdatedAt", updatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EntityId":
            return Optional.ofNullable(clazz.cast(entityId()));
        case "Persona":
            return Optional.ofNullable(clazz.cast(personaAsString()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "UpdatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PersonasSummary, T> g) {
        return obj -> g.apply((PersonasSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PersonasSummary> {
        /**
         * <p>
         * The identifier of a user or group in your Amazon Web Services SSO identity source. For example, a user ID
         * could be an email.
         * </p>
         * 
         * @param entityId
         *        The identifier of a user or group in your Amazon Web Services SSO identity source. For example, a user
         *        ID could be an email.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityId(String entityId);

        /**
         * <p>
         * The persona that defines the specific permissions of the user or group in your Amazon Web Services SSO
         * identity source. The available personas or access roles are <code>Owner</code> and <code>Viewer</code>. For
         * more information on these personas, see <a href=
         * "https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html#access-search-experience"
         * >Providing access to your search page</a>.
         * </p>
         * 
         * @param persona
         *        The persona that defines the specific permissions of the user or group in your Amazon Web Services SSO
         *        identity source. The available personas or access roles are <code>Owner</code> and <code>Viewer</code>
         *        . For more information on these personas, see <a href=
         *        "https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html#access-search-experience"
         *        >Providing access to your search page</a>.
         * @see Persona
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Persona
         */
        Builder persona(String persona);

        /**
         * <p>
         * The persona that defines the specific permissions of the user or group in your Amazon Web Services SSO
         * identity source. The available personas or access roles are <code>Owner</code> and <code>Viewer</code>. For
         * more information on these personas, see <a href=
         * "https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html#access-search-experience"
         * >Providing access to your search page</a>.
         * </p>
         * 
         * @param persona
         *        The persona that defines the specific permissions of the user or group in your Amazon Web Services SSO
         *        identity source. The available personas or access roles are <code>Owner</code> and <code>Viewer</code>
         *        . For more information on these personas, see <a href=
         *        "https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html#access-search-experience"
         *        >Providing access to your search page</a>.
         * @see Persona
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Persona
         */
        Builder persona(Persona persona);

        /**
         * <p>
         * The date-time the summary information was created.
         * </p>
         * 
         * @param createdAt
         *        The date-time the summary information was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The date-time the summary information was last updated.
         * </p>
         * 
         * @param updatedAt
         *        The date-time the summary information was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);
    }

    static final class BuilderImpl implements Builder {
        private String entityId;

        private String persona;

        private Instant createdAt;

        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(PersonasSummary model) {
            entityId(model.entityId);
            persona(model.persona);
            createdAt(model.createdAt);
            updatedAt(model.updatedAt);
        }

        public final String getEntityId() {
            return entityId;
        }

        public final void setEntityId(String entityId) {
            this.entityId = entityId;
        }

        @Override
        public final Builder entityId(String entityId) {
            this.entityId = entityId;
            return this;
        }

        public final String getPersona() {
            return persona;
        }

        public final void setPersona(String persona) {
            this.persona = persona;
        }

        @Override
        public final Builder persona(String persona) {
            this.persona = persona;
            return this;
        }

        @Override
        public final Builder persona(Persona persona) {
            this.persona(persona == null ? null : persona.toString());
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Override
        public PersonasSummary build() {
            return new PersonasSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
