/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ScoreConfidence {
    VERY_HIGH("VERY_HIGH"),
    HIGH("HIGH"),
    MEDIUM("MEDIUM"),
    LOW("LOW"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ScoreConfidence> VALUE_MAP;
    private final String value;

    private ScoreConfidence(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ScoreConfidence fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ScoreConfidence> knownValues() {
        EnumSet<ScoreConfidence> knownValues = EnumSet.allOf(ScoreConfidence.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ScoreConfidence.class, ScoreConfidence::toString);
    }
}

