/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kendra.model.SeedUrlListCopier;
import software.amazon.awssdk.services.kendra.model.WebCrawlerMode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SeedUrlConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SeedUrlConfiguration> {
    private static final SdkField<List<String>> SEED_URLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SeedUrls").getter(SeedUrlConfiguration.getter(SeedUrlConfiguration::seedUrls)).setter(SeedUrlConfiguration.setter(Builder::seedUrls)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SeedUrls").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> WEB_CRAWLER_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WebCrawlerMode").getter(SeedUrlConfiguration.getter(SeedUrlConfiguration::webCrawlerModeAsString)).setter(SeedUrlConfiguration.setter(Builder::webCrawlerMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WebCrawlerMode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SEED_URLS_FIELD, WEB_CRAWLER_MODE_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> seedUrls;
    private final String webCrawlerMode;

    private SeedUrlConfiguration(BuilderImpl builder) {
        this.seedUrls = builder.seedUrls;
        this.webCrawlerMode = builder.webCrawlerMode;
    }

    public final boolean hasSeedUrls() {
        return this.seedUrls != null && !(this.seedUrls instanceof SdkAutoConstructList);
    }

    public final List<String> seedUrls() {
        return this.seedUrls;
    }

    public final WebCrawlerMode webCrawlerMode() {
        return WebCrawlerMode.fromValue(this.webCrawlerMode);
    }

    public final String webCrawlerModeAsString() {
        return this.webCrawlerMode;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSeedUrls() ? this.seedUrls() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.webCrawlerModeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SeedUrlConfiguration)) {
            return false;
        }
        SeedUrlConfiguration other = (SeedUrlConfiguration)obj;
        return this.hasSeedUrls() == other.hasSeedUrls() && Objects.equals(this.seedUrls(), other.seedUrls()) && Objects.equals(this.webCrawlerModeAsString(), other.webCrawlerModeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"SeedUrlConfiguration").add("SeedUrls", this.hasSeedUrls() ? this.seedUrls() : null).add("WebCrawlerMode", (Object)this.webCrawlerModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SeedUrls": {
                return Optional.ofNullable(clazz.cast(this.seedUrls()));
            }
            case "WebCrawlerMode": {
                return Optional.ofNullable(clazz.cast(this.webCrawlerModeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SeedUrlConfiguration, T> g) {
        return obj -> g.apply((SeedUrlConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> seedUrls = DefaultSdkAutoConstructList.getInstance();
        private String webCrawlerMode;

        private BuilderImpl() {
        }

        private BuilderImpl(SeedUrlConfiguration model) {
            this.seedUrls(model.seedUrls);
            this.webCrawlerMode(model.webCrawlerMode);
        }

        public final Collection<String> getSeedUrls() {
            if (this.seedUrls instanceof SdkAutoConstructList) {
                return null;
            }
            return this.seedUrls;
        }

        public final void setSeedUrls(Collection<String> seedUrls) {
            this.seedUrls = SeedUrlListCopier.copy(seedUrls);
        }

        @Override
        @Transient
        public final Builder seedUrls(Collection<String> seedUrls) {
            this.seedUrls = SeedUrlListCopier.copy(seedUrls);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder seedUrls(String ... seedUrls) {
            this.seedUrls(Arrays.asList(seedUrls));
            return this;
        }

        public final String getWebCrawlerMode() {
            return this.webCrawlerMode;
        }

        public final void setWebCrawlerMode(String webCrawlerMode) {
            this.webCrawlerMode = webCrawlerMode;
        }

        @Override
        @Transient
        public final Builder webCrawlerMode(String webCrawlerMode) {
            this.webCrawlerMode = webCrawlerMode;
            return this;
        }

        @Override
        @Transient
        public final Builder webCrawlerMode(WebCrawlerMode webCrawlerMode) {
            this.webCrawlerMode(webCrawlerMode == null ? null : webCrawlerMode.toString());
            return this;
        }

        public SeedUrlConfiguration build() {
            return new SeedUrlConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SeedUrlConfiguration> {
        public Builder seedUrls(Collection<String> var1);

        public Builder seedUrls(String ... var1);

        public Builder webCrawlerMode(String var1);

        public Builder webCrawlerMode(WebCrawlerMode var1);
    }
}

