/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListIndicesResponse extends KendraResponse implements
        ToCopyableBuilder<ListIndicesResponse.Builder, ListIndicesResponse> {
    private static final SdkField<List<IndexConfigurationSummary>> INDEX_CONFIGURATION_SUMMARY_ITEMS_FIELD = SdkField
            .<List<IndexConfigurationSummary>> builder(MarshallingType.LIST)
            .memberName("IndexConfigurationSummaryItems")
            .getter(getter(ListIndicesResponse::indexConfigurationSummaryItems))
            .setter(setter(Builder::indexConfigurationSummaryItems))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexConfigurationSummaryItems")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<IndexConfigurationSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(IndexConfigurationSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListIndicesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            INDEX_CONFIGURATION_SUMMARY_ITEMS_FIELD, NEXT_TOKEN_FIELD));

    private final List<IndexConfigurationSummary> indexConfigurationSummaryItems;

    private final String nextToken;

    private ListIndicesResponse(BuilderImpl builder) {
        super(builder);
        this.indexConfigurationSummaryItems = builder.indexConfigurationSummaryItems;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the IndexConfigurationSummaryItems property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasIndexConfigurationSummaryItems() {
        return indexConfigurationSummaryItems != null && !(indexConfigurationSummaryItems instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of summary information for one or more indexes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIndexConfigurationSummaryItems} method.
     * </p>
     * 
     * @return An array of summary information for one or more indexes.
     */
    public final List<IndexConfigurationSummary> indexConfigurationSummaryItems() {
        return indexConfigurationSummaryItems;
    }

    /**
     * <p>
     * If the response is truncated, Amazon Kendra returns this token that you can use in the subsequent request to
     * retrieve the next set of indexes.
     * </p>
     * 
     * @return If the response is truncated, Amazon Kendra returns this token that you can use in the subsequent request
     *         to retrieve the next set of indexes.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode
                + Objects.hashCode(hasIndexConfigurationSummaryItems() ? indexConfigurationSummaryItems() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListIndicesResponse)) {
            return false;
        }
        ListIndicesResponse other = (ListIndicesResponse) obj;
        return hasIndexConfigurationSummaryItems() == other.hasIndexConfigurationSummaryItems()
                && Objects.equals(indexConfigurationSummaryItems(), other.indexConfigurationSummaryItems())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("ListIndicesResponse")
                .add("IndexConfigurationSummaryItems",
                        hasIndexConfigurationSummaryItems() ? indexConfigurationSummaryItems() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IndexConfigurationSummaryItems":
            return Optional.ofNullable(clazz.cast(indexConfigurationSummaryItems()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListIndicesResponse, T> g) {
        return obj -> g.apply((ListIndicesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KendraResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListIndicesResponse> {
        /**
         * <p>
         * An array of summary information for one or more indexes.
         * </p>
         * 
         * @param indexConfigurationSummaryItems
         *        An array of summary information for one or more indexes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexConfigurationSummaryItems(Collection<IndexConfigurationSummary> indexConfigurationSummaryItems);

        /**
         * <p>
         * An array of summary information for one or more indexes.
         * </p>
         * 
         * @param indexConfigurationSummaryItems
         *        An array of summary information for one or more indexes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexConfigurationSummaryItems(IndexConfigurationSummary... indexConfigurationSummaryItems);

        /**
         * <p>
         * An array of summary information for one or more indexes.
         * </p>
         * This is a convenience that creates an instance of the {@link List<IndexConfigurationSummary>.Builder}
         * avoiding the need to create one manually via {@link List<IndexConfigurationSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<IndexConfigurationSummary>.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #indexConfigurationSummaryItems(List<IndexConfigurationSummary>)}.
         * 
         * @param indexConfigurationSummaryItems
         *        a consumer that will call methods on {@link List<IndexConfigurationSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #indexConfigurationSummaryItems(List<IndexConfigurationSummary>)
         */
        Builder indexConfigurationSummaryItems(Consumer<IndexConfigurationSummary.Builder>... indexConfigurationSummaryItems);

        /**
         * <p>
         * If the response is truncated, Amazon Kendra returns this token that you can use in the subsequent request to
         * retrieve the next set of indexes.
         * </p>
         * 
         * @param nextToken
         *        If the response is truncated, Amazon Kendra returns this token that you can use in the subsequent
         *        request to retrieve the next set of indexes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends KendraResponse.BuilderImpl implements Builder {
        private List<IndexConfigurationSummary> indexConfigurationSummaryItems = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListIndicesResponse model) {
            super(model);
            indexConfigurationSummaryItems(model.indexConfigurationSummaryItems);
            nextToken(model.nextToken);
        }

        public final List<IndexConfigurationSummary.Builder> getIndexConfigurationSummaryItems() {
            List<IndexConfigurationSummary.Builder> result = IndexConfigurationSummaryListCopier
                    .copyToBuilder(this.indexConfigurationSummaryItems);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIndexConfigurationSummaryItems(
                Collection<IndexConfigurationSummary.BuilderImpl> indexConfigurationSummaryItems) {
            this.indexConfigurationSummaryItems = IndexConfigurationSummaryListCopier
                    .copyFromBuilder(indexConfigurationSummaryItems);
        }

        @Override
        @Transient
        public final Builder indexConfigurationSummaryItems(Collection<IndexConfigurationSummary> indexConfigurationSummaryItems) {
            this.indexConfigurationSummaryItems = IndexConfigurationSummaryListCopier.copy(indexConfigurationSummaryItems);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder indexConfigurationSummaryItems(IndexConfigurationSummary... indexConfigurationSummaryItems) {
            indexConfigurationSummaryItems(Arrays.asList(indexConfigurationSummaryItems));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder indexConfigurationSummaryItems(
                Consumer<IndexConfigurationSummary.Builder>... indexConfigurationSummaryItems) {
            indexConfigurationSummaryItems(Stream.of(indexConfigurationSummaryItems)
                    .map(c -> IndexConfigurationSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListIndicesResponse build() {
            return new ListIndicesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
