/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribePrincipalMappingResponse extends KendraResponse implements
        ToCopyableBuilder<DescribePrincipalMappingResponse.Builder, DescribePrincipalMappingResponse> {
    private static final SdkField<String> INDEX_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IndexId").getter(getter(DescribePrincipalMappingResponse::indexId)).setter(setter(Builder::indexId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexId").build()).build();

    private static final SdkField<String> DATA_SOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataSourceId").getter(getter(DescribePrincipalMappingResponse::dataSourceId))
            .setter(setter(Builder::dataSourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSourceId").build()).build();

    private static final SdkField<String> GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GroupId").getter(getter(DescribePrincipalMappingResponse::groupId)).setter(setter(Builder::groupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupId").build()).build();

    private static final SdkField<List<GroupOrderingIdSummary>> GROUP_ORDERING_ID_SUMMARIES_FIELD = SdkField
            .<List<GroupOrderingIdSummary>> builder(MarshallingType.LIST)
            .memberName("GroupOrderingIdSummaries")
            .getter(getter(DescribePrincipalMappingResponse::groupOrderingIdSummaries))
            .setter(setter(Builder::groupOrderingIdSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupOrderingIdSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<GroupOrderingIdSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(GroupOrderingIdSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INDEX_ID_FIELD,
            DATA_SOURCE_ID_FIELD, GROUP_ID_FIELD, GROUP_ORDERING_ID_SUMMARIES_FIELD));

    private final String indexId;

    private final String dataSourceId;

    private final String groupId;

    private final List<GroupOrderingIdSummary> groupOrderingIdSummaries;

    private DescribePrincipalMappingResponse(BuilderImpl builder) {
        super(builder);
        this.indexId = builder.indexId;
        this.dataSourceId = builder.dataSourceId;
        this.groupId = builder.groupId;
        this.groupOrderingIdSummaries = builder.groupOrderingIdSummaries;
    }

    /**
     * <p>
     * Shows the identifier of the index to see information on the processing of <code>PUT</code> and
     * <code>DELETE</code> actions for mapping users to their groups.
     * </p>
     * 
     * @return Shows the identifier of the index to see information on the processing of <code>PUT</code> and
     *         <code>DELETE</code> actions for mapping users to their groups.
     */
    public final String indexId() {
        return indexId;
    }

    /**
     * <p>
     * Shows the identifier of the data source to see information on the processing of <code>PUT</code> and
     * <code>DELETE</code> actions for mapping users to their groups.
     * </p>
     * 
     * @return Shows the identifier of the data source to see information on the processing of <code>PUT</code> and
     *         <code>DELETE</code> actions for mapping users to their groups.
     */
    public final String dataSourceId() {
        return dataSourceId;
    }

    /**
     * <p>
     * Shows the identifier of the group to see information on the processing of <code>PUT</code> and
     * <code>DELETE</code> actions for mapping users to their groups.
     * </p>
     * 
     * @return Shows the identifier of the group to see information on the processing of <code>PUT</code> and
     *         <code>DELETE</code> actions for mapping users to their groups.
     */
    public final String groupId() {
        return groupId;
    }

    /**
     * For responses, this returns true if the service returned a value for the GroupOrderingIdSummaries property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasGroupOrderingIdSummaries() {
        return groupOrderingIdSummaries != null && !(groupOrderingIdSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Shows the following information on the processing of <code>PUT</code> and <code>DELETE</code> actions for mapping
     * users to their groups:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Status – the status can be either <code>PROCESSING</code>, <code>SUCCEEDED</code>, <code>DELETING</code>,
     * <code>DELETED</code>, or <code>FAILED</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Last updated – the last date-time an action was updated.
     * </p>
     * </li>
     * <li>
     * <p>
     * Received – the last date-time an action was received or submitted.
     * </p>
     * </li>
     * <li>
     * <p>
     * Ordering ID – the latest action that should process and apply after other actions.
     * </p>
     * </li>
     * <li>
     * <p>
     * Failure reason – the reason an action could not be processed.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGroupOrderingIdSummaries} method.
     * </p>
     * 
     * @return Shows the following information on the processing of <code>PUT</code> and <code>DELETE</code> actions for
     *         mapping users to their groups:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Status – the status can be either <code>PROCESSING</code>, <code>SUCCEEDED</code>, <code>DELETING</code>,
     *         <code>DELETED</code>, or <code>FAILED</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Last updated – the last date-time an action was updated.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Received – the last date-time an action was received or submitted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Ordering ID – the latest action that should process and apply after other actions.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Failure reason – the reason an action could not be processed.
     *         </p>
     *         </li>
     */
    public final List<GroupOrderingIdSummary> groupOrderingIdSummaries() {
        return groupOrderingIdSummaries;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(indexId());
        hashCode = 31 * hashCode + Objects.hashCode(dataSourceId());
        hashCode = 31 * hashCode + Objects.hashCode(groupId());
        hashCode = 31 * hashCode + Objects.hashCode(hasGroupOrderingIdSummaries() ? groupOrderingIdSummaries() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribePrincipalMappingResponse)) {
            return false;
        }
        DescribePrincipalMappingResponse other = (DescribePrincipalMappingResponse) obj;
        return Objects.equals(indexId(), other.indexId()) && Objects.equals(dataSourceId(), other.dataSourceId())
                && Objects.equals(groupId(), other.groupId())
                && hasGroupOrderingIdSummaries() == other.hasGroupOrderingIdSummaries()
                && Objects.equals(groupOrderingIdSummaries(), other.groupOrderingIdSummaries());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribePrincipalMappingResponse").add("IndexId", indexId()).add("DataSourceId", dataSourceId())
                .add("GroupId", groupId())
                .add("GroupOrderingIdSummaries", hasGroupOrderingIdSummaries() ? groupOrderingIdSummaries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IndexId":
            return Optional.ofNullable(clazz.cast(indexId()));
        case "DataSourceId":
            return Optional.ofNullable(clazz.cast(dataSourceId()));
        case "GroupId":
            return Optional.ofNullable(clazz.cast(groupId()));
        case "GroupOrderingIdSummaries":
            return Optional.ofNullable(clazz.cast(groupOrderingIdSummaries()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribePrincipalMappingResponse, T> g) {
        return obj -> g.apply((DescribePrincipalMappingResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KendraResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribePrincipalMappingResponse> {
        /**
         * <p>
         * Shows the identifier of the index to see information on the processing of <code>PUT</code> and
         * <code>DELETE</code> actions for mapping users to their groups.
         * </p>
         * 
         * @param indexId
         *        Shows the identifier of the index to see information on the processing of <code>PUT</code> and
         *        <code>DELETE</code> actions for mapping users to their groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexId(String indexId);

        /**
         * <p>
         * Shows the identifier of the data source to see information on the processing of <code>PUT</code> and
         * <code>DELETE</code> actions for mapping users to their groups.
         * </p>
         * 
         * @param dataSourceId
         *        Shows the identifier of the data source to see information on the processing of <code>PUT</code> and
         *        <code>DELETE</code> actions for mapping users to their groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSourceId(String dataSourceId);

        /**
         * <p>
         * Shows the identifier of the group to see information on the processing of <code>PUT</code> and
         * <code>DELETE</code> actions for mapping users to their groups.
         * </p>
         * 
         * @param groupId
         *        Shows the identifier of the group to see information on the processing of <code>PUT</code> and
         *        <code>DELETE</code> actions for mapping users to their groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupId(String groupId);

        /**
         * <p>
         * Shows the following information on the processing of <code>PUT</code> and <code>DELETE</code> actions for
         * mapping users to their groups:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Status – the status can be either <code>PROCESSING</code>, <code>SUCCEEDED</code>, <code>DELETING</code>,
         * <code>DELETED</code>, or <code>FAILED</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * Last updated – the last date-time an action was updated.
         * </p>
         * </li>
         * <li>
         * <p>
         * Received – the last date-time an action was received or submitted.
         * </p>
         * </li>
         * <li>
         * <p>
         * Ordering ID – the latest action that should process and apply after other actions.
         * </p>
         * </li>
         * <li>
         * <p>
         * Failure reason – the reason an action could not be processed.
         * </p>
         * </li>
         * </ul>
         * 
         * @param groupOrderingIdSummaries
         *        Shows the following information on the processing of <code>PUT</code> and <code>DELETE</code> actions
         *        for mapping users to their groups:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Status – the status can be either <code>PROCESSING</code>, <code>SUCCEEDED</code>,
         *        <code>DELETING</code>, <code>DELETED</code>, or <code>FAILED</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Last updated – the last date-time an action was updated.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Received – the last date-time an action was received or submitted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Ordering ID – the latest action that should process and apply after other actions.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Failure reason – the reason an action could not be processed.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupOrderingIdSummaries(Collection<GroupOrderingIdSummary> groupOrderingIdSummaries);

        /**
         * <p>
         * Shows the following information on the processing of <code>PUT</code> and <code>DELETE</code> actions for
         * mapping users to their groups:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Status – the status can be either <code>PROCESSING</code>, <code>SUCCEEDED</code>, <code>DELETING</code>,
         * <code>DELETED</code>, or <code>FAILED</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * Last updated – the last date-time an action was updated.
         * </p>
         * </li>
         * <li>
         * <p>
         * Received – the last date-time an action was received or submitted.
         * </p>
         * </li>
         * <li>
         * <p>
         * Ordering ID – the latest action that should process and apply after other actions.
         * </p>
         * </li>
         * <li>
         * <p>
         * Failure reason – the reason an action could not be processed.
         * </p>
         * </li>
         * </ul>
         * 
         * @param groupOrderingIdSummaries
         *        Shows the following information on the processing of <code>PUT</code> and <code>DELETE</code> actions
         *        for mapping users to their groups:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Status – the status can be either <code>PROCESSING</code>, <code>SUCCEEDED</code>,
         *        <code>DELETING</code>, <code>DELETED</code>, or <code>FAILED</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Last updated – the last date-time an action was updated.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Received – the last date-time an action was received or submitted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Ordering ID – the latest action that should process and apply after other actions.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Failure reason – the reason an action could not be processed.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupOrderingIdSummaries(GroupOrderingIdSummary... groupOrderingIdSummaries);

        /**
         * <p>
         * Shows the following information on the processing of <code>PUT</code> and <code>DELETE</code> actions for
         * mapping users to their groups:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Status – the status can be either <code>PROCESSING</code>, <code>SUCCEEDED</code>, <code>DELETING</code>,
         * <code>DELETED</code>, or <code>FAILED</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * Last updated – the last date-time an action was updated.
         * </p>
         * </li>
         * <li>
         * <p>
         * Received – the last date-time an action was received or submitted.
         * </p>
         * </li>
         * <li>
         * <p>
         * Ordering ID – the latest action that should process and apply after other actions.
         * </p>
         * </li>
         * <li>
         * <p>
         * Failure reason – the reason an action could not be processed.
         * </p>
         * </li>
         * </ul>
         * This is a convenience that creates an instance of the {@link List<GroupOrderingIdSummary>.Builder} avoiding
         * the need to create one manually via {@link List<GroupOrderingIdSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<GroupOrderingIdSummary>.Builder#build()} is called
         * immediately and its result is passed to {@link #groupOrderingIdSummaries(List<GroupOrderingIdSummary>)}.
         * 
         * @param groupOrderingIdSummaries
         *        a consumer that will call methods on {@link List<GroupOrderingIdSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #groupOrderingIdSummaries(List<GroupOrderingIdSummary>)
         */
        Builder groupOrderingIdSummaries(Consumer<GroupOrderingIdSummary.Builder>... groupOrderingIdSummaries);
    }

    static final class BuilderImpl extends KendraResponse.BuilderImpl implements Builder {
        private String indexId;

        private String dataSourceId;

        private String groupId;

        private List<GroupOrderingIdSummary> groupOrderingIdSummaries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribePrincipalMappingResponse model) {
            super(model);
            indexId(model.indexId);
            dataSourceId(model.dataSourceId);
            groupId(model.groupId);
            groupOrderingIdSummaries(model.groupOrderingIdSummaries);
        }

        public final String getIndexId() {
            return indexId;
        }

        public final void setIndexId(String indexId) {
            this.indexId = indexId;
        }

        @Override
        @Transient
        public final Builder indexId(String indexId) {
            this.indexId = indexId;
            return this;
        }

        public final String getDataSourceId() {
            return dataSourceId;
        }

        public final void setDataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
        }

        @Override
        @Transient
        public final Builder dataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
            return this;
        }

        public final String getGroupId() {
            return groupId;
        }

        public final void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        @Override
        @Transient
        public final Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public final List<GroupOrderingIdSummary.Builder> getGroupOrderingIdSummaries() {
            List<GroupOrderingIdSummary.Builder> result = GroupOrderingIdSummariesCopier
                    .copyToBuilder(this.groupOrderingIdSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGroupOrderingIdSummaries(Collection<GroupOrderingIdSummary.BuilderImpl> groupOrderingIdSummaries) {
            this.groupOrderingIdSummaries = GroupOrderingIdSummariesCopier.copyFromBuilder(groupOrderingIdSummaries);
        }

        @Override
        @Transient
        public final Builder groupOrderingIdSummaries(Collection<GroupOrderingIdSummary> groupOrderingIdSummaries) {
            this.groupOrderingIdSummaries = GroupOrderingIdSummariesCopier.copy(groupOrderingIdSummaries);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder groupOrderingIdSummaries(GroupOrderingIdSummary... groupOrderingIdSummaries) {
            groupOrderingIdSummaries(Arrays.asList(groupOrderingIdSummaries));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder groupOrderingIdSummaries(Consumer<GroupOrderingIdSummary.Builder>... groupOrderingIdSummaries) {
            groupOrderingIdSummaries(Stream.of(groupOrderingIdSummaries)
                    .map(c -> GroupOrderingIdSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribePrincipalMappingResponse build() {
            return new DescribePrincipalMappingResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
