/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Document metadata files that contain information such as the document access control information, source URI,
 * document author, and custom attributes. Each metadata file contains metadata about a single document.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DocumentsMetadataConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<DocumentsMetadataConfiguration.Builder, DocumentsMetadataConfiguration> {
    private static final SdkField<String> S3_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("S3Prefix").getter(getter(DocumentsMetadataConfiguration::s3Prefix)).setter(setter(Builder::s3Prefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Prefix").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_PREFIX_FIELD));

    private static final long serialVersionUID = 1L;

    private final String s3Prefix;

    private DocumentsMetadataConfiguration(BuilderImpl builder) {
        this.s3Prefix = builder.s3Prefix;
    }

    /**
     * <p>
     * A prefix used to filter metadata configuration files in the Amazon Web Services S3 bucket. The S3 bucket might
     * contain multiple metadata files. Use <code>S3Prefix</code> to include only the desired metadata files.
     * </p>
     * 
     * @return A prefix used to filter metadata configuration files in the Amazon Web Services S3 bucket. The S3 bucket
     *         might contain multiple metadata files. Use <code>S3Prefix</code> to include only the desired metadata
     *         files.
     */
    public final String s3Prefix() {
        return s3Prefix;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(s3Prefix());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DocumentsMetadataConfiguration)) {
            return false;
        }
        DocumentsMetadataConfiguration other = (DocumentsMetadataConfiguration) obj;
        return Objects.equals(s3Prefix(), other.s3Prefix());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DocumentsMetadataConfiguration").add("S3Prefix", s3Prefix()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "S3Prefix":
            return Optional.ofNullable(clazz.cast(s3Prefix()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DocumentsMetadataConfiguration, T> g) {
        return obj -> g.apply((DocumentsMetadataConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DocumentsMetadataConfiguration> {
        /**
         * <p>
         * A prefix used to filter metadata configuration files in the Amazon Web Services S3 bucket. The S3 bucket
         * might contain multiple metadata files. Use <code>S3Prefix</code> to include only the desired metadata files.
         * </p>
         * 
         * @param s3Prefix
         *        A prefix used to filter metadata configuration files in the Amazon Web Services S3 bucket. The S3
         *        bucket might contain multiple metadata files. Use <code>S3Prefix</code> to include only the desired
         *        metadata files.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Prefix(String s3Prefix);
    }

    static final class BuilderImpl implements Builder {
        private String s3Prefix;

        private BuilderImpl() {
        }

        private BuilderImpl(DocumentsMetadataConfiguration model) {
            s3Prefix(model.s3Prefix);
        }

        public final String getS3Prefix() {
            return s3Prefix;
        }

        public final void setS3Prefix(String s3Prefix) {
            this.s3Prefix = s3Prefix;
        }

        @Override
        @Transient
        public final Builder s3Prefix(String s3Prefix) {
            this.s3Prefix = s3Prefix;
            return this;
        }

        @Override
        public DocumentsMetadataConfiguration build() {
            return new DocumentsMetadataConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
