/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information on the processing of <code>PUT</code> and <code>DELETE</code> actions for mapping users to their groups.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GroupOrderingIdSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<GroupOrderingIdSummary.Builder, GroupOrderingIdSummary> {
    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(GroupOrderingIdSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdatedAt").getter(getter(GroupOrderingIdSummary::lastUpdatedAt))
            .setter(setter(Builder::lastUpdatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedAt").build()).build();

    private static final SdkField<Instant> RECEIVED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("ReceivedAt").getter(getter(GroupOrderingIdSummary::receivedAt)).setter(setter(Builder::receivedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReceivedAt").build()).build();

    private static final SdkField<Long> ORDERING_ID_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("OrderingId").getter(getter(GroupOrderingIdSummary::orderingId)).setter(setter(Builder::orderingId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrderingId").build()).build();

    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FailureReason").getter(getter(GroupOrderingIdSummary::failureReason))
            .setter(setter(Builder::failureReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD,
            LAST_UPDATED_AT_FIELD, RECEIVED_AT_FIELD, ORDERING_ID_FIELD, FAILURE_REASON_FIELD));

    private static final long serialVersionUID = 1L;

    private final String status;

    private final Instant lastUpdatedAt;

    private final Instant receivedAt;

    private final Long orderingId;

    private final String failureReason;

    private GroupOrderingIdSummary(BuilderImpl builder) {
        this.status = builder.status;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.receivedAt = builder.receivedAt;
        this.orderingId = builder.orderingId;
        this.failureReason = builder.failureReason;
    }

    /**
     * <p>
     * The current processing status of actions for mapping users to their groups. The status can be either
     * <code>PROCESSING</code>, <code>SUCCEEDED</code>, <code>DELETING</code>, <code>DELETED</code>, or
     * <code>FAILED</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link PrincipalMappingStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The current processing status of actions for mapping users to their groups. The status can be either
     *         <code>PROCESSING</code>, <code>SUCCEEDED</code>, <code>DELETING</code>, <code>DELETED</code>, or
     *         <code>FAILED</code>.
     * @see PrincipalMappingStatus
     */
    public final PrincipalMappingStatus status() {
        return PrincipalMappingStatus.fromValue(status);
    }

    /**
     * <p>
     * The current processing status of actions for mapping users to their groups. The status can be either
     * <code>PROCESSING</code>, <code>SUCCEEDED</code>, <code>DELETING</code>, <code>DELETED</code>, or
     * <code>FAILED</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link PrincipalMappingStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The current processing status of actions for mapping users to their groups. The status can be either
     *         <code>PROCESSING</code>, <code>SUCCEEDED</code>, <code>DELETING</code>, <code>DELETED</code>, or
     *         <code>FAILED</code>.
     * @see PrincipalMappingStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The last date-time an action was updated. An action can be a <code>PUT</code> or <code>DELETE</code> action for
     * mapping users to their groups.
     * </p>
     * 
     * @return The last date-time an action was updated. An action can be a <code>PUT</code> or <code>DELETE</code>
     *         action for mapping users to their groups.
     */
    public final Instant lastUpdatedAt() {
        return lastUpdatedAt;
    }

    /**
     * <p>
     * The date-time an action was received by Amazon Kendra. An action can be a <code>PUT</code> or <code>DELETE</code>
     * action for mapping users to their groups.
     * </p>
     * 
     * @return The date-time an action was received by Amazon Kendra. An action can be a <code>PUT</code> or
     *         <code>DELETE</code> action for mapping users to their groups.
     */
    public final Instant receivedAt() {
        return receivedAt;
    }

    /**
     * <p>
     * The order in which actions should complete processing. An action can be a <code>PUT</code> or <code>DELETE</code>
     * action for mapping users to their groups.
     * </p>
     * 
     * @return The order in which actions should complete processing. An action can be a <code>PUT</code> or
     *         <code>DELETE</code> action for mapping users to their groups.
     */
    public final Long orderingId() {
        return orderingId;
    }

    /**
     * <p>
     * The reason an action could not be processed. An action can be a <code>PUT</code> or <code>DELETE</code> action
     * for mapping users to their groups.
     * </p>
     * 
     * @return The reason an action could not be processed. An action can be a <code>PUT</code> or <code>DELETE</code>
     *         action for mapping users to their groups.
     */
    public final String failureReason() {
        return failureReason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(receivedAt());
        hashCode = 31 * hashCode + Objects.hashCode(orderingId());
        hashCode = 31 * hashCode + Objects.hashCode(failureReason());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GroupOrderingIdSummary)) {
            return false;
        }
        GroupOrderingIdSummary other = (GroupOrderingIdSummary) obj;
        return Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(lastUpdatedAt(), other.lastUpdatedAt())
                && Objects.equals(receivedAt(), other.receivedAt()) && Objects.equals(orderingId(), other.orderingId())
                && Objects.equals(failureReason(), other.failureReason());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GroupOrderingIdSummary").add("Status", statusAsString()).add("LastUpdatedAt", lastUpdatedAt())
                .add("ReceivedAt", receivedAt()).add("OrderingId", orderingId()).add("FailureReason", failureReason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "LastUpdatedAt":
            return Optional.ofNullable(clazz.cast(lastUpdatedAt()));
        case "ReceivedAt":
            return Optional.ofNullable(clazz.cast(receivedAt()));
        case "OrderingId":
            return Optional.ofNullable(clazz.cast(orderingId()));
        case "FailureReason":
            return Optional.ofNullable(clazz.cast(failureReason()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GroupOrderingIdSummary, T> g) {
        return obj -> g.apply((GroupOrderingIdSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GroupOrderingIdSummary> {
        /**
         * <p>
         * The current processing status of actions for mapping users to their groups. The status can be either
         * <code>PROCESSING</code>, <code>SUCCEEDED</code>, <code>DELETING</code>, <code>DELETED</code>, or
         * <code>FAILED</code>.
         * </p>
         * 
         * @param status
         *        The current processing status of actions for mapping users to their groups. The status can be either
         *        <code>PROCESSING</code>, <code>SUCCEEDED</code>, <code>DELETING</code>, <code>DELETED</code>, or
         *        <code>FAILED</code>.
         * @see PrincipalMappingStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PrincipalMappingStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current processing status of actions for mapping users to their groups. The status can be either
         * <code>PROCESSING</code>, <code>SUCCEEDED</code>, <code>DELETING</code>, <code>DELETED</code>, or
         * <code>FAILED</code>.
         * </p>
         * 
         * @param status
         *        The current processing status of actions for mapping users to their groups. The status can be either
         *        <code>PROCESSING</code>, <code>SUCCEEDED</code>, <code>DELETING</code>, <code>DELETED</code>, or
         *        <code>FAILED</code>.
         * @see PrincipalMappingStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PrincipalMappingStatus
         */
        Builder status(PrincipalMappingStatus status);

        /**
         * <p>
         * The last date-time an action was updated. An action can be a <code>PUT</code> or <code>DELETE</code> action
         * for mapping users to their groups.
         * </p>
         * 
         * @param lastUpdatedAt
         *        The last date-time an action was updated. An action can be a <code>PUT</code> or <code>DELETE</code>
         *        action for mapping users to their groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedAt(Instant lastUpdatedAt);

        /**
         * <p>
         * The date-time an action was received by Amazon Kendra. An action can be a <code>PUT</code> or
         * <code>DELETE</code> action for mapping users to their groups.
         * </p>
         * 
         * @param receivedAt
         *        The date-time an action was received by Amazon Kendra. An action can be a <code>PUT</code> or
         *        <code>DELETE</code> action for mapping users to their groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder receivedAt(Instant receivedAt);

        /**
         * <p>
         * The order in which actions should complete processing. An action can be a <code>PUT</code> or
         * <code>DELETE</code> action for mapping users to their groups.
         * </p>
         * 
         * @param orderingId
         *        The order in which actions should complete processing. An action can be a <code>PUT</code> or
         *        <code>DELETE</code> action for mapping users to their groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder orderingId(Long orderingId);

        /**
         * <p>
         * The reason an action could not be processed. An action can be a <code>PUT</code> or <code>DELETE</code>
         * action for mapping users to their groups.
         * </p>
         * 
         * @param failureReason
         *        The reason an action could not be processed. An action can be a <code>PUT</code> or
         *        <code>DELETE</code> action for mapping users to their groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReason(String failureReason);
    }

    static final class BuilderImpl implements Builder {
        private String status;

        private Instant lastUpdatedAt;

        private Instant receivedAt;

        private Long orderingId;

        private String failureReason;

        private BuilderImpl() {
        }

        private BuilderImpl(GroupOrderingIdSummary model) {
            status(model.status);
            lastUpdatedAt(model.lastUpdatedAt);
            receivedAt(model.receivedAt);
            orderingId(model.orderingId);
            failureReason(model.failureReason);
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(PrincipalMappingStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Instant getLastUpdatedAt() {
            return lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        public final Instant getReceivedAt() {
            return receivedAt;
        }

        @Override
        public final Builder receivedAt(Instant receivedAt) {
            this.receivedAt = receivedAt;
            return this;
        }

        public final void setReceivedAt(Instant receivedAt) {
            this.receivedAt = receivedAt;
        }

        public final Long getOrderingId() {
            return orderingId;
        }

        @Override
        public final Builder orderingId(Long orderingId) {
            this.orderingId = orderingId;
            return this;
        }

        public final void setOrderingId(Long orderingId) {
            this.orderingId = orderingId;
        }

        public final String getFailureReason() {
            return failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public GroupOrderingIdSummary build() {
            return new GroupOrderingIdSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
