/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListGroupsOlderThanOrderingIdRequest extends KendraRequest implements
        ToCopyableBuilder<ListGroupsOlderThanOrderingIdRequest.Builder, ListGroupsOlderThanOrderingIdRequest> {
    private static final SdkField<String> INDEX_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IndexId").getter(getter(ListGroupsOlderThanOrderingIdRequest::indexId)).setter(setter(Builder::indexId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexId").build()).build();

    private static final SdkField<String> DATA_SOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataSourceId").getter(getter(ListGroupsOlderThanOrderingIdRequest::dataSourceId))
            .setter(setter(Builder::dataSourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSourceId").build()).build();

    private static final SdkField<Long> ORDERING_ID_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("OrderingId").getter(getter(ListGroupsOlderThanOrderingIdRequest::orderingId))
            .setter(setter(Builder::orderingId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrderingId").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListGroupsOlderThanOrderingIdRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListGroupsOlderThanOrderingIdRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INDEX_ID_FIELD,
            DATA_SOURCE_ID_FIELD, ORDERING_ID_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private final String indexId;

    private final String dataSourceId;

    private final Long orderingId;

    private final String nextToken;

    private final Integer maxResults;

    private ListGroupsOlderThanOrderingIdRequest(BuilderImpl builder) {
        super(builder);
        this.indexId = builder.indexId;
        this.dataSourceId = builder.dataSourceId;
        this.orderingId = builder.orderingId;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * The identifier of the index for getting a list of groups mapped to users before a given ordering or timestamp
     * identifier.
     * </p>
     * 
     * @return The identifier of the index for getting a list of groups mapped to users before a given ordering or
     *         timestamp identifier.
     */
    public final String indexId() {
        return indexId;
    }

    /**
     * <p>
     * The identifier of the data source for getting a list of groups mapped to users before a given ordering timestamp
     * identifier.
     * </p>
     * 
     * @return The identifier of the data source for getting a list of groups mapped to users before a given ordering
     *         timestamp identifier.
     */
    public final String dataSourceId() {
        return dataSourceId;
    }

    /**
     * <p>
     * The timestamp identifier used for the latest <code>PUT</code> or <code>DELETE</code> action for mapping users to
     * their groups.
     * </p>
     * 
     * @return The timestamp identifier used for the latest <code>PUT</code> or <code>DELETE</code> action for mapping
     *         users to their groups.
     */
    public final Long orderingId() {
        return orderingId;
    }

    /**
     * <p>
     * The next items in the list of groups that go beyond the maximum.
     * </p>
     * 
     * @return The next items in the list of groups that go beyond the maximum.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum results shown for a list of groups that are mapped to users before a given ordering or timestamp
     * identifier.
     * </p>
     * 
     * @return The maximum results shown for a list of groups that are mapped to users before a given ordering or
     *         timestamp identifier.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(indexId());
        hashCode = 31 * hashCode + Objects.hashCode(dataSourceId());
        hashCode = 31 * hashCode + Objects.hashCode(orderingId());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListGroupsOlderThanOrderingIdRequest)) {
            return false;
        }
        ListGroupsOlderThanOrderingIdRequest other = (ListGroupsOlderThanOrderingIdRequest) obj;
        return Objects.equals(indexId(), other.indexId()) && Objects.equals(dataSourceId(), other.dataSourceId())
                && Objects.equals(orderingId(), other.orderingId()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListGroupsOlderThanOrderingIdRequest").add("IndexId", indexId())
                .add("DataSourceId", dataSourceId()).add("OrderingId", orderingId()).add("NextToken", nextToken())
                .add("MaxResults", maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IndexId":
            return Optional.ofNullable(clazz.cast(indexId()));
        case "DataSourceId":
            return Optional.ofNullable(clazz.cast(dataSourceId()));
        case "OrderingId":
            return Optional.ofNullable(clazz.cast(orderingId()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListGroupsOlderThanOrderingIdRequest, T> g) {
        return obj -> g.apply((ListGroupsOlderThanOrderingIdRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KendraRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListGroupsOlderThanOrderingIdRequest> {
        /**
         * <p>
         * The identifier of the index for getting a list of groups mapped to users before a given ordering or timestamp
         * identifier.
         * </p>
         * 
         * @param indexId
         *        The identifier of the index for getting a list of groups mapped to users before a given ordering or
         *        timestamp identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexId(String indexId);

        /**
         * <p>
         * The identifier of the data source for getting a list of groups mapped to users before a given ordering
         * timestamp identifier.
         * </p>
         * 
         * @param dataSourceId
         *        The identifier of the data source for getting a list of groups mapped to users before a given ordering
         *        timestamp identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSourceId(String dataSourceId);

        /**
         * <p>
         * The timestamp identifier used for the latest <code>PUT</code> or <code>DELETE</code> action for mapping users
         * to their groups.
         * </p>
         * 
         * @param orderingId
         *        The timestamp identifier used for the latest <code>PUT</code> or <code>DELETE</code> action for
         *        mapping users to their groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder orderingId(Long orderingId);

        /**
         * <p>
         * The next items in the list of groups that go beyond the maximum.
         * </p>
         * 
         * @param nextToken
         *        The next items in the list of groups that go beyond the maximum.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum results shown for a list of groups that are mapped to users before a given ordering or timestamp
         * identifier.
         * </p>
         * 
         * @param maxResults
         *        The maximum results shown for a list of groups that are mapped to users before a given ordering or
         *        timestamp identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends KendraRequest.BuilderImpl implements Builder {
        private String indexId;

        private String dataSourceId;

        private Long orderingId;

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListGroupsOlderThanOrderingIdRequest model) {
            super(model);
            indexId(model.indexId);
            dataSourceId(model.dataSourceId);
            orderingId(model.orderingId);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final String getIndexId() {
            return indexId;
        }

        @Override
        public final Builder indexId(String indexId) {
            this.indexId = indexId;
            return this;
        }

        public final void setIndexId(String indexId) {
            this.indexId = indexId;
        }

        public final String getDataSourceId() {
            return dataSourceId;
        }

        @Override
        public final Builder dataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
            return this;
        }

        public final void setDataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
        }

        public final Long getOrderingId() {
            return orderingId;
        }

        @Override
        public final Builder orderingId(Long orderingId) {
            this.orderingId = orderingId;
            return this;
        }

        public final void setOrderingId(Long orderingId) {
            this.orderingId = orderingId;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListGroupsOlderThanOrderingIdRequest build() {
            return new ListGroupsOlderThanOrderingIdRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
