/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides statistical information about the FAQ questions and answers contained in an index.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FaqStatistics implements SdkPojo, Serializable, ToCopyableBuilder<FaqStatistics.Builder, FaqStatistics> {
    private static final SdkField<Integer> INDEXED_QUESTION_ANSWERS_COUNT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("IndexedQuestionAnswersCount")
            .getter(getter(FaqStatistics::indexedQuestionAnswersCount))
            .setter(setter(Builder::indexedQuestionAnswersCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexedQuestionAnswersCount")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(INDEXED_QUESTION_ANSWERS_COUNT_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer indexedQuestionAnswersCount;

    private FaqStatistics(BuilderImpl builder) {
        this.indexedQuestionAnswersCount = builder.indexedQuestionAnswersCount;
    }

    /**
     * <p>
     * The total number of FAQ questions and answers contained in the index.
     * </p>
     * 
     * @return The total number of FAQ questions and answers contained in the index.
     */
    public final Integer indexedQuestionAnswersCount() {
        return indexedQuestionAnswersCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(indexedQuestionAnswersCount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FaqStatistics)) {
            return false;
        }
        FaqStatistics other = (FaqStatistics) obj;
        return Objects.equals(indexedQuestionAnswersCount(), other.indexedQuestionAnswersCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FaqStatistics").add("IndexedQuestionAnswersCount", indexedQuestionAnswersCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IndexedQuestionAnswersCount":
            return Optional.ofNullable(clazz.cast(indexedQuestionAnswersCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FaqStatistics, T> g) {
        return obj -> g.apply((FaqStatistics) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FaqStatistics> {
        /**
         * <p>
         * The total number of FAQ questions and answers contained in the index.
         * </p>
         * 
         * @param indexedQuestionAnswersCount
         *        The total number of FAQ questions and answers contained in the index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexedQuestionAnswersCount(Integer indexedQuestionAnswersCount);
    }

    static final class BuilderImpl implements Builder {
        private Integer indexedQuestionAnswersCount;

        private BuilderImpl() {
        }

        private BuilderImpl(FaqStatistics model) {
            indexedQuestionAnswersCount(model.indexedQuestionAnswersCount);
        }

        public final Integer getIndexedQuestionAnswersCount() {
            return indexedQuestionAnswersCount;
        }

        public final void setIndexedQuestionAnswersCount(Integer indexedQuestionAnswersCount) {
            this.indexedQuestionAnswersCount = indexedQuestionAnswersCount;
        }

        @Override
        @Transient
        public final Builder indexedQuestionAnswersCount(Integer indexedQuestionAnswersCount) {
            this.indexedQuestionAnswersCount = indexedQuestionAnswersCount;
            return this;
        }

        @Override
        public FaqStatistics build() {
            return new FaqStatistics(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
