/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides configuration information for standard Salesforce knowledge articles.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SalesforceStandardKnowledgeArticleTypeConfiguration
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<SalesforceStandardKnowledgeArticleTypeConfiguration.Builder, SalesforceStandardKnowledgeArticleTypeConfiguration> {
    private static final SdkField<String> DOCUMENT_DATA_FIELD_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DocumentDataFieldName")
            .getter(getter(SalesforceStandardKnowledgeArticleTypeConfiguration::documentDataFieldName))
            .setter(setter(Builder::documentDataFieldName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentDataFieldName").build())
            .build();

    private static final SdkField<String> DOCUMENT_TITLE_FIELD_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DocumentTitleFieldName")
            .getter(getter(SalesforceStandardKnowledgeArticleTypeConfiguration::documentTitleFieldName))
            .setter(setter(Builder::documentTitleFieldName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentTitleFieldName").build())
            .build();

    private static final SdkField<List<DataSourceToIndexFieldMapping>> FIELD_MAPPINGS_FIELD = SdkField
            .<List<DataSourceToIndexFieldMapping>> builder(MarshallingType.LIST)
            .memberName("FieldMappings")
            .getter(getter(SalesforceStandardKnowledgeArticleTypeConfiguration::fieldMappings))
            .setter(setter(Builder::fieldMappings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldMappings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DataSourceToIndexFieldMapping> builder(MarshallingType.SDK_POJO)
                                            .constructor(DataSourceToIndexFieldMapping::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            DOCUMENT_DATA_FIELD_NAME_FIELD, DOCUMENT_TITLE_FIELD_NAME_FIELD, FIELD_MAPPINGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String documentDataFieldName;

    private final String documentTitleFieldName;

    private final List<DataSourceToIndexFieldMapping> fieldMappings;

    private SalesforceStandardKnowledgeArticleTypeConfiguration(BuilderImpl builder) {
        this.documentDataFieldName = builder.documentDataFieldName;
        this.documentTitleFieldName = builder.documentTitleFieldName;
        this.fieldMappings = builder.fieldMappings;
    }

    /**
     * <p>
     * The name of the field that contains the document data to index.
     * </p>
     * 
     * @return The name of the field that contains the document data to index.
     */
    public final String documentDataFieldName() {
        return documentDataFieldName;
    }

    /**
     * <p>
     * The name of the field that contains the document title.
     * </p>
     * 
     * @return The name of the field that contains the document title.
     */
    public final String documentTitleFieldName() {
        return documentTitleFieldName;
    }

    /**
     * For responses, this returns true if the service returned a value for the FieldMappings property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFieldMappings() {
        return fieldMappings != null && !(fieldMappings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more objects that map fields in the knowledge article to Amazon Kendra index fields. The index field must
     * exist before you can map a Salesforce field to it.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFieldMappings} method.
     * </p>
     * 
     * @return One or more objects that map fields in the knowledge article to Amazon Kendra index fields. The index
     *         field must exist before you can map a Salesforce field to it.
     */
    public final List<DataSourceToIndexFieldMapping> fieldMappings() {
        return fieldMappings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(documentDataFieldName());
        hashCode = 31 * hashCode + Objects.hashCode(documentTitleFieldName());
        hashCode = 31 * hashCode + Objects.hashCode(hasFieldMappings() ? fieldMappings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SalesforceStandardKnowledgeArticleTypeConfiguration)) {
            return false;
        }
        SalesforceStandardKnowledgeArticleTypeConfiguration other = (SalesforceStandardKnowledgeArticleTypeConfiguration) obj;
        return Objects.equals(documentDataFieldName(), other.documentDataFieldName())
                && Objects.equals(documentTitleFieldName(), other.documentTitleFieldName())
                && hasFieldMappings() == other.hasFieldMappings() && Objects.equals(fieldMappings(), other.fieldMappings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SalesforceStandardKnowledgeArticleTypeConfiguration")
                .add("DocumentDataFieldName", documentDataFieldName()).add("DocumentTitleFieldName", documentTitleFieldName())
                .add("FieldMappings", hasFieldMappings() ? fieldMappings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DocumentDataFieldName":
            return Optional.ofNullable(clazz.cast(documentDataFieldName()));
        case "DocumentTitleFieldName":
            return Optional.ofNullable(clazz.cast(documentTitleFieldName()));
        case "FieldMappings":
            return Optional.ofNullable(clazz.cast(fieldMappings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SalesforceStandardKnowledgeArticleTypeConfiguration, T> g) {
        return obj -> g.apply((SalesforceStandardKnowledgeArticleTypeConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SalesforceStandardKnowledgeArticleTypeConfiguration> {
        /**
         * <p>
         * The name of the field that contains the document data to index.
         * </p>
         * 
         * @param documentDataFieldName
         *        The name of the field that contains the document data to index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentDataFieldName(String documentDataFieldName);

        /**
         * <p>
         * The name of the field that contains the document title.
         * </p>
         * 
         * @param documentTitleFieldName
         *        The name of the field that contains the document title.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentTitleFieldName(String documentTitleFieldName);

        /**
         * <p>
         * One or more objects that map fields in the knowledge article to Amazon Kendra index fields. The index field
         * must exist before you can map a Salesforce field to it.
         * </p>
         * 
         * @param fieldMappings
         *        One or more objects that map fields in the knowledge article to Amazon Kendra index fields. The index
         *        field must exist before you can map a Salesforce field to it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldMappings(Collection<DataSourceToIndexFieldMapping> fieldMappings);

        /**
         * <p>
         * One or more objects that map fields in the knowledge article to Amazon Kendra index fields. The index field
         * must exist before you can map a Salesforce field to it.
         * </p>
         * 
         * @param fieldMappings
         *        One or more objects that map fields in the knowledge article to Amazon Kendra index fields. The index
         *        field must exist before you can map a Salesforce field to it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldMappings(DataSourceToIndexFieldMapping... fieldMappings);

        /**
         * <p>
         * One or more objects that map fields in the knowledge article to Amazon Kendra index fields. The index field
         * must exist before you can map a Salesforce field to it.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DataSourceToIndexFieldMapping>.Builder}
         * avoiding the need to create one manually via {@link List<DataSourceToIndexFieldMapping>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DataSourceToIndexFieldMapping>.Builder#build()} is called
         * immediately and its result is passed to {@link #fieldMappings(List<DataSourceToIndexFieldMapping>)}.
         * 
         * @param fieldMappings
         *        a consumer that will call methods on {@link List<DataSourceToIndexFieldMapping>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fieldMappings(List<DataSourceToIndexFieldMapping>)
         */
        Builder fieldMappings(Consumer<DataSourceToIndexFieldMapping.Builder>... fieldMappings);
    }

    static final class BuilderImpl implements Builder {
        private String documentDataFieldName;

        private String documentTitleFieldName;

        private List<DataSourceToIndexFieldMapping> fieldMappings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SalesforceStandardKnowledgeArticleTypeConfiguration model) {
            documentDataFieldName(model.documentDataFieldName);
            documentTitleFieldName(model.documentTitleFieldName);
            fieldMappings(model.fieldMappings);
        }

        public final String getDocumentDataFieldName() {
            return documentDataFieldName;
        }

        public final void setDocumentDataFieldName(String documentDataFieldName) {
            this.documentDataFieldName = documentDataFieldName;
        }

        @Override
        @Transient
        public final Builder documentDataFieldName(String documentDataFieldName) {
            this.documentDataFieldName = documentDataFieldName;
            return this;
        }

        public final String getDocumentTitleFieldName() {
            return documentTitleFieldName;
        }

        public final void setDocumentTitleFieldName(String documentTitleFieldName) {
            this.documentTitleFieldName = documentTitleFieldName;
        }

        @Override
        @Transient
        public final Builder documentTitleFieldName(String documentTitleFieldName) {
            this.documentTitleFieldName = documentTitleFieldName;
            return this;
        }

        public final List<DataSourceToIndexFieldMapping.Builder> getFieldMappings() {
            List<DataSourceToIndexFieldMapping.Builder> result = DataSourceToIndexFieldMappingListCopier
                    .copyToBuilder(this.fieldMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFieldMappings(Collection<DataSourceToIndexFieldMapping.BuilderImpl> fieldMappings) {
            this.fieldMappings = DataSourceToIndexFieldMappingListCopier.copyFromBuilder(fieldMappings);
        }

        @Override
        @Transient
        public final Builder fieldMappings(Collection<DataSourceToIndexFieldMapping> fieldMappings) {
            this.fieldMappings = DataSourceToIndexFieldMappingListCopier.copy(fieldMappings);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder fieldMappings(DataSourceToIndexFieldMapping... fieldMappings) {
            fieldMappings(Arrays.asList(fieldMappings));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder fieldMappings(Consumer<DataSourceToIndexFieldMapping.Builder>... fieldMappings) {
            fieldMappings(Stream.of(fieldMappings).map(c -> DataSourceToIndexFieldMapping.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public SalesforceStandardKnowledgeArticleTypeConfiguration build() {
            return new SalesforceStandardKnowledgeArticleTypeConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
