/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListQuerySuggestionsBlockListsResponse extends KendraResponse implements
        ToCopyableBuilder<ListQuerySuggestionsBlockListsResponse.Builder, ListQuerySuggestionsBlockListsResponse> {
    private static final SdkField<List<QuerySuggestionsBlockListSummary>> BLOCK_LIST_SUMMARY_ITEMS_FIELD = SdkField
            .<List<QuerySuggestionsBlockListSummary>> builder(MarshallingType.LIST)
            .memberName("BlockListSummaryItems")
            .getter(getter(ListQuerySuggestionsBlockListsResponse::blockListSummaryItems))
            .setter(setter(Builder::blockListSummaryItems))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlockListSummaryItems").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<QuerySuggestionsBlockListSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(QuerySuggestionsBlockListSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListQuerySuggestionsBlockListsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            BLOCK_LIST_SUMMARY_ITEMS_FIELD, NEXT_TOKEN_FIELD));

    private final List<QuerySuggestionsBlockListSummary> blockListSummaryItems;

    private final String nextToken;

    private ListQuerySuggestionsBlockListsResponse(BuilderImpl builder) {
        super(builder);
        this.blockListSummaryItems = builder.blockListSummaryItems;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the BlockListSummaryItems property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasBlockListSummaryItems() {
        return blockListSummaryItems != null && !(blockListSummaryItems instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Summary items for a block list.
     * </p>
     * <p>
     * This includes summary items on the block list ID, block list name, when the block list was created, when the
     * block list was last updated, and the count of block words/phrases in the block list.
     * </p>
     * <p>
     * For information on the current quota limits for block lists, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/quotas.html">Quotas for Amazon Kendra</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBlockListSummaryItems} method.
     * </p>
     * 
     * @return Summary items for a block list.</p>
     *         <p>
     *         This includes summary items on the block list ID, block list name, when the block list was created, when
     *         the block list was last updated, and the count of block words/phrases in the block list.
     *         </p>
     *         <p>
     *         For information on the current quota limits for block lists, see <a
     *         href="https://docs.aws.amazon.com/kendra/latest/dg/quotas.html">Quotas for Amazon Kendra</a>.
     */
    public final List<QuerySuggestionsBlockListSummary> blockListSummaryItems() {
        return blockListSummaryItems;
    }

    /**
     * <p>
     * If the response is truncated, Amazon Kendra returns this token that you can use in the subsequent request to
     * retrieve the next set of block lists.
     * </p>
     * 
     * @return If the response is truncated, Amazon Kendra returns this token that you can use in the subsequent request
     *         to retrieve the next set of block lists.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasBlockListSummaryItems() ? blockListSummaryItems() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListQuerySuggestionsBlockListsResponse)) {
            return false;
        }
        ListQuerySuggestionsBlockListsResponse other = (ListQuerySuggestionsBlockListsResponse) obj;
        return hasBlockListSummaryItems() == other.hasBlockListSummaryItems()
                && Objects.equals(blockListSummaryItems(), other.blockListSummaryItems())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListQuerySuggestionsBlockListsResponse")
                .add("BlockListSummaryItems", hasBlockListSummaryItems() ? blockListSummaryItems() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BlockListSummaryItems":
            return Optional.ofNullable(clazz.cast(blockListSummaryItems()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListQuerySuggestionsBlockListsResponse, T> g) {
        return obj -> g.apply((ListQuerySuggestionsBlockListsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KendraResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListQuerySuggestionsBlockListsResponse> {
        /**
         * <p>
         * Summary items for a block list.
         * </p>
         * <p>
         * This includes summary items on the block list ID, block list name, when the block list was created, when the
         * block list was last updated, and the count of block words/phrases in the block list.
         * </p>
         * <p>
         * For information on the current quota limits for block lists, see <a
         * href="https://docs.aws.amazon.com/kendra/latest/dg/quotas.html">Quotas for Amazon Kendra</a>.
         * </p>
         * 
         * @param blockListSummaryItems
         *        Summary items for a block list.</p>
         *        <p>
         *        This includes summary items on the block list ID, block list name, when the block list was created,
         *        when the block list was last updated, and the count of block words/phrases in the block list.
         *        </p>
         *        <p>
         *        For information on the current quota limits for block lists, see <a
         *        href="https://docs.aws.amazon.com/kendra/latest/dg/quotas.html">Quotas for Amazon Kendra</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockListSummaryItems(Collection<QuerySuggestionsBlockListSummary> blockListSummaryItems);

        /**
         * <p>
         * Summary items for a block list.
         * </p>
         * <p>
         * This includes summary items on the block list ID, block list name, when the block list was created, when the
         * block list was last updated, and the count of block words/phrases in the block list.
         * </p>
         * <p>
         * For information on the current quota limits for block lists, see <a
         * href="https://docs.aws.amazon.com/kendra/latest/dg/quotas.html">Quotas for Amazon Kendra</a>.
         * </p>
         * 
         * @param blockListSummaryItems
         *        Summary items for a block list.</p>
         *        <p>
         *        This includes summary items on the block list ID, block list name, when the block list was created,
         *        when the block list was last updated, and the count of block words/phrases in the block list.
         *        </p>
         *        <p>
         *        For information on the current quota limits for block lists, see <a
         *        href="https://docs.aws.amazon.com/kendra/latest/dg/quotas.html">Quotas for Amazon Kendra</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockListSummaryItems(QuerySuggestionsBlockListSummary... blockListSummaryItems);

        /**
         * <p>
         * Summary items for a block list.
         * </p>
         * <p>
         * This includes summary items on the block list ID, block list name, when the block list was created, when the
         * block list was last updated, and the count of block words/phrases in the block list.
         * </p>
         * <p>
         * For information on the current quota limits for block lists, see <a
         * href="https://docs.aws.amazon.com/kendra/latest/dg/quotas.html">Quotas for Amazon Kendra</a>.
         * </p>
         * This is a convenience that creates an instance of the {@link List<QuerySuggestionsBlockListSummary>.Builder}
         * avoiding the need to create one manually via {@link List<QuerySuggestionsBlockListSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<QuerySuggestionsBlockListSummary>.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #blockListSummaryItems(List<QuerySuggestionsBlockListSummary>)}.
         * 
         * @param blockListSummaryItems
         *        a consumer that will call methods on {@link List<QuerySuggestionsBlockListSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #blockListSummaryItems(List<QuerySuggestionsBlockListSummary>)
         */
        Builder blockListSummaryItems(Consumer<QuerySuggestionsBlockListSummary.Builder>... blockListSummaryItems);

        /**
         * <p>
         * If the response is truncated, Amazon Kendra returns this token that you can use in the subsequent request to
         * retrieve the next set of block lists.
         * </p>
         * 
         * @param nextToken
         *        If the response is truncated, Amazon Kendra returns this token that you can use in the subsequent
         *        request to retrieve the next set of block lists.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends KendraResponse.BuilderImpl implements Builder {
        private List<QuerySuggestionsBlockListSummary> blockListSummaryItems = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListQuerySuggestionsBlockListsResponse model) {
            super(model);
            blockListSummaryItems(model.blockListSummaryItems);
            nextToken(model.nextToken);
        }

        public final List<QuerySuggestionsBlockListSummary.Builder> getBlockListSummaryItems() {
            List<QuerySuggestionsBlockListSummary.Builder> result = QuerySuggestionsBlockListSummaryItemsCopier
                    .copyToBuilder(this.blockListSummaryItems);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBlockListSummaryItems(Collection<QuerySuggestionsBlockListSummary.BuilderImpl> blockListSummaryItems) {
            this.blockListSummaryItems = QuerySuggestionsBlockListSummaryItemsCopier.copyFromBuilder(blockListSummaryItems);
        }

        @Override
        @Transient
        public final Builder blockListSummaryItems(Collection<QuerySuggestionsBlockListSummary> blockListSummaryItems) {
            this.blockListSummaryItems = QuerySuggestionsBlockListSummaryItemsCopier.copy(blockListSummaryItems);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder blockListSummaryItems(QuerySuggestionsBlockListSummary... blockListSummaryItems) {
            blockListSummaryItems(Arrays.asList(blockListSummaryItems));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder blockListSummaryItems(Consumer<QuerySuggestionsBlockListSummary.Builder>... blockListSummaryItems) {
            blockListSummaryItems(Stream.of(blockListSummaryItems)
                    .map(c -> QuerySuggestionsBlockListSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListQuerySuggestionsBlockListsResponse build() {
            return new ListQuerySuggestionsBlockListsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
