/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssociateEntitiesToExperienceRequest extends KendraRequest implements
        ToCopyableBuilder<AssociateEntitiesToExperienceRequest.Builder, AssociateEntitiesToExperienceRequest> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(AssociateEntitiesToExperienceRequest::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> INDEX_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IndexId").getter(getter(AssociateEntitiesToExperienceRequest::indexId)).setter(setter(Builder::indexId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexId").build()).build();

    private static final SdkField<List<EntityConfiguration>> ENTITY_LIST_FIELD = SdkField
            .<List<EntityConfiguration>> builder(MarshallingType.LIST)
            .memberName("EntityList")
            .getter(getter(AssociateEntitiesToExperienceRequest::entityList))
            .setter(setter(Builder::entityList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntityList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EntityConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(EntityConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, INDEX_ID_FIELD,
            ENTITY_LIST_FIELD));

    private final String id;

    private final String indexId;

    private final List<EntityConfiguration> entityList;

    private AssociateEntitiesToExperienceRequest(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.indexId = builder.indexId;
        this.entityList = builder.entityList;
    }

    /**
     * <p>
     * The identifier of your Amazon Kendra experience.
     * </p>
     * 
     * @return The identifier of your Amazon Kendra experience.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The identifier of the index for your Amazon Kendra experience.
     * </p>
     * 
     * @return The identifier of the index for your Amazon Kendra experience.
     */
    public final String indexId() {
        return indexId;
    }

    /**
     * For responses, this returns true if the service returned a value for the EntityList property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasEntityList() {
        return entityList != null && !(entityList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Lists users or groups in your Amazon Web Services SSO identity source.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEntityList} method.
     * </p>
     * 
     * @return Lists users or groups in your Amazon Web Services SSO identity source.
     */
    public final List<EntityConfiguration> entityList() {
        return entityList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(indexId());
        hashCode = 31 * hashCode + Objects.hashCode(hasEntityList() ? entityList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateEntitiesToExperienceRequest)) {
            return false;
        }
        AssociateEntitiesToExperienceRequest other = (AssociateEntitiesToExperienceRequest) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(indexId(), other.indexId())
                && hasEntityList() == other.hasEntityList() && Objects.equals(entityList(), other.entityList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssociateEntitiesToExperienceRequest").add("Id", id()).add("IndexId", indexId())
                .add("EntityList", hasEntityList() ? entityList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "IndexId":
            return Optional.ofNullable(clazz.cast(indexId()));
        case "EntityList":
            return Optional.ofNullable(clazz.cast(entityList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssociateEntitiesToExperienceRequest, T> g) {
        return obj -> g.apply((AssociateEntitiesToExperienceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KendraRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, AssociateEntitiesToExperienceRequest> {
        /**
         * <p>
         * The identifier of your Amazon Kendra experience.
         * </p>
         * 
         * @param id
         *        The identifier of your Amazon Kendra experience.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The identifier of the index for your Amazon Kendra experience.
         * </p>
         * 
         * @param indexId
         *        The identifier of the index for your Amazon Kendra experience.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexId(String indexId);

        /**
         * <p>
         * Lists users or groups in your Amazon Web Services SSO identity source.
         * </p>
         * 
         * @param entityList
         *        Lists users or groups in your Amazon Web Services SSO identity source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityList(Collection<EntityConfiguration> entityList);

        /**
         * <p>
         * Lists users or groups in your Amazon Web Services SSO identity source.
         * </p>
         * 
         * @param entityList
         *        Lists users or groups in your Amazon Web Services SSO identity source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityList(EntityConfiguration... entityList);

        /**
         * <p>
         * Lists users or groups in your Amazon Web Services SSO identity source.
         * </p>
         * This is a convenience that creates an instance of the {@link List<EntityConfiguration>.Builder} avoiding the
         * need to create one manually via {@link List<EntityConfiguration>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<EntityConfiguration>.Builder#build()} is called immediately
         * and its result is passed to {@link #entityList(List<EntityConfiguration>)}.
         * 
         * @param entityList
         *        a consumer that will call methods on {@link List<EntityConfiguration>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #entityList(List<EntityConfiguration>)
         */
        Builder entityList(Consumer<EntityConfiguration.Builder>... entityList);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends KendraRequest.BuilderImpl implements Builder {
        private String id;

        private String indexId;

        private List<EntityConfiguration> entityList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateEntitiesToExperienceRequest model) {
            super(model);
            id(model.id);
            indexId(model.indexId);
            entityList(model.entityList);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        @Transient
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getIndexId() {
            return indexId;
        }

        public final void setIndexId(String indexId) {
            this.indexId = indexId;
        }

        @Override
        @Transient
        public final Builder indexId(String indexId) {
            this.indexId = indexId;
            return this;
        }

        public final List<EntityConfiguration.Builder> getEntityList() {
            List<EntityConfiguration.Builder> result = AssociateEntityListCopier.copyToBuilder(this.entityList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEntityList(Collection<EntityConfiguration.BuilderImpl> entityList) {
            this.entityList = AssociateEntityListCopier.copyFromBuilder(entityList);
        }

        @Override
        @Transient
        public final Builder entityList(Collection<EntityConfiguration> entityList) {
            this.entityList = AssociateEntityListCopier.copy(entityList);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder entityList(EntityConfiguration... entityList) {
            entityList(Arrays.asList(entityList));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder entityList(Consumer<EntityConfiguration.Builder>... entityList) {
            entityList(Stream.of(entityList).map(c -> EntityConfiguration.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociateEntitiesToExperienceRequest build() {
            return new AssociateEntitiesToExperienceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
