/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides the configuration information of the sitemap URLs to crawl.
 * </p>
 * <p>
 * <i>When selecting websites to index, you must adhere to the <a href="https://aws.amazon.com/aup/">Amazon Acceptable
 * Use Policy</a> and all other Amazon terms. Remember that you must only use Amazon Kendra Web Crawler to index your
 * own webpages, or webpages that you have authorization to index.</i>
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SiteMapsConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<SiteMapsConfiguration.Builder, SiteMapsConfiguration> {
    private static final SdkField<List<String>> SITE_MAPS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SiteMaps")
            .getter(getter(SiteMapsConfiguration::siteMaps))
            .setter(setter(Builder::siteMaps))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SiteMaps").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SITE_MAPS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> siteMaps;

    private SiteMapsConfiguration(BuilderImpl builder) {
        this.siteMaps = builder.siteMaps;
    }

    /**
     * For responses, this returns true if the service returned a value for the SiteMaps property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSiteMaps() {
        return siteMaps != null && !(siteMaps instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of sitemap URLs of the websites you want to crawl.
     * </p>
     * <p>
     * The list can include a maximum of three sitemap URLs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSiteMaps} method.
     * </p>
     * 
     * @return The list of sitemap URLs of the websites you want to crawl.</p>
     *         <p>
     *         The list can include a maximum of three sitemap URLs.
     */
    public final List<String> siteMaps() {
        return siteMaps;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasSiteMaps() ? siteMaps() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SiteMapsConfiguration)) {
            return false;
        }
        SiteMapsConfiguration other = (SiteMapsConfiguration) obj;
        return hasSiteMaps() == other.hasSiteMaps() && Objects.equals(siteMaps(), other.siteMaps());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SiteMapsConfiguration").add("SiteMaps", hasSiteMaps() ? siteMaps() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SiteMaps":
            return Optional.ofNullable(clazz.cast(siteMaps()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SiteMapsConfiguration, T> g) {
        return obj -> g.apply((SiteMapsConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SiteMapsConfiguration> {
        /**
         * <p>
         * The list of sitemap URLs of the websites you want to crawl.
         * </p>
         * <p>
         * The list can include a maximum of three sitemap URLs.
         * </p>
         * 
         * @param siteMaps
         *        The list of sitemap URLs of the websites you want to crawl.</p>
         *        <p>
         *        The list can include a maximum of three sitemap URLs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder siteMaps(Collection<String> siteMaps);

        /**
         * <p>
         * The list of sitemap URLs of the websites you want to crawl.
         * </p>
         * <p>
         * The list can include a maximum of three sitemap URLs.
         * </p>
         * 
         * @param siteMaps
         *        The list of sitemap URLs of the websites you want to crawl.</p>
         *        <p>
         *        The list can include a maximum of three sitemap URLs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder siteMaps(String... siteMaps);
    }

    static final class BuilderImpl implements Builder {
        private List<String> siteMaps = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SiteMapsConfiguration model) {
            siteMaps(model.siteMaps);
        }

        public final Collection<String> getSiteMaps() {
            if (siteMaps instanceof SdkAutoConstructList) {
                return null;
            }
            return siteMaps;
        }

        public final void setSiteMaps(Collection<String> siteMaps) {
            this.siteMaps = SiteMapsListCopier.copy(siteMaps);
        }

        @Override
        @Transient
        public final Builder siteMaps(Collection<String> siteMaps) {
            this.siteMaps = SiteMapsListCopier.copy(siteMaps);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder siteMaps(String... siteMaps) {
            siteMaps(Arrays.asList(siteMaps));
            return this;
        }

        @Override
        public SiteMapsConfiguration build() {
            return new SiteMapsConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
