/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kendra.model.EntityDisplayData;
import software.amazon.awssdk.services.kendra.model.EntityType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExperienceEntitiesSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ExperienceEntitiesSummary> {
    private static final SdkField<String> ENTITY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EntityId").getter(ExperienceEntitiesSummary.getter(ExperienceEntitiesSummary::entityId)).setter(ExperienceEntitiesSummary.setter(Builder::entityId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntityId").build()}).build();
    private static final SdkField<String> ENTITY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EntityType").getter(ExperienceEntitiesSummary.getter(ExperienceEntitiesSummary::entityTypeAsString)).setter(ExperienceEntitiesSummary.setter(Builder::entityType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntityType").build()}).build();
    private static final SdkField<EntityDisplayData> DISPLAY_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DisplayData").getter(ExperienceEntitiesSummary.getter(ExperienceEntitiesSummary::displayData)).setter(ExperienceEntitiesSummary.setter(Builder::displayData)).constructor(EntityDisplayData::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayData").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTITY_ID_FIELD, ENTITY_TYPE_FIELD, DISPLAY_DATA_FIELD));
    private static final long serialVersionUID = 1L;
    private final String entityId;
    private final String entityType;
    private final EntityDisplayData displayData;

    private ExperienceEntitiesSummary(BuilderImpl builder) {
        this.entityId = builder.entityId;
        this.entityType = builder.entityType;
        this.displayData = builder.displayData;
    }

    public final String entityId() {
        return this.entityId;
    }

    public final EntityType entityType() {
        return EntityType.fromValue(this.entityType);
    }

    public final String entityTypeAsString() {
        return this.entityType;
    }

    public final EntityDisplayData displayData() {
        return this.displayData;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.entityId());
        hashCode = 31 * hashCode + Objects.hashCode(this.entityTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayData());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExperienceEntitiesSummary)) {
            return false;
        }
        ExperienceEntitiesSummary other = (ExperienceEntitiesSummary)obj;
        return Objects.equals(this.entityId(), other.entityId()) && Objects.equals(this.entityTypeAsString(), other.entityTypeAsString()) && Objects.equals(this.displayData(), other.displayData());
    }

    public final String toString() {
        return ToString.builder((String)"ExperienceEntitiesSummary").add("EntityId", (Object)this.entityId()).add("EntityType", (Object)this.entityTypeAsString()).add("DisplayData", (Object)this.displayData()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EntityId": {
                return Optional.ofNullable(clazz.cast(this.entityId()));
            }
            case "EntityType": {
                return Optional.ofNullable(clazz.cast(this.entityTypeAsString()));
            }
            case "DisplayData": {
                return Optional.ofNullable(clazz.cast(this.displayData()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExperienceEntitiesSummary, T> g) {
        return obj -> g.apply((ExperienceEntitiesSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String entityId;
        private String entityType;
        private EntityDisplayData displayData;

        private BuilderImpl() {
        }

        private BuilderImpl(ExperienceEntitiesSummary model) {
            this.entityId(model.entityId);
            this.entityType(model.entityType);
            this.displayData(model.displayData);
        }

        public final String getEntityId() {
            return this.entityId;
        }

        public final void setEntityId(String entityId) {
            this.entityId = entityId;
        }

        @Override
        @Transient
        public final Builder entityId(String entityId) {
            this.entityId = entityId;
            return this;
        }

        public final String getEntityType() {
            return this.entityType;
        }

        public final void setEntityType(String entityType) {
            this.entityType = entityType;
        }

        @Override
        @Transient
        public final Builder entityType(String entityType) {
            this.entityType = entityType;
            return this;
        }

        @Override
        @Transient
        public final Builder entityType(EntityType entityType) {
            this.entityType(entityType == null ? null : entityType.toString());
            return this;
        }

        public final EntityDisplayData.Builder getDisplayData() {
            return this.displayData != null ? this.displayData.toBuilder() : null;
        }

        public final void setDisplayData(EntityDisplayData.BuilderImpl displayData) {
            this.displayData = displayData != null ? displayData.build() : null;
        }

        @Override
        @Transient
        public final Builder displayData(EntityDisplayData displayData) {
            this.displayData = displayData;
            return this;
        }

        public ExperienceEntitiesSummary build() {
            return new ExperienceEntitiesSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ExperienceEntitiesSummary> {
        public Builder entityId(String var1);

        public Builder entityType(String var1);

        public Builder entityType(EntityType var1);

        public Builder displayData(EntityDisplayData var1);

        default public Builder displayData(Consumer<EntityDisplayData.Builder> displayData) {
            return this.displayData((EntityDisplayData)((EntityDisplayData.Builder)EntityDisplayData.builder().applyMutation(displayData)).build());
        }
    }
}

