/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kendra.model.PrincipalMappingStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GroupOrderingIdSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GroupOrderingIdSummary> {
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(GroupOrderingIdSummary.getter(GroupOrderingIdSummary::statusAsString)).setter(GroupOrderingIdSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdatedAt").getter(GroupOrderingIdSummary.getter(GroupOrderingIdSummary::lastUpdatedAt)).setter(GroupOrderingIdSummary.setter(Builder::lastUpdatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedAt").build()}).build();
    private static final SdkField<Instant> RECEIVED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ReceivedAt").getter(GroupOrderingIdSummary.getter(GroupOrderingIdSummary::receivedAt)).setter(GroupOrderingIdSummary.setter(Builder::receivedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReceivedAt").build()}).build();
    private static final SdkField<Long> ORDERING_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("OrderingId").getter(GroupOrderingIdSummary.getter(GroupOrderingIdSummary::orderingId)).setter(GroupOrderingIdSummary.setter(Builder::orderingId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrderingId").build()}).build();
    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FailureReason").getter(GroupOrderingIdSummary.getter(GroupOrderingIdSummary::failureReason)).setter(GroupOrderingIdSummary.setter(Builder::failureReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, LAST_UPDATED_AT_FIELD, RECEIVED_AT_FIELD, ORDERING_ID_FIELD, FAILURE_REASON_FIELD));
    private static final long serialVersionUID = 1L;
    private final String status;
    private final Instant lastUpdatedAt;
    private final Instant receivedAt;
    private final Long orderingId;
    private final String failureReason;

    private GroupOrderingIdSummary(BuilderImpl builder) {
        this.status = builder.status;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.receivedAt = builder.receivedAt;
        this.orderingId = builder.orderingId;
        this.failureReason = builder.failureReason;
    }

    public final PrincipalMappingStatus status() {
        return PrincipalMappingStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant lastUpdatedAt() {
        return this.lastUpdatedAt;
    }

    public final Instant receivedAt() {
        return this.receivedAt;
    }

    public final Long orderingId() {
        return this.orderingId;
    }

    public final String failureReason() {
        return this.failureReason;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.receivedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.orderingId());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureReason());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GroupOrderingIdSummary)) {
            return false;
        }
        GroupOrderingIdSummary other = (GroupOrderingIdSummary)obj;
        return Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.lastUpdatedAt(), other.lastUpdatedAt()) && Objects.equals(this.receivedAt(), other.receivedAt()) && Objects.equals(this.orderingId(), other.orderingId()) && Objects.equals(this.failureReason(), other.failureReason());
    }

    public final String toString() {
        return ToString.builder((String)"GroupOrderingIdSummary").add("Status", (Object)this.statusAsString()).add("LastUpdatedAt", (Object)this.lastUpdatedAt()).add("ReceivedAt", (Object)this.receivedAt()).add("OrderingId", (Object)this.orderingId()).add("FailureReason", (Object)this.failureReason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "LastUpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedAt()));
            }
            case "ReceivedAt": {
                return Optional.ofNullable(clazz.cast(this.receivedAt()));
            }
            case "OrderingId": {
                return Optional.ofNullable(clazz.cast(this.orderingId()));
            }
            case "FailureReason": {
                return Optional.ofNullable(clazz.cast(this.failureReason()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GroupOrderingIdSummary, T> g) {
        return obj -> g.apply((GroupOrderingIdSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String status;
        private Instant lastUpdatedAt;
        private Instant receivedAt;
        private Long orderingId;
        private String failureReason;

        private BuilderImpl() {
        }

        private BuilderImpl(GroupOrderingIdSummary model) {
            this.status(model.status);
            this.lastUpdatedAt(model.lastUpdatedAt);
            this.receivedAt(model.receivedAt);
            this.orderingId(model.orderingId);
            this.failureReason(model.failureReason);
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        @Transient
        public final Builder status(PrincipalMappingStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return this.lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        @Transient
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final Instant getReceivedAt() {
            return this.receivedAt;
        }

        public final void setReceivedAt(Instant receivedAt) {
            this.receivedAt = receivedAt;
        }

        @Override
        @Transient
        public final Builder receivedAt(Instant receivedAt) {
            this.receivedAt = receivedAt;
            return this;
        }

        public final Long getOrderingId() {
            return this.orderingId;
        }

        public final void setOrderingId(Long orderingId) {
            this.orderingId = orderingId;
        }

        @Override
        @Transient
        public final Builder orderingId(Long orderingId) {
            this.orderingId = orderingId;
            return this;
        }

        public final String getFailureReason() {
            return this.failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        @Transient
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public GroupOrderingIdSummary build() {
            return new GroupOrderingIdSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GroupOrderingIdSummary> {
        public Builder status(String var1);

        public Builder status(PrincipalMappingStatus var1);

        public Builder lastUpdatedAt(Instant var1);

        public Builder receivedAt(Instant var1);

        public Builder orderingId(Long var1);

        public Builder failureReason(String var1);
    }
}

