/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateExperienceRequest extends KendraRequest implements
        ToCopyableBuilder<CreateExperienceRequest.Builder, CreateExperienceRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreateExperienceRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> INDEX_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IndexId").getter(getter(CreateExperienceRequest::indexId)).setter(setter(Builder::indexId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexId").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(CreateExperienceRequest::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final SdkField<ExperienceConfiguration> CONFIGURATION_FIELD = SdkField
            .<ExperienceConfiguration> builder(MarshallingType.SDK_POJO).memberName("Configuration")
            .getter(getter(CreateExperienceRequest::configuration)).setter(setter(Builder::configuration))
            .constructor(ExperienceConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Configuration").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CreateExperienceRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(CreateExperienceRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, INDEX_ID_FIELD,
            ROLE_ARN_FIELD, CONFIGURATION_FIELD, DESCRIPTION_FIELD, CLIENT_TOKEN_FIELD));

    private final String name;

    private final String indexId;

    private final String roleArn;

    private final ExperienceConfiguration configuration;

    private final String description;

    private final String clientToken;

    private CreateExperienceRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.indexId = builder.indexId;
        this.roleArn = builder.roleArn;
        this.configuration = builder.configuration;
        this.description = builder.description;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * A name for your Amazon Kendra experience.
     * </p>
     * 
     * @return A name for your Amazon Kendra experience.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The identifier of the index for your Amazon Kendra experience.
     * </p>
     * 
     * @return The identifier of the index for your Amazon Kendra experience.
     */
    public final String indexId() {
        return indexId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of a role with permission to access <code>Query</code> API,
     * <code>QuerySuggestions</code> API, <code>SubmitFeedback</code> API, and IAM Identity Center that stores your user
     * and group information. For more information, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html">IAM roles for Amazon Kendra</a>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of a role with permission to access <code>Query</code> API,
     *         <code>QuerySuggestions</code> API, <code>SubmitFeedback</code> API, and IAM Identity Center that stores
     *         your user and group information. For more information, see <a
     *         href="https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html">IAM roles for Amazon Kendra</a>.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * Configuration information for your Amazon Kendra experience. This includes
     * <code>ContentSourceConfiguration</code>, which specifies the data source IDs and/or FAQ IDs, and
     * <code>UserIdentityConfiguration</code>, which specifies the user or group information to grant access to your
     * Amazon Kendra experience.
     * </p>
     * 
     * @return Configuration information for your Amazon Kendra experience. This includes
     *         <code>ContentSourceConfiguration</code>, which specifies the data source IDs and/or FAQ IDs, and
     *         <code>UserIdentityConfiguration</code>, which specifies the user or group information to grant access to
     *         your Amazon Kendra experience.
     */
    public final ExperienceConfiguration configuration() {
        return configuration;
    }

    /**
     * <p>
     * A description for your Amazon Kendra experience.
     * </p>
     * 
     * @return A description for your Amazon Kendra experience.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * A token that you provide to identify the request to create your Amazon Kendra experience. Multiple calls to the
     * <code>CreateExperience</code> API with the same client token creates only one Amazon Kendra experience.
     * </p>
     * 
     * @return A token that you provide to identify the request to create your Amazon Kendra experience. Multiple calls
     *         to the <code>CreateExperience</code> API with the same client token creates only one Amazon Kendra
     *         experience.
     */
    public final String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(indexId());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(configuration());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateExperienceRequest)) {
            return false;
        }
        CreateExperienceRequest other = (CreateExperienceRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(indexId(), other.indexId())
                && Objects.equals(roleArn(), other.roleArn()) && Objects.equals(configuration(), other.configuration())
                && Objects.equals(description(), other.description()) && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateExperienceRequest").add("Name", name()).add("IndexId", indexId())
                .add("RoleArn", roleArn()).add("Configuration", configuration()).add("Description", description())
                .add("ClientToken", clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "IndexId":
            return Optional.ofNullable(clazz.cast(indexId()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "Configuration":
            return Optional.ofNullable(clazz.cast(configuration()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateExperienceRequest, T> g) {
        return obj -> g.apply((CreateExperienceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KendraRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateExperienceRequest> {
        /**
         * <p>
         * A name for your Amazon Kendra experience.
         * </p>
         * 
         * @param name
         *        A name for your Amazon Kendra experience.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The identifier of the index for your Amazon Kendra experience.
         * </p>
         * 
         * @param indexId
         *        The identifier of the index for your Amazon Kendra experience.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexId(String indexId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of a role with permission to access <code>Query</code> API,
         * <code>QuerySuggestions</code> API, <code>SubmitFeedback</code> API, and IAM Identity Center that stores your
         * user and group information. For more information, see <a
         * href="https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html">IAM roles for Amazon Kendra</a>.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of a role with permission to access <code>Query</code> API,
         *        <code>QuerySuggestions</code> API, <code>SubmitFeedback</code> API, and IAM Identity Center that
         *        stores your user and group information. For more information, see <a
         *        href="https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html">IAM roles for Amazon Kendra</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * Configuration information for your Amazon Kendra experience. This includes
         * <code>ContentSourceConfiguration</code>, which specifies the data source IDs and/or FAQ IDs, and
         * <code>UserIdentityConfiguration</code>, which specifies the user or group information to grant access to your
         * Amazon Kendra experience.
         * </p>
         * 
         * @param configuration
         *        Configuration information for your Amazon Kendra experience. This includes
         *        <code>ContentSourceConfiguration</code>, which specifies the data source IDs and/or FAQ IDs, and
         *        <code>UserIdentityConfiguration</code>, which specifies the user or group information to grant access
         *        to your Amazon Kendra experience.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuration(ExperienceConfiguration configuration);

        /**
         * <p>
         * Configuration information for your Amazon Kendra experience. This includes
         * <code>ContentSourceConfiguration</code>, which specifies the data source IDs and/or FAQ IDs, and
         * <code>UserIdentityConfiguration</code>, which specifies the user or group information to grant access to your
         * Amazon Kendra experience.
         * </p>
         * This is a convenience method that creates an instance of the {@link ExperienceConfiguration.Builder} avoiding
         * the need to create one manually via {@link ExperienceConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExperienceConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #configuration(ExperienceConfiguration)}.
         * 
         * @param configuration
         *        a consumer that will call methods on {@link ExperienceConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configuration(ExperienceConfiguration)
         */
        default Builder configuration(Consumer<ExperienceConfiguration.Builder> configuration) {
            return configuration(ExperienceConfiguration.builder().applyMutation(configuration).build());
        }

        /**
         * <p>
         * A description for your Amazon Kendra experience.
         * </p>
         * 
         * @param description
         *        A description for your Amazon Kendra experience.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * A token that you provide to identify the request to create your Amazon Kendra experience. Multiple calls to
         * the <code>CreateExperience</code> API with the same client token creates only one Amazon Kendra experience.
         * </p>
         * 
         * @param clientToken
         *        A token that you provide to identify the request to create your Amazon Kendra experience. Multiple
         *        calls to the <code>CreateExperience</code> API with the same client token creates only one Amazon
         *        Kendra experience.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends KendraRequest.BuilderImpl implements Builder {
        private String name;

        private String indexId;

        private String roleArn;

        private ExperienceConfiguration configuration;

        private String description;

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateExperienceRequest model) {
            super(model);
            name(model.name);
            indexId(model.indexId);
            roleArn(model.roleArn);
            configuration(model.configuration);
            description(model.description);
            clientToken(model.clientToken);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getIndexId() {
            return indexId;
        }

        public final void setIndexId(String indexId) {
            this.indexId = indexId;
        }

        @Override
        public final Builder indexId(String indexId) {
            this.indexId = indexId;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final ExperienceConfiguration.Builder getConfiguration() {
            return configuration != null ? configuration.toBuilder() : null;
        }

        public final void setConfiguration(ExperienceConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public final Builder configuration(ExperienceConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateExperienceRequest build() {
            return new CreateExperienceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
