/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summary information for a Amazon Kendra data source.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataSourceSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<DataSourceSummary.Builder, DataSourceSummary> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(DataSourceSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(DataSourceSummary::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(DataSourceSummary::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedAt").getter(getter(DataSourceSummary::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("UpdatedAt").getter(getter(DataSourceSummary::updatedAt)).setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedAt").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(DataSourceSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> LANGUAGE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LanguageCode").getter(getter(DataSourceSummary::languageCode)).setter(setter(Builder::languageCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LanguageCode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ID_FIELD,
            TYPE_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD, STATUS_FIELD, LANGUAGE_CODE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String id;

    private final String type;

    private final Instant createdAt;

    private final Instant updatedAt;

    private final String status;

    private final String languageCode;

    private DataSourceSummary(BuilderImpl builder) {
        this.name = builder.name;
        this.id = builder.id;
        this.type = builder.type;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
        this.status = builder.status;
        this.languageCode = builder.languageCode;
    }

    /**
     * <p>
     * The name of the data source.
     * </p>
     * 
     * @return The name of the data source.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The identifier for the data source.
     * </p>
     * 
     * @return The identifier for the data source.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The type of the data source.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link DataSourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the data source.
     * @see DataSourceType
     */
    public final DataSourceType type() {
        return DataSourceType.fromValue(type);
    }

    /**
     * <p>
     * The type of the data source.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link DataSourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the data source.
     * @see DataSourceType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The UNIX datetime that the data source was created.
     * </p>
     * 
     * @return The UNIX datetime that the data source was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The UNIX datetime that the data source was lasted updated.
     * </p>
     * 
     * @return The UNIX datetime that the data source was lasted updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    /**
     * <p>
     * The status of the data source. When the status is <code>ACTIVE</code> the data source is ready to use.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DataSourceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the data source. When the status is <code>ACTIVE</code> the data source is ready to use.
     * @see DataSourceStatus
     */
    public final DataSourceStatus status() {
        return DataSourceStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the data source. When the status is <code>ACTIVE</code> the data source is ready to use.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DataSourceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the data source. When the status is <code>ACTIVE</code> the data source is ready to use.
     * @see DataSourceStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The code for a language. This shows a supported language for all documents in the data source. English is
     * supported by default. For more information on supported languages, including their codes, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/in-adding-languages.html">Adding documents in languages other
     * than English</a>.
     * </p>
     * 
     * @return The code for a language. This shows a supported language for all documents in the data source. English is
     *         supported by default. For more information on supported languages, including their codes, see <a
     *         href="https://docs.aws.amazon.com/kendra/latest/dg/in-adding-languages.html">Adding documents in
     *         languages other than English</a>.
     */
    public final String languageCode() {
        return languageCode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(languageCode());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataSourceSummary)) {
            return false;
        }
        DataSourceSummary other = (DataSourceSummary) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(id(), other.id())
                && Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(updatedAt(), other.updatedAt()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(languageCode(), other.languageCode());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataSourceSummary").add("Name", name()).add("Id", id()).add("Type", typeAsString())
                .add("CreatedAt", createdAt()).add("UpdatedAt", updatedAt()).add("Status", statusAsString())
                .add("LanguageCode", languageCode()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "UpdatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "LanguageCode":
            return Optional.ofNullable(clazz.cast(languageCode()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DataSourceSummary, T> g) {
        return obj -> g.apply((DataSourceSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataSourceSummary> {
        /**
         * <p>
         * The name of the data source.
         * </p>
         * 
         * @param name
         *        The name of the data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The identifier for the data source.
         * </p>
         * 
         * @param id
         *        The identifier for the data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The type of the data source.
         * </p>
         * 
         * @param type
         *        The type of the data source.
         * @see DataSourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataSourceType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of the data source.
         * </p>
         * 
         * @param type
         *        The type of the data source.
         * @see DataSourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataSourceType
         */
        Builder type(DataSourceType type);

        /**
         * <p>
         * The UNIX datetime that the data source was created.
         * </p>
         * 
         * @param createdAt
         *        The UNIX datetime that the data source was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The UNIX datetime that the data source was lasted updated.
         * </p>
         * 
         * @param updatedAt
         *        The UNIX datetime that the data source was lasted updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);

        /**
         * <p>
         * The status of the data source. When the status is <code>ACTIVE</code> the data source is ready to use.
         * </p>
         * 
         * @param status
         *        The status of the data source. When the status is <code>ACTIVE</code> the data source is ready to use.
         * @see DataSourceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataSourceStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the data source. When the status is <code>ACTIVE</code> the data source is ready to use.
         * </p>
         * 
         * @param status
         *        The status of the data source. When the status is <code>ACTIVE</code> the data source is ready to use.
         * @see DataSourceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataSourceStatus
         */
        Builder status(DataSourceStatus status);

        /**
         * <p>
         * The code for a language. This shows a supported language for all documents in the data source. English is
         * supported by default. For more information on supported languages, including their codes, see <a
         * href="https://docs.aws.amazon.com/kendra/latest/dg/in-adding-languages.html">Adding documents in languages
         * other than English</a>.
         * </p>
         * 
         * @param languageCode
         *        The code for a language. This shows a supported language for all documents in the data source. English
         *        is supported by default. For more information on supported languages, including their codes, see <a
         *        href="https://docs.aws.amazon.com/kendra/latest/dg/in-adding-languages.html">Adding documents in
         *        languages other than English</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder languageCode(String languageCode);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String id;

        private String type;

        private Instant createdAt;

        private Instant updatedAt;

        private String status;

        private String languageCode;

        private BuilderImpl() {
        }

        private BuilderImpl(DataSourceSummary model) {
            name(model.name);
            id(model.id);
            type(model.type);
            createdAt(model.createdAt);
            updatedAt(model.updatedAt);
            status(model.status);
            languageCode(model.languageCode);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(DataSourceType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DataSourceStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getLanguageCode() {
            return languageCode;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        @Override
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        @Override
        public DataSourceSummary build() {
            return new DataSourceSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
