/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kendra.model.DocumentAttribute;
import software.amazon.awssdk.services.kendra.model.DocumentAttributeListCopier;
import software.amazon.awssdk.services.kendra.model.ScoreAttributes;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RetrieveResultItem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RetrieveResultItem> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(RetrieveResultItem.getter(RetrieveResultItem::id)).setter(RetrieveResultItem.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> DOCUMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DocumentId").getter(RetrieveResultItem.getter(RetrieveResultItem::documentId)).setter(RetrieveResultItem.setter(Builder::documentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentId").build()}).build();
    private static final SdkField<String> DOCUMENT_TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DocumentTitle").getter(RetrieveResultItem.getter(RetrieveResultItem::documentTitle)).setter(RetrieveResultItem.setter(Builder::documentTitle)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentTitle").build()}).build();
    private static final SdkField<String> CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Content").getter(RetrieveResultItem.getter(RetrieveResultItem::content)).setter(RetrieveResultItem.setter(Builder::content)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Content").build()}).build();
    private static final SdkField<String> DOCUMENT_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DocumentURI").getter(RetrieveResultItem.getter(RetrieveResultItem::documentURI)).setter(RetrieveResultItem.setter(Builder::documentURI)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentURI").build()}).build();
    private static final SdkField<List<DocumentAttribute>> DOCUMENT_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DocumentAttributes").getter(RetrieveResultItem.getter(RetrieveResultItem::documentAttributes)).setter(RetrieveResultItem.setter(Builder::documentAttributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentAttributes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DocumentAttribute::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ScoreAttributes> SCORE_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ScoreAttributes").getter(RetrieveResultItem.getter(RetrieveResultItem::scoreAttributes)).setter(RetrieveResultItem.setter(Builder::scoreAttributes)).constructor(ScoreAttributes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScoreAttributes").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, DOCUMENT_ID_FIELD, DOCUMENT_TITLE_FIELD, CONTENT_FIELD, DOCUMENT_URI_FIELD, DOCUMENT_ATTRIBUTES_FIELD, SCORE_ATTRIBUTES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String documentId;
    private final String documentTitle;
    private final String content;
    private final String documentURI;
    private final List<DocumentAttribute> documentAttributes;
    private final ScoreAttributes scoreAttributes;

    private RetrieveResultItem(BuilderImpl builder) {
        this.id = builder.id;
        this.documentId = builder.documentId;
        this.documentTitle = builder.documentTitle;
        this.content = builder.content;
        this.documentURI = builder.documentURI;
        this.documentAttributes = builder.documentAttributes;
        this.scoreAttributes = builder.scoreAttributes;
    }

    public final String id() {
        return this.id;
    }

    public final String documentId() {
        return this.documentId;
    }

    public final String documentTitle() {
        return this.documentTitle;
    }

    public final String content() {
        return this.content;
    }

    public final String documentURI() {
        return this.documentURI;
    }

    public final boolean hasDocumentAttributes() {
        return this.documentAttributes != null && !(this.documentAttributes instanceof SdkAutoConstructList);
    }

    public final List<DocumentAttribute> documentAttributes() {
        return this.documentAttributes;
    }

    public final ScoreAttributes scoreAttributes() {
        return this.scoreAttributes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentTitle());
        hashCode = 31 * hashCode + Objects.hashCode(this.content());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentURI());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDocumentAttributes() ? this.documentAttributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.scoreAttributes());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RetrieveResultItem)) {
            return false;
        }
        RetrieveResultItem other = (RetrieveResultItem)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.documentId(), other.documentId()) && Objects.equals(this.documentTitle(), other.documentTitle()) && Objects.equals(this.content(), other.content()) && Objects.equals(this.documentURI(), other.documentURI()) && this.hasDocumentAttributes() == other.hasDocumentAttributes() && Objects.equals(this.documentAttributes(), other.documentAttributes()) && Objects.equals(this.scoreAttributes(), other.scoreAttributes());
    }

    public final String toString() {
        return ToString.builder((String)"RetrieveResultItem").add("Id", (Object)this.id()).add("DocumentId", (Object)this.documentId()).add("DocumentTitle", (Object)this.documentTitle()).add("Content", (Object)this.content()).add("DocumentURI", (Object)this.documentURI()).add("DocumentAttributes", this.hasDocumentAttributes() ? this.documentAttributes() : null).add("ScoreAttributes", (Object)this.scoreAttributes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "DocumentId": {
                return Optional.ofNullable(clazz.cast(this.documentId()));
            }
            case "DocumentTitle": {
                return Optional.ofNullable(clazz.cast(this.documentTitle()));
            }
            case "Content": {
                return Optional.ofNullable(clazz.cast(this.content()));
            }
            case "DocumentURI": {
                return Optional.ofNullable(clazz.cast(this.documentURI()));
            }
            case "DocumentAttributes": {
                return Optional.ofNullable(clazz.cast(this.documentAttributes()));
            }
            case "ScoreAttributes": {
                return Optional.ofNullable(clazz.cast(this.scoreAttributes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RetrieveResultItem, T> g) {
        return obj -> g.apply((RetrieveResultItem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String documentId;
        private String documentTitle;
        private String content;
        private String documentURI;
        private List<DocumentAttribute> documentAttributes = DefaultSdkAutoConstructList.getInstance();
        private ScoreAttributes scoreAttributes;

        private BuilderImpl() {
        }

        private BuilderImpl(RetrieveResultItem model) {
            this.id(model.id);
            this.documentId(model.documentId);
            this.documentTitle(model.documentTitle);
            this.content(model.content);
            this.documentURI(model.documentURI);
            this.documentAttributes(model.documentAttributes);
            this.scoreAttributes(model.scoreAttributes);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getDocumentId() {
            return this.documentId;
        }

        public final void setDocumentId(String documentId) {
            this.documentId = documentId;
        }

        @Override
        public final Builder documentId(String documentId) {
            this.documentId = documentId;
            return this;
        }

        public final String getDocumentTitle() {
            return this.documentTitle;
        }

        public final void setDocumentTitle(String documentTitle) {
            this.documentTitle = documentTitle;
        }

        @Override
        public final Builder documentTitle(String documentTitle) {
            this.documentTitle = documentTitle;
            return this;
        }

        public final String getContent() {
            return this.content;
        }

        public final void setContent(String content) {
            this.content = content;
        }

        @Override
        public final Builder content(String content) {
            this.content = content;
            return this;
        }

        public final String getDocumentURI() {
            return this.documentURI;
        }

        public final void setDocumentURI(String documentURI) {
            this.documentURI = documentURI;
        }

        @Override
        public final Builder documentURI(String documentURI) {
            this.documentURI = documentURI;
            return this;
        }

        public final List<DocumentAttribute.Builder> getDocumentAttributes() {
            List<DocumentAttribute.Builder> result = DocumentAttributeListCopier.copyToBuilder(this.documentAttributes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDocumentAttributes(Collection<DocumentAttribute.BuilderImpl> documentAttributes) {
            this.documentAttributes = DocumentAttributeListCopier.copyFromBuilder(documentAttributes);
        }

        @Override
        public final Builder documentAttributes(Collection<DocumentAttribute> documentAttributes) {
            this.documentAttributes = DocumentAttributeListCopier.copy(documentAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder documentAttributes(DocumentAttribute ... documentAttributes) {
            this.documentAttributes(Arrays.asList(documentAttributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder documentAttributes(Consumer<DocumentAttribute.Builder> ... documentAttributes) {
            this.documentAttributes(Stream.of(documentAttributes).map(c -> (DocumentAttribute)((DocumentAttribute.Builder)DocumentAttribute.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final ScoreAttributes.Builder getScoreAttributes() {
            return this.scoreAttributes != null ? this.scoreAttributes.toBuilder() : null;
        }

        public final void setScoreAttributes(ScoreAttributes.BuilderImpl scoreAttributes) {
            this.scoreAttributes = scoreAttributes != null ? scoreAttributes.build() : null;
        }

        @Override
        public final Builder scoreAttributes(ScoreAttributes scoreAttributes) {
            this.scoreAttributes = scoreAttributes;
            return this;
        }

        public RetrieveResultItem build() {
            return new RetrieveResultItem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RetrieveResultItem> {
        public Builder id(String var1);

        public Builder documentId(String var1);

        public Builder documentTitle(String var1);

        public Builder content(String var1);

        public Builder documentURI(String var1);

        public Builder documentAttributes(Collection<DocumentAttribute> var1);

        public Builder documentAttributes(DocumentAttribute ... var1);

        public Builder documentAttributes(Consumer<DocumentAttribute.Builder> ... var1);

        public Builder scoreAttributes(ScoreAttributes var1);

        default public Builder scoreAttributes(Consumer<ScoreAttributes.Builder> scoreAttributes) {
            return this.scoreAttributes((ScoreAttributes)((ScoreAttributes.Builder)ScoreAttributes.builder().applyMutation(scoreAttributes)).build());
        }
    }
}

