/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The value of a document attribute. You can only provide one value for a document attribute.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DocumentAttributeValue implements SdkPojo, Serializable,
        ToCopyableBuilder<DocumentAttributeValue.Builder, DocumentAttributeValue> {
    private static final SdkField<String> STRING_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StringValue").getter(getter(DocumentAttributeValue::stringValue)).setter(setter(Builder::stringValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StringValue").build()).build();

    private static final SdkField<List<String>> STRING_LIST_VALUE_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("StringListValue")
            .getter(getter(DocumentAttributeValue::stringListValue))
            .setter(setter(Builder::stringListValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StringListValue").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Long> LONG_VALUE_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("LongValue")
            .getter(getter(DocumentAttributeValue::longValue)).setter(setter(Builder::longValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LongValue").build()).build();

    private static final SdkField<Instant> DATE_VALUE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("DateValue").getter(getter(DocumentAttributeValue::dateValue)).setter(setter(Builder::dateValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DateValue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STRING_VALUE_FIELD,
            STRING_LIST_VALUE_FIELD, LONG_VALUE_FIELD, DATE_VALUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String stringValue;

    private final List<String> stringListValue;

    private final Long longValue;

    private final Instant dateValue;

    private final Type type;

    private DocumentAttributeValue(BuilderImpl builder) {
        this.stringValue = builder.stringValue;
        this.stringListValue = builder.stringListValue;
        this.longValue = builder.longValue;
        this.dateValue = builder.dateValue;
        this.type = builder.type;
    }

    /**
     * <p>
     * A string, such as "department".
     * </p>
     * 
     * @return A string, such as "department".
     */
    public final String stringValue() {
        return stringValue;
    }

    /**
     * For responses, this returns true if the service returned a value for the StringListValue property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasStringListValue() {
        return stringListValue != null && !(stringListValue instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of strings. The default maximum length or number of strings is 10.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStringListValue} method.
     * </p>
     * 
     * @return A list of strings. The default maximum length or number of strings is 10.
     */
    public final List<String> stringListValue() {
        return stringListValue;
    }

    /**
     * <p>
     * A long integer value.
     * </p>
     * 
     * @return A long integer value.
     */
    public final Long longValue() {
        return longValue;
    }

    /**
     * <p>
     * A date expressed as an ISO 8601 string.
     * </p>
     * <p>
     * It is important for the time zone to be included in the ISO 8601 date-time format. For example,
     * 2012-03-25T12:30:10+01:00 is the ISO 8601 date-time format for March 25th 2012 at 12:30PM (plus 10 seconds) in
     * Central European Time.
     * </p>
     * 
     * @return A date expressed as an ISO 8601 string.</p>
     *         <p>
     *         It is important for the time zone to be included in the ISO 8601 date-time format. For example,
     *         2012-03-25T12:30:10+01:00 is the ISO 8601 date-time format for March 25th 2012 at 12:30PM (plus 10
     *         seconds) in Central European Time.
     */
    public final Instant dateValue() {
        return dateValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stringValue());
        hashCode = 31 * hashCode + Objects.hashCode(hasStringListValue() ? stringListValue() : null);
        hashCode = 31 * hashCode + Objects.hashCode(longValue());
        hashCode = 31 * hashCode + Objects.hashCode(dateValue());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DocumentAttributeValue)) {
            return false;
        }
        DocumentAttributeValue other = (DocumentAttributeValue) obj;
        return Objects.equals(stringValue(), other.stringValue()) && hasStringListValue() == other.hasStringListValue()
                && Objects.equals(stringListValue(), other.stringListValue()) && Objects.equals(longValue(), other.longValue())
                && Objects.equals(dateValue(), other.dateValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DocumentAttributeValue").add("StringValue", stringValue())
                .add("StringListValue", hasStringListValue() ? stringListValue() : null).add("LongValue", longValue())
                .add("DateValue", dateValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StringValue":
            return Optional.ofNullable(clazz.cast(stringValue()));
        case "StringListValue":
            return Optional.ofNullable(clazz.cast(stringListValue()));
        case "LongValue":
            return Optional.ofNullable(clazz.cast(longValue()));
        case "DateValue":
            return Optional.ofNullable(clazz.cast(dateValue()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #stringValue()} initialized to the given value.
     *
     * <p>
     * A string, such as "department".
     * </p>
     * 
     * @param stringValue
     *        A string, such as "department".
     */
    public static DocumentAttributeValue fromStringValue(String stringValue) {
        return builder().stringValue(stringValue).build();
    }

    /**
     * Create an instance of this class with {@link #stringListValue()} initialized to the given value.
     *
     * <p>
     * A list of strings. The default maximum length or number of strings is 10.
     * </p>
     * 
     * @param stringListValue
     *        A list of strings. The default maximum length or number of strings is 10.
     */
    public static DocumentAttributeValue fromStringListValue(List<String> stringListValue) {
        return builder().stringListValue(stringListValue).build();
    }

    /**
     * Create an instance of this class with {@link #longValue()} initialized to the given value.
     *
     * <p>
     * A long integer value.
     * </p>
     * 
     * @param longValue
     *        A long integer value.
     */
    public static DocumentAttributeValue fromLongValue(Long longValue) {
        return builder().longValue(longValue).build();
    }

    /**
     * Create an instance of this class with {@link #dateValue()} initialized to the given value.
     *
     * <p>
     * A date expressed as an ISO 8601 string.
     * </p>
     * <p>
     * It is important for the time zone to be included in the ISO 8601 date-time format. For example,
     * 2012-03-25T12:30:10+01:00 is the ISO 8601 date-time format for March 25th 2012 at 12:30PM (plus 10 seconds) in
     * Central European Time.
     * </p>
     * 
     * @param dateValue
     *        A date expressed as an ISO 8601 string.</p>
     *        <p>
     *        It is important for the time zone to be included in the ISO 8601 date-time format. For example,
     *        2012-03-25T12:30:10+01:00 is the ISO 8601 date-time format for March 25th 2012 at 12:30PM (plus 10
     *        seconds) in Central European Time.
     */
    public static DocumentAttributeValue fromDateValue(Instant dateValue) {
        return builder().dateValue(dateValue).build();
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DocumentAttributeValue, T> g) {
        return obj -> g.apply((DocumentAttributeValue) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DocumentAttributeValue> {
        /**
         * <p>
         * A string, such as "department".
         * </p>
         * 
         * @param stringValue
         *        A string, such as "department".
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stringValue(String stringValue);

        /**
         * <p>
         * A list of strings. The default maximum length or number of strings is 10.
         * </p>
         * 
         * @param stringListValue
         *        A list of strings. The default maximum length or number of strings is 10.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stringListValue(Collection<String> stringListValue);

        /**
         * <p>
         * A list of strings. The default maximum length or number of strings is 10.
         * </p>
         * 
         * @param stringListValue
         *        A list of strings. The default maximum length or number of strings is 10.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stringListValue(String... stringListValue);

        /**
         * <p>
         * A long integer value.
         * </p>
         * 
         * @param longValue
         *        A long integer value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder longValue(Long longValue);

        /**
         * <p>
         * A date expressed as an ISO 8601 string.
         * </p>
         * <p>
         * It is important for the time zone to be included in the ISO 8601 date-time format. For example,
         * 2012-03-25T12:30:10+01:00 is the ISO 8601 date-time format for March 25th 2012 at 12:30PM (plus 10 seconds)
         * in Central European Time.
         * </p>
         * 
         * @param dateValue
         *        A date expressed as an ISO 8601 string.</p>
         *        <p>
         *        It is important for the time zone to be included in the ISO 8601 date-time format. For example,
         *        2012-03-25T12:30:10+01:00 is the ISO 8601 date-time format for March 25th 2012 at 12:30PM (plus 10
         *        seconds) in Central European Time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dateValue(Instant dateValue);
    }

    static final class BuilderImpl implements Builder {
        private String stringValue;

        private List<String> stringListValue = DefaultSdkAutoConstructList.getInstance();

        private Long longValue;

        private Instant dateValue;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(DocumentAttributeValue model) {
            stringValue(model.stringValue);
            stringListValue(model.stringListValue);
            longValue(model.longValue);
            dateValue(model.dateValue);
        }

        public final String getStringValue() {
            return stringValue;
        }

        public final void setStringValue(String stringValue) {
            Object oldValue = this.stringValue;
            this.stringValue = stringValue;
            handleUnionValueChange(Type.STRING_VALUE, oldValue, this.stringValue);
        }

        @Override
        public final Builder stringValue(String stringValue) {
            Object oldValue = this.stringValue;
            this.stringValue = stringValue;
            handleUnionValueChange(Type.STRING_VALUE, oldValue, this.stringValue);
            return this;
        }

        public final Collection<String> getStringListValue() {
            if (stringListValue instanceof SdkAutoConstructList) {
                return null;
            }
            return stringListValue;
        }

        public final void setStringListValue(Collection<String> stringListValue) {
            Object oldValue = this.stringListValue;
            this.stringListValue = DocumentAttributeStringListValueCopier.copy(stringListValue);
            handleUnionValueChange(Type.STRING_LIST_VALUE, oldValue, this.stringListValue);
        }

        @Override
        public final Builder stringListValue(Collection<String> stringListValue) {
            Object oldValue = this.stringListValue;
            this.stringListValue = DocumentAttributeStringListValueCopier.copy(stringListValue);
            handleUnionValueChange(Type.STRING_LIST_VALUE, oldValue, this.stringListValue);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stringListValue(String... stringListValue) {
            stringListValue(Arrays.asList(stringListValue));
            return this;
        }

        public final Long getLongValue() {
            return longValue;
        }

        public final void setLongValue(Long longValue) {
            Object oldValue = this.longValue;
            this.longValue = longValue;
            handleUnionValueChange(Type.LONG_VALUE, oldValue, this.longValue);
        }

        @Override
        public final Builder longValue(Long longValue) {
            Object oldValue = this.longValue;
            this.longValue = longValue;
            handleUnionValueChange(Type.LONG_VALUE, oldValue, this.longValue);
            return this;
        }

        public final Instant getDateValue() {
            return dateValue;
        }

        public final void setDateValue(Instant dateValue) {
            Object oldValue = this.dateValue;
            this.dateValue = dateValue;
            handleUnionValueChange(Type.DATE_VALUE, oldValue, this.dateValue);
        }

        @Override
        public final Builder dateValue(Instant dateValue) {
            Object oldValue = this.dateValue;
            this.dateValue = dateValue;
            handleUnionValueChange(Type.DATE_VALUE, oldValue, this.dateValue);
            return this;
        }

        @Override
        public DocumentAttributeValue build() {
            return new DocumentAttributeValue(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see DocumentAttributeValue#type()
     */
    public enum Type {
        STRING_VALUE,

        STRING_LIST_VALUE,

        LONG_VALUE,

        DATE_VALUE,

        UNKNOWN_TO_SDK_VERSION
    }
}
