/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.kendra.model.AssociateEntitiesToExperienceRequest;
import software.amazon.awssdk.services.kendra.model.AssociateEntitiesToExperienceResponse;
import software.amazon.awssdk.services.kendra.model.AssociatePersonasToEntitiesRequest;
import software.amazon.awssdk.services.kendra.model.AssociatePersonasToEntitiesResponse;
import software.amazon.awssdk.services.kendra.model.BatchDeleteDocumentRequest;
import software.amazon.awssdk.services.kendra.model.BatchDeleteDocumentResponse;
import software.amazon.awssdk.services.kendra.model.BatchGetDocumentStatusRequest;
import software.amazon.awssdk.services.kendra.model.BatchGetDocumentStatusResponse;
import software.amazon.awssdk.services.kendra.model.BatchPutDocumentRequest;
import software.amazon.awssdk.services.kendra.model.BatchPutDocumentResponse;
import software.amazon.awssdk.services.kendra.model.ClearQuerySuggestionsRequest;
import software.amazon.awssdk.services.kendra.model.ClearQuerySuggestionsResponse;
import software.amazon.awssdk.services.kendra.model.CreateAccessControlConfigurationRequest;
import software.amazon.awssdk.services.kendra.model.CreateAccessControlConfigurationResponse;
import software.amazon.awssdk.services.kendra.model.CreateDataSourceRequest;
import software.amazon.awssdk.services.kendra.model.CreateDataSourceResponse;
import software.amazon.awssdk.services.kendra.model.CreateExperienceRequest;
import software.amazon.awssdk.services.kendra.model.CreateExperienceResponse;
import software.amazon.awssdk.services.kendra.model.CreateFaqRequest;
import software.amazon.awssdk.services.kendra.model.CreateFaqResponse;
import software.amazon.awssdk.services.kendra.model.CreateIndexRequest;
import software.amazon.awssdk.services.kendra.model.CreateIndexResponse;
import software.amazon.awssdk.services.kendra.model.CreateQuerySuggestionsBlockListRequest;
import software.amazon.awssdk.services.kendra.model.CreateQuerySuggestionsBlockListResponse;
import software.amazon.awssdk.services.kendra.model.CreateThesaurusRequest;
import software.amazon.awssdk.services.kendra.model.CreateThesaurusResponse;
import software.amazon.awssdk.services.kendra.model.DeleteAccessControlConfigurationRequest;
import software.amazon.awssdk.services.kendra.model.DeleteAccessControlConfigurationResponse;
import software.amazon.awssdk.services.kendra.model.DeleteDataSourceRequest;
import software.amazon.awssdk.services.kendra.model.DeleteDataSourceResponse;
import software.amazon.awssdk.services.kendra.model.DeleteExperienceRequest;
import software.amazon.awssdk.services.kendra.model.DeleteExperienceResponse;
import software.amazon.awssdk.services.kendra.model.DeleteFaqRequest;
import software.amazon.awssdk.services.kendra.model.DeleteFaqResponse;
import software.amazon.awssdk.services.kendra.model.DeleteIndexRequest;
import software.amazon.awssdk.services.kendra.model.DeleteIndexResponse;
import software.amazon.awssdk.services.kendra.model.DeletePrincipalMappingRequest;
import software.amazon.awssdk.services.kendra.model.DeletePrincipalMappingResponse;
import software.amazon.awssdk.services.kendra.model.DeleteQuerySuggestionsBlockListRequest;
import software.amazon.awssdk.services.kendra.model.DeleteQuerySuggestionsBlockListResponse;
import software.amazon.awssdk.services.kendra.model.DeleteThesaurusRequest;
import software.amazon.awssdk.services.kendra.model.DeleteThesaurusResponse;
import software.amazon.awssdk.services.kendra.model.DescribeAccessControlConfigurationRequest;
import software.amazon.awssdk.services.kendra.model.DescribeAccessControlConfigurationResponse;
import software.amazon.awssdk.services.kendra.model.DescribeDataSourceRequest;
import software.amazon.awssdk.services.kendra.model.DescribeDataSourceResponse;
import software.amazon.awssdk.services.kendra.model.DescribeExperienceRequest;
import software.amazon.awssdk.services.kendra.model.DescribeExperienceResponse;
import software.amazon.awssdk.services.kendra.model.DescribeFaqRequest;
import software.amazon.awssdk.services.kendra.model.DescribeFaqResponse;
import software.amazon.awssdk.services.kendra.model.DescribeIndexRequest;
import software.amazon.awssdk.services.kendra.model.DescribeIndexResponse;
import software.amazon.awssdk.services.kendra.model.DescribePrincipalMappingRequest;
import software.amazon.awssdk.services.kendra.model.DescribePrincipalMappingResponse;
import software.amazon.awssdk.services.kendra.model.DescribeQuerySuggestionsBlockListRequest;
import software.amazon.awssdk.services.kendra.model.DescribeQuerySuggestionsBlockListResponse;
import software.amazon.awssdk.services.kendra.model.DescribeQuerySuggestionsConfigRequest;
import software.amazon.awssdk.services.kendra.model.DescribeQuerySuggestionsConfigResponse;
import software.amazon.awssdk.services.kendra.model.DescribeThesaurusRequest;
import software.amazon.awssdk.services.kendra.model.DescribeThesaurusResponse;
import software.amazon.awssdk.services.kendra.model.DisassociateEntitiesFromExperienceRequest;
import software.amazon.awssdk.services.kendra.model.DisassociateEntitiesFromExperienceResponse;
import software.amazon.awssdk.services.kendra.model.DisassociatePersonasFromEntitiesRequest;
import software.amazon.awssdk.services.kendra.model.DisassociatePersonasFromEntitiesResponse;
import software.amazon.awssdk.services.kendra.model.GetQuerySuggestionsRequest;
import software.amazon.awssdk.services.kendra.model.GetQuerySuggestionsResponse;
import software.amazon.awssdk.services.kendra.model.GetSnapshotsRequest;
import software.amazon.awssdk.services.kendra.model.GetSnapshotsResponse;
import software.amazon.awssdk.services.kendra.model.ListAccessControlConfigurationsRequest;
import software.amazon.awssdk.services.kendra.model.ListAccessControlConfigurationsResponse;
import software.amazon.awssdk.services.kendra.model.ListDataSourceSyncJobsRequest;
import software.amazon.awssdk.services.kendra.model.ListDataSourceSyncJobsResponse;
import software.amazon.awssdk.services.kendra.model.ListDataSourcesRequest;
import software.amazon.awssdk.services.kendra.model.ListDataSourcesResponse;
import software.amazon.awssdk.services.kendra.model.ListEntityPersonasRequest;
import software.amazon.awssdk.services.kendra.model.ListEntityPersonasResponse;
import software.amazon.awssdk.services.kendra.model.ListExperienceEntitiesRequest;
import software.amazon.awssdk.services.kendra.model.ListExperienceEntitiesResponse;
import software.amazon.awssdk.services.kendra.model.ListExperiencesRequest;
import software.amazon.awssdk.services.kendra.model.ListExperiencesResponse;
import software.amazon.awssdk.services.kendra.model.ListFaqsRequest;
import software.amazon.awssdk.services.kendra.model.ListFaqsResponse;
import software.amazon.awssdk.services.kendra.model.ListGroupsOlderThanOrderingIdRequest;
import software.amazon.awssdk.services.kendra.model.ListGroupsOlderThanOrderingIdResponse;
import software.amazon.awssdk.services.kendra.model.ListIndicesRequest;
import software.amazon.awssdk.services.kendra.model.ListIndicesResponse;
import software.amazon.awssdk.services.kendra.model.ListQuerySuggestionsBlockListsRequest;
import software.amazon.awssdk.services.kendra.model.ListQuerySuggestionsBlockListsResponse;
import software.amazon.awssdk.services.kendra.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.kendra.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.kendra.model.ListThesauriRequest;
import software.amazon.awssdk.services.kendra.model.ListThesauriResponse;
import software.amazon.awssdk.services.kendra.model.PutPrincipalMappingRequest;
import software.amazon.awssdk.services.kendra.model.PutPrincipalMappingResponse;
import software.amazon.awssdk.services.kendra.model.QueryRequest;
import software.amazon.awssdk.services.kendra.model.QueryResponse;
import software.amazon.awssdk.services.kendra.model.StartDataSourceSyncJobRequest;
import software.amazon.awssdk.services.kendra.model.StartDataSourceSyncJobResponse;
import software.amazon.awssdk.services.kendra.model.StopDataSourceSyncJobRequest;
import software.amazon.awssdk.services.kendra.model.StopDataSourceSyncJobResponse;
import software.amazon.awssdk.services.kendra.model.SubmitFeedbackRequest;
import software.amazon.awssdk.services.kendra.model.SubmitFeedbackResponse;
import software.amazon.awssdk.services.kendra.model.TagResourceRequest;
import software.amazon.awssdk.services.kendra.model.TagResourceResponse;
import software.amazon.awssdk.services.kendra.model.UntagResourceRequest;
import software.amazon.awssdk.services.kendra.model.UntagResourceResponse;
import software.amazon.awssdk.services.kendra.model.UpdateAccessControlConfigurationRequest;
import software.amazon.awssdk.services.kendra.model.UpdateAccessControlConfigurationResponse;
import software.amazon.awssdk.services.kendra.model.UpdateDataSourceRequest;
import software.amazon.awssdk.services.kendra.model.UpdateDataSourceResponse;
import software.amazon.awssdk.services.kendra.model.UpdateExperienceRequest;
import software.amazon.awssdk.services.kendra.model.UpdateExperienceResponse;
import software.amazon.awssdk.services.kendra.model.UpdateIndexRequest;
import software.amazon.awssdk.services.kendra.model.UpdateIndexResponse;
import software.amazon.awssdk.services.kendra.model.UpdateQuerySuggestionsBlockListRequest;
import software.amazon.awssdk.services.kendra.model.UpdateQuerySuggestionsBlockListResponse;
import software.amazon.awssdk.services.kendra.model.UpdateQuerySuggestionsConfigRequest;
import software.amazon.awssdk.services.kendra.model.UpdateQuerySuggestionsConfigResponse;
import software.amazon.awssdk.services.kendra.model.UpdateThesaurusRequest;
import software.amazon.awssdk.services.kendra.model.UpdateThesaurusResponse;
import software.amazon.awssdk.services.kendra.paginators.GetSnapshotsPublisher;
import software.amazon.awssdk.services.kendra.paginators.ListAccessControlConfigurationsPublisher;
import software.amazon.awssdk.services.kendra.paginators.ListDataSourceSyncJobsPublisher;
import software.amazon.awssdk.services.kendra.paginators.ListDataSourcesPublisher;
import software.amazon.awssdk.services.kendra.paginators.ListEntityPersonasPublisher;
import software.amazon.awssdk.services.kendra.paginators.ListExperienceEntitiesPublisher;
import software.amazon.awssdk.services.kendra.paginators.ListExperiencesPublisher;
import software.amazon.awssdk.services.kendra.paginators.ListFaqsPublisher;
import software.amazon.awssdk.services.kendra.paginators.ListGroupsOlderThanOrderingIdPublisher;
import software.amazon.awssdk.services.kendra.paginators.ListIndicesPublisher;
import software.amazon.awssdk.services.kendra.paginators.ListQuerySuggestionsBlockListsPublisher;
import software.amazon.awssdk.services.kendra.paginators.ListThesauriPublisher;

/**
 * Service client for accessing kendra asynchronously. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * Amazon Kendra is a service for indexing large document sets.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface KendraAsyncClient extends AwsClient {
    String SERVICE_NAME = "kendra";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "kendra";

    /**
     * <p>
     * Grants users or groups in your IAM Identity Center identity source access to your Amazon Kendra experience. You
     * can create an Amazon Kendra experience such as a search application. For more information on creating a search
     * application experience, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html">Building a search
     * experience with no code</a>.
     * </p>
     *
     * @param associateEntitiesToExperienceRequest
     * @return A Java Future containing the result of the AssociateEntitiesToExperience operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>ResourceAlreadyExistException The resource you want to use already exists. Please check you have
     *         provided the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.AssociateEntitiesToExperience
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/AssociateEntitiesToExperience"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateEntitiesToExperienceResponse> associateEntitiesToExperience(
            AssociateEntitiesToExperienceRequest associateEntitiesToExperienceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Grants users or groups in your IAM Identity Center identity source access to your Amazon Kendra experience. You
     * can create an Amazon Kendra experience such as a search application. For more information on creating a search
     * application experience, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html">Building a search
     * experience with no code</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateEntitiesToExperienceRequest.Builder}
     * avoiding the need to create one manually via {@link AssociateEntitiesToExperienceRequest#builder()}
     * </p>
     *
     * @param associateEntitiesToExperienceRequest
     *        A {@link Consumer} that will call methods on {@link AssociateEntitiesToExperienceRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the AssociateEntitiesToExperience operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>ResourceAlreadyExistException The resource you want to use already exists. Please check you have
     *         provided the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.AssociateEntitiesToExperience
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/AssociateEntitiesToExperience"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateEntitiesToExperienceResponse> associateEntitiesToExperience(
            Consumer<AssociateEntitiesToExperienceRequest.Builder> associateEntitiesToExperienceRequest) {
        return associateEntitiesToExperience(AssociateEntitiesToExperienceRequest.builder()
                .applyMutation(associateEntitiesToExperienceRequest).build());
    }

    /**
     * <p>
     * Defines the specific permissions of users or groups in your IAM Identity Center identity source with access to
     * your Amazon Kendra experience. You can create an Amazon Kendra experience such as a search application. For more
     * information on creating a search application experience, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html">Building a search
     * experience with no code</a>.
     * </p>
     *
     * @param associatePersonasToEntitiesRequest
     * @return A Java Future containing the result of the AssociatePersonasToEntities operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>ResourceAlreadyExistException The resource you want to use already exists. Please check you have
     *         provided the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.AssociatePersonasToEntities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/AssociatePersonasToEntities"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociatePersonasToEntitiesResponse> associatePersonasToEntities(
            AssociatePersonasToEntitiesRequest associatePersonasToEntitiesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Defines the specific permissions of users or groups in your IAM Identity Center identity source with access to
     * your Amazon Kendra experience. You can create an Amazon Kendra experience such as a search application. For more
     * information on creating a search application experience, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html">Building a search
     * experience with no code</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociatePersonasToEntitiesRequest.Builder}
     * avoiding the need to create one manually via {@link AssociatePersonasToEntitiesRequest#builder()}
     * </p>
     *
     * @param associatePersonasToEntitiesRequest
     *        A {@link Consumer} that will call methods on {@link AssociatePersonasToEntitiesRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the AssociatePersonasToEntities operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>ResourceAlreadyExistException The resource you want to use already exists. Please check you have
     *         provided the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.AssociatePersonasToEntities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/AssociatePersonasToEntities"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociatePersonasToEntitiesResponse> associatePersonasToEntities(
            Consumer<AssociatePersonasToEntitiesRequest.Builder> associatePersonasToEntitiesRequest) {
        return associatePersonasToEntities(AssociatePersonasToEntitiesRequest.builder()
                .applyMutation(associatePersonasToEntitiesRequest).build());
    }

    /**
     * <p>
     * Removes one or more documents from an index. The documents must have been added with the
     * <code>BatchPutDocument</code> API.
     * </p>
     * <p>
     * The documents are deleted asynchronously. You can see the progress of the deletion by using Amazon Web Services
     * CloudWatch. Any error messages related to the processing of the batch are sent to you CloudWatch log.
     * </p>
     *
     * @param batchDeleteDocumentRequest
     * @return A Java Future containing the result of the BatchDeleteDocument operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ConflictException A conflict occurred with the request. Please fix any inconsistences with your
     *         resources and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.BatchDeleteDocument
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/BatchDeleteDocument" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<BatchDeleteDocumentResponse> batchDeleteDocument(
            BatchDeleteDocumentRequest batchDeleteDocumentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes one or more documents from an index. The documents must have been added with the
     * <code>BatchPutDocument</code> API.
     * </p>
     * <p>
     * The documents are deleted asynchronously. You can see the progress of the deletion by using Amazon Web Services
     * CloudWatch. Any error messages related to the processing of the batch are sent to you CloudWatch log.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchDeleteDocumentRequest.Builder} avoiding the
     * need to create one manually via {@link BatchDeleteDocumentRequest#builder()}
     * </p>
     *
     * @param batchDeleteDocumentRequest
     *        A {@link Consumer} that will call methods on {@link BatchDeleteDocumentRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the BatchDeleteDocument operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ConflictException A conflict occurred with the request. Please fix any inconsistences with your
     *         resources and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.BatchDeleteDocument
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/BatchDeleteDocument" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<BatchDeleteDocumentResponse> batchDeleteDocument(
            Consumer<BatchDeleteDocumentRequest.Builder> batchDeleteDocumentRequest) {
        return batchDeleteDocument(BatchDeleteDocumentRequest.builder().applyMutation(batchDeleteDocumentRequest).build());
    }

    /**
     * <p>
     * Returns the indexing status for one or more documents submitted with the <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/API_BatchPutDocument.html"> BatchPutDocument</a> API.
     * </p>
     * <p>
     * When you use the <code>BatchPutDocument</code> API, documents are indexed asynchronously. You can use the
     * <code>BatchGetDocumentStatus</code> API to get the current status of a list of documents so that you can
     * determine if they have been successfully indexed.
     * </p>
     * <p>
     * You can also use the <code>BatchGetDocumentStatus</code> API to check the status of the <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/API_BatchDeleteDocument.html"> BatchDeleteDocument</a> API.
     * When a document is deleted from the index, Amazon Kendra returns <code>NOT_FOUND</code> as the status.
     * </p>
     *
     * @param batchGetDocumentStatusRequest
     * @return A Java Future containing the result of the BatchGetDocumentStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ConflictException A conflict occurred with the request. Please fix any inconsistences with your
     *         resources and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.BatchGetDocumentStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/BatchGetDocumentStatus" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<BatchGetDocumentStatusResponse> batchGetDocumentStatus(
            BatchGetDocumentStatusRequest batchGetDocumentStatusRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the indexing status for one or more documents submitted with the <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/API_BatchPutDocument.html"> BatchPutDocument</a> API.
     * </p>
     * <p>
     * When you use the <code>BatchPutDocument</code> API, documents are indexed asynchronously. You can use the
     * <code>BatchGetDocumentStatus</code> API to get the current status of a list of documents so that you can
     * determine if they have been successfully indexed.
     * </p>
     * <p>
     * You can also use the <code>BatchGetDocumentStatus</code> API to check the status of the <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/API_BatchDeleteDocument.html"> BatchDeleteDocument</a> API.
     * When a document is deleted from the index, Amazon Kendra returns <code>NOT_FOUND</code> as the status.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchGetDocumentStatusRequest.Builder} avoiding the
     * need to create one manually via {@link BatchGetDocumentStatusRequest#builder()}
     * </p>
     *
     * @param batchGetDocumentStatusRequest
     *        A {@link Consumer} that will call methods on {@link BatchGetDocumentStatusRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the BatchGetDocumentStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ConflictException A conflict occurred with the request. Please fix any inconsistences with your
     *         resources and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.BatchGetDocumentStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/BatchGetDocumentStatus" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<BatchGetDocumentStatusResponse> batchGetDocumentStatus(
            Consumer<BatchGetDocumentStatusRequest.Builder> batchGetDocumentStatusRequest) {
        return batchGetDocumentStatus(BatchGetDocumentStatusRequest.builder().applyMutation(batchGetDocumentStatusRequest)
                .build());
    }

    /**
     * <p>
     * Adds one or more documents to an index.
     * </p>
     * <p>
     * The <code>BatchPutDocument</code> API enables you to ingest inline documents or a set of documents stored in an
     * Amazon S3 bucket. Use this API to ingest your text and unstructured text into an index, add custom attributes to
     * the documents, and to attach an access control list to the documents added to the index.
     * </p>
     * <p>
     * The documents are indexed asynchronously. You can see the progress of the batch using Amazon Web Services
     * CloudWatch. Any error messages related to processing the batch are sent to your Amazon Web Services CloudWatch
     * log.
     * </p>
     * <p>
     * For an example of ingesting inline documents using Python and Java SDKs, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/in-adding-binary-doc.html">Adding files directly to an
     * index</a>.
     * </p>
     *
     * @param batchPutDocumentRequest
     * @return A Java Future containing the result of the BatchPutDocument operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ConflictException A conflict occurred with the request. Please fix any inconsistences with your
     *         resources and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>ServiceQuotaExceededException You have exceeded the set limits for your Amazon Kendra service. Please
     *         see Quotas[hyperlink Kendra Quotas pg] for more information, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> to inquire about an increase of
     *         limits.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.BatchPutDocument
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/BatchPutDocument" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<BatchPutDocumentResponse> batchPutDocument(BatchPutDocumentRequest batchPutDocumentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds one or more documents to an index.
     * </p>
     * <p>
     * The <code>BatchPutDocument</code> API enables you to ingest inline documents or a set of documents stored in an
     * Amazon S3 bucket. Use this API to ingest your text and unstructured text into an index, add custom attributes to
     * the documents, and to attach an access control list to the documents added to the index.
     * </p>
     * <p>
     * The documents are indexed asynchronously. You can see the progress of the batch using Amazon Web Services
     * CloudWatch. Any error messages related to processing the batch are sent to your Amazon Web Services CloudWatch
     * log.
     * </p>
     * <p>
     * For an example of ingesting inline documents using Python and Java SDKs, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/in-adding-binary-doc.html">Adding files directly to an
     * index</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchPutDocumentRequest.Builder} avoiding the need
     * to create one manually via {@link BatchPutDocumentRequest#builder()}
     * </p>
     *
     * @param batchPutDocumentRequest
     *        A {@link Consumer} that will call methods on {@link BatchPutDocumentRequest.Builder} to create a request.
     * @return A Java Future containing the result of the BatchPutDocument operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ConflictException A conflict occurred with the request. Please fix any inconsistences with your
     *         resources and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>ServiceQuotaExceededException You have exceeded the set limits for your Amazon Kendra service. Please
     *         see Quotas[hyperlink Kendra Quotas pg] for more information, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> to inquire about an increase of
     *         limits.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.BatchPutDocument
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/BatchPutDocument" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<BatchPutDocumentResponse> batchPutDocument(
            Consumer<BatchPutDocumentRequest.Builder> batchPutDocumentRequest) {
        return batchPutDocument(BatchPutDocumentRequest.builder().applyMutation(batchPutDocumentRequest).build());
    }

    /**
     * <p>
     * Clears existing query suggestions from an index.
     * </p>
     * <p>
     * This deletes existing suggestions only, not the queries in the query log. After you clear suggestions, Amazon
     * Kendra learns new suggestions based on new queries added to the query log from the time you cleared suggestions.
     * If you do not see any new suggestions, then please allow Amazon Kendra to collect enough queries to learn new
     * suggestions.
     * </p>
     * <p>
     * <code>ClearQuerySuggestions</code> is currently not supported in the Amazon Web Services GovCloud (US-West)
     * region.
     * </p>
     *
     * @param clearQuerySuggestionsRequest
     * @return A Java Future containing the result of the ClearQuerySuggestions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>ConflictException A conflict occurred with the request. Please fix any inconsistences with your
     *         resources and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.ClearQuerySuggestions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/ClearQuerySuggestions" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ClearQuerySuggestionsResponse> clearQuerySuggestions(
            ClearQuerySuggestionsRequest clearQuerySuggestionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Clears existing query suggestions from an index.
     * </p>
     * <p>
     * This deletes existing suggestions only, not the queries in the query log. After you clear suggestions, Amazon
     * Kendra learns new suggestions based on new queries added to the query log from the time you cleared suggestions.
     * If you do not see any new suggestions, then please allow Amazon Kendra to collect enough queries to learn new
     * suggestions.
     * </p>
     * <p>
     * <code>ClearQuerySuggestions</code> is currently not supported in the Amazon Web Services GovCloud (US-West)
     * region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ClearQuerySuggestionsRequest.Builder} avoiding the
     * need to create one manually via {@link ClearQuerySuggestionsRequest#builder()}
     * </p>
     *
     * @param clearQuerySuggestionsRequest
     *        A {@link Consumer} that will call methods on {@link ClearQuerySuggestionsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ClearQuerySuggestions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>ConflictException A conflict occurred with the request. Please fix any inconsistences with your
     *         resources and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.ClearQuerySuggestions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/ClearQuerySuggestions" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ClearQuerySuggestionsResponse> clearQuerySuggestions(
            Consumer<ClearQuerySuggestionsRequest.Builder> clearQuerySuggestionsRequest) {
        return clearQuerySuggestions(ClearQuerySuggestionsRequest.builder().applyMutation(clearQuerySuggestionsRequest).build());
    }

    /**
     * <p>
     * Creates an access configuration for your documents. This includes user and group access information for your
     * documents. This is useful for user context filtering, where search results are filtered based on the user or
     * their group access to documents.
     * </p>
     * <p>
     * You can use this to re-configure your existing document level access control without indexing all of your
     * documents again. For example, your index contains top-secret company documents that only certain employees or
     * users should access. One of these users leaves the company or switches to a team that should be blocked from
     * accessing top-secret documents. The user still has access to top-secret documents because the user had access
     * when your documents were previously indexed. You can create a specific access control configuration for the user
     * with deny access. You can later update the access control configuration to allow access if the user returns to
     * the company and re-joins the 'top-secret' team. You can re-configure access control for your documents as
     * circumstances change.
     * </p>
     * <p>
     * To apply your access control configuration to certain documents, you call the <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/API_BatchPutDocument.html">BatchPutDocument</a> API with the
     * <code>AccessControlConfigurationId</code> included in the <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/API_Document.html">Document</a> object. If you use an S3
     * bucket as a data source, you update the <code>.metadata.json</code> with the
     * <code>AccessControlConfigurationId</code> and synchronize your data source. Amazon Kendra currently only supports
     * access control configuration for S3 data sources and documents indexed using the <code>BatchPutDocument</code>
     * API.
     * </p>
     *
     * @param createAccessControlConfigurationRequest
     * @return A Java Future containing the result of the CreateAccessControlConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceQuotaExceededException You have exceeded the set limits for your Amazon Kendra service. Please
     *         see Quotas[hyperlink Kendra Quotas pg] for more information, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> to inquire about an increase of
     *         limits.</li>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>ConflictException A conflict occurred with the request. Please fix any inconsistences with your
     *         resources and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.CreateAccessControlConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/CreateAccessControlConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateAccessControlConfigurationResponse> createAccessControlConfiguration(
            CreateAccessControlConfigurationRequest createAccessControlConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an access configuration for your documents. This includes user and group access information for your
     * documents. This is useful for user context filtering, where search results are filtered based on the user or
     * their group access to documents.
     * </p>
     * <p>
     * You can use this to re-configure your existing document level access control without indexing all of your
     * documents again. For example, your index contains top-secret company documents that only certain employees or
     * users should access. One of these users leaves the company or switches to a team that should be blocked from
     * accessing top-secret documents. The user still has access to top-secret documents because the user had access
     * when your documents were previously indexed. You can create a specific access control configuration for the user
     * with deny access. You can later update the access control configuration to allow access if the user returns to
     * the company and re-joins the 'top-secret' team. You can re-configure access control for your documents as
     * circumstances change.
     * </p>
     * <p>
     * To apply your access control configuration to certain documents, you call the <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/API_BatchPutDocument.html">BatchPutDocument</a> API with the
     * <code>AccessControlConfigurationId</code> included in the <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/API_Document.html">Document</a> object. If you use an S3
     * bucket as a data source, you update the <code>.metadata.json</code> with the
     * <code>AccessControlConfigurationId</code> and synchronize your data source. Amazon Kendra currently only supports
     * access control configuration for S3 data sources and documents indexed using the <code>BatchPutDocument</code>
     * API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAccessControlConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link CreateAccessControlConfigurationRequest#builder()}
     * </p>
     *
     * @param createAccessControlConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link CreateAccessControlConfigurationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateAccessControlConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceQuotaExceededException You have exceeded the set limits for your Amazon Kendra service. Please
     *         see Quotas[hyperlink Kendra Quotas pg] for more information, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> to inquire about an increase of
     *         limits.</li>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>ConflictException A conflict occurred with the request. Please fix any inconsistences with your
     *         resources and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.CreateAccessControlConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/CreateAccessControlConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateAccessControlConfigurationResponse> createAccessControlConfiguration(
            Consumer<CreateAccessControlConfigurationRequest.Builder> createAccessControlConfigurationRequest) {
        return createAccessControlConfiguration(CreateAccessControlConfigurationRequest.builder()
                .applyMutation(createAccessControlConfigurationRequest).build());
    }

    /**
     * <p>
     * Creates a data source connector that you want to use with an Amazon Kendra index.
     * </p>
     * <p>
     * You specify a name, data source connector type and description for your data source. You also specify
     * configuration information for the data source connector.
     * </p>
     * <p>
     * <code>CreateDataSource</code> is a synchronous operation. The operation returns 200 if the data source was
     * successfully created. Otherwise, an exception is raised.
     * </p>
     * <p>
     * Amazon S3 and <a href="https://docs.aws.amazon.com/kendra/latest/dg/data-source-custom.html">custom</a> data
     * sources are the only supported data sources in the Amazon Web Services GovCloud (US-West) region.
     * </p>
     * <p>
     * For an example of creating an index and data source using the Python SDK, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/gs-python.html">Getting started with Python SDK</a>. For an
     * example of creating an index and data source using the Java SDK, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/gs-java.html">Getting started with Java SDK</a>.
     * </p>
     *
     * @param createDataSourceRequest
     * @return A Java Future containing the result of the CreateDataSource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ConflictException A conflict occurred with the request. Please fix any inconsistences with your
     *         resources and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>ResourceAlreadyExistException The resource you want to use already exists. Please check you have
     *         provided the correct resource and try again.</li>
     *         <li>ServiceQuotaExceededException You have exceeded the set limits for your Amazon Kendra service. Please
     *         see Quotas[hyperlink Kendra Quotas pg] for more information, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> to inquire about an increase of
     *         limits.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.CreateDataSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/CreateDataSource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateDataSourceResponse> createDataSource(CreateDataSourceRequest createDataSourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a data source connector that you want to use with an Amazon Kendra index.
     * </p>
     * <p>
     * You specify a name, data source connector type and description for your data source. You also specify
     * configuration information for the data source connector.
     * </p>
     * <p>
     * <code>CreateDataSource</code> is a synchronous operation. The operation returns 200 if the data source was
     * successfully created. Otherwise, an exception is raised.
     * </p>
     * <p>
     * Amazon S3 and <a href="https://docs.aws.amazon.com/kendra/latest/dg/data-source-custom.html">custom</a> data
     * sources are the only supported data sources in the Amazon Web Services GovCloud (US-West) region.
     * </p>
     * <p>
     * For an example of creating an index and data source using the Python SDK, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/gs-python.html">Getting started with Python SDK</a>. For an
     * example of creating an index and data source using the Java SDK, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/gs-java.html">Getting started with Java SDK</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDataSourceRequest.Builder} avoiding the need
     * to create one manually via {@link CreateDataSourceRequest#builder()}
     * </p>
     *
     * @param createDataSourceRequest
     *        A {@link Consumer} that will call methods on {@link CreateDataSourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateDataSource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ConflictException A conflict occurred with the request. Please fix any inconsistences with your
     *         resources and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>ResourceAlreadyExistException The resource you want to use already exists. Please check you have
     *         provided the correct resource and try again.</li>
     *         <li>ServiceQuotaExceededException You have exceeded the set limits for your Amazon Kendra service. Please
     *         see Quotas[hyperlink Kendra Quotas pg] for more information, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> to inquire about an increase of
     *         limits.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.CreateDataSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/CreateDataSource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateDataSourceResponse> createDataSource(
            Consumer<CreateDataSourceRequest.Builder> createDataSourceRequest) {
        return createDataSource(CreateDataSourceRequest.builder().applyMutation(createDataSourceRequest).build());
    }

    /**
     * <p>
     * Creates an Amazon Kendra experience such as a search application. For more information on creating a search
     * application experience, including using the Python and Java SDKs, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html">Building a search
     * experience with no code</a>.
     * </p>
     *
     * @param createExperienceRequest
     * @return A Java Future containing the result of the CreateExperience operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ConflictException A conflict occurred with the request. Please fix any inconsistences with your
     *         resources and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>ServiceQuotaExceededException You have exceeded the set limits for your Amazon Kendra service. Please
     *         see Quotas[hyperlink Kendra Quotas pg] for more information, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> to inquire about an increase of
     *         limits.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.CreateExperience
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/CreateExperience" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateExperienceResponse> createExperience(CreateExperienceRequest createExperienceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Amazon Kendra experience such as a search application. For more information on creating a search
     * application experience, including using the Python and Java SDKs, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html">Building a search
     * experience with no code</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateExperienceRequest.Builder} avoiding the need
     * to create one manually via {@link CreateExperienceRequest#builder()}
     * </p>
     *
     * @param createExperienceRequest
     *        A {@link Consumer} that will call methods on {@link CreateExperienceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateExperience operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ConflictException A conflict occurred with the request. Please fix any inconsistences with your
     *         resources and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>ServiceQuotaExceededException You have exceeded the set limits for your Amazon Kendra service. Please
     *         see Quotas[hyperlink Kendra Quotas pg] for more information, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> to inquire about an increase of
     *         limits.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.CreateExperience
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/CreateExperience" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateExperienceResponse> createExperience(
            Consumer<CreateExperienceRequest.Builder> createExperienceRequest) {
        return createExperience(CreateExperienceRequest.builder().applyMutation(createExperienceRequest).build());
    }

    /**
     * <p>
     * Creates an new set of frequently asked question (FAQ) questions and answers.
     * </p>
     * <p>
     * Adding FAQs to an index is an asynchronous operation.
     * </p>
     * <p>
     * For an example of adding an FAQ to an index using Python and Java SDKs, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/in-creating-faq.html#using-faq-file">Using your FAQ file</a>.
     * </p>
     *
     * @param createFaqRequest
     * @return A Java Future containing the result of the CreateFaq operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ConflictException A conflict occurred with the request. Please fix any inconsistences with your
     *         resources and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>ServiceQuotaExceededException You have exceeded the set limits for your Amazon Kendra service. Please
     *         see Quotas[hyperlink Kendra Quotas pg] for more information, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> to inquire about an increase of
     *         limits.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.CreateFaq
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/CreateFaq" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateFaqResponse> createFaq(CreateFaqRequest createFaqRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an new set of frequently asked question (FAQ) questions and answers.
     * </p>
     * <p>
     * Adding FAQs to an index is an asynchronous operation.
     * </p>
     * <p>
     * For an example of adding an FAQ to an index using Python and Java SDKs, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/in-creating-faq.html#using-faq-file">Using your FAQ file</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateFaqRequest.Builder} avoiding the need to
     * create one manually via {@link CreateFaqRequest#builder()}
     * </p>
     *
     * @param createFaqRequest
     *        A {@link Consumer} that will call methods on {@link CreateFaqRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateFaq operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ConflictException A conflict occurred with the request. Please fix any inconsistences with your
     *         resources and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>ServiceQuotaExceededException You have exceeded the set limits for your Amazon Kendra service. Please
     *         see Quotas[hyperlink Kendra Quotas pg] for more information, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> to inquire about an increase of
     *         limits.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.CreateFaq
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/CreateFaq" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateFaqResponse> createFaq(Consumer<CreateFaqRequest.Builder> createFaqRequest) {
        return createFaq(CreateFaqRequest.builder().applyMutation(createFaqRequest).build());
    }

    /**
     * <p>
     * Creates an Amazon Kendra index. Index creation is an asynchronous API. To determine if index creation has
     * completed, check the <code>Status</code> field returned from a call to <code>DescribeIndex</code>. The
     * <code>Status</code> field is set to <code>ACTIVE</code> when the index is ready to use.
     * </p>
     * <p>
     * Once the index is active you can index your documents using the <code>BatchPutDocument</code> API or using one of
     * the supported data sources.
     * </p>
     * <p>
     * For an example of creating an index and data source using the Python SDK, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/gs-python.html">Getting started with Python SDK</a>. For an
     * example of creating an index and data source using the Java SDK, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/gs-java.html">Getting started with Java SDK</a>.
     * </p>
     *
     * @param createIndexRequest
     * @return A Java Future containing the result of the CreateIndex operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ResourceAlreadyExistException The resource you want to use already exists. Please check you have
     *         provided the correct resource and try again.</li>
     *         <li>ServiceQuotaExceededException You have exceeded the set limits for your Amazon Kendra service. Please
     *         see Quotas[hyperlink Kendra Quotas pg] for more information, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> to inquire about an increase of
     *         limits.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>ConflictException A conflict occurred with the request. Please fix any inconsistences with your
     *         resources and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.CreateIndex
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/CreateIndex" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateIndexResponse> createIndex(CreateIndexRequest createIndexRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Amazon Kendra index. Index creation is an asynchronous API. To determine if index creation has
     * completed, check the <code>Status</code> field returned from a call to <code>DescribeIndex</code>. The
     * <code>Status</code> field is set to <code>ACTIVE</code> when the index is ready to use.
     * </p>
     * <p>
     * Once the index is active you can index your documents using the <code>BatchPutDocument</code> API or using one of
     * the supported data sources.
     * </p>
     * <p>
     * For an example of creating an index and data source using the Python SDK, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/gs-python.html">Getting started with Python SDK</a>. For an
     * example of creating an index and data source using the Java SDK, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/gs-java.html">Getting started with Java SDK</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateIndexRequest.Builder} avoiding the need to
     * create one manually via {@link CreateIndexRequest#builder()}
     * </p>
     *
     * @param createIndexRequest
     *        A {@link Consumer} that will call methods on {@link CreateIndexRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateIndex operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ResourceAlreadyExistException The resource you want to use already exists. Please check you have
     *         provided the correct resource and try again.</li>
     *         <li>ServiceQuotaExceededException You have exceeded the set limits for your Amazon Kendra service. Please
     *         see Quotas[hyperlink Kendra Quotas pg] for more information, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> to inquire about an increase of
     *         limits.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>ConflictException A conflict occurred with the request. Please fix any inconsistences with your
     *         resources and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.CreateIndex
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/CreateIndex" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateIndexResponse> createIndex(Consumer<CreateIndexRequest.Builder> createIndexRequest) {
        return createIndex(CreateIndexRequest.builder().applyMutation(createIndexRequest).build());
    }

    /**
     * <p>
     * Creates a block list to exlcude certain queries from suggestions.
     * </p>
     * <p>
     * Any query that contains words or phrases specified in the block list is blocked or filtered out from being shown
     * as a suggestion.
     * </p>
     * <p>
     * You need to provide the file location of your block list text file in your S3 bucket. In your text file, enter
     * each block word or phrase on a separate line.
     * </p>
     * <p>
     * For information on the current quota limits for block lists, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/quotas.html">Quotas for Amazon Kendra</a>.
     * </p>
     * <p>
     * <code>CreateQuerySuggestionsBlockList</code> is currently not supported in the Amazon Web Services GovCloud
     * (US-West) region.
     * </p>
     * <p>
     * For an example of creating a block list for query suggestions using the Python SDK, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/query-suggestions.html#suggestions-block-list">Query
     * suggestions block list</a>.
     * </p>
     *
     * @param createQuerySuggestionsBlockListRequest
     * @return A Java Future containing the result of the CreateQuerySuggestionsBlockList operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>ServiceQuotaExceededException You have exceeded the set limits for your Amazon Kendra service. Please
     *         see Quotas[hyperlink Kendra Quotas pg] for more information, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> to inquire about an increase of
     *         limits.</li>
     *         <li>ConflictException A conflict occurred with the request. Please fix any inconsistences with your
     *         resources and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.CreateQuerySuggestionsBlockList
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/CreateQuerySuggestionsBlockList"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateQuerySuggestionsBlockListResponse> createQuerySuggestionsBlockList(
            CreateQuerySuggestionsBlockListRequest createQuerySuggestionsBlockListRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a block list to exlcude certain queries from suggestions.
     * </p>
     * <p>
     * Any query that contains words or phrases specified in the block list is blocked or filtered out from being shown
     * as a suggestion.
     * </p>
     * <p>
     * You need to provide the file location of your block list text file in your S3 bucket. In your text file, enter
     * each block word or phrase on a separate line.
     * </p>
     * <p>
     * For information on the current quota limits for block lists, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/quotas.html">Quotas for Amazon Kendra</a>.
     * </p>
     * <p>
     * <code>CreateQuerySuggestionsBlockList</code> is currently not supported in the Amazon Web Services GovCloud
     * (US-West) region.
     * </p>
     * <p>
     * For an example of creating a block list for query suggestions using the Python SDK, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/query-suggestions.html#suggestions-block-list">Query
     * suggestions block list</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateQuerySuggestionsBlockListRequest.Builder}
     * avoiding the need to create one manually via {@link CreateQuerySuggestionsBlockListRequest#builder()}
     * </p>
     *
     * @param createQuerySuggestionsBlockListRequest
     *        A {@link Consumer} that will call methods on {@link CreateQuerySuggestionsBlockListRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateQuerySuggestionsBlockList operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>ServiceQuotaExceededException You have exceeded the set limits for your Amazon Kendra service. Please
     *         see Quotas[hyperlink Kendra Quotas pg] for more information, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> to inquire about an increase of
     *         limits.</li>
     *         <li>ConflictException A conflict occurred with the request. Please fix any inconsistences with your
     *         resources and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.CreateQuerySuggestionsBlockList
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/CreateQuerySuggestionsBlockList"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateQuerySuggestionsBlockListResponse> createQuerySuggestionsBlockList(
            Consumer<CreateQuerySuggestionsBlockListRequest.Builder> createQuerySuggestionsBlockListRequest) {
        return createQuerySuggestionsBlockList(CreateQuerySuggestionsBlockListRequest.builder()
                .applyMutation(createQuerySuggestionsBlockListRequest).build());
    }

    /**
     * <p>
     * Creates a thesaurus for an index. The thesaurus contains a list of synonyms in Solr format.
     * </p>
     * <p>
     * For an example of adding a thesaurus file to an index, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/index-synonyms-adding-thesaurus-file.html">Adding custom
     * synonyms to an index</a>.
     * </p>
     *
     * @param createThesaurusRequest
     * @return A Java Future containing the result of the CreateThesaurus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ConflictException A conflict occurred with the request. Please fix any inconsistences with your
     *         resources and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>ServiceQuotaExceededException You have exceeded the set limits for your Amazon Kendra service. Please
     *         see Quotas[hyperlink Kendra Quotas pg] for more information, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> to inquire about an increase of
     *         limits.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.CreateThesaurus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/CreateThesaurus" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateThesaurusResponse> createThesaurus(CreateThesaurusRequest createThesaurusRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a thesaurus for an index. The thesaurus contains a list of synonyms in Solr format.
     * </p>
     * <p>
     * For an example of adding a thesaurus file to an index, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/index-synonyms-adding-thesaurus-file.html">Adding custom
     * synonyms to an index</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateThesaurusRequest.Builder} avoiding the need
     * to create one manually via {@link CreateThesaurusRequest#builder()}
     * </p>
     *
     * @param createThesaurusRequest
     *        A {@link Consumer} that will call methods on {@link CreateThesaurusRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateThesaurus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ConflictException A conflict occurred with the request. Please fix any inconsistences with your
     *         resources and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>ServiceQuotaExceededException You have exceeded the set limits for your Amazon Kendra service. Please
     *         see Quotas[hyperlink Kendra Quotas pg] for more information, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> to inquire about an increase of
     *         limits.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.CreateThesaurus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/CreateThesaurus" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateThesaurusResponse> createThesaurus(
            Consumer<CreateThesaurusRequest.Builder> createThesaurusRequest) {
        return createThesaurus(CreateThesaurusRequest.builder().applyMutation(createThesaurusRequest).build());
    }

    /**
     * <p>
     * Deletes an access control configuration that you created for your documents in an index. This includes user and
     * group access information for your documents. This is useful for user context filtering, where search results are
     * filtered based on the user or their group access to documents.
     * </p>
     *
     * @param deleteAccessControlConfigurationRequest
     * @return A Java Future containing the result of the DeleteAccessControlConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>ConflictException A conflict occurred with the request. Please fix any inconsistences with your
     *         resources and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.DeleteAccessControlConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/DeleteAccessControlConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteAccessControlConfigurationResponse> deleteAccessControlConfiguration(
            DeleteAccessControlConfigurationRequest deleteAccessControlConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an access control configuration that you created for your documents in an index. This includes user and
     * group access information for your documents. This is useful for user context filtering, where search results are
     * filtered based on the user or their group access to documents.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAccessControlConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteAccessControlConfigurationRequest#builder()}
     * </p>
     *
     * @param deleteAccessControlConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link DeleteAccessControlConfigurationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteAccessControlConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>ConflictException A conflict occurred with the request. Please fix any inconsistences with your
     *         resources and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.DeleteAccessControlConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/DeleteAccessControlConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteAccessControlConfigurationResponse> deleteAccessControlConfiguration(
            Consumer<DeleteAccessControlConfigurationRequest.Builder> deleteAccessControlConfigurationRequest) {
        return deleteAccessControlConfiguration(DeleteAccessControlConfigurationRequest.builder()
                .applyMutation(deleteAccessControlConfigurationRequest).build());
    }

    /**
     * <p>
     * Deletes an Amazon Kendra data source connector. An exception is not thrown if the data source is already being
     * deleted. While the data source is being deleted, the <code>Status</code> field returned by a call to the
     * <code>DescribeDataSource</code> API is set to <code>DELETING</code>. For more information, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/delete-data-source.html">Deleting Data Sources</a>.
     * </p>
     *
     * @param deleteDataSourceRequest
     * @return A Java Future containing the result of the DeleteDataSource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ConflictException A conflict occurred with the request. Please fix any inconsistences with your
     *         resources and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.DeleteDataSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/DeleteDataSource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteDataSourceResponse> deleteDataSource(DeleteDataSourceRequest deleteDataSourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an Amazon Kendra data source connector. An exception is not thrown if the data source is already being
     * deleted. While the data source is being deleted, the <code>Status</code> field returned by a call to the
     * <code>DescribeDataSource</code> API is set to <code>DELETING</code>. For more information, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/delete-data-source.html">Deleting Data Sources</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDataSourceRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteDataSourceRequest#builder()}
     * </p>
     *
     * @param deleteDataSourceRequest
     *        A {@link Consumer} that will call methods on {@link DeleteDataSourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteDataSource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ConflictException A conflict occurred with the request. Please fix any inconsistences with your
     *         resources and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.DeleteDataSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/DeleteDataSource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteDataSourceResponse> deleteDataSource(
            Consumer<DeleteDataSourceRequest.Builder> deleteDataSourceRequest) {
        return deleteDataSource(DeleteDataSourceRequest.builder().applyMutation(deleteDataSourceRequest).build());
    }

    /**
     * <p>
     * Deletes your Amazon Kendra experience such as a search application. For more information on creating a search
     * application experience, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html">Building a search
     * experience with no code</a>.
     * </p>
     *
     * @param deleteExperienceRequest
     * @return A Java Future containing the result of the DeleteExperience operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ConflictException A conflict occurred with the request. Please fix any inconsistences with your
     *         resources and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.DeleteExperience
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/DeleteExperience" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteExperienceResponse> deleteExperience(DeleteExperienceRequest deleteExperienceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes your Amazon Kendra experience such as a search application. For more information on creating a search
     * application experience, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html">Building a search
     * experience with no code</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteExperienceRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteExperienceRequest#builder()}
     * </p>
     *
     * @param deleteExperienceRequest
     *        A {@link Consumer} that will call methods on {@link DeleteExperienceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteExperience operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ConflictException A conflict occurred with the request. Please fix any inconsistences with your
     *         resources and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.DeleteExperience
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/DeleteExperience" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteExperienceResponse> deleteExperience(
            Consumer<DeleteExperienceRequest.Builder> deleteExperienceRequest) {
        return deleteExperience(DeleteExperienceRequest.builder().applyMutation(deleteExperienceRequest).build());
    }

    /**
     * <p>
     * Removes an FAQ from an index.
     * </p>
     *
     * @param deleteFaqRequest
     * @return A Java Future containing the result of the DeleteFaq operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ConflictException A conflict occurred with the request. Please fix any inconsistences with your
     *         resources and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.DeleteFaq
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/DeleteFaq" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteFaqResponse> deleteFaq(DeleteFaqRequest deleteFaqRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes an FAQ from an index.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteFaqRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteFaqRequest#builder()}
     * </p>
     *
     * @param deleteFaqRequest
     *        A {@link Consumer} that will call methods on {@link DeleteFaqRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteFaq operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ConflictException A conflict occurred with the request. Please fix any inconsistences with your
     *         resources and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.DeleteFaq
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/DeleteFaq" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteFaqResponse> deleteFaq(Consumer<DeleteFaqRequest.Builder> deleteFaqRequest) {
        return deleteFaq(DeleteFaqRequest.builder().applyMutation(deleteFaqRequest).build());
    }

    /**
     * <p>
     * Deletes an existing Amazon Kendra index. An exception is not thrown if the index is already being deleted. While
     * the index is being deleted, the <code>Status</code> field returned by a call to the <code>DescribeIndex</code>
     * API is set to <code>DELETING</code>.
     * </p>
     *
     * @param deleteIndexRequest
     * @return A Java Future containing the result of the DeleteIndex operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ConflictException A conflict occurred with the request. Please fix any inconsistences with your
     *         resources and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.DeleteIndex
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/DeleteIndex" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteIndexResponse> deleteIndex(DeleteIndexRequest deleteIndexRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an existing Amazon Kendra index. An exception is not thrown if the index is already being deleted. While
     * the index is being deleted, the <code>Status</code> field returned by a call to the <code>DescribeIndex</code>
     * API is set to <code>DELETING</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteIndexRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteIndexRequest#builder()}
     * </p>
     *
     * @param deleteIndexRequest
     *        A {@link Consumer} that will call methods on {@link DeleteIndexRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteIndex operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ConflictException A conflict occurred with the request. Please fix any inconsistences with your
     *         resources and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.DeleteIndex
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/DeleteIndex" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteIndexResponse> deleteIndex(Consumer<DeleteIndexRequest.Builder> deleteIndexRequest) {
        return deleteIndex(DeleteIndexRequest.builder().applyMutation(deleteIndexRequest).build());
    }

    /**
     * <p>
     * Deletes a group so that all users and sub groups that belong to the group can no longer access documents only
     * available to that group.
     * </p>
     * <p>
     * For example, after deleting the group "Summer Interns", all interns who belonged to that group no longer see
     * intern-only documents in their search results.
     * </p>
     * <p>
     * If you want to delete or replace users or sub groups of a group, you need to use the
     * <code>PutPrincipalMapping</code> operation. For example, if a user in the group "Engineering" leaves the
     * engineering team and another user takes their place, you provide an updated list of users or sub groups that
     * belong to the "Engineering" group when calling <code>PutPrincipalMapping</code>. You can update your internal
     * list of users or sub groups and input this list when calling <code>PutPrincipalMapping</code>.
     * </p>
     * <p>
     * <code>DeletePrincipalMapping</code> is currently not supported in the Amazon Web Services GovCloud (US-West)
     * region.
     * </p>
     *
     * @param deletePrincipalMappingRequest
     * @return A Java Future containing the result of the DeletePrincipalMapping operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ConflictException A conflict occurred with the request. Please fix any inconsistences with your
     *         resources and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.DeletePrincipalMapping
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/DeletePrincipalMapping" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeletePrincipalMappingResponse> deletePrincipalMapping(
            DeletePrincipalMappingRequest deletePrincipalMappingRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a group so that all users and sub groups that belong to the group can no longer access documents only
     * available to that group.
     * </p>
     * <p>
     * For example, after deleting the group "Summer Interns", all interns who belonged to that group no longer see
     * intern-only documents in their search results.
     * </p>
     * <p>
     * If you want to delete or replace users or sub groups of a group, you need to use the
     * <code>PutPrincipalMapping</code> operation. For example, if a user in the group "Engineering" leaves the
     * engineering team and another user takes their place, you provide an updated list of users or sub groups that
     * belong to the "Engineering" group when calling <code>PutPrincipalMapping</code>. You can update your internal
     * list of users or sub groups and input this list when calling <code>PutPrincipalMapping</code>.
     * </p>
     * <p>
     * <code>DeletePrincipalMapping</code> is currently not supported in the Amazon Web Services GovCloud (US-West)
     * region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeletePrincipalMappingRequest.Builder} avoiding the
     * need to create one manually via {@link DeletePrincipalMappingRequest#builder()}
     * </p>
     *
     * @param deletePrincipalMappingRequest
     *        A {@link Consumer} that will call methods on {@link DeletePrincipalMappingRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeletePrincipalMapping operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ConflictException A conflict occurred with the request. Please fix any inconsistences with your
     *         resources and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.DeletePrincipalMapping
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/DeletePrincipalMapping" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeletePrincipalMappingResponse> deletePrincipalMapping(
            Consumer<DeletePrincipalMappingRequest.Builder> deletePrincipalMappingRequest) {
        return deletePrincipalMapping(DeletePrincipalMappingRequest.builder().applyMutation(deletePrincipalMappingRequest)
                .build());
    }

    /**
     * <p>
     * Deletes a block list used for query suggestions for an index.
     * </p>
     * <p>
     * A deleted block list might not take effect right away. Amazon Kendra needs to refresh the entire suggestions list
     * to add back the queries that were previously blocked.
     * </p>
     * <p>
     * <code>DeleteQuerySuggestionsBlockList</code> is currently not supported in the Amazon Web Services GovCloud
     * (US-West) region.
     * </p>
     *
     * @param deleteQuerySuggestionsBlockListRequest
     * @return A Java Future containing the result of the DeleteQuerySuggestionsBlockList operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>ConflictException A conflict occurred with the request. Please fix any inconsistences with your
     *         resources and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.DeleteQuerySuggestionsBlockList
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/DeleteQuerySuggestionsBlockList"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteQuerySuggestionsBlockListResponse> deleteQuerySuggestionsBlockList(
            DeleteQuerySuggestionsBlockListRequest deleteQuerySuggestionsBlockListRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a block list used for query suggestions for an index.
     * </p>
     * <p>
     * A deleted block list might not take effect right away. Amazon Kendra needs to refresh the entire suggestions list
     * to add back the queries that were previously blocked.
     * </p>
     * <p>
     * <code>DeleteQuerySuggestionsBlockList</code> is currently not supported in the Amazon Web Services GovCloud
     * (US-West) region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteQuerySuggestionsBlockListRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteQuerySuggestionsBlockListRequest#builder()}
     * </p>
     *
     * @param deleteQuerySuggestionsBlockListRequest
     *        A {@link Consumer} that will call methods on {@link DeleteQuerySuggestionsBlockListRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteQuerySuggestionsBlockList operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>ConflictException A conflict occurred with the request. Please fix any inconsistences with your
     *         resources and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.DeleteQuerySuggestionsBlockList
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/DeleteQuerySuggestionsBlockList"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteQuerySuggestionsBlockListResponse> deleteQuerySuggestionsBlockList(
            Consumer<DeleteQuerySuggestionsBlockListRequest.Builder> deleteQuerySuggestionsBlockListRequest) {
        return deleteQuerySuggestionsBlockList(DeleteQuerySuggestionsBlockListRequest.builder()
                .applyMutation(deleteQuerySuggestionsBlockListRequest).build());
    }

    /**
     * <p>
     * Deletes an existing Amazon Kendra thesaurus.
     * </p>
     *
     * @param deleteThesaurusRequest
     * @return A Java Future containing the result of the DeleteThesaurus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ConflictException A conflict occurred with the request. Please fix any inconsistences with your
     *         resources and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.DeleteThesaurus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/DeleteThesaurus" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteThesaurusResponse> deleteThesaurus(DeleteThesaurusRequest deleteThesaurusRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an existing Amazon Kendra thesaurus.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteThesaurusRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteThesaurusRequest#builder()}
     * </p>
     *
     * @param deleteThesaurusRequest
     *        A {@link Consumer} that will call methods on {@link DeleteThesaurusRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteThesaurus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ConflictException A conflict occurred with the request. Please fix any inconsistences with your
     *         resources and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.DeleteThesaurus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/DeleteThesaurus" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteThesaurusResponse> deleteThesaurus(
            Consumer<DeleteThesaurusRequest.Builder> deleteThesaurusRequest) {
        return deleteThesaurus(DeleteThesaurusRequest.builder().applyMutation(deleteThesaurusRequest).build());
    }

    /**
     * <p>
     * Gets information about an access control configuration that you created for your documents in an index. This
     * includes user and group access information for your documents. This is useful for user context filtering, where
     * search results are filtered based on the user or their group access to documents.
     * </p>
     *
     * @param describeAccessControlConfigurationRequest
     * @return A Java Future containing the result of the DescribeAccessControlConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.DescribeAccessControlConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/DescribeAccessControlConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeAccessControlConfigurationResponse> describeAccessControlConfiguration(
            DescribeAccessControlConfigurationRequest describeAccessControlConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about an access control configuration that you created for your documents in an index. This
     * includes user and group access information for your documents. This is useful for user context filtering, where
     * search results are filtered based on the user or their group access to documents.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAccessControlConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeAccessControlConfigurationRequest#builder()}
     * </p>
     *
     * @param describeAccessControlConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link DescribeAccessControlConfigurationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeAccessControlConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.DescribeAccessControlConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/DescribeAccessControlConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeAccessControlConfigurationResponse> describeAccessControlConfiguration(
            Consumer<DescribeAccessControlConfigurationRequest.Builder> describeAccessControlConfigurationRequest) {
        return describeAccessControlConfiguration(DescribeAccessControlConfigurationRequest.builder()
                .applyMutation(describeAccessControlConfigurationRequest).build());
    }

    /**
     * <p>
     * Gets information about an Amazon Kendra data source connector.
     * </p>
     *
     * @param describeDataSourceRequest
     * @return A Java Future containing the result of the DescribeDataSource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.DescribeDataSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/DescribeDataSource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeDataSourceResponse> describeDataSource(DescribeDataSourceRequest describeDataSourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about an Amazon Kendra data source connector.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDataSourceRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeDataSourceRequest#builder()}
     * </p>
     *
     * @param describeDataSourceRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDataSourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeDataSource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.DescribeDataSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/DescribeDataSource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeDataSourceResponse> describeDataSource(
            Consumer<DescribeDataSourceRequest.Builder> describeDataSourceRequest) {
        return describeDataSource(DescribeDataSourceRequest.builder().applyMutation(describeDataSourceRequest).build());
    }

    /**
     * <p>
     * Gets information about your Amazon Kendra experience such as a search application. For more information on
     * creating a search application experience, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html">Building a search
     * experience with no code</a>.
     * </p>
     *
     * @param describeExperienceRequest
     * @return A Java Future containing the result of the DescribeExperience operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.DescribeExperience
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/DescribeExperience" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeExperienceResponse> describeExperience(DescribeExperienceRequest describeExperienceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about your Amazon Kendra experience such as a search application. For more information on
     * creating a search application experience, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html">Building a search
     * experience with no code</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeExperienceRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeExperienceRequest#builder()}
     * </p>
     *
     * @param describeExperienceRequest
     *        A {@link Consumer} that will call methods on {@link DescribeExperienceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeExperience operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.DescribeExperience
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/DescribeExperience" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeExperienceResponse> describeExperience(
            Consumer<DescribeExperienceRequest.Builder> describeExperienceRequest) {
        return describeExperience(DescribeExperienceRequest.builder().applyMutation(describeExperienceRequest).build());
    }

    /**
     * <p>
     * Gets information about an FAQ list.
     * </p>
     *
     * @param describeFaqRequest
     * @return A Java Future containing the result of the DescribeFaq operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.DescribeFaq
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/DescribeFaq" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeFaqResponse> describeFaq(DescribeFaqRequest describeFaqRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about an FAQ list.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeFaqRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeFaqRequest#builder()}
     * </p>
     *
     * @param describeFaqRequest
     *        A {@link Consumer} that will call methods on {@link DescribeFaqRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeFaq operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.DescribeFaq
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/DescribeFaq" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeFaqResponse> describeFaq(Consumer<DescribeFaqRequest.Builder> describeFaqRequest) {
        return describeFaq(DescribeFaqRequest.builder().applyMutation(describeFaqRequest).build());
    }

    /**
     * <p>
     * Gets information about an existing Amazon Kendra index.
     * </p>
     *
     * @param describeIndexRequest
     * @return A Java Future containing the result of the DescribeIndex operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.DescribeIndex
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/DescribeIndex" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeIndexResponse> describeIndex(DescribeIndexRequest describeIndexRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about an existing Amazon Kendra index.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeIndexRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeIndexRequest#builder()}
     * </p>
     *
     * @param describeIndexRequest
     *        A {@link Consumer} that will call methods on {@link DescribeIndexRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeIndex operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.DescribeIndex
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/DescribeIndex" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeIndexResponse> describeIndex(Consumer<DescribeIndexRequest.Builder> describeIndexRequest) {
        return describeIndex(DescribeIndexRequest.builder().applyMutation(describeIndexRequest).build());
    }

    /**
     * <p>
     * Describes the processing of <code>PUT</code> and <code>DELETE</code> actions for mapping users to their groups.
     * This includes information on the status of actions currently processing or yet to be processed, when actions were
     * last updated, when actions were received by Amazon Kendra, the latest action that should process and apply after
     * other actions, and useful error messages if an action could not be processed.
     * </p>
     * <p>
     * <code>DescribePrincipalMapping</code> is currently not supported in the Amazon Web Services GovCloud (US-West)
     * region.
     * </p>
     *
     * @param describePrincipalMappingRequest
     * @return A Java Future containing the result of the DescribePrincipalMapping operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.DescribePrincipalMapping
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/DescribePrincipalMapping"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribePrincipalMappingResponse> describePrincipalMapping(
            DescribePrincipalMappingRequest describePrincipalMappingRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the processing of <code>PUT</code> and <code>DELETE</code> actions for mapping users to their groups.
     * This includes information on the status of actions currently processing or yet to be processed, when actions were
     * last updated, when actions were received by Amazon Kendra, the latest action that should process and apply after
     * other actions, and useful error messages if an action could not be processed.
     * </p>
     * <p>
     * <code>DescribePrincipalMapping</code> is currently not supported in the Amazon Web Services GovCloud (US-West)
     * region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribePrincipalMappingRequest.Builder} avoiding
     * the need to create one manually via {@link DescribePrincipalMappingRequest#builder()}
     * </p>
     *
     * @param describePrincipalMappingRequest
     *        A {@link Consumer} that will call methods on {@link DescribePrincipalMappingRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribePrincipalMapping operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.DescribePrincipalMapping
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/DescribePrincipalMapping"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribePrincipalMappingResponse> describePrincipalMapping(
            Consumer<DescribePrincipalMappingRequest.Builder> describePrincipalMappingRequest) {
        return describePrincipalMapping(DescribePrincipalMappingRequest.builder().applyMutation(describePrincipalMappingRequest)
                .build());
    }

    /**
     * <p>
     * Gets information about a block list used for query suggestions for an index.
     * </p>
     * <p>
     * This is used to check the current settings that are applied to a block list.
     * </p>
     * <p>
     * <code>DescribeQuerySuggestionsBlockList</code> is currently not supported in the Amazon Web Services GovCloud
     * (US-West) region.
     * </p>
     *
     * @param describeQuerySuggestionsBlockListRequest
     * @return A Java Future containing the result of the DescribeQuerySuggestionsBlockList operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.DescribeQuerySuggestionsBlockList
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/DescribeQuerySuggestionsBlockList"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeQuerySuggestionsBlockListResponse> describeQuerySuggestionsBlockList(
            DescribeQuerySuggestionsBlockListRequest describeQuerySuggestionsBlockListRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a block list used for query suggestions for an index.
     * </p>
     * <p>
     * This is used to check the current settings that are applied to a block list.
     * </p>
     * <p>
     * <code>DescribeQuerySuggestionsBlockList</code> is currently not supported in the Amazon Web Services GovCloud
     * (US-West) region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeQuerySuggestionsBlockListRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeQuerySuggestionsBlockListRequest#builder()}
     * </p>
     *
     * @param describeQuerySuggestionsBlockListRequest
     *        A {@link Consumer} that will call methods on {@link DescribeQuerySuggestionsBlockListRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeQuerySuggestionsBlockList operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.DescribeQuerySuggestionsBlockList
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/DescribeQuerySuggestionsBlockList"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeQuerySuggestionsBlockListResponse> describeQuerySuggestionsBlockList(
            Consumer<DescribeQuerySuggestionsBlockListRequest.Builder> describeQuerySuggestionsBlockListRequest) {
        return describeQuerySuggestionsBlockList(DescribeQuerySuggestionsBlockListRequest.builder()
                .applyMutation(describeQuerySuggestionsBlockListRequest).build());
    }

    /**
     * <p>
     * Gets information on the settings of query suggestions for an index.
     * </p>
     * <p>
     * This is used to check the current settings applied to query suggestions.
     * </p>
     * <p>
     * <code>DescribeQuerySuggestionsConfig</code> is currently not supported in the Amazon Web Services GovCloud
     * (US-West) region.
     * </p>
     *
     * @param describeQuerySuggestionsConfigRequest
     * @return A Java Future containing the result of the DescribeQuerySuggestionsConfig operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.DescribeQuerySuggestionsConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/DescribeQuerySuggestionsConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeQuerySuggestionsConfigResponse> describeQuerySuggestionsConfig(
            DescribeQuerySuggestionsConfigRequest describeQuerySuggestionsConfigRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information on the settings of query suggestions for an index.
     * </p>
     * <p>
     * This is used to check the current settings applied to query suggestions.
     * </p>
     * <p>
     * <code>DescribeQuerySuggestionsConfig</code> is currently not supported in the Amazon Web Services GovCloud
     * (US-West) region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeQuerySuggestionsConfigRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeQuerySuggestionsConfigRequest#builder()}
     * </p>
     *
     * @param describeQuerySuggestionsConfigRequest
     *        A {@link Consumer} that will call methods on {@link DescribeQuerySuggestionsConfigRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeQuerySuggestionsConfig operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.DescribeQuerySuggestionsConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/DescribeQuerySuggestionsConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeQuerySuggestionsConfigResponse> describeQuerySuggestionsConfig(
            Consumer<DescribeQuerySuggestionsConfigRequest.Builder> describeQuerySuggestionsConfigRequest) {
        return describeQuerySuggestionsConfig(DescribeQuerySuggestionsConfigRequest.builder()
                .applyMutation(describeQuerySuggestionsConfigRequest).build());
    }

    /**
     * <p>
     * Gets information about an existing Amazon Kendra thesaurus.
     * </p>
     *
     * @param describeThesaurusRequest
     * @return A Java Future containing the result of the DescribeThesaurus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.DescribeThesaurus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/DescribeThesaurus" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeThesaurusResponse> describeThesaurus(DescribeThesaurusRequest describeThesaurusRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about an existing Amazon Kendra thesaurus.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeThesaurusRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeThesaurusRequest#builder()}
     * </p>
     *
     * @param describeThesaurusRequest
     *        A {@link Consumer} that will call methods on {@link DescribeThesaurusRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeThesaurus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.DescribeThesaurus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/DescribeThesaurus" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeThesaurusResponse> describeThesaurus(
            Consumer<DescribeThesaurusRequest.Builder> describeThesaurusRequest) {
        return describeThesaurus(DescribeThesaurusRequest.builder().applyMutation(describeThesaurusRequest).build());
    }

    /**
     * <p>
     * Prevents users or groups in your IAM Identity Center identity source from accessing your Amazon Kendra
     * experience. You can create an Amazon Kendra experience such as a search application. For more information on
     * creating a search application experience, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html">Building a search
     * experience with no code</a>.
     * </p>
     *
     * @param disassociateEntitiesFromExperienceRequest
     * @return A Java Future containing the result of the DisassociateEntitiesFromExperience operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.DisassociateEntitiesFromExperience
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/DisassociateEntitiesFromExperience"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateEntitiesFromExperienceResponse> disassociateEntitiesFromExperience(
            DisassociateEntitiesFromExperienceRequest disassociateEntitiesFromExperienceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Prevents users or groups in your IAM Identity Center identity source from accessing your Amazon Kendra
     * experience. You can create an Amazon Kendra experience such as a search application. For more information on
     * creating a search application experience, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html">Building a search
     * experience with no code</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateEntitiesFromExperienceRequest.Builder}
     * avoiding the need to create one manually via {@link DisassociateEntitiesFromExperienceRequest#builder()}
     * </p>
     *
     * @param disassociateEntitiesFromExperienceRequest
     *        A {@link Consumer} that will call methods on {@link DisassociateEntitiesFromExperienceRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DisassociateEntitiesFromExperience operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.DisassociateEntitiesFromExperience
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/DisassociateEntitiesFromExperience"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateEntitiesFromExperienceResponse> disassociateEntitiesFromExperience(
            Consumer<DisassociateEntitiesFromExperienceRequest.Builder> disassociateEntitiesFromExperienceRequest) {
        return disassociateEntitiesFromExperience(DisassociateEntitiesFromExperienceRequest.builder()
                .applyMutation(disassociateEntitiesFromExperienceRequest).build());
    }

    /**
     * <p>
     * Removes the specific permissions of users or groups in your IAM Identity Center identity source with access to
     * your Amazon Kendra experience. You can create an Amazon Kendra experience such as a search application. For more
     * information on creating a search application experience, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html">Building a search
     * experience with no code</a>.
     * </p>
     *
     * @param disassociatePersonasFromEntitiesRequest
     * @return A Java Future containing the result of the DisassociatePersonasFromEntities operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.DisassociatePersonasFromEntities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/DisassociatePersonasFromEntities"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociatePersonasFromEntitiesResponse> disassociatePersonasFromEntities(
            DisassociatePersonasFromEntitiesRequest disassociatePersonasFromEntitiesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the specific permissions of users or groups in your IAM Identity Center identity source with access to
     * your Amazon Kendra experience. You can create an Amazon Kendra experience such as a search application. For more
     * information on creating a search application experience, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html">Building a search
     * experience with no code</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociatePersonasFromEntitiesRequest.Builder}
     * avoiding the need to create one manually via {@link DisassociatePersonasFromEntitiesRequest#builder()}
     * </p>
     *
     * @param disassociatePersonasFromEntitiesRequest
     *        A {@link Consumer} that will call methods on {@link DisassociatePersonasFromEntitiesRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DisassociatePersonasFromEntities operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.DisassociatePersonasFromEntities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/DisassociatePersonasFromEntities"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociatePersonasFromEntitiesResponse> disassociatePersonasFromEntities(
            Consumer<DisassociatePersonasFromEntitiesRequest.Builder> disassociatePersonasFromEntitiesRequest) {
        return disassociatePersonasFromEntities(DisassociatePersonasFromEntitiesRequest.builder()
                .applyMutation(disassociatePersonasFromEntitiesRequest).build());
    }

    /**
     * <p>
     * Fetches the queries that are suggested to your users.
     * </p>
     * <p>
     * <code>GetQuerySuggestions</code> is currently not supported in the Amazon Web Services GovCloud (US-West) region.
     * </p>
     *
     * @param getQuerySuggestionsRequest
     * @return A Java Future containing the result of the GetQuerySuggestions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>ServiceQuotaExceededException You have exceeded the set limits for your Amazon Kendra service. Please
     *         see Quotas[hyperlink Kendra Quotas pg] for more information, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> to inquire about an increase of
     *         limits.</li>
     *         <li>ConflictException A conflict occurred with the request. Please fix any inconsistences with your
     *         resources and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.GetQuerySuggestions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/GetQuerySuggestions" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetQuerySuggestionsResponse> getQuerySuggestions(
            GetQuerySuggestionsRequest getQuerySuggestionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Fetches the queries that are suggested to your users.
     * </p>
     * <p>
     * <code>GetQuerySuggestions</code> is currently not supported in the Amazon Web Services GovCloud (US-West) region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetQuerySuggestionsRequest.Builder} avoiding the
     * need to create one manually via {@link GetQuerySuggestionsRequest#builder()}
     * </p>
     *
     * @param getQuerySuggestionsRequest
     *        A {@link Consumer} that will call methods on {@link GetQuerySuggestionsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetQuerySuggestions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>ServiceQuotaExceededException You have exceeded the set limits for your Amazon Kendra service. Please
     *         see Quotas[hyperlink Kendra Quotas pg] for more information, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> to inquire about an increase of
     *         limits.</li>
     *         <li>ConflictException A conflict occurred with the request. Please fix any inconsistences with your
     *         resources and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.GetQuerySuggestions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/GetQuerySuggestions" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetQuerySuggestionsResponse> getQuerySuggestions(
            Consumer<GetQuerySuggestionsRequest.Builder> getQuerySuggestionsRequest) {
        return getQuerySuggestions(GetQuerySuggestionsRequest.builder().applyMutation(getQuerySuggestionsRequest).build());
    }

    /**
     * <p>
     * Retrieves search metrics data. The data provides a snapshot of how your users interact with your search
     * application and how effective the application is.
     * </p>
     *
     * @param getSnapshotsRequest
     * @return A Java Future containing the result of the GetSnapshots operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The input to the request is not valid. Please provide the correct input and
     *         try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.GetSnapshots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/GetSnapshots" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetSnapshotsResponse> getSnapshots(GetSnapshotsRequest getSnapshotsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves search metrics data. The data provides a snapshot of how your users interact with your search
     * application and how effective the application is.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSnapshotsRequest.Builder} avoiding the need to
     * create one manually via {@link GetSnapshotsRequest#builder()}
     * </p>
     *
     * @param getSnapshotsRequest
     *        A {@link Consumer} that will call methods on {@link GetSnapshotsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetSnapshots operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The input to the request is not valid. Please provide the correct input and
     *         try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.GetSnapshots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/GetSnapshots" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetSnapshotsResponse> getSnapshots(Consumer<GetSnapshotsRequest.Builder> getSnapshotsRequest) {
        return getSnapshots(GetSnapshotsRequest.builder().applyMutation(getSnapshotsRequest).build());
    }

    /**
     * <p>
     * Retrieves search metrics data. The data provides a snapshot of how your users interact with your search
     * application and how effective the application is.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getSnapshots(software.amazon.awssdk.services.kendra.model.GetSnapshotsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kendra.paginators.GetSnapshotsPublisher publisher = client.getSnapshotsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kendra.paginators.GetSnapshotsPublisher publisher = client.getSnapshotsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.kendra.model.GetSnapshotsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.kendra.model.GetSnapshotsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getSnapshots(software.amazon.awssdk.services.kendra.model.GetSnapshotsRequest)} operation.</b>
     * </p>
     *
     * @param getSnapshotsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The input to the request is not valid. Please provide the correct input and
     *         try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.GetSnapshots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/GetSnapshots" target="_top">AWS API
     *      Documentation</a>
     */
    default GetSnapshotsPublisher getSnapshotsPaginator(GetSnapshotsRequest getSnapshotsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves search metrics data. The data provides a snapshot of how your users interact with your search
     * application and how effective the application is.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getSnapshots(software.amazon.awssdk.services.kendra.model.GetSnapshotsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kendra.paginators.GetSnapshotsPublisher publisher = client.getSnapshotsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kendra.paginators.GetSnapshotsPublisher publisher = client.getSnapshotsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.kendra.model.GetSnapshotsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.kendra.model.GetSnapshotsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getSnapshots(software.amazon.awssdk.services.kendra.model.GetSnapshotsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSnapshotsRequest.Builder} avoiding the need to
     * create one manually via {@link GetSnapshotsRequest#builder()}
     * </p>
     *
     * @param getSnapshotsRequest
     *        A {@link Consumer} that will call methods on {@link GetSnapshotsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The input to the request is not valid. Please provide the correct input and
     *         try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.GetSnapshots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/GetSnapshots" target="_top">AWS API
     *      Documentation</a>
     */
    default GetSnapshotsPublisher getSnapshotsPaginator(Consumer<GetSnapshotsRequest.Builder> getSnapshotsRequest) {
        return getSnapshotsPaginator(GetSnapshotsRequest.builder().applyMutation(getSnapshotsRequest).build());
    }

    /**
     * <p>
     * Lists one or more access control configurations for an index. This includes user and group access information for
     * your documents. This is useful for user context filtering, where search results are filtered based on the user or
     * their group access to documents.
     * </p>
     *
     * @param listAccessControlConfigurationsRequest
     * @return A Java Future containing the result of the ListAccessControlConfigurations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.ListAccessControlConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/ListAccessControlConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAccessControlConfigurationsResponse> listAccessControlConfigurations(
            ListAccessControlConfigurationsRequest listAccessControlConfigurationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists one or more access control configurations for an index. This includes user and group access information for
     * your documents. This is useful for user context filtering, where search results are filtered based on the user or
     * their group access to documents.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAccessControlConfigurationsRequest.Builder}
     * avoiding the need to create one manually via {@link ListAccessControlConfigurationsRequest#builder()}
     * </p>
     *
     * @param listAccessControlConfigurationsRequest
     *        A {@link Consumer} that will call methods on {@link ListAccessControlConfigurationsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListAccessControlConfigurations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.ListAccessControlConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/ListAccessControlConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAccessControlConfigurationsResponse> listAccessControlConfigurations(
            Consumer<ListAccessControlConfigurationsRequest.Builder> listAccessControlConfigurationsRequest) {
        return listAccessControlConfigurations(ListAccessControlConfigurationsRequest.builder()
                .applyMutation(listAccessControlConfigurationsRequest).build());
    }

    /**
     * <p>
     * Lists one or more access control configurations for an index. This includes user and group access information for
     * your documents. This is useful for user context filtering, where search results are filtered based on the user or
     * their group access to documents.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAccessControlConfigurations(software.amazon.awssdk.services.kendra.model.ListAccessControlConfigurationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kendra.paginators.ListAccessControlConfigurationsPublisher publisher = client.listAccessControlConfigurationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kendra.paginators.ListAccessControlConfigurationsPublisher publisher = client.listAccessControlConfigurationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.kendra.model.ListAccessControlConfigurationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.kendra.model.ListAccessControlConfigurationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAccessControlConfigurations(software.amazon.awssdk.services.kendra.model.ListAccessControlConfigurationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAccessControlConfigurationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.ListAccessControlConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/ListAccessControlConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAccessControlConfigurationsPublisher listAccessControlConfigurationsPaginator(
            ListAccessControlConfigurationsRequest listAccessControlConfigurationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists one or more access control configurations for an index. This includes user and group access information for
     * your documents. This is useful for user context filtering, where search results are filtered based on the user or
     * their group access to documents.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAccessControlConfigurations(software.amazon.awssdk.services.kendra.model.ListAccessControlConfigurationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kendra.paginators.ListAccessControlConfigurationsPublisher publisher = client.listAccessControlConfigurationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kendra.paginators.ListAccessControlConfigurationsPublisher publisher = client.listAccessControlConfigurationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.kendra.model.ListAccessControlConfigurationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.kendra.model.ListAccessControlConfigurationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAccessControlConfigurations(software.amazon.awssdk.services.kendra.model.ListAccessControlConfigurationsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAccessControlConfigurationsRequest.Builder}
     * avoiding the need to create one manually via {@link ListAccessControlConfigurationsRequest#builder()}
     * </p>
     *
     * @param listAccessControlConfigurationsRequest
     *        A {@link Consumer} that will call methods on {@link ListAccessControlConfigurationsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.ListAccessControlConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/ListAccessControlConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAccessControlConfigurationsPublisher listAccessControlConfigurationsPaginator(
            Consumer<ListAccessControlConfigurationsRequest.Builder> listAccessControlConfigurationsRequest) {
        return listAccessControlConfigurationsPaginator(ListAccessControlConfigurationsRequest.builder()
                .applyMutation(listAccessControlConfigurationsRequest).build());
    }

    /**
     * <p>
     * Gets statistics about synchronizing a data source connector.
     * </p>
     *
     * @param listDataSourceSyncJobsRequest
     * @return A Java Future containing the result of the ListDataSourceSyncJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>ConflictException A conflict occurred with the request. Please fix any inconsistences with your
     *         resources and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.ListDataSourceSyncJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/ListDataSourceSyncJobs" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListDataSourceSyncJobsResponse> listDataSourceSyncJobs(
            ListDataSourceSyncJobsRequest listDataSourceSyncJobsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets statistics about synchronizing a data source connector.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDataSourceSyncJobsRequest.Builder} avoiding the
     * need to create one manually via {@link ListDataSourceSyncJobsRequest#builder()}
     * </p>
     *
     * @param listDataSourceSyncJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListDataSourceSyncJobsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListDataSourceSyncJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>ConflictException A conflict occurred with the request. Please fix any inconsistences with your
     *         resources and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.ListDataSourceSyncJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/ListDataSourceSyncJobs" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListDataSourceSyncJobsResponse> listDataSourceSyncJobs(
            Consumer<ListDataSourceSyncJobsRequest.Builder> listDataSourceSyncJobsRequest) {
        return listDataSourceSyncJobs(ListDataSourceSyncJobsRequest.builder().applyMutation(listDataSourceSyncJobsRequest)
                .build());
    }

    /**
     * <p>
     * Gets statistics about synchronizing a data source connector.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDataSourceSyncJobs(software.amazon.awssdk.services.kendra.model.ListDataSourceSyncJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kendra.paginators.ListDataSourceSyncJobsPublisher publisher = client.listDataSourceSyncJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kendra.paginators.ListDataSourceSyncJobsPublisher publisher = client.listDataSourceSyncJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.kendra.model.ListDataSourceSyncJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.kendra.model.ListDataSourceSyncJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDataSourceSyncJobs(software.amazon.awssdk.services.kendra.model.ListDataSourceSyncJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDataSourceSyncJobsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>ConflictException A conflict occurred with the request. Please fix any inconsistences with your
     *         resources and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.ListDataSourceSyncJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/ListDataSourceSyncJobs" target="_top">AWS
     *      API Documentation</a>
     */
    default ListDataSourceSyncJobsPublisher listDataSourceSyncJobsPaginator(
            ListDataSourceSyncJobsRequest listDataSourceSyncJobsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets statistics about synchronizing a data source connector.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDataSourceSyncJobs(software.amazon.awssdk.services.kendra.model.ListDataSourceSyncJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kendra.paginators.ListDataSourceSyncJobsPublisher publisher = client.listDataSourceSyncJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kendra.paginators.ListDataSourceSyncJobsPublisher publisher = client.listDataSourceSyncJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.kendra.model.ListDataSourceSyncJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.kendra.model.ListDataSourceSyncJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDataSourceSyncJobs(software.amazon.awssdk.services.kendra.model.ListDataSourceSyncJobsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDataSourceSyncJobsRequest.Builder} avoiding the
     * need to create one manually via {@link ListDataSourceSyncJobsRequest#builder()}
     * </p>
     *
     * @param listDataSourceSyncJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListDataSourceSyncJobsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>ConflictException A conflict occurred with the request. Please fix any inconsistences with your
     *         resources and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.ListDataSourceSyncJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/ListDataSourceSyncJobs" target="_top">AWS
     *      API Documentation</a>
     */
    default ListDataSourceSyncJobsPublisher listDataSourceSyncJobsPaginator(
            Consumer<ListDataSourceSyncJobsRequest.Builder> listDataSourceSyncJobsRequest) {
        return listDataSourceSyncJobsPaginator(ListDataSourceSyncJobsRequest.builder()
                .applyMutation(listDataSourceSyncJobsRequest).build());
    }

    /**
     * <p>
     * Lists the data source connectors that you have created.
     * </p>
     *
     * @param listDataSourcesRequest
     * @return A Java Future containing the result of the ListDataSources operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.ListDataSources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/ListDataSources" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListDataSourcesResponse> listDataSources(ListDataSourcesRequest listDataSourcesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the data source connectors that you have created.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDataSourcesRequest.Builder} avoiding the need
     * to create one manually via {@link ListDataSourcesRequest#builder()}
     * </p>
     *
     * @param listDataSourcesRequest
     *        A {@link Consumer} that will call methods on {@link ListDataSourcesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListDataSources operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.ListDataSources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/ListDataSources" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListDataSourcesResponse> listDataSources(
            Consumer<ListDataSourcesRequest.Builder> listDataSourcesRequest) {
        return listDataSources(ListDataSourcesRequest.builder().applyMutation(listDataSourcesRequest).build());
    }

    /**
     * <p>
     * Lists the data source connectors that you have created.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDataSources(software.amazon.awssdk.services.kendra.model.ListDataSourcesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kendra.paginators.ListDataSourcesPublisher publisher = client.listDataSourcesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kendra.paginators.ListDataSourcesPublisher publisher = client.listDataSourcesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.kendra.model.ListDataSourcesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.kendra.model.ListDataSourcesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDataSources(software.amazon.awssdk.services.kendra.model.ListDataSourcesRequest)} operation.</b>
     * </p>
     *
     * @param listDataSourcesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.ListDataSources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/ListDataSources" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDataSourcesPublisher listDataSourcesPaginator(ListDataSourcesRequest listDataSourcesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the data source connectors that you have created.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDataSources(software.amazon.awssdk.services.kendra.model.ListDataSourcesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kendra.paginators.ListDataSourcesPublisher publisher = client.listDataSourcesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kendra.paginators.ListDataSourcesPublisher publisher = client.listDataSourcesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.kendra.model.ListDataSourcesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.kendra.model.ListDataSourcesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDataSources(software.amazon.awssdk.services.kendra.model.ListDataSourcesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDataSourcesRequest.Builder} avoiding the need
     * to create one manually via {@link ListDataSourcesRequest#builder()}
     * </p>
     *
     * @param listDataSourcesRequest
     *        A {@link Consumer} that will call methods on {@link ListDataSourcesRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.ListDataSources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/ListDataSources" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDataSourcesPublisher listDataSourcesPaginator(Consumer<ListDataSourcesRequest.Builder> listDataSourcesRequest) {
        return listDataSourcesPaginator(ListDataSourcesRequest.builder().applyMutation(listDataSourcesRequest).build());
    }

    /**
     * <p>
     * Lists specific permissions of users and groups with access to your Amazon Kendra experience.
     * </p>
     *
     * @param listEntityPersonasRequest
     * @return A Java Future containing the result of the ListEntityPersonas operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.ListEntityPersonas
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/ListEntityPersonas" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListEntityPersonasResponse> listEntityPersonas(ListEntityPersonasRequest listEntityPersonasRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists specific permissions of users and groups with access to your Amazon Kendra experience.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEntityPersonasRequest.Builder} avoiding the
     * need to create one manually via {@link ListEntityPersonasRequest#builder()}
     * </p>
     *
     * @param listEntityPersonasRequest
     *        A {@link Consumer} that will call methods on {@link ListEntityPersonasRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListEntityPersonas operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.ListEntityPersonas
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/ListEntityPersonas" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListEntityPersonasResponse> listEntityPersonas(
            Consumer<ListEntityPersonasRequest.Builder> listEntityPersonasRequest) {
        return listEntityPersonas(ListEntityPersonasRequest.builder().applyMutation(listEntityPersonasRequest).build());
    }

    /**
     * <p>
     * Lists specific permissions of users and groups with access to your Amazon Kendra experience.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listEntityPersonas(software.amazon.awssdk.services.kendra.model.ListEntityPersonasRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kendra.paginators.ListEntityPersonasPublisher publisher = client.listEntityPersonasPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kendra.paginators.ListEntityPersonasPublisher publisher = client.listEntityPersonasPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.kendra.model.ListEntityPersonasResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.kendra.model.ListEntityPersonasResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEntityPersonas(software.amazon.awssdk.services.kendra.model.ListEntityPersonasRequest)}
     * operation.</b>
     * </p>
     *
     * @param listEntityPersonasRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.ListEntityPersonas
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/ListEntityPersonas" target="_top">AWS API
     *      Documentation</a>
     */
    default ListEntityPersonasPublisher listEntityPersonasPaginator(ListEntityPersonasRequest listEntityPersonasRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists specific permissions of users and groups with access to your Amazon Kendra experience.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listEntityPersonas(software.amazon.awssdk.services.kendra.model.ListEntityPersonasRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kendra.paginators.ListEntityPersonasPublisher publisher = client.listEntityPersonasPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kendra.paginators.ListEntityPersonasPublisher publisher = client.listEntityPersonasPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.kendra.model.ListEntityPersonasResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.kendra.model.ListEntityPersonasResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEntityPersonas(software.amazon.awssdk.services.kendra.model.ListEntityPersonasRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEntityPersonasRequest.Builder} avoiding the
     * need to create one manually via {@link ListEntityPersonasRequest#builder()}
     * </p>
     *
     * @param listEntityPersonasRequest
     *        A {@link Consumer} that will call methods on {@link ListEntityPersonasRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.ListEntityPersonas
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/ListEntityPersonas" target="_top">AWS API
     *      Documentation</a>
     */
    default ListEntityPersonasPublisher listEntityPersonasPaginator(
            Consumer<ListEntityPersonasRequest.Builder> listEntityPersonasRequest) {
        return listEntityPersonasPaginator(ListEntityPersonasRequest.builder().applyMutation(listEntityPersonasRequest).build());
    }

    /**
     * <p>
     * Lists users or groups in your IAM Identity Center identity source that are granted access to your Amazon Kendra
     * experience. You can create an Amazon Kendra experience such as a search application. For more information on
     * creating a search application experience, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html">Building a search
     * experience with no code</a>.
     * </p>
     *
     * @param listExperienceEntitiesRequest
     * @return A Java Future containing the result of the ListExperienceEntities operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.ListExperienceEntities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/ListExperienceEntities" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListExperienceEntitiesResponse> listExperienceEntities(
            ListExperienceEntitiesRequest listExperienceEntitiesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists users or groups in your IAM Identity Center identity source that are granted access to your Amazon Kendra
     * experience. You can create an Amazon Kendra experience such as a search application. For more information on
     * creating a search application experience, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html">Building a search
     * experience with no code</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListExperienceEntitiesRequest.Builder} avoiding the
     * need to create one manually via {@link ListExperienceEntitiesRequest#builder()}
     * </p>
     *
     * @param listExperienceEntitiesRequest
     *        A {@link Consumer} that will call methods on {@link ListExperienceEntitiesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListExperienceEntities operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.ListExperienceEntities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/ListExperienceEntities" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListExperienceEntitiesResponse> listExperienceEntities(
            Consumer<ListExperienceEntitiesRequest.Builder> listExperienceEntitiesRequest) {
        return listExperienceEntities(ListExperienceEntitiesRequest.builder().applyMutation(listExperienceEntitiesRequest)
                .build());
    }

    /**
     * <p>
     * Lists users or groups in your IAM Identity Center identity source that are granted access to your Amazon Kendra
     * experience. You can create an Amazon Kendra experience such as a search application. For more information on
     * creating a search application experience, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html">Building a search
     * experience with no code</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listExperienceEntities(software.amazon.awssdk.services.kendra.model.ListExperienceEntitiesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kendra.paginators.ListExperienceEntitiesPublisher publisher = client.listExperienceEntitiesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kendra.paginators.ListExperienceEntitiesPublisher publisher = client.listExperienceEntitiesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.kendra.model.ListExperienceEntitiesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.kendra.model.ListExperienceEntitiesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listExperienceEntities(software.amazon.awssdk.services.kendra.model.ListExperienceEntitiesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listExperienceEntitiesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.ListExperienceEntities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/ListExperienceEntities" target="_top">AWS
     *      API Documentation</a>
     */
    default ListExperienceEntitiesPublisher listExperienceEntitiesPaginator(
            ListExperienceEntitiesRequest listExperienceEntitiesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists users or groups in your IAM Identity Center identity source that are granted access to your Amazon Kendra
     * experience. You can create an Amazon Kendra experience such as a search application. For more information on
     * creating a search application experience, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html">Building a search
     * experience with no code</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listExperienceEntities(software.amazon.awssdk.services.kendra.model.ListExperienceEntitiesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kendra.paginators.ListExperienceEntitiesPublisher publisher = client.listExperienceEntitiesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kendra.paginators.ListExperienceEntitiesPublisher publisher = client.listExperienceEntitiesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.kendra.model.ListExperienceEntitiesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.kendra.model.ListExperienceEntitiesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listExperienceEntities(software.amazon.awssdk.services.kendra.model.ListExperienceEntitiesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListExperienceEntitiesRequest.Builder} avoiding the
     * need to create one manually via {@link ListExperienceEntitiesRequest#builder()}
     * </p>
     *
     * @param listExperienceEntitiesRequest
     *        A {@link Consumer} that will call methods on {@link ListExperienceEntitiesRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.ListExperienceEntities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/ListExperienceEntities" target="_top">AWS
     *      API Documentation</a>
     */
    default ListExperienceEntitiesPublisher listExperienceEntitiesPaginator(
            Consumer<ListExperienceEntitiesRequest.Builder> listExperienceEntitiesRequest) {
        return listExperienceEntitiesPaginator(ListExperienceEntitiesRequest.builder()
                .applyMutation(listExperienceEntitiesRequest).build());
    }

    /**
     * <p>
     * Lists one or more Amazon Kendra experiences. You can create an Amazon Kendra experience such as a search
     * application. For more information on creating a search application experience, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html">Building a search
     * experience with no code</a>.
     * </p>
     *
     * @param listExperiencesRequest
     * @return A Java Future containing the result of the ListExperiences operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.ListExperiences
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/ListExperiences" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListExperiencesResponse> listExperiences(ListExperiencesRequest listExperiencesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists one or more Amazon Kendra experiences. You can create an Amazon Kendra experience such as a search
     * application. For more information on creating a search application experience, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html">Building a search
     * experience with no code</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListExperiencesRequest.Builder} avoiding the need
     * to create one manually via {@link ListExperiencesRequest#builder()}
     * </p>
     *
     * @param listExperiencesRequest
     *        A {@link Consumer} that will call methods on {@link ListExperiencesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListExperiences operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.ListExperiences
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/ListExperiences" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListExperiencesResponse> listExperiences(
            Consumer<ListExperiencesRequest.Builder> listExperiencesRequest) {
        return listExperiences(ListExperiencesRequest.builder().applyMutation(listExperiencesRequest).build());
    }

    /**
     * <p>
     * Lists one or more Amazon Kendra experiences. You can create an Amazon Kendra experience such as a search
     * application. For more information on creating a search application experience, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html">Building a search
     * experience with no code</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listExperiences(software.amazon.awssdk.services.kendra.model.ListExperiencesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kendra.paginators.ListExperiencesPublisher publisher = client.listExperiencesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kendra.paginators.ListExperiencesPublisher publisher = client.listExperiencesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.kendra.model.ListExperiencesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.kendra.model.ListExperiencesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listExperiences(software.amazon.awssdk.services.kendra.model.ListExperiencesRequest)} operation.</b>
     * </p>
     *
     * @param listExperiencesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.ListExperiences
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/ListExperiences" target="_top">AWS API
     *      Documentation</a>
     */
    default ListExperiencesPublisher listExperiencesPaginator(ListExperiencesRequest listExperiencesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists one or more Amazon Kendra experiences. You can create an Amazon Kendra experience such as a search
     * application. For more information on creating a search application experience, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html">Building a search
     * experience with no code</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listExperiences(software.amazon.awssdk.services.kendra.model.ListExperiencesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kendra.paginators.ListExperiencesPublisher publisher = client.listExperiencesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kendra.paginators.ListExperiencesPublisher publisher = client.listExperiencesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.kendra.model.ListExperiencesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.kendra.model.ListExperiencesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listExperiences(software.amazon.awssdk.services.kendra.model.ListExperiencesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListExperiencesRequest.Builder} avoiding the need
     * to create one manually via {@link ListExperiencesRequest#builder()}
     * </p>
     *
     * @param listExperiencesRequest
     *        A {@link Consumer} that will call methods on {@link ListExperiencesRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.ListExperiences
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/ListExperiences" target="_top">AWS API
     *      Documentation</a>
     */
    default ListExperiencesPublisher listExperiencesPaginator(Consumer<ListExperiencesRequest.Builder> listExperiencesRequest) {
        return listExperiencesPaginator(ListExperiencesRequest.builder().applyMutation(listExperiencesRequest).build());
    }

    /**
     * <p>
     * Gets a list of FAQ lists associated with an index.
     * </p>
     *
     * @param listFaqsRequest
     * @return A Java Future containing the result of the ListFaqs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.ListFaqs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/ListFaqs" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListFaqsResponse> listFaqs(ListFaqsRequest listFaqsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of FAQ lists associated with an index.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFaqsRequest.Builder} avoiding the need to
     * create one manually via {@link ListFaqsRequest#builder()}
     * </p>
     *
     * @param listFaqsRequest
     *        A {@link Consumer} that will call methods on {@link ListFaqsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListFaqs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.ListFaqs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/ListFaqs" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListFaqsResponse> listFaqs(Consumer<ListFaqsRequest.Builder> listFaqsRequest) {
        return listFaqs(ListFaqsRequest.builder().applyMutation(listFaqsRequest).build());
    }

    /**
     * <p>
     * Gets a list of FAQ lists associated with an index.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listFaqs(software.amazon.awssdk.services.kendra.model.ListFaqsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kendra.paginators.ListFaqsPublisher publisher = client.listFaqsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kendra.paginators.ListFaqsPublisher publisher = client.listFaqsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.kendra.model.ListFaqsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.kendra.model.ListFaqsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFaqs(software.amazon.awssdk.services.kendra.model.ListFaqsRequest)} operation.</b>
     * </p>
     *
     * @param listFaqsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.ListFaqs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/ListFaqs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFaqsPublisher listFaqsPaginator(ListFaqsRequest listFaqsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of FAQ lists associated with an index.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listFaqs(software.amazon.awssdk.services.kendra.model.ListFaqsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kendra.paginators.ListFaqsPublisher publisher = client.listFaqsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kendra.paginators.ListFaqsPublisher publisher = client.listFaqsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.kendra.model.ListFaqsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.kendra.model.ListFaqsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFaqs(software.amazon.awssdk.services.kendra.model.ListFaqsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFaqsRequest.Builder} avoiding the need to
     * create one manually via {@link ListFaqsRequest#builder()}
     * </p>
     *
     * @param listFaqsRequest
     *        A {@link Consumer} that will call methods on {@link ListFaqsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.ListFaqs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/ListFaqs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFaqsPublisher listFaqsPaginator(Consumer<ListFaqsRequest.Builder> listFaqsRequest) {
        return listFaqsPaginator(ListFaqsRequest.builder().applyMutation(listFaqsRequest).build());
    }

    /**
     * <p>
     * Provides a list of groups that are mapped to users before a given ordering or timestamp identifier.
     * </p>
     * <p>
     * <code>ListGroupsOlderThanOrderingId</code> is currently not supported in the Amazon Web Services GovCloud
     * (US-West) region.
     * </p>
     *
     * @param listGroupsOlderThanOrderingIdRequest
     * @return A Java Future containing the result of the ListGroupsOlderThanOrderingId operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>ConflictException A conflict occurred with the request. Please fix any inconsistences with your
     *         resources and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.ListGroupsOlderThanOrderingId
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/ListGroupsOlderThanOrderingId"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListGroupsOlderThanOrderingIdResponse> listGroupsOlderThanOrderingId(
            ListGroupsOlderThanOrderingIdRequest listGroupsOlderThanOrderingIdRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides a list of groups that are mapped to users before a given ordering or timestamp identifier.
     * </p>
     * <p>
     * <code>ListGroupsOlderThanOrderingId</code> is currently not supported in the Amazon Web Services GovCloud
     * (US-West) region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGroupsOlderThanOrderingIdRequest.Builder}
     * avoiding the need to create one manually via {@link ListGroupsOlderThanOrderingIdRequest#builder()}
     * </p>
     *
     * @param listGroupsOlderThanOrderingIdRequest
     *        A {@link Consumer} that will call methods on {@link ListGroupsOlderThanOrderingIdRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListGroupsOlderThanOrderingId operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>ConflictException A conflict occurred with the request. Please fix any inconsistences with your
     *         resources and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.ListGroupsOlderThanOrderingId
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/ListGroupsOlderThanOrderingId"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListGroupsOlderThanOrderingIdResponse> listGroupsOlderThanOrderingId(
            Consumer<ListGroupsOlderThanOrderingIdRequest.Builder> listGroupsOlderThanOrderingIdRequest) {
        return listGroupsOlderThanOrderingId(ListGroupsOlderThanOrderingIdRequest.builder()
                .applyMutation(listGroupsOlderThanOrderingIdRequest).build());
    }

    /**
     * <p>
     * Provides a list of groups that are mapped to users before a given ordering or timestamp identifier.
     * </p>
     * <p>
     * <code>ListGroupsOlderThanOrderingId</code> is currently not supported in the Amazon Web Services GovCloud
     * (US-West) region.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listGroupsOlderThanOrderingId(software.amazon.awssdk.services.kendra.model.ListGroupsOlderThanOrderingIdRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kendra.paginators.ListGroupsOlderThanOrderingIdPublisher publisher = client.listGroupsOlderThanOrderingIdPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kendra.paginators.ListGroupsOlderThanOrderingIdPublisher publisher = client.listGroupsOlderThanOrderingIdPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.kendra.model.ListGroupsOlderThanOrderingIdResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.kendra.model.ListGroupsOlderThanOrderingIdResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listGroupsOlderThanOrderingId(software.amazon.awssdk.services.kendra.model.ListGroupsOlderThanOrderingIdRequest)}
     * operation.</b>
     * </p>
     *
     * @param listGroupsOlderThanOrderingIdRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>ConflictException A conflict occurred with the request. Please fix any inconsistences with your
     *         resources and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.ListGroupsOlderThanOrderingId
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/ListGroupsOlderThanOrderingId"
     *      target="_top">AWS API Documentation</a>
     */
    default ListGroupsOlderThanOrderingIdPublisher listGroupsOlderThanOrderingIdPaginator(
            ListGroupsOlderThanOrderingIdRequest listGroupsOlderThanOrderingIdRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides a list of groups that are mapped to users before a given ordering or timestamp identifier.
     * </p>
     * <p>
     * <code>ListGroupsOlderThanOrderingId</code> is currently not supported in the Amazon Web Services GovCloud
     * (US-West) region.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listGroupsOlderThanOrderingId(software.amazon.awssdk.services.kendra.model.ListGroupsOlderThanOrderingIdRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kendra.paginators.ListGroupsOlderThanOrderingIdPublisher publisher = client.listGroupsOlderThanOrderingIdPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kendra.paginators.ListGroupsOlderThanOrderingIdPublisher publisher = client.listGroupsOlderThanOrderingIdPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.kendra.model.ListGroupsOlderThanOrderingIdResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.kendra.model.ListGroupsOlderThanOrderingIdResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listGroupsOlderThanOrderingId(software.amazon.awssdk.services.kendra.model.ListGroupsOlderThanOrderingIdRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGroupsOlderThanOrderingIdRequest.Builder}
     * avoiding the need to create one manually via {@link ListGroupsOlderThanOrderingIdRequest#builder()}
     * </p>
     *
     * @param listGroupsOlderThanOrderingIdRequest
     *        A {@link Consumer} that will call methods on {@link ListGroupsOlderThanOrderingIdRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>ConflictException A conflict occurred with the request. Please fix any inconsistences with your
     *         resources and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.ListGroupsOlderThanOrderingId
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/ListGroupsOlderThanOrderingId"
     *      target="_top">AWS API Documentation</a>
     */
    default ListGroupsOlderThanOrderingIdPublisher listGroupsOlderThanOrderingIdPaginator(
            Consumer<ListGroupsOlderThanOrderingIdRequest.Builder> listGroupsOlderThanOrderingIdRequest) {
        return listGroupsOlderThanOrderingIdPaginator(ListGroupsOlderThanOrderingIdRequest.builder()
                .applyMutation(listGroupsOlderThanOrderingIdRequest).build());
    }

    /**
     * <p>
     * Lists the Amazon Kendra indexes that you created.
     * </p>
     *
     * @param listIndicesRequest
     * @return A Java Future containing the result of the ListIndices operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.ListIndices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/ListIndices" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListIndicesResponse> listIndices(ListIndicesRequest listIndicesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the Amazon Kendra indexes that you created.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListIndicesRequest.Builder} avoiding the need to
     * create one manually via {@link ListIndicesRequest#builder()}
     * </p>
     *
     * @param listIndicesRequest
     *        A {@link Consumer} that will call methods on {@link ListIndicesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListIndices operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.ListIndices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/ListIndices" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListIndicesResponse> listIndices(Consumer<ListIndicesRequest.Builder> listIndicesRequest) {
        return listIndices(ListIndicesRequest.builder().applyMutation(listIndicesRequest).build());
    }

    /**
     * <p>
     * Lists the Amazon Kendra indexes that you created.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listIndices(software.amazon.awssdk.services.kendra.model.ListIndicesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kendra.paginators.ListIndicesPublisher publisher = client.listIndicesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kendra.paginators.ListIndicesPublisher publisher = client.listIndicesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.kendra.model.ListIndicesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.kendra.model.ListIndicesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listIndices(software.amazon.awssdk.services.kendra.model.ListIndicesRequest)} operation.</b>
     * </p>
     *
     * @param listIndicesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.ListIndices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/ListIndices" target="_top">AWS API
     *      Documentation</a>
     */
    default ListIndicesPublisher listIndicesPaginator(ListIndicesRequest listIndicesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the Amazon Kendra indexes that you created.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listIndices(software.amazon.awssdk.services.kendra.model.ListIndicesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kendra.paginators.ListIndicesPublisher publisher = client.listIndicesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kendra.paginators.ListIndicesPublisher publisher = client.listIndicesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.kendra.model.ListIndicesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.kendra.model.ListIndicesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listIndices(software.amazon.awssdk.services.kendra.model.ListIndicesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListIndicesRequest.Builder} avoiding the need to
     * create one manually via {@link ListIndicesRequest#builder()}
     * </p>
     *
     * @param listIndicesRequest
     *        A {@link Consumer} that will call methods on {@link ListIndicesRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.ListIndices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/ListIndices" target="_top">AWS API
     *      Documentation</a>
     */
    default ListIndicesPublisher listIndicesPaginator(Consumer<ListIndicesRequest.Builder> listIndicesRequest) {
        return listIndicesPaginator(ListIndicesRequest.builder().applyMutation(listIndicesRequest).build());
    }

    /**
     * <p>
     * Lists the block lists used for query suggestions for an index.
     * </p>
     * <p>
     * For information on the current quota limits for block lists, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/quotas.html">Quotas for Amazon Kendra</a>.
     * </p>
     * <p>
     * <code>ListQuerySuggestionsBlockLists</code> is currently not supported in the Amazon Web Services GovCloud
     * (US-West) region.
     * </p>
     *
     * @param listQuerySuggestionsBlockListsRequest
     * @return A Java Future containing the result of the ListQuerySuggestionsBlockLists operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.ListQuerySuggestionsBlockLists
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/ListQuerySuggestionsBlockLists"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListQuerySuggestionsBlockListsResponse> listQuerySuggestionsBlockLists(
            ListQuerySuggestionsBlockListsRequest listQuerySuggestionsBlockListsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the block lists used for query suggestions for an index.
     * </p>
     * <p>
     * For information on the current quota limits for block lists, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/quotas.html">Quotas for Amazon Kendra</a>.
     * </p>
     * <p>
     * <code>ListQuerySuggestionsBlockLists</code> is currently not supported in the Amazon Web Services GovCloud
     * (US-West) region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListQuerySuggestionsBlockListsRequest.Builder}
     * avoiding the need to create one manually via {@link ListQuerySuggestionsBlockListsRequest#builder()}
     * </p>
     *
     * @param listQuerySuggestionsBlockListsRequest
     *        A {@link Consumer} that will call methods on {@link ListQuerySuggestionsBlockListsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListQuerySuggestionsBlockLists operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.ListQuerySuggestionsBlockLists
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/ListQuerySuggestionsBlockLists"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListQuerySuggestionsBlockListsResponse> listQuerySuggestionsBlockLists(
            Consumer<ListQuerySuggestionsBlockListsRequest.Builder> listQuerySuggestionsBlockListsRequest) {
        return listQuerySuggestionsBlockLists(ListQuerySuggestionsBlockListsRequest.builder()
                .applyMutation(listQuerySuggestionsBlockListsRequest).build());
    }

    /**
     * <p>
     * Lists the block lists used for query suggestions for an index.
     * </p>
     * <p>
     * For information on the current quota limits for block lists, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/quotas.html">Quotas for Amazon Kendra</a>.
     * </p>
     * <p>
     * <code>ListQuerySuggestionsBlockLists</code> is currently not supported in the Amazon Web Services GovCloud
     * (US-West) region.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listQuerySuggestionsBlockLists(software.amazon.awssdk.services.kendra.model.ListQuerySuggestionsBlockListsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kendra.paginators.ListQuerySuggestionsBlockListsPublisher publisher = client.listQuerySuggestionsBlockListsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kendra.paginators.ListQuerySuggestionsBlockListsPublisher publisher = client.listQuerySuggestionsBlockListsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.kendra.model.ListQuerySuggestionsBlockListsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.kendra.model.ListQuerySuggestionsBlockListsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listQuerySuggestionsBlockLists(software.amazon.awssdk.services.kendra.model.ListQuerySuggestionsBlockListsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listQuerySuggestionsBlockListsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.ListQuerySuggestionsBlockLists
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/ListQuerySuggestionsBlockLists"
     *      target="_top">AWS API Documentation</a>
     */
    default ListQuerySuggestionsBlockListsPublisher listQuerySuggestionsBlockListsPaginator(
            ListQuerySuggestionsBlockListsRequest listQuerySuggestionsBlockListsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the block lists used for query suggestions for an index.
     * </p>
     * <p>
     * For information on the current quota limits for block lists, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/quotas.html">Quotas for Amazon Kendra</a>.
     * </p>
     * <p>
     * <code>ListQuerySuggestionsBlockLists</code> is currently not supported in the Amazon Web Services GovCloud
     * (US-West) region.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listQuerySuggestionsBlockLists(software.amazon.awssdk.services.kendra.model.ListQuerySuggestionsBlockListsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kendra.paginators.ListQuerySuggestionsBlockListsPublisher publisher = client.listQuerySuggestionsBlockListsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kendra.paginators.ListQuerySuggestionsBlockListsPublisher publisher = client.listQuerySuggestionsBlockListsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.kendra.model.ListQuerySuggestionsBlockListsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.kendra.model.ListQuerySuggestionsBlockListsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listQuerySuggestionsBlockLists(software.amazon.awssdk.services.kendra.model.ListQuerySuggestionsBlockListsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListQuerySuggestionsBlockListsRequest.Builder}
     * avoiding the need to create one manually via {@link ListQuerySuggestionsBlockListsRequest#builder()}
     * </p>
     *
     * @param listQuerySuggestionsBlockListsRequest
     *        A {@link Consumer} that will call methods on {@link ListQuerySuggestionsBlockListsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.ListQuerySuggestionsBlockLists
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/ListQuerySuggestionsBlockLists"
     *      target="_top">AWS API Documentation</a>
     */
    default ListQuerySuggestionsBlockListsPublisher listQuerySuggestionsBlockListsPaginator(
            Consumer<ListQuerySuggestionsBlockListsRequest.Builder> listQuerySuggestionsBlockListsRequest) {
        return listQuerySuggestionsBlockListsPaginator(ListQuerySuggestionsBlockListsRequest.builder()
                .applyMutation(listQuerySuggestionsBlockListsRequest).build());
    }

    /**
     * <p>
     * Gets a list of tags associated with a specified resource. Indexes, FAQs, and data sources can have tags
     * associated with them.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ResourceUnavailableException The resource you want to use isn't available. Please check you have
     *         provided the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of tags associated with a specified resource. Indexes, FAQs, and data sources can have tags
     * associated with them.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ResourceUnavailableException The resource you want to use isn't available. Please check you have
     *         provided the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Lists the thesauri for an index.
     * </p>
     *
     * @param listThesauriRequest
     * @return A Java Future containing the result of the ListThesauri operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.ListThesauri
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/ListThesauri" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListThesauriResponse> listThesauri(ListThesauriRequest listThesauriRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the thesauri for an index.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListThesauriRequest.Builder} avoiding the need to
     * create one manually via {@link ListThesauriRequest#builder()}
     * </p>
     *
     * @param listThesauriRequest
     *        A {@link Consumer} that will call methods on {@link ListThesauriRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListThesauri operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.ListThesauri
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/ListThesauri" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListThesauriResponse> listThesauri(Consumer<ListThesauriRequest.Builder> listThesauriRequest) {
        return listThesauri(ListThesauriRequest.builder().applyMutation(listThesauriRequest).build());
    }

    /**
     * <p>
     * Lists the thesauri for an index.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listThesauri(software.amazon.awssdk.services.kendra.model.ListThesauriRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kendra.paginators.ListThesauriPublisher publisher = client.listThesauriPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kendra.paginators.ListThesauriPublisher publisher = client.listThesauriPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.kendra.model.ListThesauriResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.kendra.model.ListThesauriResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listThesauri(software.amazon.awssdk.services.kendra.model.ListThesauriRequest)} operation.</b>
     * </p>
     *
     * @param listThesauriRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.ListThesauri
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/ListThesauri" target="_top">AWS API
     *      Documentation</a>
     */
    default ListThesauriPublisher listThesauriPaginator(ListThesauriRequest listThesauriRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the thesauri for an index.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listThesauri(software.amazon.awssdk.services.kendra.model.ListThesauriRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kendra.paginators.ListThesauriPublisher publisher = client.listThesauriPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kendra.paginators.ListThesauriPublisher publisher = client.listThesauriPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.kendra.model.ListThesauriResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.kendra.model.ListThesauriResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listThesauri(software.amazon.awssdk.services.kendra.model.ListThesauriRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListThesauriRequest.Builder} avoiding the need to
     * create one manually via {@link ListThesauriRequest#builder()}
     * </p>
     *
     * @param listThesauriRequest
     *        A {@link Consumer} that will call methods on {@link ListThesauriRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.ListThesauri
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/ListThesauri" target="_top">AWS API
     *      Documentation</a>
     */
    default ListThesauriPublisher listThesauriPaginator(Consumer<ListThesauriRequest.Builder> listThesauriRequest) {
        return listThesauriPaginator(ListThesauriRequest.builder().applyMutation(listThesauriRequest).build());
    }

    /**
     * <p>
     * Maps users to their groups so that you only need to provide the user ID when you issue the query.
     * </p>
     * <p>
     * You can also map sub groups to groups. For example, the group "Company Intellectual Property Teams" includes sub
     * groups "Research" and "Engineering". These sub groups include their own list of users or people who work in these
     * teams. Only users who work in research and engineering, and therefore belong in the intellectual property group,
     * can see top-secret company documents in their search results.
     * </p>
     * <p>
     * This is useful for user context filtering, where search results are filtered based on the user or their group
     * access to documents. For more information, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/user-context-filter.html">Filtering on user context</a>.
     * </p>
     * <p>
     * If more than five <code>PUT</code> actions for a group are currently processing, a validation exception is
     * thrown.
     * </p>
     * <p>
     * <code>PutPrincipalMapping</code> is currently not supported in the Amazon Web Services GovCloud (US-West) region.
     * </p>
     *
     * @param putPrincipalMappingRequest
     * @return A Java Future containing the result of the PutPrincipalMapping operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ConflictException A conflict occurred with the request. Please fix any inconsistences with your
     *         resources and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>ServiceQuotaExceededException You have exceeded the set limits for your Amazon Kendra service. Please
     *         see Quotas[hyperlink Kendra Quotas pg] for more information, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> to inquire about an increase of
     *         limits.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.PutPrincipalMapping
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/PutPrincipalMapping" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<PutPrincipalMappingResponse> putPrincipalMapping(
            PutPrincipalMappingRequest putPrincipalMappingRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Maps users to their groups so that you only need to provide the user ID when you issue the query.
     * </p>
     * <p>
     * You can also map sub groups to groups. For example, the group "Company Intellectual Property Teams" includes sub
     * groups "Research" and "Engineering". These sub groups include their own list of users or people who work in these
     * teams. Only users who work in research and engineering, and therefore belong in the intellectual property group,
     * can see top-secret company documents in their search results.
     * </p>
     * <p>
     * This is useful for user context filtering, where search results are filtered based on the user or their group
     * access to documents. For more information, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/user-context-filter.html">Filtering on user context</a>.
     * </p>
     * <p>
     * If more than five <code>PUT</code> actions for a group are currently processing, a validation exception is
     * thrown.
     * </p>
     * <p>
     * <code>PutPrincipalMapping</code> is currently not supported in the Amazon Web Services GovCloud (US-West) region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutPrincipalMappingRequest.Builder} avoiding the
     * need to create one manually via {@link PutPrincipalMappingRequest#builder()}
     * </p>
     *
     * @param putPrincipalMappingRequest
     *        A {@link Consumer} that will call methods on {@link PutPrincipalMappingRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the PutPrincipalMapping operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ConflictException A conflict occurred with the request. Please fix any inconsistences with your
     *         resources and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>ServiceQuotaExceededException You have exceeded the set limits for your Amazon Kendra service. Please
     *         see Quotas[hyperlink Kendra Quotas pg] for more information, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> to inquire about an increase of
     *         limits.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.PutPrincipalMapping
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/PutPrincipalMapping" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<PutPrincipalMappingResponse> putPrincipalMapping(
            Consumer<PutPrincipalMappingRequest.Builder> putPrincipalMappingRequest) {
        return putPrincipalMapping(PutPrincipalMappingRequest.builder().applyMutation(putPrincipalMappingRequest).build());
    }

    /**
     * <p>
     * Searches an active index. Use this API to search your documents using query. The <code>Query</code> API enables
     * to do faceted search and to filter results based on document attributes.
     * </p>
     * <p>
     * It also enables you to provide user context that Amazon Kendra uses to enforce document access control in the
     * search results.
     * </p>
     * <p>
     * Amazon Kendra searches your index for text content and question and answer (FAQ) content. By default the response
     * contains three types of results.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Relevant passages
     * </p>
     * </li>
     * <li>
     * <p>
     * Matching FAQs
     * </p>
     * </li>
     * <li>
     * <p>
     * Relevant documents
     * </p>
     * </li>
     * </ul>
     * <p>
     * You can specify that the query return only one type of result using the <code>QueryResultTypeFilter</code>
     * parameter.
     * </p>
     * <p>
     * Each query returns the 100 most relevant results.
     * </p>
     *
     * @param queryRequest
     * @return A Java Future containing the result of the Query operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ConflictException A conflict occurred with the request. Please fix any inconsistences with your
     *         resources and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>ServiceQuotaExceededException You have exceeded the set limits for your Amazon Kendra service. Please
     *         see Quotas[hyperlink Kendra Quotas pg] for more information, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> to inquire about an increase of
     *         limits.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.Query
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/Query" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<QueryResponse> query(QueryRequest queryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Searches an active index. Use this API to search your documents using query. The <code>Query</code> API enables
     * to do faceted search and to filter results based on document attributes.
     * </p>
     * <p>
     * It also enables you to provide user context that Amazon Kendra uses to enforce document access control in the
     * search results.
     * </p>
     * <p>
     * Amazon Kendra searches your index for text content and question and answer (FAQ) content. By default the response
     * contains three types of results.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Relevant passages
     * </p>
     * </li>
     * <li>
     * <p>
     * Matching FAQs
     * </p>
     * </li>
     * <li>
     * <p>
     * Relevant documents
     * </p>
     * </li>
     * </ul>
     * <p>
     * You can specify that the query return only one type of result using the <code>QueryResultTypeFilter</code>
     * parameter.
     * </p>
     * <p>
     * Each query returns the 100 most relevant results.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link QueryRequest.Builder} avoiding the need to create
     * one manually via {@link QueryRequest#builder()}
     * </p>
     *
     * @param queryRequest
     *        A {@link Consumer} that will call methods on {@link QueryRequest.Builder} to create a request.
     * @return A Java Future containing the result of the Query operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ConflictException A conflict occurred with the request. Please fix any inconsistences with your
     *         resources and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>ServiceQuotaExceededException You have exceeded the set limits for your Amazon Kendra service. Please
     *         see Quotas[hyperlink Kendra Quotas pg] for more information, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> to inquire about an increase of
     *         limits.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.Query
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/Query" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<QueryResponse> query(Consumer<QueryRequest.Builder> queryRequest) {
        return query(QueryRequest.builder().applyMutation(queryRequest).build());
    }

    /**
     * <p>
     * Starts a synchronization job for a data source connector. If a synchronization job is already in progress, Amazon
     * Kendra returns a <code>ResourceInUseException</code> exception.
     * </p>
     *
     * @param startDataSourceSyncJobRequest
     * @return A Java Future containing the result of the StartDataSourceSyncJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>ResourceInUseException The resource you want to use is currently in use. Please check you have
     *         provided the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>ConflictException A conflict occurred with the request. Please fix any inconsistences with your
     *         resources and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.StartDataSourceSyncJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/StartDataSourceSyncJob" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<StartDataSourceSyncJobResponse> startDataSourceSyncJob(
            StartDataSourceSyncJobRequest startDataSourceSyncJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts a synchronization job for a data source connector. If a synchronization job is already in progress, Amazon
     * Kendra returns a <code>ResourceInUseException</code> exception.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartDataSourceSyncJobRequest.Builder} avoiding the
     * need to create one manually via {@link StartDataSourceSyncJobRequest#builder()}
     * </p>
     *
     * @param startDataSourceSyncJobRequest
     *        A {@link Consumer} that will call methods on {@link StartDataSourceSyncJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the StartDataSourceSyncJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>ResourceInUseException The resource you want to use is currently in use. Please check you have
     *         provided the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>ConflictException A conflict occurred with the request. Please fix any inconsistences with your
     *         resources and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.StartDataSourceSyncJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/StartDataSourceSyncJob" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<StartDataSourceSyncJobResponse> startDataSourceSyncJob(
            Consumer<StartDataSourceSyncJobRequest.Builder> startDataSourceSyncJobRequest) {
        return startDataSourceSyncJob(StartDataSourceSyncJobRequest.builder().applyMutation(startDataSourceSyncJobRequest)
                .build());
    }

    /**
     * <p>
     * Stops a synchronization job that is currently running. You can't stop a scheduled synchronization job.
     * </p>
     *
     * @param stopDataSourceSyncJobRequest
     * @return A Java Future containing the result of the StopDataSourceSyncJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.StopDataSourceSyncJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/StopDataSourceSyncJob" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<StopDataSourceSyncJobResponse> stopDataSourceSyncJob(
            StopDataSourceSyncJobRequest stopDataSourceSyncJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops a synchronization job that is currently running. You can't stop a scheduled synchronization job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopDataSourceSyncJobRequest.Builder} avoiding the
     * need to create one manually via {@link StopDataSourceSyncJobRequest#builder()}
     * </p>
     *
     * @param stopDataSourceSyncJobRequest
     *        A {@link Consumer} that will call methods on {@link StopDataSourceSyncJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the StopDataSourceSyncJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.StopDataSourceSyncJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/StopDataSourceSyncJob" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<StopDataSourceSyncJobResponse> stopDataSourceSyncJob(
            Consumer<StopDataSourceSyncJobRequest.Builder> stopDataSourceSyncJobRequest) {
        return stopDataSourceSyncJob(StopDataSourceSyncJobRequest.builder().applyMutation(stopDataSourceSyncJobRequest).build());
    }

    /**
     * <p>
     * Enables you to provide feedback to Amazon Kendra to improve the performance of your index.
     * </p>
     * <p>
     * <code>SubmitFeedback</code> is currently not supported in the Amazon Web Services GovCloud (US-West) region.
     * </p>
     *
     * @param submitFeedbackRequest
     * @return A Java Future containing the result of the SubmitFeedback operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ResourceUnavailableException The resource you want to use isn't available. Please check you have
     *         provided the correct resource and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.SubmitFeedback
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/SubmitFeedback" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<SubmitFeedbackResponse> submitFeedback(SubmitFeedbackRequest submitFeedbackRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables you to provide feedback to Amazon Kendra to improve the performance of your index.
     * </p>
     * <p>
     * <code>SubmitFeedback</code> is currently not supported in the Amazon Web Services GovCloud (US-West) region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SubmitFeedbackRequest.Builder} avoiding the need to
     * create one manually via {@link SubmitFeedbackRequest#builder()}
     * </p>
     *
     * @param submitFeedbackRequest
     *        A {@link Consumer} that will call methods on {@link SubmitFeedbackRequest.Builder} to create a request.
     * @return A Java Future containing the result of the SubmitFeedback operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ResourceUnavailableException The resource you want to use isn't available. Please check you have
     *         provided the correct resource and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.SubmitFeedback
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/SubmitFeedback" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<SubmitFeedbackResponse> submitFeedback(Consumer<SubmitFeedbackRequest.Builder> submitFeedbackRequest) {
        return submitFeedback(SubmitFeedbackRequest.builder().applyMutation(submitFeedbackRequest).build());
    }

    /**
     * <p>
     * Adds the specified tag to the specified index, FAQ, or data source resource. If the tag already exists, the
     * existing value is replaced with the new value.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ResourceUnavailableException The resource you want to use isn't available. Please check you have
     *         provided the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds the specified tag to the specified index, FAQ, or data source resource. If the tag already exists, the
     * existing value is replaced with the new value.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ResourceUnavailableException The resource you want to use isn't available. Please check you have
     *         provided the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes a tag from an index, FAQ, or a data source.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ResourceUnavailableException The resource you want to use isn't available. Please check you have
     *         provided the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a tag from an index, FAQ, or a data source.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ResourceUnavailableException The resource you want to use isn't available. Please check you have
     *         provided the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates an access control configuration for your documents in an index. This includes user and group access
     * information for your documents. This is useful for user context filtering, where search results are filtered
     * based on the user or their group access to documents.
     * </p>
     * <p>
     * You can update an access control configuration you created without indexing all of your documents again. For
     * example, your index contains top-secret company documents that only certain employees or users should access. You
     * created an 'allow' access control configuration for one user who recently joined the 'top-secret' team, switching
     * from a team with 'deny' access to top-secret documents. However, the user suddenly returns to their previous team
     * and should no longer have access to top secret documents. You can update the access control configuration to
     * re-configure access control for your documents as circumstances change.
     * </p>
     * <p>
     * You call the <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/API_BatchPutDocument.html">BatchPutDocument</a> API to apply
     * the updated access control configuration, with the <code>AccessControlConfigurationId</code> included in the <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/API_Document.html">Document</a> object. If you use an S3
     * bucket as a data source, you synchronize your data source to apply the <code>AccessControlConfigurationId</code>
     * in the <code>.metadata.json</code> file. Amazon Kendra currently only supports access control configuration for
     * S3 data sources and documents indexed using the <code>BatchPutDocument</code> API.
     * </p>
     *
     * @param updateAccessControlConfigurationRequest
     * @return A Java Future containing the result of the UpdateAccessControlConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>ConflictException A conflict occurred with the request. Please fix any inconsistences with your
     *         resources and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>ServiceQuotaExceededException You have exceeded the set limits for your Amazon Kendra service. Please
     *         see Quotas[hyperlink Kendra Quotas pg] for more information, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> to inquire about an increase of
     *         limits.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.UpdateAccessControlConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/UpdateAccessControlConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateAccessControlConfigurationResponse> updateAccessControlConfiguration(
            UpdateAccessControlConfigurationRequest updateAccessControlConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an access control configuration for your documents in an index. This includes user and group access
     * information for your documents. This is useful for user context filtering, where search results are filtered
     * based on the user or their group access to documents.
     * </p>
     * <p>
     * You can update an access control configuration you created without indexing all of your documents again. For
     * example, your index contains top-secret company documents that only certain employees or users should access. You
     * created an 'allow' access control configuration for one user who recently joined the 'top-secret' team, switching
     * from a team with 'deny' access to top-secret documents. However, the user suddenly returns to their previous team
     * and should no longer have access to top secret documents. You can update the access control configuration to
     * re-configure access control for your documents as circumstances change.
     * </p>
     * <p>
     * You call the <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/API_BatchPutDocument.html">BatchPutDocument</a> API to apply
     * the updated access control configuration, with the <code>AccessControlConfigurationId</code> included in the <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/API_Document.html">Document</a> object. If you use an S3
     * bucket as a data source, you synchronize your data source to apply the <code>AccessControlConfigurationId</code>
     * in the <code>.metadata.json</code> file. Amazon Kendra currently only supports access control configuration for
     * S3 data sources and documents indexed using the <code>BatchPutDocument</code> API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateAccessControlConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateAccessControlConfigurationRequest#builder()}
     * </p>
     *
     * @param updateAccessControlConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link UpdateAccessControlConfigurationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the UpdateAccessControlConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>ConflictException A conflict occurred with the request. Please fix any inconsistences with your
     *         resources and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>ServiceQuotaExceededException You have exceeded the set limits for your Amazon Kendra service. Please
     *         see Quotas[hyperlink Kendra Quotas pg] for more information, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> to inquire about an increase of
     *         limits.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.UpdateAccessControlConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/UpdateAccessControlConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateAccessControlConfigurationResponse> updateAccessControlConfiguration(
            Consumer<UpdateAccessControlConfigurationRequest.Builder> updateAccessControlConfigurationRequest) {
        return updateAccessControlConfiguration(UpdateAccessControlConfigurationRequest.builder()
                .applyMutation(updateAccessControlConfigurationRequest).build());
    }

    /**
     * <p>
     * Updates an existing Amazon Kendra data source connector.
     * </p>
     *
     * @param updateDataSourceRequest
     * @return A Java Future containing the result of the UpdateDataSource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ConflictException A conflict occurred with the request. Please fix any inconsistences with your
     *         resources and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.UpdateDataSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/UpdateDataSource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateDataSourceResponse> updateDataSource(UpdateDataSourceRequest updateDataSourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing Amazon Kendra data source connector.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDataSourceRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateDataSourceRequest#builder()}
     * </p>
     *
     * @param updateDataSourceRequest
     *        A {@link Consumer} that will call methods on {@link UpdateDataSourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateDataSource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ConflictException A conflict occurred with the request. Please fix any inconsistences with your
     *         resources and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.UpdateDataSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/UpdateDataSource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateDataSourceResponse> updateDataSource(
            Consumer<UpdateDataSourceRequest.Builder> updateDataSourceRequest) {
        return updateDataSource(UpdateDataSourceRequest.builder().applyMutation(updateDataSourceRequest).build());
    }

    /**
     * <p>
     * Updates your Amazon Kendra experience such as a search application. For more information on creating a search
     * application experience, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html">Building a search
     * experience with no code</a>.
     * </p>
     *
     * @param updateExperienceRequest
     * @return A Java Future containing the result of the UpdateExperience operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ConflictException A conflict occurred with the request. Please fix any inconsistences with your
     *         resources and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.UpdateExperience
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/UpdateExperience" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateExperienceResponse> updateExperience(UpdateExperienceRequest updateExperienceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates your Amazon Kendra experience such as a search application. For more information on creating a search
     * application experience, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html">Building a search
     * experience with no code</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateExperienceRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateExperienceRequest#builder()}
     * </p>
     *
     * @param updateExperienceRequest
     *        A {@link Consumer} that will call methods on {@link UpdateExperienceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateExperience operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ConflictException A conflict occurred with the request. Please fix any inconsistences with your
     *         resources and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.UpdateExperience
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/UpdateExperience" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateExperienceResponse> updateExperience(
            Consumer<UpdateExperienceRequest.Builder> updateExperienceRequest) {
        return updateExperience(UpdateExperienceRequest.builder().applyMutation(updateExperienceRequest).build());
    }

    /**
     * <p>
     * Updates an existing Amazon Kendra index.
     * </p>
     *
     * @param updateIndexRequest
     * @return A Java Future containing the result of the UpdateIndex operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ConflictException A conflict occurred with the request. Please fix any inconsistences with your
     *         resources and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>ServiceQuotaExceededException You have exceeded the set limits for your Amazon Kendra service. Please
     *         see Quotas[hyperlink Kendra Quotas pg] for more information, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> to inquire about an increase of
     *         limits.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.UpdateIndex
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/UpdateIndex" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateIndexResponse> updateIndex(UpdateIndexRequest updateIndexRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing Amazon Kendra index.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateIndexRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateIndexRequest#builder()}
     * </p>
     *
     * @param updateIndexRequest
     *        A {@link Consumer} that will call methods on {@link UpdateIndexRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateIndex operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ConflictException A conflict occurred with the request. Please fix any inconsistences with your
     *         resources and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>ServiceQuotaExceededException You have exceeded the set limits for your Amazon Kendra service. Please
     *         see Quotas[hyperlink Kendra Quotas pg] for more information, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> to inquire about an increase of
     *         limits.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.UpdateIndex
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/UpdateIndex" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateIndexResponse> updateIndex(Consumer<UpdateIndexRequest.Builder> updateIndexRequest) {
        return updateIndex(UpdateIndexRequest.builder().applyMutation(updateIndexRequest).build());
    }

    /**
     * <p>
     * Updates a block list used for query suggestions for an index.
     * </p>
     * <p>
     * Updates to a block list might not take effect right away. Amazon Kendra needs to refresh the entire suggestions
     * list to apply any updates to the block list. Other changes not related to the block list apply immediately.
     * </p>
     * <p>
     * If a block list is updating, then you need to wait for the first update to finish before submitting another
     * update.
     * </p>
     * <p>
     * Amazon Kendra supports partial updates, so you only need to provide the fields you want to update.
     * </p>
     * <p>
     * <code>UpdateQuerySuggestionsBlockList</code> is currently not supported in the Amazon Web Services GovCloud
     * (US-West) region.
     * </p>
     *
     * @param updateQuerySuggestionsBlockListRequest
     * @return A Java Future containing the result of the UpdateQuerySuggestionsBlockList operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>ConflictException A conflict occurred with the request. Please fix any inconsistences with your
     *         resources and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.UpdateQuerySuggestionsBlockList
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/UpdateQuerySuggestionsBlockList"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateQuerySuggestionsBlockListResponse> updateQuerySuggestionsBlockList(
            UpdateQuerySuggestionsBlockListRequest updateQuerySuggestionsBlockListRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a block list used for query suggestions for an index.
     * </p>
     * <p>
     * Updates to a block list might not take effect right away. Amazon Kendra needs to refresh the entire suggestions
     * list to apply any updates to the block list. Other changes not related to the block list apply immediately.
     * </p>
     * <p>
     * If a block list is updating, then you need to wait for the first update to finish before submitting another
     * update.
     * </p>
     * <p>
     * Amazon Kendra supports partial updates, so you only need to provide the fields you want to update.
     * </p>
     * <p>
     * <code>UpdateQuerySuggestionsBlockList</code> is currently not supported in the Amazon Web Services GovCloud
     * (US-West) region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateQuerySuggestionsBlockListRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateQuerySuggestionsBlockListRequest#builder()}
     * </p>
     *
     * @param updateQuerySuggestionsBlockListRequest
     *        A {@link Consumer} that will call methods on {@link UpdateQuerySuggestionsBlockListRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the UpdateQuerySuggestionsBlockList operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>ConflictException A conflict occurred with the request. Please fix any inconsistences with your
     *         resources and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.UpdateQuerySuggestionsBlockList
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/UpdateQuerySuggestionsBlockList"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateQuerySuggestionsBlockListResponse> updateQuerySuggestionsBlockList(
            Consumer<UpdateQuerySuggestionsBlockListRequest.Builder> updateQuerySuggestionsBlockListRequest) {
        return updateQuerySuggestionsBlockList(UpdateQuerySuggestionsBlockListRequest.builder()
                .applyMutation(updateQuerySuggestionsBlockListRequest).build());
    }

    /**
     * <p>
     * Updates the settings of query suggestions for an index.
     * </p>
     * <p>
     * Amazon Kendra supports partial updates, so you only need to provide the fields you want to update.
     * </p>
     * <p>
     * If an update is currently processing (i.e. 'happening'), you need to wait for the update to finish before making
     * another update.
     * </p>
     * <p>
     * Updates to query suggestions settings might not take effect right away. The time for your updated settings to
     * take effect depends on the updates made and the number of search queries in your index.
     * </p>
     * <p>
     * You can still enable/disable query suggestions at any time.
     * </p>
     * <p>
     * <code>UpdateQuerySuggestionsConfig</code> is currently not supported in the Amazon Web Services GovCloud
     * (US-West) region.
     * </p>
     *
     * @param updateQuerySuggestionsConfigRequest
     * @return A Java Future containing the result of the UpdateQuerySuggestionsConfig operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ConflictException A conflict occurred with the request. Please fix any inconsistences with your
     *         resources and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.UpdateQuerySuggestionsConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/UpdateQuerySuggestionsConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateQuerySuggestionsConfigResponse> updateQuerySuggestionsConfig(
            UpdateQuerySuggestionsConfigRequest updateQuerySuggestionsConfigRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the settings of query suggestions for an index.
     * </p>
     * <p>
     * Amazon Kendra supports partial updates, so you only need to provide the fields you want to update.
     * </p>
     * <p>
     * If an update is currently processing (i.e. 'happening'), you need to wait for the update to finish before making
     * another update.
     * </p>
     * <p>
     * Updates to query suggestions settings might not take effect right away. The time for your updated settings to
     * take effect depends on the updates made and the number of search queries in your index.
     * </p>
     * <p>
     * You can still enable/disable query suggestions at any time.
     * </p>
     * <p>
     * <code>UpdateQuerySuggestionsConfig</code> is currently not supported in the Amazon Web Services GovCloud
     * (US-West) region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateQuerySuggestionsConfigRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateQuerySuggestionsConfigRequest#builder()}
     * </p>
     *
     * @param updateQuerySuggestionsConfigRequest
     *        A {@link Consumer} that will call methods on {@link UpdateQuerySuggestionsConfigRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the UpdateQuerySuggestionsConfig operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ConflictException A conflict occurred with the request. Please fix any inconsistences with your
     *         resources and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.UpdateQuerySuggestionsConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/UpdateQuerySuggestionsConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateQuerySuggestionsConfigResponse> updateQuerySuggestionsConfig(
            Consumer<UpdateQuerySuggestionsConfigRequest.Builder> updateQuerySuggestionsConfigRequest) {
        return updateQuerySuggestionsConfig(UpdateQuerySuggestionsConfigRequest.builder()
                .applyMutation(updateQuerySuggestionsConfigRequest).build());
    }

    /**
     * <p>
     * Updates a thesaurus for an index.
     * </p>
     *
     * @param updateThesaurusRequest
     * @return A Java Future containing the result of the UpdateThesaurus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>ConflictException A conflict occurred with the request. Please fix any inconsistences with your
     *         resources and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.UpdateThesaurus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/UpdateThesaurus" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateThesaurusResponse> updateThesaurus(UpdateThesaurusRequest updateThesaurusRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a thesaurus for an index.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateThesaurusRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateThesaurusRequest#builder()}
     * </p>
     *
     * @param updateThesaurusRequest
     *        A {@link Consumer} that will call methods on {@link UpdateThesaurusRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateThesaurus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>ConflictException A conflict occurred with the request. Please fix any inconsistences with your
     *         resources and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/aws.amazon.com/contact-us"> Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.UpdateThesaurus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/UpdateThesaurus" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateThesaurusResponse> updateThesaurus(
            Consumer<UpdateThesaurusRequest.Builder> updateThesaurusRequest) {
        return updateThesaurus(UpdateThesaurusRequest.builder().applyMutation(updateThesaurusRequest).build());
    }

    @Override
    KendraServiceClientConfiguration serviceClientConfiguration();

    /**
     * Create a {@link KendraAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static KendraAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link KendraAsyncClient}.
     */
    static KendraAsyncClientBuilder builder() {
        return new DefaultKendraAsyncClientBuilder();
    }
}
