/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeQuerySuggestionsConfigResponse extends KendraResponse implements
        ToCopyableBuilder<DescribeQuerySuggestionsConfigResponse.Builder, DescribeQuerySuggestionsConfigResponse> {
    private static final SdkField<String> MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Mode")
            .getter(getter(DescribeQuerySuggestionsConfigResponse::modeAsString)).setter(setter(Builder::mode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Mode").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(DescribeQuerySuggestionsConfigResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Integer> QUERY_LOG_LOOK_BACK_WINDOW_IN_DAYS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("QueryLogLookBackWindowInDays")
            .getter(getter(DescribeQuerySuggestionsConfigResponse::queryLogLookBackWindowInDays))
            .setter(setter(Builder::queryLogLookBackWindowInDays))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryLogLookBackWindowInDays")
                    .build()).build();

    private static final SdkField<Boolean> INCLUDE_QUERIES_WITHOUT_USER_INFORMATION_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IncludeQueriesWithoutUserInformation")
            .getter(getter(DescribeQuerySuggestionsConfigResponse::includeQueriesWithoutUserInformation))
            .setter(setter(Builder::includeQueriesWithoutUserInformation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("IncludeQueriesWithoutUserInformation").build()).build();

    private static final SdkField<Integer> MINIMUM_NUMBER_OF_QUERYING_USERS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("MinimumNumberOfQueryingUsers")
            .getter(getter(DescribeQuerySuggestionsConfigResponse::minimumNumberOfQueryingUsers))
            .setter(setter(Builder::minimumNumberOfQueryingUsers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinimumNumberOfQueryingUsers")
                    .build()).build();

    private static final SdkField<Integer> MINIMUM_QUERY_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MinimumQueryCount").getter(getter(DescribeQuerySuggestionsConfigResponse::minimumQueryCount))
            .setter(setter(Builder::minimumQueryCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinimumQueryCount").build()).build();

    private static final SdkField<Instant> LAST_SUGGESTIONS_BUILD_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT).memberName("LastSuggestionsBuildTime")
            .getter(getter(DescribeQuerySuggestionsConfigResponse::lastSuggestionsBuildTime))
            .setter(setter(Builder::lastSuggestionsBuildTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastSuggestionsBuildTime").build())
            .build();

    private static final SdkField<Instant> LAST_CLEAR_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastClearTime").getter(getter(DescribeQuerySuggestionsConfigResponse::lastClearTime))
            .setter(setter(Builder::lastClearTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastClearTime").build()).build();

    private static final SdkField<Integer> TOTAL_SUGGESTIONS_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("TotalSuggestionsCount").getter(getter(DescribeQuerySuggestionsConfigResponse::totalSuggestionsCount))
            .setter(setter(Builder::totalSuggestionsCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalSuggestionsCount").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODE_FIELD, STATUS_FIELD,
            QUERY_LOG_LOOK_BACK_WINDOW_IN_DAYS_FIELD, INCLUDE_QUERIES_WITHOUT_USER_INFORMATION_FIELD,
            MINIMUM_NUMBER_OF_QUERYING_USERS_FIELD, MINIMUM_QUERY_COUNT_FIELD, LAST_SUGGESTIONS_BUILD_TIME_FIELD,
            LAST_CLEAR_TIME_FIELD, TOTAL_SUGGESTIONS_COUNT_FIELD));

    private final String mode;

    private final String status;

    private final Integer queryLogLookBackWindowInDays;

    private final Boolean includeQueriesWithoutUserInformation;

    private final Integer minimumNumberOfQueryingUsers;

    private final Integer minimumQueryCount;

    private final Instant lastSuggestionsBuildTime;

    private final Instant lastClearTime;

    private final Integer totalSuggestionsCount;

    private DescribeQuerySuggestionsConfigResponse(BuilderImpl builder) {
        super(builder);
        this.mode = builder.mode;
        this.status = builder.status;
        this.queryLogLookBackWindowInDays = builder.queryLogLookBackWindowInDays;
        this.includeQueriesWithoutUserInformation = builder.includeQueriesWithoutUserInformation;
        this.minimumNumberOfQueryingUsers = builder.minimumNumberOfQueryingUsers;
        this.minimumQueryCount = builder.minimumQueryCount;
        this.lastSuggestionsBuildTime = builder.lastSuggestionsBuildTime;
        this.lastClearTime = builder.lastClearTime;
        this.totalSuggestionsCount = builder.totalSuggestionsCount;
    }

    /**
     * <p>
     * Whether query suggestions are currently in <code>ENABLED</code> mode or <code>LEARN_ONLY</code> mode.
     * </p>
     * <p>
     * By default, Amazon Kendra enables query suggestions.<code>LEARN_ONLY</code> turns off query suggestions for your
     * users. You can change the mode using the <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/API_UpdateQuerySuggestionsConfig.html"
     * >UpdateQuerySuggestionsConfig</a> API.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mode} will return
     * {@link Mode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #modeAsString}.
     * </p>
     * 
     * @return Whether query suggestions are currently in <code>ENABLED</code> mode or <code>LEARN_ONLY</code> mode.</p>
     *         <p>
     *         By default, Amazon Kendra enables query suggestions.<code>LEARN_ONLY</code> turns off query suggestions
     *         for your users. You can change the mode using the <a
     *         href="https://docs.aws.amazon.com/kendra/latest/dg/API_UpdateQuerySuggestionsConfig.html"
     *         >UpdateQuerySuggestionsConfig</a> API.
     * @see Mode
     */
    public final Mode mode() {
        return Mode.fromValue(mode);
    }

    /**
     * <p>
     * Whether query suggestions are currently in <code>ENABLED</code> mode or <code>LEARN_ONLY</code> mode.
     * </p>
     * <p>
     * By default, Amazon Kendra enables query suggestions.<code>LEARN_ONLY</code> turns off query suggestions for your
     * users. You can change the mode using the <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/API_UpdateQuerySuggestionsConfig.html"
     * >UpdateQuerySuggestionsConfig</a> API.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mode} will return
     * {@link Mode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #modeAsString}.
     * </p>
     * 
     * @return Whether query suggestions are currently in <code>ENABLED</code> mode or <code>LEARN_ONLY</code> mode.</p>
     *         <p>
     *         By default, Amazon Kendra enables query suggestions.<code>LEARN_ONLY</code> turns off query suggestions
     *         for your users. You can change the mode using the <a
     *         href="https://docs.aws.amazon.com/kendra/latest/dg/API_UpdateQuerySuggestionsConfig.html"
     *         >UpdateQuerySuggestionsConfig</a> API.
     * @see Mode
     */
    public final String modeAsString() {
        return mode;
    }

    /**
     * <p>
     * Whether the status of query suggestions settings is currently <code>ACTIVE</code> or <code>UPDATING</code>.
     * </p>
     * <p>
     * Active means the current settings apply and Updating means your changed settings are in the process of applying.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link QuerySuggestionsStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return Whether the status of query suggestions settings is currently <code>ACTIVE</code> or
     *         <code>UPDATING</code>.</p>
     *         <p>
     *         Active means the current settings apply and Updating means your changed settings are in the process of
     *         applying.
     * @see QuerySuggestionsStatus
     */
    public final QuerySuggestionsStatus status() {
        return QuerySuggestionsStatus.fromValue(status);
    }

    /**
     * <p>
     * Whether the status of query suggestions settings is currently <code>ACTIVE</code> or <code>UPDATING</code>.
     * </p>
     * <p>
     * Active means the current settings apply and Updating means your changed settings are in the process of applying.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link QuerySuggestionsStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return Whether the status of query suggestions settings is currently <code>ACTIVE</code> or
     *         <code>UPDATING</code>.</p>
     *         <p>
     *         Active means the current settings apply and Updating means your changed settings are in the process of
     *         applying.
     * @see QuerySuggestionsStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * How recent your queries are in your query log time window (in days).
     * </p>
     * 
     * @return How recent your queries are in your query log time window (in days).
     */
    public final Integer queryLogLookBackWindowInDays() {
        return queryLogLookBackWindowInDays;
    }

    /**
     * <p>
     * <code>TRUE</code> to use all queries, otherwise use only queries that include user information to generate the
     * query suggestions.
     * </p>
     * 
     * @return <code>TRUE</code> to use all queries, otherwise use only queries that include user information to
     *         generate the query suggestions.
     */
    public final Boolean includeQueriesWithoutUserInformation() {
        return includeQueriesWithoutUserInformation;
    }

    /**
     * <p>
     * The minimum number of unique users who must search a query in order for the query to be eligible to suggest to
     * your users.
     * </p>
     * 
     * @return The minimum number of unique users who must search a query in order for the query to be eligible to
     *         suggest to your users.
     */
    public final Integer minimumNumberOfQueryingUsers() {
        return minimumNumberOfQueryingUsers;
    }

    /**
     * <p>
     * The minimum number of times a query must be searched in order for the query to be eligible to suggest to your
     * users.
     * </p>
     * 
     * @return The minimum number of times a query must be searched in order for the query to be eligible to suggest to
     *         your users.
     */
    public final Integer minimumQueryCount() {
        return minimumQueryCount;
    }

    /**
     * <p>
     * The Unix timestamp when query suggestions for an index was last updated.
     * </p>
     * 
     * @return The Unix timestamp when query suggestions for an index was last updated.
     */
    public final Instant lastSuggestionsBuildTime() {
        return lastSuggestionsBuildTime;
    }

    /**
     * <p>
     * The Unix timestamp when query suggestions for an index was last cleared.
     * </p>
     * <p>
     * After you clear suggestions, Amazon Kendra learns new suggestions based on new queries added to the query log
     * from the time you cleared suggestions. Amazon Kendra only considers re-occurences of a query from the time you
     * cleared suggestions.
     * </p>
     * 
     * @return The Unix timestamp when query suggestions for an index was last cleared.</p>
     *         <p>
     *         After you clear suggestions, Amazon Kendra learns new suggestions based on new queries added to the query
     *         log from the time you cleared suggestions. Amazon Kendra only considers re-occurences of a query from the
     *         time you cleared suggestions.
     */
    public final Instant lastClearTime() {
        return lastClearTime;
    }

    /**
     * <p>
     * The current total count of query suggestions for an index.
     * </p>
     * <p>
     * This count can change when you update your query suggestions settings, if you filter out certain queries from
     * suggestions using a block list, and as the query log accumulates more queries for Amazon Kendra to learn from.
     * </p>
     * 
     * @return The current total count of query suggestions for an index.</p>
     *         <p>
     *         This count can change when you update your query suggestions settings, if you filter out certain queries
     *         from suggestions using a block list, and as the query log accumulates more queries for Amazon Kendra to
     *         learn from.
     */
    public final Integer totalSuggestionsCount() {
        return totalSuggestionsCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(modeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(queryLogLookBackWindowInDays());
        hashCode = 31 * hashCode + Objects.hashCode(includeQueriesWithoutUserInformation());
        hashCode = 31 * hashCode + Objects.hashCode(minimumNumberOfQueryingUsers());
        hashCode = 31 * hashCode + Objects.hashCode(minimumQueryCount());
        hashCode = 31 * hashCode + Objects.hashCode(lastSuggestionsBuildTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastClearTime());
        hashCode = 31 * hashCode + Objects.hashCode(totalSuggestionsCount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeQuerySuggestionsConfigResponse)) {
            return false;
        }
        DescribeQuerySuggestionsConfigResponse other = (DescribeQuerySuggestionsConfigResponse) obj;
        return Objects.equals(modeAsString(), other.modeAsString()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(queryLogLookBackWindowInDays(), other.queryLogLookBackWindowInDays())
                && Objects.equals(includeQueriesWithoutUserInformation(), other.includeQueriesWithoutUserInformation())
                && Objects.equals(minimumNumberOfQueryingUsers(), other.minimumNumberOfQueryingUsers())
                && Objects.equals(minimumQueryCount(), other.minimumQueryCount())
                && Objects.equals(lastSuggestionsBuildTime(), other.lastSuggestionsBuildTime())
                && Objects.equals(lastClearTime(), other.lastClearTime())
                && Objects.equals(totalSuggestionsCount(), other.totalSuggestionsCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeQuerySuggestionsConfigResponse").add("Mode", modeAsString())
                .add("Status", statusAsString()).add("QueryLogLookBackWindowInDays", queryLogLookBackWindowInDays())
                .add("IncludeQueriesWithoutUserInformation", includeQueriesWithoutUserInformation())
                .add("MinimumNumberOfQueryingUsers", minimumNumberOfQueryingUsers())
                .add("MinimumQueryCount", minimumQueryCount()).add("LastSuggestionsBuildTime", lastSuggestionsBuildTime())
                .add("LastClearTime", lastClearTime()).add("TotalSuggestionsCount", totalSuggestionsCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Mode":
            return Optional.ofNullable(clazz.cast(modeAsString()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "QueryLogLookBackWindowInDays":
            return Optional.ofNullable(clazz.cast(queryLogLookBackWindowInDays()));
        case "IncludeQueriesWithoutUserInformation":
            return Optional.ofNullable(clazz.cast(includeQueriesWithoutUserInformation()));
        case "MinimumNumberOfQueryingUsers":
            return Optional.ofNullable(clazz.cast(minimumNumberOfQueryingUsers()));
        case "MinimumQueryCount":
            return Optional.ofNullable(clazz.cast(minimumQueryCount()));
        case "LastSuggestionsBuildTime":
            return Optional.ofNullable(clazz.cast(lastSuggestionsBuildTime()));
        case "LastClearTime":
            return Optional.ofNullable(clazz.cast(lastClearTime()));
        case "TotalSuggestionsCount":
            return Optional.ofNullable(clazz.cast(totalSuggestionsCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeQuerySuggestionsConfigResponse, T> g) {
        return obj -> g.apply((DescribeQuerySuggestionsConfigResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KendraResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeQuerySuggestionsConfigResponse> {
        /**
         * <p>
         * Whether query suggestions are currently in <code>ENABLED</code> mode or <code>LEARN_ONLY</code> mode.
         * </p>
         * <p>
         * By default, Amazon Kendra enables query suggestions.<code>LEARN_ONLY</code> turns off query suggestions for
         * your users. You can change the mode using the <a
         * href="https://docs.aws.amazon.com/kendra/latest/dg/API_UpdateQuerySuggestionsConfig.html"
         * >UpdateQuerySuggestionsConfig</a> API.
         * </p>
         * 
         * @param mode
         *        Whether query suggestions are currently in <code>ENABLED</code> mode or <code>LEARN_ONLY</code>
         *        mode.</p>
         *        <p>
         *        By default, Amazon Kendra enables query suggestions.<code>LEARN_ONLY</code> turns off query
         *        suggestions for your users. You can change the mode using the <a
         *        href="https://docs.aws.amazon.com/kendra/latest/dg/API_UpdateQuerySuggestionsConfig.html"
         *        >UpdateQuerySuggestionsConfig</a> API.
         * @see Mode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Mode
         */
        Builder mode(String mode);

        /**
         * <p>
         * Whether query suggestions are currently in <code>ENABLED</code> mode or <code>LEARN_ONLY</code> mode.
         * </p>
         * <p>
         * By default, Amazon Kendra enables query suggestions.<code>LEARN_ONLY</code> turns off query suggestions for
         * your users. You can change the mode using the <a
         * href="https://docs.aws.amazon.com/kendra/latest/dg/API_UpdateQuerySuggestionsConfig.html"
         * >UpdateQuerySuggestionsConfig</a> API.
         * </p>
         * 
         * @param mode
         *        Whether query suggestions are currently in <code>ENABLED</code> mode or <code>LEARN_ONLY</code>
         *        mode.</p>
         *        <p>
         *        By default, Amazon Kendra enables query suggestions.<code>LEARN_ONLY</code> turns off query
         *        suggestions for your users. You can change the mode using the <a
         *        href="https://docs.aws.amazon.com/kendra/latest/dg/API_UpdateQuerySuggestionsConfig.html"
         *        >UpdateQuerySuggestionsConfig</a> API.
         * @see Mode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Mode
         */
        Builder mode(Mode mode);

        /**
         * <p>
         * Whether the status of query suggestions settings is currently <code>ACTIVE</code> or <code>UPDATING</code>.
         * </p>
         * <p>
         * Active means the current settings apply and Updating means your changed settings are in the process of
         * applying.
         * </p>
         * 
         * @param status
         *        Whether the status of query suggestions settings is currently <code>ACTIVE</code> or
         *        <code>UPDATING</code>.</p>
         *        <p>
         *        Active means the current settings apply and Updating means your changed settings are in the process of
         *        applying.
         * @see QuerySuggestionsStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QuerySuggestionsStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Whether the status of query suggestions settings is currently <code>ACTIVE</code> or <code>UPDATING</code>.
         * </p>
         * <p>
         * Active means the current settings apply and Updating means your changed settings are in the process of
         * applying.
         * </p>
         * 
         * @param status
         *        Whether the status of query suggestions settings is currently <code>ACTIVE</code> or
         *        <code>UPDATING</code>.</p>
         *        <p>
         *        Active means the current settings apply and Updating means your changed settings are in the process of
         *        applying.
         * @see QuerySuggestionsStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QuerySuggestionsStatus
         */
        Builder status(QuerySuggestionsStatus status);

        /**
         * <p>
         * How recent your queries are in your query log time window (in days).
         * </p>
         * 
         * @param queryLogLookBackWindowInDays
         *        How recent your queries are in your query log time window (in days).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryLogLookBackWindowInDays(Integer queryLogLookBackWindowInDays);

        /**
         * <p>
         * <code>TRUE</code> to use all queries, otherwise use only queries that include user information to generate
         * the query suggestions.
         * </p>
         * 
         * @param includeQueriesWithoutUserInformation
         *        <code>TRUE</code> to use all queries, otherwise use only queries that include user information to
         *        generate the query suggestions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeQueriesWithoutUserInformation(Boolean includeQueriesWithoutUserInformation);

        /**
         * <p>
         * The minimum number of unique users who must search a query in order for the query to be eligible to suggest
         * to your users.
         * </p>
         * 
         * @param minimumNumberOfQueryingUsers
         *        The minimum number of unique users who must search a query in order for the query to be eligible to
         *        suggest to your users.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minimumNumberOfQueryingUsers(Integer minimumNumberOfQueryingUsers);

        /**
         * <p>
         * The minimum number of times a query must be searched in order for the query to be eligible to suggest to your
         * users.
         * </p>
         * 
         * @param minimumQueryCount
         *        The minimum number of times a query must be searched in order for the query to be eligible to suggest
         *        to your users.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minimumQueryCount(Integer minimumQueryCount);

        /**
         * <p>
         * The Unix timestamp when query suggestions for an index was last updated.
         * </p>
         * 
         * @param lastSuggestionsBuildTime
         *        The Unix timestamp when query suggestions for an index was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastSuggestionsBuildTime(Instant lastSuggestionsBuildTime);

        /**
         * <p>
         * The Unix timestamp when query suggestions for an index was last cleared.
         * </p>
         * <p>
         * After you clear suggestions, Amazon Kendra learns new suggestions based on new queries added to the query log
         * from the time you cleared suggestions. Amazon Kendra only considers re-occurences of a query from the time
         * you cleared suggestions.
         * </p>
         * 
         * @param lastClearTime
         *        The Unix timestamp when query suggestions for an index was last cleared.</p>
         *        <p>
         *        After you clear suggestions, Amazon Kendra learns new suggestions based on new queries added to the
         *        query log from the time you cleared suggestions. Amazon Kendra only considers re-occurences of a query
         *        from the time you cleared suggestions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastClearTime(Instant lastClearTime);

        /**
         * <p>
         * The current total count of query suggestions for an index.
         * </p>
         * <p>
         * This count can change when you update your query suggestions settings, if you filter out certain queries from
         * suggestions using a block list, and as the query log accumulates more queries for Amazon Kendra to learn
         * from.
         * </p>
         * 
         * @param totalSuggestionsCount
         *        The current total count of query suggestions for an index.</p>
         *        <p>
         *        This count can change when you update your query suggestions settings, if you filter out certain
         *        queries from suggestions using a block list, and as the query log accumulates more queries for Amazon
         *        Kendra to learn from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalSuggestionsCount(Integer totalSuggestionsCount);
    }

    static final class BuilderImpl extends KendraResponse.BuilderImpl implements Builder {
        private String mode;

        private String status;

        private Integer queryLogLookBackWindowInDays;

        private Boolean includeQueriesWithoutUserInformation;

        private Integer minimumNumberOfQueryingUsers;

        private Integer minimumQueryCount;

        private Instant lastSuggestionsBuildTime;

        private Instant lastClearTime;

        private Integer totalSuggestionsCount;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeQuerySuggestionsConfigResponse model) {
            super(model);
            mode(model.mode);
            status(model.status);
            queryLogLookBackWindowInDays(model.queryLogLookBackWindowInDays);
            includeQueriesWithoutUserInformation(model.includeQueriesWithoutUserInformation);
            minimumNumberOfQueryingUsers(model.minimumNumberOfQueryingUsers);
            minimumQueryCount(model.minimumQueryCount);
            lastSuggestionsBuildTime(model.lastSuggestionsBuildTime);
            lastClearTime(model.lastClearTime);
            totalSuggestionsCount(model.totalSuggestionsCount);
        }

        public final String getMode() {
            return mode;
        }

        public final void setMode(String mode) {
            this.mode = mode;
        }

        @Override
        public final Builder mode(String mode) {
            this.mode = mode;
            return this;
        }

        @Override
        public final Builder mode(Mode mode) {
            this.mode(mode == null ? null : mode.toString());
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(QuerySuggestionsStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Integer getQueryLogLookBackWindowInDays() {
            return queryLogLookBackWindowInDays;
        }

        public final void setQueryLogLookBackWindowInDays(Integer queryLogLookBackWindowInDays) {
            this.queryLogLookBackWindowInDays = queryLogLookBackWindowInDays;
        }

        @Override
        public final Builder queryLogLookBackWindowInDays(Integer queryLogLookBackWindowInDays) {
            this.queryLogLookBackWindowInDays = queryLogLookBackWindowInDays;
            return this;
        }

        public final Boolean getIncludeQueriesWithoutUserInformation() {
            return includeQueriesWithoutUserInformation;
        }

        public final void setIncludeQueriesWithoutUserInformation(Boolean includeQueriesWithoutUserInformation) {
            this.includeQueriesWithoutUserInformation = includeQueriesWithoutUserInformation;
        }

        @Override
        public final Builder includeQueriesWithoutUserInformation(Boolean includeQueriesWithoutUserInformation) {
            this.includeQueriesWithoutUserInformation = includeQueriesWithoutUserInformation;
            return this;
        }

        public final Integer getMinimumNumberOfQueryingUsers() {
            return minimumNumberOfQueryingUsers;
        }

        public final void setMinimumNumberOfQueryingUsers(Integer minimumNumberOfQueryingUsers) {
            this.minimumNumberOfQueryingUsers = minimumNumberOfQueryingUsers;
        }

        @Override
        public final Builder minimumNumberOfQueryingUsers(Integer minimumNumberOfQueryingUsers) {
            this.minimumNumberOfQueryingUsers = minimumNumberOfQueryingUsers;
            return this;
        }

        public final Integer getMinimumQueryCount() {
            return minimumQueryCount;
        }

        public final void setMinimumQueryCount(Integer minimumQueryCount) {
            this.minimumQueryCount = minimumQueryCount;
        }

        @Override
        public final Builder minimumQueryCount(Integer minimumQueryCount) {
            this.minimumQueryCount = minimumQueryCount;
            return this;
        }

        public final Instant getLastSuggestionsBuildTime() {
            return lastSuggestionsBuildTime;
        }

        public final void setLastSuggestionsBuildTime(Instant lastSuggestionsBuildTime) {
            this.lastSuggestionsBuildTime = lastSuggestionsBuildTime;
        }

        @Override
        public final Builder lastSuggestionsBuildTime(Instant lastSuggestionsBuildTime) {
            this.lastSuggestionsBuildTime = lastSuggestionsBuildTime;
            return this;
        }

        public final Instant getLastClearTime() {
            return lastClearTime;
        }

        public final void setLastClearTime(Instant lastClearTime) {
            this.lastClearTime = lastClearTime;
        }

        @Override
        public final Builder lastClearTime(Instant lastClearTime) {
            this.lastClearTime = lastClearTime;
            return this;
        }

        public final Integer getTotalSuggestionsCount() {
            return totalSuggestionsCount;
        }

        public final void setTotalSuggestionsCount(Integer totalSuggestionsCount) {
            this.totalSuggestionsCount = totalSuggestionsCount;
        }

        @Override
        public final Builder totalSuggestionsCount(Integer totalSuggestionsCount) {
            this.totalSuggestionsCount = totalSuggestionsCount;
            return this;
        }

        @Override
        public DescribeQuerySuggestionsConfigResponse build() {
            return new DescribeQuerySuggestionsConfigResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
