/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides the configuration information for the seed or starting point URLs to crawl.
 * </p>
 * <p>
 * <i>When selecting websites to index, you must adhere to the <a href="https://aws.amazon.com/aup/">Amazon Acceptable
 * Use Policy</a> and all other Amazon terms. Remember that you must only use Amazon Kendra Web Crawler to index your
 * own web pages, or web pages that you have authorization to index.</i>
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SeedUrlConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<SeedUrlConfiguration.Builder, SeedUrlConfiguration> {
    private static final SdkField<List<String>> SEED_URLS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SeedUrls")
            .getter(getter(SeedUrlConfiguration::seedUrls))
            .setter(setter(Builder::seedUrls))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SeedUrls").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> WEB_CRAWLER_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WebCrawlerMode").getter(getter(SeedUrlConfiguration::webCrawlerModeAsString))
            .setter(setter(Builder::webCrawlerMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WebCrawlerMode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SEED_URLS_FIELD,
            WEB_CRAWLER_MODE_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> seedUrls;

    private final String webCrawlerMode;

    private SeedUrlConfiguration(BuilderImpl builder) {
        this.seedUrls = builder.seedUrls;
        this.webCrawlerMode = builder.webCrawlerMode;
    }

    /**
     * For responses, this returns true if the service returned a value for the SeedUrls property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSeedUrls() {
        return seedUrls != null && !(seedUrls instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of seed or starting point URLs of the websites you want to crawl.
     * </p>
     * <p>
     * The list can include a maximum of 100 seed URLs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSeedUrls} method.
     * </p>
     * 
     * @return The list of seed or starting point URLs of the websites you want to crawl.</p>
     *         <p>
     *         The list can include a maximum of 100 seed URLs.
     */
    public final List<String> seedUrls() {
        return seedUrls;
    }

    /**
     * <p>
     * You can choose one of the following modes:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>HOST_ONLY</code> – crawl only the website host names. For example, if the seed URL is "abc.example.com",
     * then only URLs with host name "abc.example.com" are crawled.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SUBDOMAINS</code> – crawl the website host names with subdomains. For example, if the seed URL is
     * "abc.example.com", then "a.abc.example.com" and "b.abc.example.com" are also crawled.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>EVERYTHING</code> – crawl the website host names with subdomains and other domains that the web pages link
     * to.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The default mode is set to <code>HOST_ONLY</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #webCrawlerMode}
     * will return {@link WebCrawlerMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #webCrawlerModeAsString}.
     * </p>
     * 
     * @return You can choose one of the following modes:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>HOST_ONLY</code> – crawl only the website host names. For example, if the seed URL is
     *         "abc.example.com", then only URLs with host name "abc.example.com" are crawled.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SUBDOMAINS</code> – crawl the website host names with subdomains. For example, if the seed URL is
     *         "abc.example.com", then "a.abc.example.com" and "b.abc.example.com" are also crawled.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>EVERYTHING</code> – crawl the website host names with subdomains and other domains that the web
     *         pages link to.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         The default mode is set to <code>HOST_ONLY</code>.
     * @see WebCrawlerMode
     */
    public final WebCrawlerMode webCrawlerMode() {
        return WebCrawlerMode.fromValue(webCrawlerMode);
    }

    /**
     * <p>
     * You can choose one of the following modes:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>HOST_ONLY</code> – crawl only the website host names. For example, if the seed URL is "abc.example.com",
     * then only URLs with host name "abc.example.com" are crawled.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SUBDOMAINS</code> – crawl the website host names with subdomains. For example, if the seed URL is
     * "abc.example.com", then "a.abc.example.com" and "b.abc.example.com" are also crawled.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>EVERYTHING</code> – crawl the website host names with subdomains and other domains that the web pages link
     * to.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The default mode is set to <code>HOST_ONLY</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #webCrawlerMode}
     * will return {@link WebCrawlerMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #webCrawlerModeAsString}.
     * </p>
     * 
     * @return You can choose one of the following modes:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>HOST_ONLY</code> – crawl only the website host names. For example, if the seed URL is
     *         "abc.example.com", then only URLs with host name "abc.example.com" are crawled.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SUBDOMAINS</code> – crawl the website host names with subdomains. For example, if the seed URL is
     *         "abc.example.com", then "a.abc.example.com" and "b.abc.example.com" are also crawled.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>EVERYTHING</code> – crawl the website host names with subdomains and other domains that the web
     *         pages link to.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         The default mode is set to <code>HOST_ONLY</code>.
     * @see WebCrawlerMode
     */
    public final String webCrawlerModeAsString() {
        return webCrawlerMode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasSeedUrls() ? seedUrls() : null);
        hashCode = 31 * hashCode + Objects.hashCode(webCrawlerModeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SeedUrlConfiguration)) {
            return false;
        }
        SeedUrlConfiguration other = (SeedUrlConfiguration) obj;
        return hasSeedUrls() == other.hasSeedUrls() && Objects.equals(seedUrls(), other.seedUrls())
                && Objects.equals(webCrawlerModeAsString(), other.webCrawlerModeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SeedUrlConfiguration").add("SeedUrls", hasSeedUrls() ? seedUrls() : null)
                .add("WebCrawlerMode", webCrawlerModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SeedUrls":
            return Optional.ofNullable(clazz.cast(seedUrls()));
        case "WebCrawlerMode":
            return Optional.ofNullable(clazz.cast(webCrawlerModeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SeedUrlConfiguration, T> g) {
        return obj -> g.apply((SeedUrlConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SeedUrlConfiguration> {
        /**
         * <p>
         * The list of seed or starting point URLs of the websites you want to crawl.
         * </p>
         * <p>
         * The list can include a maximum of 100 seed URLs.
         * </p>
         * 
         * @param seedUrls
         *        The list of seed or starting point URLs of the websites you want to crawl.</p>
         *        <p>
         *        The list can include a maximum of 100 seed URLs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder seedUrls(Collection<String> seedUrls);

        /**
         * <p>
         * The list of seed or starting point URLs of the websites you want to crawl.
         * </p>
         * <p>
         * The list can include a maximum of 100 seed URLs.
         * </p>
         * 
         * @param seedUrls
         *        The list of seed or starting point URLs of the websites you want to crawl.</p>
         *        <p>
         *        The list can include a maximum of 100 seed URLs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder seedUrls(String... seedUrls);

        /**
         * <p>
         * You can choose one of the following modes:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>HOST_ONLY</code> – crawl only the website host names. For example, if the seed URL is
         * "abc.example.com", then only URLs with host name "abc.example.com" are crawled.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SUBDOMAINS</code> – crawl the website host names with subdomains. For example, if the seed URL is
         * "abc.example.com", then "a.abc.example.com" and "b.abc.example.com" are also crawled.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>EVERYTHING</code> – crawl the website host names with subdomains and other domains that the web pages
         * link to.
         * </p>
         * </li>
         * </ul>
         * <p>
         * The default mode is set to <code>HOST_ONLY</code>.
         * </p>
         * 
         * @param webCrawlerMode
         *        You can choose one of the following modes:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>HOST_ONLY</code> – crawl only the website host names. For example, if the seed URL is
         *        "abc.example.com", then only URLs with host name "abc.example.com" are crawled.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SUBDOMAINS</code> – crawl the website host names with subdomains. For example, if the seed URL
         *        is "abc.example.com", then "a.abc.example.com" and "b.abc.example.com" are also crawled.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>EVERYTHING</code> – crawl the website host names with subdomains and other domains that the web
         *        pages link to.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The default mode is set to <code>HOST_ONLY</code>.
         * @see WebCrawlerMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WebCrawlerMode
         */
        Builder webCrawlerMode(String webCrawlerMode);

        /**
         * <p>
         * You can choose one of the following modes:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>HOST_ONLY</code> – crawl only the website host names. For example, if the seed URL is
         * "abc.example.com", then only URLs with host name "abc.example.com" are crawled.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SUBDOMAINS</code> – crawl the website host names with subdomains. For example, if the seed URL is
         * "abc.example.com", then "a.abc.example.com" and "b.abc.example.com" are also crawled.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>EVERYTHING</code> – crawl the website host names with subdomains and other domains that the web pages
         * link to.
         * </p>
         * </li>
         * </ul>
         * <p>
         * The default mode is set to <code>HOST_ONLY</code>.
         * </p>
         * 
         * @param webCrawlerMode
         *        You can choose one of the following modes:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>HOST_ONLY</code> – crawl only the website host names. For example, if the seed URL is
         *        "abc.example.com", then only URLs with host name "abc.example.com" are crawled.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SUBDOMAINS</code> – crawl the website host names with subdomains. For example, if the seed URL
         *        is "abc.example.com", then "a.abc.example.com" and "b.abc.example.com" are also crawled.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>EVERYTHING</code> – crawl the website host names with subdomains and other domains that the web
         *        pages link to.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The default mode is set to <code>HOST_ONLY</code>.
         * @see WebCrawlerMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WebCrawlerMode
         */
        Builder webCrawlerMode(WebCrawlerMode webCrawlerMode);
    }

    static final class BuilderImpl implements Builder {
        private List<String> seedUrls = DefaultSdkAutoConstructList.getInstance();

        private String webCrawlerMode;

        private BuilderImpl() {
        }

        private BuilderImpl(SeedUrlConfiguration model) {
            seedUrls(model.seedUrls);
            webCrawlerMode(model.webCrawlerMode);
        }

        public final Collection<String> getSeedUrls() {
            if (seedUrls instanceof SdkAutoConstructList) {
                return null;
            }
            return seedUrls;
        }

        public final void setSeedUrls(Collection<String> seedUrls) {
            this.seedUrls = SeedUrlListCopier.copy(seedUrls);
        }

        @Override
        public final Builder seedUrls(Collection<String> seedUrls) {
            this.seedUrls = SeedUrlListCopier.copy(seedUrls);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder seedUrls(String... seedUrls) {
            seedUrls(Arrays.asList(seedUrls));
            return this;
        }

        public final String getWebCrawlerMode() {
            return webCrawlerMode;
        }

        public final void setWebCrawlerMode(String webCrawlerMode) {
            this.webCrawlerMode = webCrawlerMode;
        }

        @Override
        public final Builder webCrawlerMode(String webCrawlerMode) {
            this.webCrawlerMode = webCrawlerMode;
            return this;
        }

        @Override
        public final Builder webCrawlerMode(WebCrawlerMode webCrawlerMode) {
            this.webCrawlerMode(webCrawlerMode == null ? null : webCrawlerMode.toString());
            return this;
        }

        @Override
        public SeedUrlConfiguration build() {
            return new SeedUrlConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
