/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DatabaseEngineType {
    RDS_AURORA_MYSQL("RDS_AURORA_MYSQL"),
    RDS_AURORA_POSTGRESQL("RDS_AURORA_POSTGRESQL"),
    RDS_MYSQL("RDS_MYSQL"),
    RDS_POSTGRESQL("RDS_POSTGRESQL"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DatabaseEngineType> VALUE_MAP;
    private final String value;

    private DatabaseEngineType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DatabaseEngineType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DatabaseEngineType> knownValues() {
        EnumSet<DatabaseEngineType> knownValues = EnumSet.allOf(DatabaseEngineType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DatabaseEngineType.class, DatabaseEngineType::toString);
    }
}

