/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DisassociatePersonasFromEntitiesRequest extends KendraRequest implements
        ToCopyableBuilder<DisassociatePersonasFromEntitiesRequest.Builder, DisassociatePersonasFromEntitiesRequest> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(DisassociatePersonasFromEntitiesRequest::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> INDEX_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IndexId").getter(getter(DisassociatePersonasFromEntitiesRequest::indexId))
            .setter(setter(Builder::indexId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexId").build()).build();

    private static final SdkField<List<String>> ENTITY_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("EntityIds")
            .getter(getter(DisassociatePersonasFromEntitiesRequest::entityIds))
            .setter(setter(Builder::entityIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntityIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, INDEX_ID_FIELD,
            ENTITY_IDS_FIELD));

    private final String id;

    private final String indexId;

    private final List<String> entityIds;

    private DisassociatePersonasFromEntitiesRequest(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.indexId = builder.indexId;
        this.entityIds = builder.entityIds;
    }

    /**
     * <p>
     * The identifier of your Amazon Kendra experience.
     * </p>
     * 
     * @return The identifier of your Amazon Kendra experience.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The identifier of the index for your Amazon Kendra experience.
     * </p>
     * 
     * @return The identifier of the index for your Amazon Kendra experience.
     */
    public final String indexId() {
        return indexId;
    }

    /**
     * For responses, this returns true if the service returned a value for the EntityIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasEntityIds() {
        return entityIds != null && !(entityIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The identifiers of users or groups in your IAM Identity Center identity source. For example, user IDs could be
     * user emails.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEntityIds} method.
     * </p>
     * 
     * @return The identifiers of users or groups in your IAM Identity Center identity source. For example, user IDs
     *         could be user emails.
     */
    public final List<String> entityIds() {
        return entityIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(indexId());
        hashCode = 31 * hashCode + Objects.hashCode(hasEntityIds() ? entityIds() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisassociatePersonasFromEntitiesRequest)) {
            return false;
        }
        DisassociatePersonasFromEntitiesRequest other = (DisassociatePersonasFromEntitiesRequest) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(indexId(), other.indexId())
                && hasEntityIds() == other.hasEntityIds() && Objects.equals(entityIds(), other.entityIds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DisassociatePersonasFromEntitiesRequest").add("Id", id()).add("IndexId", indexId())
                .add("EntityIds", hasEntityIds() ? entityIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "IndexId":
            return Optional.ofNullable(clazz.cast(indexId()));
        case "EntityIds":
            return Optional.ofNullable(clazz.cast(entityIds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DisassociatePersonasFromEntitiesRequest, T> g) {
        return obj -> g.apply((DisassociatePersonasFromEntitiesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KendraRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DisassociatePersonasFromEntitiesRequest> {
        /**
         * <p>
         * The identifier of your Amazon Kendra experience.
         * </p>
         * 
         * @param id
         *        The identifier of your Amazon Kendra experience.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The identifier of the index for your Amazon Kendra experience.
         * </p>
         * 
         * @param indexId
         *        The identifier of the index for your Amazon Kendra experience.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexId(String indexId);

        /**
         * <p>
         * The identifiers of users or groups in your IAM Identity Center identity source. For example, user IDs could
         * be user emails.
         * </p>
         * 
         * @param entityIds
         *        The identifiers of users or groups in your IAM Identity Center identity source. For example, user IDs
         *        could be user emails.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityIds(Collection<String> entityIds);

        /**
         * <p>
         * The identifiers of users or groups in your IAM Identity Center identity source. For example, user IDs could
         * be user emails.
         * </p>
         * 
         * @param entityIds
         *        The identifiers of users or groups in your IAM Identity Center identity source. For example, user IDs
         *        could be user emails.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityIds(String... entityIds);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends KendraRequest.BuilderImpl implements Builder {
        private String id;

        private String indexId;

        private List<String> entityIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DisassociatePersonasFromEntitiesRequest model) {
            super(model);
            id(model.id);
            indexId(model.indexId);
            entityIds(model.entityIds);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getIndexId() {
            return indexId;
        }

        public final void setIndexId(String indexId) {
            this.indexId = indexId;
        }

        @Override
        public final Builder indexId(String indexId) {
            this.indexId = indexId;
            return this;
        }

        public final Collection<String> getEntityIds() {
            if (entityIds instanceof SdkAutoConstructList) {
                return null;
            }
            return entityIds;
        }

        public final void setEntityIds(Collection<String> entityIds) {
            this.entityIds = EntityIdsListCopier.copy(entityIds);
        }

        @Override
        public final Builder entityIds(Collection<String> entityIds) {
            this.entityIds = EntityIdsListCopier.copy(entityIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entityIds(String... entityIds) {
            entityIds(Arrays.asList(entityIds));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DisassociatePersonasFromEntitiesRequest build() {
            return new DisassociatePersonasFromEntitiesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
