/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListFeaturedResultsSetsResponse extends KendraResponse implements
        ToCopyableBuilder<ListFeaturedResultsSetsResponse.Builder, ListFeaturedResultsSetsResponse> {
    private static final SdkField<List<FeaturedResultsSetSummary>> FEATURED_RESULTS_SET_SUMMARY_ITEMS_FIELD = SdkField
            .<List<FeaturedResultsSetSummary>> builder(MarshallingType.LIST)
            .memberName("FeaturedResultsSetSummaryItems")
            .getter(getter(ListFeaturedResultsSetsResponse::featuredResultsSetSummaryItems))
            .setter(setter(Builder::featuredResultsSetSummaryItems))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeaturedResultsSetSummaryItems")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FeaturedResultsSetSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(FeaturedResultsSetSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListFeaturedResultsSetsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            FEATURED_RESULTS_SET_SUMMARY_ITEMS_FIELD, NEXT_TOKEN_FIELD));

    private final List<FeaturedResultsSetSummary> featuredResultsSetSummaryItems;

    private final String nextToken;

    private ListFeaturedResultsSetsResponse(BuilderImpl builder) {
        super(builder);
        this.featuredResultsSetSummaryItems = builder.featuredResultsSetSummaryItems;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the FeaturedResultsSetSummaryItems property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasFeaturedResultsSetSummaryItems() {
        return featuredResultsSetSummaryItems != null && !(featuredResultsSetSummaryItems instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of summary information for one or more featured results sets.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFeaturedResultsSetSummaryItems} method.
     * </p>
     * 
     * @return An array of summary information for one or more featured results sets.
     */
    public final List<FeaturedResultsSetSummary> featuredResultsSetSummaryItems() {
        return featuredResultsSetSummaryItems;
    }

    /**
     * <p>
     * If the response is truncated, Amazon Kendra returns a pagination token in the response.
     * </p>
     * 
     * @return If the response is truncated, Amazon Kendra returns a pagination token in the response.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode
                + Objects.hashCode(hasFeaturedResultsSetSummaryItems() ? featuredResultsSetSummaryItems() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFeaturedResultsSetsResponse)) {
            return false;
        }
        ListFeaturedResultsSetsResponse other = (ListFeaturedResultsSetsResponse) obj;
        return hasFeaturedResultsSetSummaryItems() == other.hasFeaturedResultsSetSummaryItems()
                && Objects.equals(featuredResultsSetSummaryItems(), other.featuredResultsSetSummaryItems())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("ListFeaturedResultsSetsResponse")
                .add("FeaturedResultsSetSummaryItems",
                        hasFeaturedResultsSetSummaryItems() ? featuredResultsSetSummaryItems() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FeaturedResultsSetSummaryItems":
            return Optional.ofNullable(clazz.cast(featuredResultsSetSummaryItems()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListFeaturedResultsSetsResponse, T> g) {
        return obj -> g.apply((ListFeaturedResultsSetsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KendraResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListFeaturedResultsSetsResponse> {
        /**
         * <p>
         * An array of summary information for one or more featured results sets.
         * </p>
         * 
         * @param featuredResultsSetSummaryItems
         *        An array of summary information for one or more featured results sets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder featuredResultsSetSummaryItems(Collection<FeaturedResultsSetSummary> featuredResultsSetSummaryItems);

        /**
         * <p>
         * An array of summary information for one or more featured results sets.
         * </p>
         * 
         * @param featuredResultsSetSummaryItems
         *        An array of summary information for one or more featured results sets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder featuredResultsSetSummaryItems(FeaturedResultsSetSummary... featuredResultsSetSummaryItems);

        /**
         * <p>
         * An array of summary information for one or more featured results sets.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.kendra.model.FeaturedResultsSetSummary.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.kendra.model.FeaturedResultsSetSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.kendra.model.FeaturedResultsSetSummary.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #featuredResultsSetSummaryItems(List<FeaturedResultsSetSummary>)}.
         * 
         * @param featuredResultsSetSummaryItems
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.kendra.model.FeaturedResultsSetSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #featuredResultsSetSummaryItems(java.util.Collection<FeaturedResultsSetSummary>)
         */
        Builder featuredResultsSetSummaryItems(Consumer<FeaturedResultsSetSummary.Builder>... featuredResultsSetSummaryItems);

        /**
         * <p>
         * If the response is truncated, Amazon Kendra returns a pagination token in the response.
         * </p>
         * 
         * @param nextToken
         *        If the response is truncated, Amazon Kendra returns a pagination token in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends KendraResponse.BuilderImpl implements Builder {
        private List<FeaturedResultsSetSummary> featuredResultsSetSummaryItems = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListFeaturedResultsSetsResponse model) {
            super(model);
            featuredResultsSetSummaryItems(model.featuredResultsSetSummaryItems);
            nextToken(model.nextToken);
        }

        public final List<FeaturedResultsSetSummary.Builder> getFeaturedResultsSetSummaryItems() {
            List<FeaturedResultsSetSummary.Builder> result = FeaturedResultsSetSummaryItemsCopier
                    .copyToBuilder(this.featuredResultsSetSummaryItems);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFeaturedResultsSetSummaryItems(
                Collection<FeaturedResultsSetSummary.BuilderImpl> featuredResultsSetSummaryItems) {
            this.featuredResultsSetSummaryItems = FeaturedResultsSetSummaryItemsCopier
                    .copyFromBuilder(featuredResultsSetSummaryItems);
        }

        @Override
        public final Builder featuredResultsSetSummaryItems(Collection<FeaturedResultsSetSummary> featuredResultsSetSummaryItems) {
            this.featuredResultsSetSummaryItems = FeaturedResultsSetSummaryItemsCopier.copy(featuredResultsSetSummaryItems);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder featuredResultsSetSummaryItems(FeaturedResultsSetSummary... featuredResultsSetSummaryItems) {
            featuredResultsSetSummaryItems(Arrays.asList(featuredResultsSetSummaryItems));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder featuredResultsSetSummaryItems(
                Consumer<FeaturedResultsSetSummary.Builder>... featuredResultsSetSummaryItems) {
            featuredResultsSetSummaryItems(Stream.of(featuredResultsSetSummaryItems)
                    .map(c -> FeaturedResultsSetSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListFeaturedResultsSetsResponse build() {
            return new ListFeaturedResultsSetsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
