/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The <code>SuggestionTextWithHighlights</code> structure information.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SuggestionValue implements SdkPojo, Serializable, ToCopyableBuilder<SuggestionValue.Builder, SuggestionValue> {
    private static final SdkField<SuggestionTextWithHighlights> TEXT_FIELD = SdkField
            .<SuggestionTextWithHighlights> builder(MarshallingType.SDK_POJO).memberName("Text")
            .getter(getter(SuggestionValue::text)).setter(setter(Builder::text))
            .constructor(SuggestionTextWithHighlights::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Text").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEXT_FIELD));

    private static final long serialVersionUID = 1L;

    private final SuggestionTextWithHighlights text;

    private SuggestionValue(BuilderImpl builder) {
        this.text = builder.text;
    }

    /**
     * <p>
     * The <code>SuggestionTextWithHighlights</code> structure that contains the query suggestion text and highlights.
     * </p>
     * 
     * @return The <code>SuggestionTextWithHighlights</code> structure that contains the query suggestion text and
     *         highlights.
     */
    public final SuggestionTextWithHighlights text() {
        return text;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(text());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SuggestionValue)) {
            return false;
        }
        SuggestionValue other = (SuggestionValue) obj;
        return Objects.equals(text(), other.text());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SuggestionValue").add("Text", text()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Text":
            return Optional.ofNullable(clazz.cast(text()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SuggestionValue, T> g) {
        return obj -> g.apply((SuggestionValue) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SuggestionValue> {
        /**
         * <p>
         * The <code>SuggestionTextWithHighlights</code> structure that contains the query suggestion text and
         * highlights.
         * </p>
         * 
         * @param text
         *        The <code>SuggestionTextWithHighlights</code> structure that contains the query suggestion text and
         *        highlights.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder text(SuggestionTextWithHighlights text);

        /**
         * <p>
         * The <code>SuggestionTextWithHighlights</code> structure that contains the query suggestion text and
         * highlights.
         * </p>
         * This is a convenience method that creates an instance of the {@link SuggestionTextWithHighlights.Builder}
         * avoiding the need to create one manually via {@link SuggestionTextWithHighlights#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SuggestionTextWithHighlights.Builder#build()} is called
         * immediately and its result is passed to {@link #text(SuggestionTextWithHighlights)}.
         * 
         * @param text
         *        a consumer that will call methods on {@link SuggestionTextWithHighlights.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #text(SuggestionTextWithHighlights)
         */
        default Builder text(Consumer<SuggestionTextWithHighlights.Builder> text) {
            return text(SuggestionTextWithHighlights.builder().applyMutation(text).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private SuggestionTextWithHighlights text;

        private BuilderImpl() {
        }

        private BuilderImpl(SuggestionValue model) {
            text(model.text);
        }

        public final SuggestionTextWithHighlights.Builder getText() {
            return text != null ? text.toBuilder() : null;
        }

        public final void setText(SuggestionTextWithHighlights.BuilderImpl text) {
            this.text = text != null ? text.build() : null;
        }

        @Override
        public final Builder text(SuggestionTextWithHighlights text) {
            this.text = text;
            return this;
        }

        @Override
        public SuggestionValue build() {
            return new SuggestionValue(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
