/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides the configuration information for applying basic logic to alter document metadata and content when ingesting
 * documents into Amazon Kendra. To apply advanced logic, to go beyond what you can do with basic logic, see <a
 * href="https://docs.aws.amazon.com/kendra/latest/dg/API_HookConfiguration.html">HookConfiguration</a>.
 * </p>
 * <p>
 * For more information, see <a
 * href="https://docs.aws.amazon.com/kendra/latest/dg/custom-document-enrichment.html">Customizing document metadata
 * during the ingestion process</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InlineCustomDocumentEnrichmentConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<InlineCustomDocumentEnrichmentConfiguration.Builder, InlineCustomDocumentEnrichmentConfiguration> {
    private static final SdkField<DocumentAttributeCondition> CONDITION_FIELD = SdkField
            .<DocumentAttributeCondition> builder(MarshallingType.SDK_POJO).memberName("Condition")
            .getter(getter(InlineCustomDocumentEnrichmentConfiguration::condition)).setter(setter(Builder::condition))
            .constructor(DocumentAttributeCondition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Condition").build()).build();

    private static final SdkField<DocumentAttributeTarget> TARGET_FIELD = SdkField
            .<DocumentAttributeTarget> builder(MarshallingType.SDK_POJO).memberName("Target")
            .getter(getter(InlineCustomDocumentEnrichmentConfiguration::target)).setter(setter(Builder::target))
            .constructor(DocumentAttributeTarget::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Target").build()).build();

    private static final SdkField<Boolean> DOCUMENT_CONTENT_DELETION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DocumentContentDeletion")
            .getter(getter(InlineCustomDocumentEnrichmentConfiguration::documentContentDeletion))
            .setter(setter(Builder::documentContentDeletion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentContentDeletion").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONDITION_FIELD, TARGET_FIELD,
            DOCUMENT_CONTENT_DELETION_FIELD));

    private static final long serialVersionUID = 1L;

    private final DocumentAttributeCondition condition;

    private final DocumentAttributeTarget target;

    private final Boolean documentContentDeletion;

    private InlineCustomDocumentEnrichmentConfiguration(BuilderImpl builder) {
        this.condition = builder.condition;
        this.target = builder.target;
        this.documentContentDeletion = builder.documentContentDeletion;
    }

    /**
     * <p>
     * Configuration of the condition used for the target document attribute or metadata field when ingesting documents
     * into Amazon Kendra.
     * </p>
     * 
     * @return Configuration of the condition used for the target document attribute or metadata field when ingesting
     *         documents into Amazon Kendra.
     */
    public final DocumentAttributeCondition condition() {
        return condition;
    }

    /**
     * <p>
     * Configuration of the target document attribute or metadata field when ingesting documents into Amazon Kendra. You
     * can also include a value.
     * </p>
     * 
     * @return Configuration of the target document attribute or metadata field when ingesting documents into Amazon
     *         Kendra. You can also include a value.
     */
    public final DocumentAttributeTarget target() {
        return target;
    }

    /**
     * <p>
     * <code>TRUE</code> to delete content if the condition used for the target attribute is met.
     * </p>
     * 
     * @return <code>TRUE</code> to delete content if the condition used for the target attribute is met.
     */
    public final Boolean documentContentDeletion() {
        return documentContentDeletion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(condition());
        hashCode = 31 * hashCode + Objects.hashCode(target());
        hashCode = 31 * hashCode + Objects.hashCode(documentContentDeletion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InlineCustomDocumentEnrichmentConfiguration)) {
            return false;
        }
        InlineCustomDocumentEnrichmentConfiguration other = (InlineCustomDocumentEnrichmentConfiguration) obj;
        return Objects.equals(condition(), other.condition()) && Objects.equals(target(), other.target())
                && Objects.equals(documentContentDeletion(), other.documentContentDeletion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InlineCustomDocumentEnrichmentConfiguration").add("Condition", condition())
                .add("Target", target()).add("DocumentContentDeletion", documentContentDeletion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Condition":
            return Optional.ofNullable(clazz.cast(condition()));
        case "Target":
            return Optional.ofNullable(clazz.cast(target()));
        case "DocumentContentDeletion":
            return Optional.ofNullable(clazz.cast(documentContentDeletion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InlineCustomDocumentEnrichmentConfiguration, T> g) {
        return obj -> g.apply((InlineCustomDocumentEnrichmentConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InlineCustomDocumentEnrichmentConfiguration> {
        /**
         * <p>
         * Configuration of the condition used for the target document attribute or metadata field when ingesting
         * documents into Amazon Kendra.
         * </p>
         * 
         * @param condition
         *        Configuration of the condition used for the target document attribute or metadata field when ingesting
         *        documents into Amazon Kendra.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder condition(DocumentAttributeCondition condition);

        /**
         * <p>
         * Configuration of the condition used for the target document attribute or metadata field when ingesting
         * documents into Amazon Kendra.
         * </p>
         * This is a convenience method that creates an instance of the {@link DocumentAttributeCondition.Builder}
         * avoiding the need to create one manually via {@link DocumentAttributeCondition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DocumentAttributeCondition.Builder#build()} is called immediately
         * and its result is passed to {@link #condition(DocumentAttributeCondition)}.
         * 
         * @param condition
         *        a consumer that will call methods on {@link DocumentAttributeCondition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #condition(DocumentAttributeCondition)
         */
        default Builder condition(Consumer<DocumentAttributeCondition.Builder> condition) {
            return condition(DocumentAttributeCondition.builder().applyMutation(condition).build());
        }

        /**
         * <p>
         * Configuration of the target document attribute or metadata field when ingesting documents into Amazon Kendra.
         * You can also include a value.
         * </p>
         * 
         * @param target
         *        Configuration of the target document attribute or metadata field when ingesting documents into Amazon
         *        Kendra. You can also include a value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder target(DocumentAttributeTarget target);

        /**
         * <p>
         * Configuration of the target document attribute or metadata field when ingesting documents into Amazon Kendra.
         * You can also include a value.
         * </p>
         * This is a convenience method that creates an instance of the {@link DocumentAttributeTarget.Builder} avoiding
         * the need to create one manually via {@link DocumentAttributeTarget#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DocumentAttributeTarget.Builder#build()} is called immediately
         * and its result is passed to {@link #target(DocumentAttributeTarget)}.
         * 
         * @param target
         *        a consumer that will call methods on {@link DocumentAttributeTarget.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #target(DocumentAttributeTarget)
         */
        default Builder target(Consumer<DocumentAttributeTarget.Builder> target) {
            return target(DocumentAttributeTarget.builder().applyMutation(target).build());
        }

        /**
         * <p>
         * <code>TRUE</code> to delete content if the condition used for the target attribute is met.
         * </p>
         * 
         * @param documentContentDeletion
         *        <code>TRUE</code> to delete content if the condition used for the target attribute is met.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentContentDeletion(Boolean documentContentDeletion);
    }

    static final class BuilderImpl implements Builder {
        private DocumentAttributeCondition condition;

        private DocumentAttributeTarget target;

        private Boolean documentContentDeletion;

        private BuilderImpl() {
        }

        private BuilderImpl(InlineCustomDocumentEnrichmentConfiguration model) {
            condition(model.condition);
            target(model.target);
            documentContentDeletion(model.documentContentDeletion);
        }

        public final DocumentAttributeCondition.Builder getCondition() {
            return condition != null ? condition.toBuilder() : null;
        }

        public final void setCondition(DocumentAttributeCondition.BuilderImpl condition) {
            this.condition = condition != null ? condition.build() : null;
        }

        @Override
        public final Builder condition(DocumentAttributeCondition condition) {
            this.condition = condition;
            return this;
        }

        public final DocumentAttributeTarget.Builder getTarget() {
            return target != null ? target.toBuilder() : null;
        }

        public final void setTarget(DocumentAttributeTarget.BuilderImpl target) {
            this.target = target != null ? target.build() : null;
        }

        @Override
        public final Builder target(DocumentAttributeTarget target) {
            this.target = target;
            return this;
        }

        public final Boolean getDocumentContentDeletion() {
            return documentContentDeletion;
        }

        public final void setDocumentContentDeletion(Boolean documentContentDeletion) {
            this.documentContentDeletion = documentContentDeletion;
        }

        @Override
        public final Builder documentContentDeletion(Boolean documentContentDeletion) {
            this.documentContentDeletion = documentContentDeletion;
            return this;
        }

        @Override
        public InlineCustomDocumentEnrichmentConfiguration build() {
            return new InlineCustomDocumentEnrichmentConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
