/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A single expanded result in a collapsed group of search results.
 * </p>
 * <p>
 * An expanded result item contains information about an expanded result document within a collapsed group of search
 * results. This includes the original location of the document, a list of attributes assigned to the document, and
 * relevant text from the document that satisfies the query.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExpandedResultItem implements SdkPojo, Serializable,
        ToCopyableBuilder<ExpandedResultItem.Builder, ExpandedResultItem> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(ExpandedResultItem::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> DOCUMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DocumentId").getter(getter(ExpandedResultItem::documentId)).setter(setter(Builder::documentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentId").build()).build();

    private static final SdkField<TextWithHighlights> DOCUMENT_TITLE_FIELD = SdkField
            .<TextWithHighlights> builder(MarshallingType.SDK_POJO).memberName("DocumentTitle")
            .getter(getter(ExpandedResultItem::documentTitle)).setter(setter(Builder::documentTitle))
            .constructor(TextWithHighlights::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentTitle").build()).build();

    private static final SdkField<TextWithHighlights> DOCUMENT_EXCERPT_FIELD = SdkField
            .<TextWithHighlights> builder(MarshallingType.SDK_POJO).memberName("DocumentExcerpt")
            .getter(getter(ExpandedResultItem::documentExcerpt)).setter(setter(Builder::documentExcerpt))
            .constructor(TextWithHighlights::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentExcerpt").build()).build();

    private static final SdkField<String> DOCUMENT_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DocumentURI").getter(getter(ExpandedResultItem::documentURI)).setter(setter(Builder::documentURI))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentURI").build()).build();

    private static final SdkField<List<DocumentAttribute>> DOCUMENT_ATTRIBUTES_FIELD = SdkField
            .<List<DocumentAttribute>> builder(MarshallingType.LIST)
            .memberName("DocumentAttributes")
            .getter(getter(ExpandedResultItem::documentAttributes))
            .setter(setter(Builder::documentAttributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentAttributes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DocumentAttribute> builder(MarshallingType.SDK_POJO)
                                            .constructor(DocumentAttribute::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, DOCUMENT_ID_FIELD,
            DOCUMENT_TITLE_FIELD, DOCUMENT_EXCERPT_FIELD, DOCUMENT_URI_FIELD, DOCUMENT_ATTRIBUTES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String documentId;

    private final TextWithHighlights documentTitle;

    private final TextWithHighlights documentExcerpt;

    private final String documentURI;

    private final List<DocumentAttribute> documentAttributes;

    private ExpandedResultItem(BuilderImpl builder) {
        this.id = builder.id;
        this.documentId = builder.documentId;
        this.documentTitle = builder.documentTitle;
        this.documentExcerpt = builder.documentExcerpt;
        this.documentURI = builder.documentURI;
        this.documentAttributes = builder.documentAttributes;
    }

    /**
     * <p>
     * The identifier for the expanded result.
     * </p>
     * 
     * @return The identifier for the expanded result.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The idenitifier of the document.
     * </p>
     * 
     * @return The idenitifier of the document.
     */
    public final String documentId() {
        return documentId;
    }

    /**
     * Returns the value of the DocumentTitle property for this object.
     * 
     * @return The value of the DocumentTitle property for this object.
     */
    public final TextWithHighlights documentTitle() {
        return documentTitle;
    }

    /**
     * Returns the value of the DocumentExcerpt property for this object.
     * 
     * @return The value of the DocumentExcerpt property for this object.
     */
    public final TextWithHighlights documentExcerpt() {
        return documentExcerpt;
    }

    /**
     * <p>
     * The URI of the original location of the document.
     * </p>
     * 
     * @return The URI of the original location of the document.
     */
    public final String documentURI() {
        return documentURI;
    }

    /**
     * For responses, this returns true if the service returned a value for the DocumentAttributes property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDocumentAttributes() {
        return documentAttributes != null && !(documentAttributes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of document attributes assigned to a document in the search results. For example, the document author
     * ("_author") or the source URI ("_source_uri") of the document.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDocumentAttributes} method.
     * </p>
     * 
     * @return An array of document attributes assigned to a document in the search results. For example, the document
     *         author ("_author") or the source URI ("_source_uri") of the document.
     */
    public final List<DocumentAttribute> documentAttributes() {
        return documentAttributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(documentId());
        hashCode = 31 * hashCode + Objects.hashCode(documentTitle());
        hashCode = 31 * hashCode + Objects.hashCode(documentExcerpt());
        hashCode = 31 * hashCode + Objects.hashCode(documentURI());
        hashCode = 31 * hashCode + Objects.hashCode(hasDocumentAttributes() ? documentAttributes() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExpandedResultItem)) {
            return false;
        }
        ExpandedResultItem other = (ExpandedResultItem) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(documentId(), other.documentId())
                && Objects.equals(documentTitle(), other.documentTitle())
                && Objects.equals(documentExcerpt(), other.documentExcerpt())
                && Objects.equals(documentURI(), other.documentURI()) && hasDocumentAttributes() == other.hasDocumentAttributes()
                && Objects.equals(documentAttributes(), other.documentAttributes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExpandedResultItem").add("Id", id()).add("DocumentId", documentId())
                .add("DocumentTitle", documentTitle()).add("DocumentExcerpt", documentExcerpt())
                .add("DocumentURI", documentURI())
                .add("DocumentAttributes", hasDocumentAttributes() ? documentAttributes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "DocumentId":
            return Optional.ofNullable(clazz.cast(documentId()));
        case "DocumentTitle":
            return Optional.ofNullable(clazz.cast(documentTitle()));
        case "DocumentExcerpt":
            return Optional.ofNullable(clazz.cast(documentExcerpt()));
        case "DocumentURI":
            return Optional.ofNullable(clazz.cast(documentURI()));
        case "DocumentAttributes":
            return Optional.ofNullable(clazz.cast(documentAttributes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExpandedResultItem, T> g) {
        return obj -> g.apply((ExpandedResultItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExpandedResultItem> {
        /**
         * <p>
         * The identifier for the expanded result.
         * </p>
         * 
         * @param id
         *        The identifier for the expanded result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The idenitifier of the document.
         * </p>
         * 
         * @param documentId
         *        The idenitifier of the document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentId(String documentId);

        /**
         * Sets the value of the DocumentTitle property for this object.
         *
         * @param documentTitle
         *        The new value for the DocumentTitle property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentTitle(TextWithHighlights documentTitle);

        /**
         * Sets the value of the DocumentTitle property for this object.
         *
         * This is a convenience method that creates an instance of the {@link TextWithHighlights.Builder} avoiding the
         * need to create one manually via {@link TextWithHighlights#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TextWithHighlights.Builder#build()} is called immediately and its
         * result is passed to {@link #documentTitle(TextWithHighlights)}.
         * 
         * @param documentTitle
         *        a consumer that will call methods on {@link TextWithHighlights.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #documentTitle(TextWithHighlights)
         */
        default Builder documentTitle(Consumer<TextWithHighlights.Builder> documentTitle) {
            return documentTitle(TextWithHighlights.builder().applyMutation(documentTitle).build());
        }

        /**
         * Sets the value of the DocumentExcerpt property for this object.
         *
         * @param documentExcerpt
         *        The new value for the DocumentExcerpt property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentExcerpt(TextWithHighlights documentExcerpt);

        /**
         * Sets the value of the DocumentExcerpt property for this object.
         *
         * This is a convenience method that creates an instance of the {@link TextWithHighlights.Builder} avoiding the
         * need to create one manually via {@link TextWithHighlights#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TextWithHighlights.Builder#build()} is called immediately and its
         * result is passed to {@link #documentExcerpt(TextWithHighlights)}.
         * 
         * @param documentExcerpt
         *        a consumer that will call methods on {@link TextWithHighlights.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #documentExcerpt(TextWithHighlights)
         */
        default Builder documentExcerpt(Consumer<TextWithHighlights.Builder> documentExcerpt) {
            return documentExcerpt(TextWithHighlights.builder().applyMutation(documentExcerpt).build());
        }

        /**
         * <p>
         * The URI of the original location of the document.
         * </p>
         * 
         * @param documentURI
         *        The URI of the original location of the document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentURI(String documentURI);

        /**
         * <p>
         * An array of document attributes assigned to a document in the search results. For example, the document
         * author ("_author") or the source URI ("_source_uri") of the document.
         * </p>
         * 
         * @param documentAttributes
         *        An array of document attributes assigned to a document in the search results. For example, the
         *        document author ("_author") or the source URI ("_source_uri") of the document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentAttributes(Collection<DocumentAttribute> documentAttributes);

        /**
         * <p>
         * An array of document attributes assigned to a document in the search results. For example, the document
         * author ("_author") or the source URI ("_source_uri") of the document.
         * </p>
         * 
         * @param documentAttributes
         *        An array of document attributes assigned to a document in the search results. For example, the
         *        document author ("_author") or the source URI ("_source_uri") of the document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentAttributes(DocumentAttribute... documentAttributes);

        /**
         * <p>
         * An array of document attributes assigned to a document in the search results. For example, the document
         * author ("_author") or the source URI ("_source_uri") of the document.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.kendra.model.DocumentAttribute.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.kendra.model.DocumentAttribute#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.kendra.model.DocumentAttribute.Builder#build()} is called immediately
         * and its result is passed to {@link #documentAttributes(List<DocumentAttribute>)}.
         * 
         * @param documentAttributes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.kendra.model.DocumentAttribute.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #documentAttributes(java.util.Collection<DocumentAttribute>)
         */
        Builder documentAttributes(Consumer<DocumentAttribute.Builder>... documentAttributes);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String documentId;

        private TextWithHighlights documentTitle;

        private TextWithHighlights documentExcerpt;

        private String documentURI;

        private List<DocumentAttribute> documentAttributes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ExpandedResultItem model) {
            id(model.id);
            documentId(model.documentId);
            documentTitle(model.documentTitle);
            documentExcerpt(model.documentExcerpt);
            documentURI(model.documentURI);
            documentAttributes(model.documentAttributes);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getDocumentId() {
            return documentId;
        }

        public final void setDocumentId(String documentId) {
            this.documentId = documentId;
        }

        @Override
        public final Builder documentId(String documentId) {
            this.documentId = documentId;
            return this;
        }

        public final TextWithHighlights.Builder getDocumentTitle() {
            return documentTitle != null ? documentTitle.toBuilder() : null;
        }

        public final void setDocumentTitle(TextWithHighlights.BuilderImpl documentTitle) {
            this.documentTitle = documentTitle != null ? documentTitle.build() : null;
        }

        @Override
        public final Builder documentTitle(TextWithHighlights documentTitle) {
            this.documentTitle = documentTitle;
            return this;
        }

        public final TextWithHighlights.Builder getDocumentExcerpt() {
            return documentExcerpt != null ? documentExcerpt.toBuilder() : null;
        }

        public final void setDocumentExcerpt(TextWithHighlights.BuilderImpl documentExcerpt) {
            this.documentExcerpt = documentExcerpt != null ? documentExcerpt.build() : null;
        }

        @Override
        public final Builder documentExcerpt(TextWithHighlights documentExcerpt) {
            this.documentExcerpt = documentExcerpt;
            return this;
        }

        public final String getDocumentURI() {
            return documentURI;
        }

        public final void setDocumentURI(String documentURI) {
            this.documentURI = documentURI;
        }

        @Override
        public final Builder documentURI(String documentURI) {
            this.documentURI = documentURI;
            return this;
        }

        public final List<DocumentAttribute.Builder> getDocumentAttributes() {
            List<DocumentAttribute.Builder> result = DocumentAttributeListCopier.copyToBuilder(this.documentAttributes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDocumentAttributes(Collection<DocumentAttribute.BuilderImpl> documentAttributes) {
            this.documentAttributes = DocumentAttributeListCopier.copyFromBuilder(documentAttributes);
        }

        @Override
        public final Builder documentAttributes(Collection<DocumentAttribute> documentAttributes) {
            this.documentAttributes = DocumentAttributeListCopier.copy(documentAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder documentAttributes(DocumentAttribute... documentAttributes) {
            documentAttributes(Arrays.asList(documentAttributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder documentAttributes(Consumer<DocumentAttribute.Builder>... documentAttributes) {
            documentAttributes(Stream.of(documentAttributes).map(c -> DocumentAttribute.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ExpandedResultItem build() {
            return new ExpandedResultItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
