/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class QueryRequest extends KendraRequest implements ToCopyableBuilder<QueryRequest.Builder, QueryRequest> {
    private static final SdkField<String> INDEX_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IndexId").getter(getter(QueryRequest::indexId)).setter(setter(Builder::indexId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexId").build()).build();

    private static final SdkField<String> QUERY_TEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("QueryText").getter(getter(QueryRequest::queryText)).setter(setter(Builder::queryText))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryText").build()).build();

    private static final SdkField<AttributeFilter> ATTRIBUTE_FILTER_FIELD = SdkField
            .<AttributeFilter> builder(MarshallingType.SDK_POJO).memberName("AttributeFilter")
            .getter(getter(QueryRequest::attributeFilter)).setter(setter(Builder::attributeFilter))
            .constructor(AttributeFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeFilter").build()).build();

    private static final SdkField<List<Facet>> FACETS_FIELD = SdkField
            .<List<Facet>> builder(MarshallingType.LIST)
            .memberName("Facets")
            .getter(getter(QueryRequest::facets))
            .setter(setter(Builder::facets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Facets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Facet> builder(MarshallingType.SDK_POJO)
                                            .constructor(Facet::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> REQUESTED_DOCUMENT_ATTRIBUTES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("RequestedDocumentAttributes")
            .getter(getter(QueryRequest::requestedDocumentAttributes))
            .setter(setter(Builder::requestedDocumentAttributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestedDocumentAttributes")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> QUERY_RESULT_TYPE_FILTER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("QueryResultTypeFilter").getter(getter(QueryRequest::queryResultTypeFilterAsString))
            .setter(setter(Builder::queryResultTypeFilter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryResultTypeFilter").build())
            .build();

    private static final SdkField<List<DocumentRelevanceConfiguration>> DOCUMENT_RELEVANCE_OVERRIDE_CONFIGURATIONS_FIELD = SdkField
            .<List<DocumentRelevanceConfiguration>> builder(MarshallingType.LIST)
            .memberName("DocumentRelevanceOverrideConfigurations")
            .getter(getter(QueryRequest::documentRelevanceOverrideConfigurations))
            .setter(setter(Builder::documentRelevanceOverrideConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("DocumentRelevanceOverrideConfigurations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DocumentRelevanceConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(DocumentRelevanceConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> PAGE_NUMBER_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("PageNumber").getter(getter(QueryRequest::pageNumber)).setter(setter(Builder::pageNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PageNumber").build()).build();

    private static final SdkField<Integer> PAGE_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("PageSize").getter(getter(QueryRequest::pageSize)).setter(setter(Builder::pageSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PageSize").build()).build();

    private static final SdkField<SortingConfiguration> SORTING_CONFIGURATION_FIELD = SdkField
            .<SortingConfiguration> builder(MarshallingType.SDK_POJO).memberName("SortingConfiguration")
            .getter(getter(QueryRequest::sortingConfiguration)).setter(setter(Builder::sortingConfiguration))
            .constructor(SortingConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortingConfiguration").build())
            .build();

    private static final SdkField<List<SortingConfiguration>> SORTING_CONFIGURATIONS_FIELD = SdkField
            .<List<SortingConfiguration>> builder(MarshallingType.LIST)
            .memberName("SortingConfigurations")
            .getter(getter(QueryRequest::sortingConfigurations))
            .setter(setter(Builder::sortingConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortingConfigurations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SortingConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(SortingConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<UserContext> USER_CONTEXT_FIELD = SdkField.<UserContext> builder(MarshallingType.SDK_POJO)
            .memberName("UserContext").getter(getter(QueryRequest::userContext)).setter(setter(Builder::userContext))
            .constructor(UserContext::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserContext").build()).build();

    private static final SdkField<String> VISITOR_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VisitorId").getter(getter(QueryRequest::visitorId)).setter(setter(Builder::visitorId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VisitorId").build()).build();

    private static final SdkField<SpellCorrectionConfiguration> SPELL_CORRECTION_CONFIGURATION_FIELD = SdkField
            .<SpellCorrectionConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("SpellCorrectionConfiguration")
            .getter(getter(QueryRequest::spellCorrectionConfiguration))
            .setter(setter(Builder::spellCorrectionConfiguration))
            .constructor(SpellCorrectionConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpellCorrectionConfiguration")
                    .build()).build();

    private static final SdkField<CollapseConfiguration> COLLAPSE_CONFIGURATION_FIELD = SdkField
            .<CollapseConfiguration> builder(MarshallingType.SDK_POJO).memberName("CollapseConfiguration")
            .getter(getter(QueryRequest::collapseConfiguration)).setter(setter(Builder::collapseConfiguration))
            .constructor(CollapseConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CollapseConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INDEX_ID_FIELD,
            QUERY_TEXT_FIELD, ATTRIBUTE_FILTER_FIELD, FACETS_FIELD, REQUESTED_DOCUMENT_ATTRIBUTES_FIELD,
            QUERY_RESULT_TYPE_FILTER_FIELD, DOCUMENT_RELEVANCE_OVERRIDE_CONFIGURATIONS_FIELD, PAGE_NUMBER_FIELD, PAGE_SIZE_FIELD,
            SORTING_CONFIGURATION_FIELD, SORTING_CONFIGURATIONS_FIELD, USER_CONTEXT_FIELD, VISITOR_ID_FIELD,
            SPELL_CORRECTION_CONFIGURATION_FIELD, COLLAPSE_CONFIGURATION_FIELD));

    private final String indexId;

    private final String queryText;

    private final AttributeFilter attributeFilter;

    private final List<Facet> facets;

    private final List<String> requestedDocumentAttributes;

    private final String queryResultTypeFilter;

    private final List<DocumentRelevanceConfiguration> documentRelevanceOverrideConfigurations;

    private final Integer pageNumber;

    private final Integer pageSize;

    private final SortingConfiguration sortingConfiguration;

    private final List<SortingConfiguration> sortingConfigurations;

    private final UserContext userContext;

    private final String visitorId;

    private final SpellCorrectionConfiguration spellCorrectionConfiguration;

    private final CollapseConfiguration collapseConfiguration;

    private QueryRequest(BuilderImpl builder) {
        super(builder);
        this.indexId = builder.indexId;
        this.queryText = builder.queryText;
        this.attributeFilter = builder.attributeFilter;
        this.facets = builder.facets;
        this.requestedDocumentAttributes = builder.requestedDocumentAttributes;
        this.queryResultTypeFilter = builder.queryResultTypeFilter;
        this.documentRelevanceOverrideConfigurations = builder.documentRelevanceOverrideConfigurations;
        this.pageNumber = builder.pageNumber;
        this.pageSize = builder.pageSize;
        this.sortingConfiguration = builder.sortingConfiguration;
        this.sortingConfigurations = builder.sortingConfigurations;
        this.userContext = builder.userContext;
        this.visitorId = builder.visitorId;
        this.spellCorrectionConfiguration = builder.spellCorrectionConfiguration;
        this.collapseConfiguration = builder.collapseConfiguration;
    }

    /**
     * <p>
     * The identifier of the index for the search.
     * </p>
     * 
     * @return The identifier of the index for the search.
     */
    public final String indexId() {
        return indexId;
    }

    /**
     * <p>
     * The input query text for the search. Amazon Kendra truncates queries at 30 token words, which excludes
     * punctuation and stop words. Truncation still applies if you use Boolean or more advanced, complex queries.
     * </p>
     * 
     * @return The input query text for the search. Amazon Kendra truncates queries at 30 token words, which excludes
     *         punctuation and stop words. Truncation still applies if you use Boolean or more advanced, complex
     *         queries.
     */
    public final String queryText() {
        return queryText;
    }

    /**
     * <p>
     * Filters search results by document fields/attributes. You can only provide one attribute filter; however, the
     * <code>AndAllFilters</code>, <code>NotFilter</code>, and <code>OrAllFilters</code> parameters contain a list of
     * other filters.
     * </p>
     * <p>
     * The <code>AttributeFilter</code> parameter means you can create a set of filtering rules that a document must
     * satisfy to be included in the query results.
     * </p>
     * 
     * @return Filters search results by document fields/attributes. You can only provide one attribute filter; however,
     *         the <code>AndAllFilters</code>, <code>NotFilter</code>, and <code>OrAllFilters</code> parameters contain
     *         a list of other filters.</p>
     *         <p>
     *         The <code>AttributeFilter</code> parameter means you can create a set of filtering rules that a document
     *         must satisfy to be included in the query results.
     */
    public final AttributeFilter attributeFilter() {
        return attributeFilter;
    }

    /**
     * For responses, this returns true if the service returned a value for the Facets property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFacets() {
        return facets != null && !(facets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of documents fields/attributes for faceted search. Amazon Kendra returns a count for each field key
     * specified. This helps your users narrow their search.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFacets} method.
     * </p>
     * 
     * @return An array of documents fields/attributes for faceted search. Amazon Kendra returns a count for each field
     *         key specified. This helps your users narrow their search.
     */
    public final List<Facet> facets() {
        return facets;
    }

    /**
     * For responses, this returns true if the service returned a value for the RequestedDocumentAttributes property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasRequestedDocumentAttributes() {
        return requestedDocumentAttributes != null && !(requestedDocumentAttributes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of document fields/attributes to include in the response. You can limit the response to include certain
     * document fields. By default, all document attributes are included in the response.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRequestedDocumentAttributes} method.
     * </p>
     * 
     * @return An array of document fields/attributes to include in the response. You can limit the response to include
     *         certain document fields. By default, all document attributes are included in the response.
     */
    public final List<String> requestedDocumentAttributes() {
        return requestedDocumentAttributes;
    }

    /**
     * <p>
     * Sets the type of query result or response. Only results for the specified type are returned.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #queryResultTypeFilter} will return {@link QueryResultType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #queryResultTypeFilterAsString}.
     * </p>
     * 
     * @return Sets the type of query result or response. Only results for the specified type are returned.
     * @see QueryResultType
     */
    public final QueryResultType queryResultTypeFilter() {
        return QueryResultType.fromValue(queryResultTypeFilter);
    }

    /**
     * <p>
     * Sets the type of query result or response. Only results for the specified type are returned.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #queryResultTypeFilter} will return {@link QueryResultType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #queryResultTypeFilterAsString}.
     * </p>
     * 
     * @return Sets the type of query result or response. Only results for the specified type are returned.
     * @see QueryResultType
     */
    public final String queryResultTypeFilterAsString() {
        return queryResultTypeFilter;
    }

    /**
     * For responses, this returns true if the service returned a value for the DocumentRelevanceOverrideConfigurations
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasDocumentRelevanceOverrideConfigurations() {
        return documentRelevanceOverrideConfigurations != null
                && !(documentRelevanceOverrideConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Overrides relevance tuning configurations of fields/attributes set at the index level.
     * </p>
     * <p>
     * If you use this API to override the relevance tuning configured at the index level, but there is no relevance
     * tuning configured at the index level, then Amazon Kendra does not apply any relevance tuning.
     * </p>
     * <p>
     * If there is relevance tuning configured for fields at the index level, and you use this API to override only some
     * of these fields, then for the fields you did not override, the importance is set to 1.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the
     * {@link #hasDocumentRelevanceOverrideConfigurations} method.
     * </p>
     * 
     * @return Overrides relevance tuning configurations of fields/attributes set at the index level.</p>
     *         <p>
     *         If you use this API to override the relevance tuning configured at the index level, but there is no
     *         relevance tuning configured at the index level, then Amazon Kendra does not apply any relevance tuning.
     *         </p>
     *         <p>
     *         If there is relevance tuning configured for fields at the index level, and you use this API to override
     *         only some of these fields, then for the fields you did not override, the importance is set to 1.
     */
    public final List<DocumentRelevanceConfiguration> documentRelevanceOverrideConfigurations() {
        return documentRelevanceOverrideConfigurations;
    }

    /**
     * <p>
     * Query results are returned in pages the size of the <code>PageSize</code> parameter. By default, Amazon Kendra
     * returns the first page of results. Use this parameter to get result pages after the first one.
     * </p>
     * 
     * @return Query results are returned in pages the size of the <code>PageSize</code> parameter. By default, Amazon
     *         Kendra returns the first page of results. Use this parameter to get result pages after the first one.
     */
    public final Integer pageNumber() {
        return pageNumber;
    }

    /**
     * <p>
     * Sets the number of results that are returned in each page of results. The default page size is 10. The maximum
     * number of results returned is 100. If you ask for more than 100 results, only 100 are returned.
     * </p>
     * 
     * @return Sets the number of results that are returned in each page of results. The default page size is 10. The
     *         maximum number of results returned is 100. If you ask for more than 100 results, only 100 are returned.
     */
    public final Integer pageSize() {
        return pageSize;
    }

    /**
     * <p>
     * Provides information that determines how the results of the query are sorted. You can set the field that Amazon
     * Kendra should sort the results on, and specify whether the results should be sorted in ascending or descending
     * order. In the case of ties in sorting the results, the results are sorted by relevance.
     * </p>
     * <p>
     * If you don't provide sorting configuration, the results are sorted by the relevance that Amazon Kendra determines
     * for the result.
     * </p>
     * 
     * @return Provides information that determines how the results of the query are sorted. You can set the field that
     *         Amazon Kendra should sort the results on, and specify whether the results should be sorted in ascending
     *         or descending order. In the case of ties in sorting the results, the results are sorted by relevance.</p>
     *         <p>
     *         If you don't provide sorting configuration, the results are sorted by the relevance that Amazon Kendra
     *         determines for the result.
     */
    public final SortingConfiguration sortingConfiguration() {
        return sortingConfiguration;
    }

    /**
     * For responses, this returns true if the service returned a value for the SortingConfigurations property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasSortingConfigurations() {
        return sortingConfigurations != null && !(sortingConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Provides configuration information to determine how the results of a query are sorted.
     * </p>
     * <p>
     * You can set upto 3 fields that Amazon Kendra should sort the results on, and specify whether the results should
     * be sorted in ascending or descending order. The sort field quota can be increased.
     * </p>
     * <p>
     * If you don't provide a sorting configuration, the results are sorted by the relevance that Amazon Kendra
     * determines for the result. In the case of ties in sorting the results, the results are sorted by relevance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSortingConfigurations} method.
     * </p>
     * 
     * @return Provides configuration information to determine how the results of a query are sorted.</p>
     *         <p>
     *         You can set upto 3 fields that Amazon Kendra should sort the results on, and specify whether the results
     *         should be sorted in ascending or descending order. The sort field quota can be increased.
     *         </p>
     *         <p>
     *         If you don't provide a sorting configuration, the results are sorted by the relevance that Amazon Kendra
     *         determines for the result. In the case of ties in sorting the results, the results are sorted by
     *         relevance.
     */
    public final List<SortingConfiguration> sortingConfigurations() {
        return sortingConfigurations;
    }

    /**
     * <p>
     * The user context token or user and group information.
     * </p>
     * 
     * @return The user context token or user and group information.
     */
    public final UserContext userContext() {
        return userContext;
    }

    /**
     * <p>
     * Provides an identifier for a specific user. The <code>VisitorId</code> should be a unique identifier, such as a
     * GUID. Don't use personally identifiable information, such as the user's email address, as the
     * <code>VisitorId</code>.
     * </p>
     * 
     * @return Provides an identifier for a specific user. The <code>VisitorId</code> should be a unique identifier,
     *         such as a GUID. Don't use personally identifiable information, such as the user's email address, as the
     *         <code>VisitorId</code>.
     */
    public final String visitorId() {
        return visitorId;
    }

    /**
     * <p>
     * Enables suggested spell corrections for queries.
     * </p>
     * 
     * @return Enables suggested spell corrections for queries.
     */
    public final SpellCorrectionConfiguration spellCorrectionConfiguration() {
        return spellCorrectionConfiguration;
    }

    /**
     * <p>
     * Provides configuration to determine how to group results by document attribute value, and how to display them
     * (collapsed or expanded) under a designated primary document for each group.
     * </p>
     * 
     * @return Provides configuration to determine how to group results by document attribute value, and how to display
     *         them (collapsed or expanded) under a designated primary document for each group.
     */
    public final CollapseConfiguration collapseConfiguration() {
        return collapseConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(indexId());
        hashCode = 31 * hashCode + Objects.hashCode(queryText());
        hashCode = 31 * hashCode + Objects.hashCode(attributeFilter());
        hashCode = 31 * hashCode + Objects.hashCode(hasFacets() ? facets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasRequestedDocumentAttributes() ? requestedDocumentAttributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(queryResultTypeFilterAsString());
        hashCode = 31
                * hashCode
                + Objects.hashCode(hasDocumentRelevanceOverrideConfigurations() ? documentRelevanceOverrideConfigurations()
                        : null);
        hashCode = 31 * hashCode + Objects.hashCode(pageNumber());
        hashCode = 31 * hashCode + Objects.hashCode(pageSize());
        hashCode = 31 * hashCode + Objects.hashCode(sortingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(hasSortingConfigurations() ? sortingConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(userContext());
        hashCode = 31 * hashCode + Objects.hashCode(visitorId());
        hashCode = 31 * hashCode + Objects.hashCode(spellCorrectionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(collapseConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueryRequest)) {
            return false;
        }
        QueryRequest other = (QueryRequest) obj;
        return Objects.equals(indexId(), other.indexId()) && Objects.equals(queryText(), other.queryText())
                && Objects.equals(attributeFilter(), other.attributeFilter()) && hasFacets() == other.hasFacets()
                && Objects.equals(facets(), other.facets())
                && hasRequestedDocumentAttributes() == other.hasRequestedDocumentAttributes()
                && Objects.equals(requestedDocumentAttributes(), other.requestedDocumentAttributes())
                && Objects.equals(queryResultTypeFilterAsString(), other.queryResultTypeFilterAsString())
                && hasDocumentRelevanceOverrideConfigurations() == other.hasDocumentRelevanceOverrideConfigurations()
                && Objects.equals(documentRelevanceOverrideConfigurations(), other.documentRelevanceOverrideConfigurations())
                && Objects.equals(pageNumber(), other.pageNumber()) && Objects.equals(pageSize(), other.pageSize())
                && Objects.equals(sortingConfiguration(), other.sortingConfiguration())
                && hasSortingConfigurations() == other.hasSortingConfigurations()
                && Objects.equals(sortingConfigurations(), other.sortingConfigurations())
                && Objects.equals(userContext(), other.userContext()) && Objects.equals(visitorId(), other.visitorId())
                && Objects.equals(spellCorrectionConfiguration(), other.spellCorrectionConfiguration())
                && Objects.equals(collapseConfiguration(), other.collapseConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("QueryRequest")
                .add("IndexId", indexId())
                .add("QueryText", queryText())
                .add("AttributeFilter", attributeFilter())
                .add("Facets", hasFacets() ? facets() : null)
                .add("RequestedDocumentAttributes", hasRequestedDocumentAttributes() ? requestedDocumentAttributes() : null)
                .add("QueryResultTypeFilter", queryResultTypeFilterAsString())
                .add("DocumentRelevanceOverrideConfigurations",
                        hasDocumentRelevanceOverrideConfigurations() ? documentRelevanceOverrideConfigurations() : null)
                .add("PageNumber", pageNumber()).add("PageSize", pageSize()).add("SortingConfiguration", sortingConfiguration())
                .add("SortingConfigurations", hasSortingConfigurations() ? sortingConfigurations() : null)
                .add("UserContext", userContext()).add("VisitorId", visitorId())
                .add("SpellCorrectionConfiguration", spellCorrectionConfiguration())
                .add("CollapseConfiguration", collapseConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IndexId":
            return Optional.ofNullable(clazz.cast(indexId()));
        case "QueryText":
            return Optional.ofNullable(clazz.cast(queryText()));
        case "AttributeFilter":
            return Optional.ofNullable(clazz.cast(attributeFilter()));
        case "Facets":
            return Optional.ofNullable(clazz.cast(facets()));
        case "RequestedDocumentAttributes":
            return Optional.ofNullable(clazz.cast(requestedDocumentAttributes()));
        case "QueryResultTypeFilter":
            return Optional.ofNullable(clazz.cast(queryResultTypeFilterAsString()));
        case "DocumentRelevanceOverrideConfigurations":
            return Optional.ofNullable(clazz.cast(documentRelevanceOverrideConfigurations()));
        case "PageNumber":
            return Optional.ofNullable(clazz.cast(pageNumber()));
        case "PageSize":
            return Optional.ofNullable(clazz.cast(pageSize()));
        case "SortingConfiguration":
            return Optional.ofNullable(clazz.cast(sortingConfiguration()));
        case "SortingConfigurations":
            return Optional.ofNullable(clazz.cast(sortingConfigurations()));
        case "UserContext":
            return Optional.ofNullable(clazz.cast(userContext()));
        case "VisitorId":
            return Optional.ofNullable(clazz.cast(visitorId()));
        case "SpellCorrectionConfiguration":
            return Optional.ofNullable(clazz.cast(spellCorrectionConfiguration()));
        case "CollapseConfiguration":
            return Optional.ofNullable(clazz.cast(collapseConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<QueryRequest, T> g) {
        return obj -> g.apply((QueryRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KendraRequest.Builder, SdkPojo, CopyableBuilder<Builder, QueryRequest> {
        /**
         * <p>
         * The identifier of the index for the search.
         * </p>
         * 
         * @param indexId
         *        The identifier of the index for the search.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexId(String indexId);

        /**
         * <p>
         * The input query text for the search. Amazon Kendra truncates queries at 30 token words, which excludes
         * punctuation and stop words. Truncation still applies if you use Boolean or more advanced, complex queries.
         * </p>
         * 
         * @param queryText
         *        The input query text for the search. Amazon Kendra truncates queries at 30 token words, which excludes
         *        punctuation and stop words. Truncation still applies if you use Boolean or more advanced, complex
         *        queries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryText(String queryText);

        /**
         * <p>
         * Filters search results by document fields/attributes. You can only provide one attribute filter; however, the
         * <code>AndAllFilters</code>, <code>NotFilter</code>, and <code>OrAllFilters</code> parameters contain a list
         * of other filters.
         * </p>
         * <p>
         * The <code>AttributeFilter</code> parameter means you can create a set of filtering rules that a document must
         * satisfy to be included in the query results.
         * </p>
         * 
         * @param attributeFilter
         *        Filters search results by document fields/attributes. You can only provide one attribute filter;
         *        however, the <code>AndAllFilters</code>, <code>NotFilter</code>, and <code>OrAllFilters</code>
         *        parameters contain a list of other filters.</p>
         *        <p>
         *        The <code>AttributeFilter</code> parameter means you can create a set of filtering rules that a
         *        document must satisfy to be included in the query results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeFilter(AttributeFilter attributeFilter);

        /**
         * <p>
         * Filters search results by document fields/attributes. You can only provide one attribute filter; however, the
         * <code>AndAllFilters</code>, <code>NotFilter</code>, and <code>OrAllFilters</code> parameters contain a list
         * of other filters.
         * </p>
         * <p>
         * The <code>AttributeFilter</code> parameter means you can create a set of filtering rules that a document must
         * satisfy to be included in the query results.
         * </p>
         * This is a convenience method that creates an instance of the {@link AttributeFilter.Builder} avoiding the
         * need to create one manually via {@link AttributeFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AttributeFilter.Builder#build()} is called immediately and its
         * result is passed to {@link #attributeFilter(AttributeFilter)}.
         * 
         * @param attributeFilter
         *        a consumer that will call methods on {@link AttributeFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attributeFilter(AttributeFilter)
         */
        default Builder attributeFilter(Consumer<AttributeFilter.Builder> attributeFilter) {
            return attributeFilter(AttributeFilter.builder().applyMutation(attributeFilter).build());
        }

        /**
         * <p>
         * An array of documents fields/attributes for faceted search. Amazon Kendra returns a count for each field key
         * specified. This helps your users narrow their search.
         * </p>
         * 
         * @param facets
         *        An array of documents fields/attributes for faceted search. Amazon Kendra returns a count for each
         *        field key specified. This helps your users narrow their search.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder facets(Collection<Facet> facets);

        /**
         * <p>
         * An array of documents fields/attributes for faceted search. Amazon Kendra returns a count for each field key
         * specified. This helps your users narrow their search.
         * </p>
         * 
         * @param facets
         *        An array of documents fields/attributes for faceted search. Amazon Kendra returns a count for each
         *        field key specified. This helps your users narrow their search.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder facets(Facet... facets);

        /**
         * <p>
         * An array of documents fields/attributes for faceted search. Amazon Kendra returns a count for each field key
         * specified. This helps your users narrow their search.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.kendra.model.Facet.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.kendra.model.Facet#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.kendra.model.Facet.Builder#build()} is called immediately and its
         * result is passed to {@link #facets(List<Facet>)}.
         * 
         * @param facets
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.kendra.model.Facet.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #facets(java.util.Collection<Facet>)
         */
        Builder facets(Consumer<Facet.Builder>... facets);

        /**
         * <p>
         * An array of document fields/attributes to include in the response. You can limit the response to include
         * certain document fields. By default, all document attributes are included in the response.
         * </p>
         * 
         * @param requestedDocumentAttributes
         *        An array of document fields/attributes to include in the response. You can limit the response to
         *        include certain document fields. By default, all document attributes are included in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestedDocumentAttributes(Collection<String> requestedDocumentAttributes);

        /**
         * <p>
         * An array of document fields/attributes to include in the response. You can limit the response to include
         * certain document fields. By default, all document attributes are included in the response.
         * </p>
         * 
         * @param requestedDocumentAttributes
         *        An array of document fields/attributes to include in the response. You can limit the response to
         *        include certain document fields. By default, all document attributes are included in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestedDocumentAttributes(String... requestedDocumentAttributes);

        /**
         * <p>
         * Sets the type of query result or response. Only results for the specified type are returned.
         * </p>
         * 
         * @param queryResultTypeFilter
         *        Sets the type of query result or response. Only results for the specified type are returned.
         * @see QueryResultType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QueryResultType
         */
        Builder queryResultTypeFilter(String queryResultTypeFilter);

        /**
         * <p>
         * Sets the type of query result or response. Only results for the specified type are returned.
         * </p>
         * 
         * @param queryResultTypeFilter
         *        Sets the type of query result or response. Only results for the specified type are returned.
         * @see QueryResultType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QueryResultType
         */
        Builder queryResultTypeFilter(QueryResultType queryResultTypeFilter);

        /**
         * <p>
         * Overrides relevance tuning configurations of fields/attributes set at the index level.
         * </p>
         * <p>
         * If you use this API to override the relevance tuning configured at the index level, but there is no relevance
         * tuning configured at the index level, then Amazon Kendra does not apply any relevance tuning.
         * </p>
         * <p>
         * If there is relevance tuning configured for fields at the index level, and you use this API to override only
         * some of these fields, then for the fields you did not override, the importance is set to 1.
         * </p>
         * 
         * @param documentRelevanceOverrideConfigurations
         *        Overrides relevance tuning configurations of fields/attributes set at the index level.</p>
         *        <p>
         *        If you use this API to override the relevance tuning configured at the index level, but there is no
         *        relevance tuning configured at the index level, then Amazon Kendra does not apply any relevance
         *        tuning.
         *        </p>
         *        <p>
         *        If there is relevance tuning configured for fields at the index level, and you use this API to
         *        override only some of these fields, then for the fields you did not override, the importance is set to
         *        1.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentRelevanceOverrideConfigurations(
                Collection<DocumentRelevanceConfiguration> documentRelevanceOverrideConfigurations);

        /**
         * <p>
         * Overrides relevance tuning configurations of fields/attributes set at the index level.
         * </p>
         * <p>
         * If you use this API to override the relevance tuning configured at the index level, but there is no relevance
         * tuning configured at the index level, then Amazon Kendra does not apply any relevance tuning.
         * </p>
         * <p>
         * If there is relevance tuning configured for fields at the index level, and you use this API to override only
         * some of these fields, then for the fields you did not override, the importance is set to 1.
         * </p>
         * 
         * @param documentRelevanceOverrideConfigurations
         *        Overrides relevance tuning configurations of fields/attributes set at the index level.</p>
         *        <p>
         *        If you use this API to override the relevance tuning configured at the index level, but there is no
         *        relevance tuning configured at the index level, then Amazon Kendra does not apply any relevance
         *        tuning.
         *        </p>
         *        <p>
         *        If there is relevance tuning configured for fields at the index level, and you use this API to
         *        override only some of these fields, then for the fields you did not override, the importance is set to
         *        1.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentRelevanceOverrideConfigurations(DocumentRelevanceConfiguration... documentRelevanceOverrideConfigurations);

        /**
         * <p>
         * Overrides relevance tuning configurations of fields/attributes set at the index level.
         * </p>
         * <p>
         * If you use this API to override the relevance tuning configured at the index level, but there is no relevance
         * tuning configured at the index level, then Amazon Kendra does not apply any relevance tuning.
         * </p>
         * <p>
         * If there is relevance tuning configured for fields at the index level, and you use this API to override only
         * some of these fields, then for the fields you did not override, the importance is set to 1.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.kendra.model.DocumentRelevanceConfiguration.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.kendra.model.DocumentRelevanceConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.kendra.model.DocumentRelevanceConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #documentRelevanceOverrideConfigurations(List<DocumentRelevanceConfiguration>)}.
         * 
         * @param documentRelevanceOverrideConfigurations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.kendra.model.DocumentRelevanceConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #documentRelevanceOverrideConfigurations(java.util.Collection<DocumentRelevanceConfiguration>)
         */
        Builder documentRelevanceOverrideConfigurations(
                Consumer<DocumentRelevanceConfiguration.Builder>... documentRelevanceOverrideConfigurations);

        /**
         * <p>
         * Query results are returned in pages the size of the <code>PageSize</code> parameter. By default, Amazon
         * Kendra returns the first page of results. Use this parameter to get result pages after the first one.
         * </p>
         * 
         * @param pageNumber
         *        Query results are returned in pages the size of the <code>PageSize</code> parameter. By default,
         *        Amazon Kendra returns the first page of results. Use this parameter to get result pages after the
         *        first one.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pageNumber(Integer pageNumber);

        /**
         * <p>
         * Sets the number of results that are returned in each page of results. The default page size is 10. The
         * maximum number of results returned is 100. If you ask for more than 100 results, only 100 are returned.
         * </p>
         * 
         * @param pageSize
         *        Sets the number of results that are returned in each page of results. The default page size is 10. The
         *        maximum number of results returned is 100. If you ask for more than 100 results, only 100 are
         *        returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pageSize(Integer pageSize);

        /**
         * <p>
         * Provides information that determines how the results of the query are sorted. You can set the field that
         * Amazon Kendra should sort the results on, and specify whether the results should be sorted in ascending or
         * descending order. In the case of ties in sorting the results, the results are sorted by relevance.
         * </p>
         * <p>
         * If you don't provide sorting configuration, the results are sorted by the relevance that Amazon Kendra
         * determines for the result.
         * </p>
         * 
         * @param sortingConfiguration
         *        Provides information that determines how the results of the query are sorted. You can set the field
         *        that Amazon Kendra should sort the results on, and specify whether the results should be sorted in
         *        ascending or descending order. In the case of ties in sorting the results, the results are sorted by
         *        relevance.</p>
         *        <p>
         *        If you don't provide sorting configuration, the results are sorted by the relevance that Amazon Kendra
         *        determines for the result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sortingConfiguration(SortingConfiguration sortingConfiguration);

        /**
         * <p>
         * Provides information that determines how the results of the query are sorted. You can set the field that
         * Amazon Kendra should sort the results on, and specify whether the results should be sorted in ascending or
         * descending order. In the case of ties in sorting the results, the results are sorted by relevance.
         * </p>
         * <p>
         * If you don't provide sorting configuration, the results are sorted by the relevance that Amazon Kendra
         * determines for the result.
         * </p>
         * This is a convenience method that creates an instance of the {@link SortingConfiguration.Builder} avoiding
         * the need to create one manually via {@link SortingConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SortingConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #sortingConfiguration(SortingConfiguration)}.
         * 
         * @param sortingConfiguration
         *        a consumer that will call methods on {@link SortingConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sortingConfiguration(SortingConfiguration)
         */
        default Builder sortingConfiguration(Consumer<SortingConfiguration.Builder> sortingConfiguration) {
            return sortingConfiguration(SortingConfiguration.builder().applyMutation(sortingConfiguration).build());
        }

        /**
         * <p>
         * Provides configuration information to determine how the results of a query are sorted.
         * </p>
         * <p>
         * You can set upto 3 fields that Amazon Kendra should sort the results on, and specify whether the results
         * should be sorted in ascending or descending order. The sort field quota can be increased.
         * </p>
         * <p>
         * If you don't provide a sorting configuration, the results are sorted by the relevance that Amazon Kendra
         * determines for the result. In the case of ties in sorting the results, the results are sorted by relevance.
         * </p>
         * 
         * @param sortingConfigurations
         *        Provides configuration information to determine how the results of a query are sorted.</p>
         *        <p>
         *        You can set upto 3 fields that Amazon Kendra should sort the results on, and specify whether the
         *        results should be sorted in ascending or descending order. The sort field quota can be increased.
         *        </p>
         *        <p>
         *        If you don't provide a sorting configuration, the results are sorted by the relevance that Amazon
         *        Kendra determines for the result. In the case of ties in sorting the results, the results are sorted
         *        by relevance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sortingConfigurations(Collection<SortingConfiguration> sortingConfigurations);

        /**
         * <p>
         * Provides configuration information to determine how the results of a query are sorted.
         * </p>
         * <p>
         * You can set upto 3 fields that Amazon Kendra should sort the results on, and specify whether the results
         * should be sorted in ascending or descending order. The sort field quota can be increased.
         * </p>
         * <p>
         * If you don't provide a sorting configuration, the results are sorted by the relevance that Amazon Kendra
         * determines for the result. In the case of ties in sorting the results, the results are sorted by relevance.
         * </p>
         * 
         * @param sortingConfigurations
         *        Provides configuration information to determine how the results of a query are sorted.</p>
         *        <p>
         *        You can set upto 3 fields that Amazon Kendra should sort the results on, and specify whether the
         *        results should be sorted in ascending or descending order. The sort field quota can be increased.
         *        </p>
         *        <p>
         *        If you don't provide a sorting configuration, the results are sorted by the relevance that Amazon
         *        Kendra determines for the result. In the case of ties in sorting the results, the results are sorted
         *        by relevance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sortingConfigurations(SortingConfiguration... sortingConfigurations);

        /**
         * <p>
         * Provides configuration information to determine how the results of a query are sorted.
         * </p>
         * <p>
         * You can set upto 3 fields that Amazon Kendra should sort the results on, and specify whether the results
         * should be sorted in ascending or descending order. The sort field quota can be increased.
         * </p>
         * <p>
         * If you don't provide a sorting configuration, the results are sorted by the relevance that Amazon Kendra
         * determines for the result. In the case of ties in sorting the results, the results are sorted by relevance.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.kendra.model.SortingConfiguration.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.kendra.model.SortingConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.kendra.model.SortingConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #sortingConfigurations(List<SortingConfiguration>)}.
         * 
         * @param sortingConfigurations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.kendra.model.SortingConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sortingConfigurations(java.util.Collection<SortingConfiguration>)
         */
        Builder sortingConfigurations(Consumer<SortingConfiguration.Builder>... sortingConfigurations);

        /**
         * <p>
         * The user context token or user and group information.
         * </p>
         * 
         * @param userContext
         *        The user context token or user and group information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userContext(UserContext userContext);

        /**
         * <p>
         * The user context token or user and group information.
         * </p>
         * This is a convenience method that creates an instance of the {@link UserContext.Builder} avoiding the need to
         * create one manually via {@link UserContext#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UserContext.Builder#build()} is called immediately and its result
         * is passed to {@link #userContext(UserContext)}.
         * 
         * @param userContext
         *        a consumer that will call methods on {@link UserContext.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #userContext(UserContext)
         */
        default Builder userContext(Consumer<UserContext.Builder> userContext) {
            return userContext(UserContext.builder().applyMutation(userContext).build());
        }

        /**
         * <p>
         * Provides an identifier for a specific user. The <code>VisitorId</code> should be a unique identifier, such as
         * a GUID. Don't use personally identifiable information, such as the user's email address, as the
         * <code>VisitorId</code>.
         * </p>
         * 
         * @param visitorId
         *        Provides an identifier for a specific user. The <code>VisitorId</code> should be a unique identifier,
         *        such as a GUID. Don't use personally identifiable information, such as the user's email address, as
         *        the <code>VisitorId</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder visitorId(String visitorId);

        /**
         * <p>
         * Enables suggested spell corrections for queries.
         * </p>
         * 
         * @param spellCorrectionConfiguration
         *        Enables suggested spell corrections for queries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spellCorrectionConfiguration(SpellCorrectionConfiguration spellCorrectionConfiguration);

        /**
         * <p>
         * Enables suggested spell corrections for queries.
         * </p>
         * This is a convenience method that creates an instance of the {@link SpellCorrectionConfiguration.Builder}
         * avoiding the need to create one manually via {@link SpellCorrectionConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SpellCorrectionConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #spellCorrectionConfiguration(SpellCorrectionConfiguration)}.
         * 
         * @param spellCorrectionConfiguration
         *        a consumer that will call methods on {@link SpellCorrectionConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #spellCorrectionConfiguration(SpellCorrectionConfiguration)
         */
        default Builder spellCorrectionConfiguration(Consumer<SpellCorrectionConfiguration.Builder> spellCorrectionConfiguration) {
            return spellCorrectionConfiguration(SpellCorrectionConfiguration.builder()
                    .applyMutation(spellCorrectionConfiguration).build());
        }

        /**
         * <p>
         * Provides configuration to determine how to group results by document attribute value, and how to display them
         * (collapsed or expanded) under a designated primary document for each group.
         * </p>
         * 
         * @param collapseConfiguration
         *        Provides configuration to determine how to group results by document attribute value, and how to
         *        display them (collapsed or expanded) under a designated primary document for each group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collapseConfiguration(CollapseConfiguration collapseConfiguration);

        /**
         * <p>
         * Provides configuration to determine how to group results by document attribute value, and how to display them
         * (collapsed or expanded) under a designated primary document for each group.
         * </p>
         * This is a convenience method that creates an instance of the {@link CollapseConfiguration.Builder} avoiding
         * the need to create one manually via {@link CollapseConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CollapseConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #collapseConfiguration(CollapseConfiguration)}.
         * 
         * @param collapseConfiguration
         *        a consumer that will call methods on {@link CollapseConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #collapseConfiguration(CollapseConfiguration)
         */
        default Builder collapseConfiguration(Consumer<CollapseConfiguration.Builder> collapseConfiguration) {
            return collapseConfiguration(CollapseConfiguration.builder().applyMutation(collapseConfiguration).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends KendraRequest.BuilderImpl implements Builder {
        private String indexId;

        private String queryText;

        private AttributeFilter attributeFilter;

        private List<Facet> facets = DefaultSdkAutoConstructList.getInstance();

        private List<String> requestedDocumentAttributes = DefaultSdkAutoConstructList.getInstance();

        private String queryResultTypeFilter;

        private List<DocumentRelevanceConfiguration> documentRelevanceOverrideConfigurations = DefaultSdkAutoConstructList
                .getInstance();

        private Integer pageNumber;

        private Integer pageSize;

        private SortingConfiguration sortingConfiguration;

        private List<SortingConfiguration> sortingConfigurations = DefaultSdkAutoConstructList.getInstance();

        private UserContext userContext;

        private String visitorId;

        private SpellCorrectionConfiguration spellCorrectionConfiguration;

        private CollapseConfiguration collapseConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(QueryRequest model) {
            super(model);
            indexId(model.indexId);
            queryText(model.queryText);
            attributeFilter(model.attributeFilter);
            facets(model.facets);
            requestedDocumentAttributes(model.requestedDocumentAttributes);
            queryResultTypeFilter(model.queryResultTypeFilter);
            documentRelevanceOverrideConfigurations(model.documentRelevanceOverrideConfigurations);
            pageNumber(model.pageNumber);
            pageSize(model.pageSize);
            sortingConfiguration(model.sortingConfiguration);
            sortingConfigurations(model.sortingConfigurations);
            userContext(model.userContext);
            visitorId(model.visitorId);
            spellCorrectionConfiguration(model.spellCorrectionConfiguration);
            collapseConfiguration(model.collapseConfiguration);
        }

        public final String getIndexId() {
            return indexId;
        }

        public final void setIndexId(String indexId) {
            this.indexId = indexId;
        }

        @Override
        public final Builder indexId(String indexId) {
            this.indexId = indexId;
            return this;
        }

        public final String getQueryText() {
            return queryText;
        }

        public final void setQueryText(String queryText) {
            this.queryText = queryText;
        }

        @Override
        public final Builder queryText(String queryText) {
            this.queryText = queryText;
            return this;
        }

        public final AttributeFilter.Builder getAttributeFilter() {
            return attributeFilter != null ? attributeFilter.toBuilder() : null;
        }

        public final void setAttributeFilter(AttributeFilter.BuilderImpl attributeFilter) {
            this.attributeFilter = attributeFilter != null ? attributeFilter.build() : null;
        }

        @Override
        public final Builder attributeFilter(AttributeFilter attributeFilter) {
            this.attributeFilter = attributeFilter;
            return this;
        }

        public final List<Facet.Builder> getFacets() {
            List<Facet.Builder> result = FacetListCopier.copyToBuilder(this.facets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFacets(Collection<Facet.BuilderImpl> facets) {
            this.facets = FacetListCopier.copyFromBuilder(facets);
        }

        @Override
        public final Builder facets(Collection<Facet> facets) {
            this.facets = FacetListCopier.copy(facets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder facets(Facet... facets) {
            facets(Arrays.asList(facets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder facets(Consumer<Facet.Builder>... facets) {
            facets(Stream.of(facets).map(c -> Facet.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getRequestedDocumentAttributes() {
            if (requestedDocumentAttributes instanceof SdkAutoConstructList) {
                return null;
            }
            return requestedDocumentAttributes;
        }

        public final void setRequestedDocumentAttributes(Collection<String> requestedDocumentAttributes) {
            this.requestedDocumentAttributes = DocumentAttributeKeyListCopier.copy(requestedDocumentAttributes);
        }

        @Override
        public final Builder requestedDocumentAttributes(Collection<String> requestedDocumentAttributes) {
            this.requestedDocumentAttributes = DocumentAttributeKeyListCopier.copy(requestedDocumentAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder requestedDocumentAttributes(String... requestedDocumentAttributes) {
            requestedDocumentAttributes(Arrays.asList(requestedDocumentAttributes));
            return this;
        }

        public final String getQueryResultTypeFilter() {
            return queryResultTypeFilter;
        }

        public final void setQueryResultTypeFilter(String queryResultTypeFilter) {
            this.queryResultTypeFilter = queryResultTypeFilter;
        }

        @Override
        public final Builder queryResultTypeFilter(String queryResultTypeFilter) {
            this.queryResultTypeFilter = queryResultTypeFilter;
            return this;
        }

        @Override
        public final Builder queryResultTypeFilter(QueryResultType queryResultTypeFilter) {
            this.queryResultTypeFilter(queryResultTypeFilter == null ? null : queryResultTypeFilter.toString());
            return this;
        }

        public final List<DocumentRelevanceConfiguration.Builder> getDocumentRelevanceOverrideConfigurations() {
            List<DocumentRelevanceConfiguration.Builder> result = DocumentRelevanceOverrideConfigurationListCopier
                    .copyToBuilder(this.documentRelevanceOverrideConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDocumentRelevanceOverrideConfigurations(
                Collection<DocumentRelevanceConfiguration.BuilderImpl> documentRelevanceOverrideConfigurations) {
            this.documentRelevanceOverrideConfigurations = DocumentRelevanceOverrideConfigurationListCopier
                    .copyFromBuilder(documentRelevanceOverrideConfigurations);
        }

        @Override
        public final Builder documentRelevanceOverrideConfigurations(
                Collection<DocumentRelevanceConfiguration> documentRelevanceOverrideConfigurations) {
            this.documentRelevanceOverrideConfigurations = DocumentRelevanceOverrideConfigurationListCopier
                    .copy(documentRelevanceOverrideConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder documentRelevanceOverrideConfigurations(
                DocumentRelevanceConfiguration... documentRelevanceOverrideConfigurations) {
            documentRelevanceOverrideConfigurations(Arrays.asList(documentRelevanceOverrideConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder documentRelevanceOverrideConfigurations(
                Consumer<DocumentRelevanceConfiguration.Builder>... documentRelevanceOverrideConfigurations) {
            documentRelevanceOverrideConfigurations(Stream.of(documentRelevanceOverrideConfigurations)
                    .map(c -> DocumentRelevanceConfiguration.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getPageNumber() {
            return pageNumber;
        }

        public final void setPageNumber(Integer pageNumber) {
            this.pageNumber = pageNumber;
        }

        @Override
        public final Builder pageNumber(Integer pageNumber) {
            this.pageNumber = pageNumber;
            return this;
        }

        public final Integer getPageSize() {
            return pageSize;
        }

        public final void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }

        @Override
        public final Builder pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public final SortingConfiguration.Builder getSortingConfiguration() {
            return sortingConfiguration != null ? sortingConfiguration.toBuilder() : null;
        }

        public final void setSortingConfiguration(SortingConfiguration.BuilderImpl sortingConfiguration) {
            this.sortingConfiguration = sortingConfiguration != null ? sortingConfiguration.build() : null;
        }

        @Override
        public final Builder sortingConfiguration(SortingConfiguration sortingConfiguration) {
            this.sortingConfiguration = sortingConfiguration;
            return this;
        }

        public final List<SortingConfiguration.Builder> getSortingConfigurations() {
            List<SortingConfiguration.Builder> result = SortingConfigurationListCopier.copyToBuilder(this.sortingConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSortingConfigurations(Collection<SortingConfiguration.BuilderImpl> sortingConfigurations) {
            this.sortingConfigurations = SortingConfigurationListCopier.copyFromBuilder(sortingConfigurations);
        }

        @Override
        public final Builder sortingConfigurations(Collection<SortingConfiguration> sortingConfigurations) {
            this.sortingConfigurations = SortingConfigurationListCopier.copy(sortingConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sortingConfigurations(SortingConfiguration... sortingConfigurations) {
            sortingConfigurations(Arrays.asList(sortingConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sortingConfigurations(Consumer<SortingConfiguration.Builder>... sortingConfigurations) {
            sortingConfigurations(Stream.of(sortingConfigurations)
                    .map(c -> SortingConfiguration.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final UserContext.Builder getUserContext() {
            return userContext != null ? userContext.toBuilder() : null;
        }

        public final void setUserContext(UserContext.BuilderImpl userContext) {
            this.userContext = userContext != null ? userContext.build() : null;
        }

        @Override
        public final Builder userContext(UserContext userContext) {
            this.userContext = userContext;
            return this;
        }

        public final String getVisitorId() {
            return visitorId;
        }

        public final void setVisitorId(String visitorId) {
            this.visitorId = visitorId;
        }

        @Override
        public final Builder visitorId(String visitorId) {
            this.visitorId = visitorId;
            return this;
        }

        public final SpellCorrectionConfiguration.Builder getSpellCorrectionConfiguration() {
            return spellCorrectionConfiguration != null ? spellCorrectionConfiguration.toBuilder() : null;
        }

        public final void setSpellCorrectionConfiguration(SpellCorrectionConfiguration.BuilderImpl spellCorrectionConfiguration) {
            this.spellCorrectionConfiguration = spellCorrectionConfiguration != null ? spellCorrectionConfiguration.build()
                    : null;
        }

        @Override
        public final Builder spellCorrectionConfiguration(SpellCorrectionConfiguration spellCorrectionConfiguration) {
            this.spellCorrectionConfiguration = spellCorrectionConfiguration;
            return this;
        }

        public final CollapseConfiguration.Builder getCollapseConfiguration() {
            return collapseConfiguration != null ? collapseConfiguration.toBuilder() : null;
        }

        public final void setCollapseConfiguration(CollapseConfiguration.BuilderImpl collapseConfiguration) {
            this.collapseConfiguration = collapseConfiguration != null ? collapseConfiguration.build() : null;
        }

        @Override
        public final Builder collapseConfiguration(CollapseConfiguration collapseConfiguration) {
            this.collapseConfiguration = collapseConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public QueryRequest build() {
            return new QueryRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
