/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.kendra.internal.KendraServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.kendra.model.AccessDeniedException;
import software.amazon.awssdk.services.kendra.model.AssociateEntitiesToExperienceRequest;
import software.amazon.awssdk.services.kendra.model.AssociateEntitiesToExperienceResponse;
import software.amazon.awssdk.services.kendra.model.AssociatePersonasToEntitiesRequest;
import software.amazon.awssdk.services.kendra.model.AssociatePersonasToEntitiesResponse;
import software.amazon.awssdk.services.kendra.model.BatchDeleteDocumentRequest;
import software.amazon.awssdk.services.kendra.model.BatchDeleteDocumentResponse;
import software.amazon.awssdk.services.kendra.model.BatchDeleteFeaturedResultsSetRequest;
import software.amazon.awssdk.services.kendra.model.BatchDeleteFeaturedResultsSetResponse;
import software.amazon.awssdk.services.kendra.model.BatchGetDocumentStatusRequest;
import software.amazon.awssdk.services.kendra.model.BatchGetDocumentStatusResponse;
import software.amazon.awssdk.services.kendra.model.BatchPutDocumentRequest;
import software.amazon.awssdk.services.kendra.model.BatchPutDocumentResponse;
import software.amazon.awssdk.services.kendra.model.ClearQuerySuggestionsRequest;
import software.amazon.awssdk.services.kendra.model.ClearQuerySuggestionsResponse;
import software.amazon.awssdk.services.kendra.model.ConflictException;
import software.amazon.awssdk.services.kendra.model.CreateAccessControlConfigurationRequest;
import software.amazon.awssdk.services.kendra.model.CreateAccessControlConfigurationResponse;
import software.amazon.awssdk.services.kendra.model.CreateDataSourceRequest;
import software.amazon.awssdk.services.kendra.model.CreateDataSourceResponse;
import software.amazon.awssdk.services.kendra.model.CreateExperienceRequest;
import software.amazon.awssdk.services.kendra.model.CreateExperienceResponse;
import software.amazon.awssdk.services.kendra.model.CreateFaqRequest;
import software.amazon.awssdk.services.kendra.model.CreateFaqResponse;
import software.amazon.awssdk.services.kendra.model.CreateFeaturedResultsSetRequest;
import software.amazon.awssdk.services.kendra.model.CreateFeaturedResultsSetResponse;
import software.amazon.awssdk.services.kendra.model.CreateIndexRequest;
import software.amazon.awssdk.services.kendra.model.CreateIndexResponse;
import software.amazon.awssdk.services.kendra.model.CreateQuerySuggestionsBlockListRequest;
import software.amazon.awssdk.services.kendra.model.CreateQuerySuggestionsBlockListResponse;
import software.amazon.awssdk.services.kendra.model.CreateThesaurusRequest;
import software.amazon.awssdk.services.kendra.model.CreateThesaurusResponse;
import software.amazon.awssdk.services.kendra.model.DeleteAccessControlConfigurationRequest;
import software.amazon.awssdk.services.kendra.model.DeleteAccessControlConfigurationResponse;
import software.amazon.awssdk.services.kendra.model.DeleteDataSourceRequest;
import software.amazon.awssdk.services.kendra.model.DeleteDataSourceResponse;
import software.amazon.awssdk.services.kendra.model.DeleteExperienceRequest;
import software.amazon.awssdk.services.kendra.model.DeleteExperienceResponse;
import software.amazon.awssdk.services.kendra.model.DeleteFaqRequest;
import software.amazon.awssdk.services.kendra.model.DeleteFaqResponse;
import software.amazon.awssdk.services.kendra.model.DeleteIndexRequest;
import software.amazon.awssdk.services.kendra.model.DeleteIndexResponse;
import software.amazon.awssdk.services.kendra.model.DeletePrincipalMappingRequest;
import software.amazon.awssdk.services.kendra.model.DeletePrincipalMappingResponse;
import software.amazon.awssdk.services.kendra.model.DeleteQuerySuggestionsBlockListRequest;
import software.amazon.awssdk.services.kendra.model.DeleteQuerySuggestionsBlockListResponse;
import software.amazon.awssdk.services.kendra.model.DeleteThesaurusRequest;
import software.amazon.awssdk.services.kendra.model.DeleteThesaurusResponse;
import software.amazon.awssdk.services.kendra.model.DescribeAccessControlConfigurationRequest;
import software.amazon.awssdk.services.kendra.model.DescribeAccessControlConfigurationResponse;
import software.amazon.awssdk.services.kendra.model.DescribeDataSourceRequest;
import software.amazon.awssdk.services.kendra.model.DescribeDataSourceResponse;
import software.amazon.awssdk.services.kendra.model.DescribeExperienceRequest;
import software.amazon.awssdk.services.kendra.model.DescribeExperienceResponse;
import software.amazon.awssdk.services.kendra.model.DescribeFaqRequest;
import software.amazon.awssdk.services.kendra.model.DescribeFaqResponse;
import software.amazon.awssdk.services.kendra.model.DescribeFeaturedResultsSetRequest;
import software.amazon.awssdk.services.kendra.model.DescribeFeaturedResultsSetResponse;
import software.amazon.awssdk.services.kendra.model.DescribeIndexRequest;
import software.amazon.awssdk.services.kendra.model.DescribeIndexResponse;
import software.amazon.awssdk.services.kendra.model.DescribePrincipalMappingRequest;
import software.amazon.awssdk.services.kendra.model.DescribePrincipalMappingResponse;
import software.amazon.awssdk.services.kendra.model.DescribeQuerySuggestionsBlockListRequest;
import software.amazon.awssdk.services.kendra.model.DescribeQuerySuggestionsBlockListResponse;
import software.amazon.awssdk.services.kendra.model.DescribeQuerySuggestionsConfigRequest;
import software.amazon.awssdk.services.kendra.model.DescribeQuerySuggestionsConfigResponse;
import software.amazon.awssdk.services.kendra.model.DescribeThesaurusRequest;
import software.amazon.awssdk.services.kendra.model.DescribeThesaurusResponse;
import software.amazon.awssdk.services.kendra.model.DisassociateEntitiesFromExperienceRequest;
import software.amazon.awssdk.services.kendra.model.DisassociateEntitiesFromExperienceResponse;
import software.amazon.awssdk.services.kendra.model.DisassociatePersonasFromEntitiesRequest;
import software.amazon.awssdk.services.kendra.model.DisassociatePersonasFromEntitiesResponse;
import software.amazon.awssdk.services.kendra.model.FeaturedResultsConflictException;
import software.amazon.awssdk.services.kendra.model.GetQuerySuggestionsRequest;
import software.amazon.awssdk.services.kendra.model.GetQuerySuggestionsResponse;
import software.amazon.awssdk.services.kendra.model.GetSnapshotsRequest;
import software.amazon.awssdk.services.kendra.model.GetSnapshotsResponse;
import software.amazon.awssdk.services.kendra.model.InternalServerException;
import software.amazon.awssdk.services.kendra.model.InvalidRequestException;
import software.amazon.awssdk.services.kendra.model.KendraException;
import software.amazon.awssdk.services.kendra.model.ListAccessControlConfigurationsRequest;
import software.amazon.awssdk.services.kendra.model.ListAccessControlConfigurationsResponse;
import software.amazon.awssdk.services.kendra.model.ListDataSourceSyncJobsRequest;
import software.amazon.awssdk.services.kendra.model.ListDataSourceSyncJobsResponse;
import software.amazon.awssdk.services.kendra.model.ListDataSourcesRequest;
import software.amazon.awssdk.services.kendra.model.ListDataSourcesResponse;
import software.amazon.awssdk.services.kendra.model.ListEntityPersonasRequest;
import software.amazon.awssdk.services.kendra.model.ListEntityPersonasResponse;
import software.amazon.awssdk.services.kendra.model.ListExperienceEntitiesRequest;
import software.amazon.awssdk.services.kendra.model.ListExperienceEntitiesResponse;
import software.amazon.awssdk.services.kendra.model.ListExperiencesRequest;
import software.amazon.awssdk.services.kendra.model.ListExperiencesResponse;
import software.amazon.awssdk.services.kendra.model.ListFaqsRequest;
import software.amazon.awssdk.services.kendra.model.ListFaqsResponse;
import software.amazon.awssdk.services.kendra.model.ListFeaturedResultsSetsRequest;
import software.amazon.awssdk.services.kendra.model.ListFeaturedResultsSetsResponse;
import software.amazon.awssdk.services.kendra.model.ListGroupsOlderThanOrderingIdRequest;
import software.amazon.awssdk.services.kendra.model.ListGroupsOlderThanOrderingIdResponse;
import software.amazon.awssdk.services.kendra.model.ListIndicesRequest;
import software.amazon.awssdk.services.kendra.model.ListIndicesResponse;
import software.amazon.awssdk.services.kendra.model.ListQuerySuggestionsBlockListsRequest;
import software.amazon.awssdk.services.kendra.model.ListQuerySuggestionsBlockListsResponse;
import software.amazon.awssdk.services.kendra.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.kendra.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.kendra.model.ListThesauriRequest;
import software.amazon.awssdk.services.kendra.model.ListThesauriResponse;
import software.amazon.awssdk.services.kendra.model.PutPrincipalMappingRequest;
import software.amazon.awssdk.services.kendra.model.PutPrincipalMappingResponse;
import software.amazon.awssdk.services.kendra.model.QueryRequest;
import software.amazon.awssdk.services.kendra.model.QueryResponse;
import software.amazon.awssdk.services.kendra.model.ResourceAlreadyExistException;
import software.amazon.awssdk.services.kendra.model.ResourceInUseException;
import software.amazon.awssdk.services.kendra.model.ResourceNotFoundException;
import software.amazon.awssdk.services.kendra.model.ResourceUnavailableException;
import software.amazon.awssdk.services.kendra.model.RetrieveRequest;
import software.amazon.awssdk.services.kendra.model.RetrieveResponse;
import software.amazon.awssdk.services.kendra.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.kendra.model.StartDataSourceSyncJobRequest;
import software.amazon.awssdk.services.kendra.model.StartDataSourceSyncJobResponse;
import software.amazon.awssdk.services.kendra.model.StopDataSourceSyncJobRequest;
import software.amazon.awssdk.services.kendra.model.StopDataSourceSyncJobResponse;
import software.amazon.awssdk.services.kendra.model.SubmitFeedbackRequest;
import software.amazon.awssdk.services.kendra.model.SubmitFeedbackResponse;
import software.amazon.awssdk.services.kendra.model.TagResourceRequest;
import software.amazon.awssdk.services.kendra.model.TagResourceResponse;
import software.amazon.awssdk.services.kendra.model.ThrottlingException;
import software.amazon.awssdk.services.kendra.model.UntagResourceRequest;
import software.amazon.awssdk.services.kendra.model.UntagResourceResponse;
import software.amazon.awssdk.services.kendra.model.UpdateAccessControlConfigurationRequest;
import software.amazon.awssdk.services.kendra.model.UpdateAccessControlConfigurationResponse;
import software.amazon.awssdk.services.kendra.model.UpdateDataSourceRequest;
import software.amazon.awssdk.services.kendra.model.UpdateDataSourceResponse;
import software.amazon.awssdk.services.kendra.model.UpdateExperienceRequest;
import software.amazon.awssdk.services.kendra.model.UpdateExperienceResponse;
import software.amazon.awssdk.services.kendra.model.UpdateFeaturedResultsSetRequest;
import software.amazon.awssdk.services.kendra.model.UpdateFeaturedResultsSetResponse;
import software.amazon.awssdk.services.kendra.model.UpdateIndexRequest;
import software.amazon.awssdk.services.kendra.model.UpdateIndexResponse;
import software.amazon.awssdk.services.kendra.model.UpdateQuerySuggestionsBlockListRequest;
import software.amazon.awssdk.services.kendra.model.UpdateQuerySuggestionsBlockListResponse;
import software.amazon.awssdk.services.kendra.model.UpdateQuerySuggestionsConfigRequest;
import software.amazon.awssdk.services.kendra.model.UpdateQuerySuggestionsConfigResponse;
import software.amazon.awssdk.services.kendra.model.UpdateThesaurusRequest;
import software.amazon.awssdk.services.kendra.model.UpdateThesaurusResponse;
import software.amazon.awssdk.services.kendra.model.ValidationException;
import software.amazon.awssdk.services.kendra.transform.AssociateEntitiesToExperienceRequestMarshaller;
import software.amazon.awssdk.services.kendra.transform.AssociatePersonasToEntitiesRequestMarshaller;
import software.amazon.awssdk.services.kendra.transform.BatchDeleteDocumentRequestMarshaller;
import software.amazon.awssdk.services.kendra.transform.BatchDeleteFeaturedResultsSetRequestMarshaller;
import software.amazon.awssdk.services.kendra.transform.BatchGetDocumentStatusRequestMarshaller;
import software.amazon.awssdk.services.kendra.transform.BatchPutDocumentRequestMarshaller;
import software.amazon.awssdk.services.kendra.transform.ClearQuerySuggestionsRequestMarshaller;
import software.amazon.awssdk.services.kendra.transform.CreateAccessControlConfigurationRequestMarshaller;
import software.amazon.awssdk.services.kendra.transform.CreateDataSourceRequestMarshaller;
import software.amazon.awssdk.services.kendra.transform.CreateExperienceRequestMarshaller;
import software.amazon.awssdk.services.kendra.transform.CreateFaqRequestMarshaller;
import software.amazon.awssdk.services.kendra.transform.CreateFeaturedResultsSetRequestMarshaller;
import software.amazon.awssdk.services.kendra.transform.CreateIndexRequestMarshaller;
import software.amazon.awssdk.services.kendra.transform.CreateQuerySuggestionsBlockListRequestMarshaller;
import software.amazon.awssdk.services.kendra.transform.CreateThesaurusRequestMarshaller;
import software.amazon.awssdk.services.kendra.transform.DeleteAccessControlConfigurationRequestMarshaller;
import software.amazon.awssdk.services.kendra.transform.DeleteDataSourceRequestMarshaller;
import software.amazon.awssdk.services.kendra.transform.DeleteExperienceRequestMarshaller;
import software.amazon.awssdk.services.kendra.transform.DeleteFaqRequestMarshaller;
import software.amazon.awssdk.services.kendra.transform.DeleteIndexRequestMarshaller;
import software.amazon.awssdk.services.kendra.transform.DeletePrincipalMappingRequestMarshaller;
import software.amazon.awssdk.services.kendra.transform.DeleteQuerySuggestionsBlockListRequestMarshaller;
import software.amazon.awssdk.services.kendra.transform.DeleteThesaurusRequestMarshaller;
import software.amazon.awssdk.services.kendra.transform.DescribeAccessControlConfigurationRequestMarshaller;
import software.amazon.awssdk.services.kendra.transform.DescribeDataSourceRequestMarshaller;
import software.amazon.awssdk.services.kendra.transform.DescribeExperienceRequestMarshaller;
import software.amazon.awssdk.services.kendra.transform.DescribeFaqRequestMarshaller;
import software.amazon.awssdk.services.kendra.transform.DescribeFeaturedResultsSetRequestMarshaller;
import software.amazon.awssdk.services.kendra.transform.DescribeIndexRequestMarshaller;
import software.amazon.awssdk.services.kendra.transform.DescribePrincipalMappingRequestMarshaller;
import software.amazon.awssdk.services.kendra.transform.DescribeQuerySuggestionsBlockListRequestMarshaller;
import software.amazon.awssdk.services.kendra.transform.DescribeQuerySuggestionsConfigRequestMarshaller;
import software.amazon.awssdk.services.kendra.transform.DescribeThesaurusRequestMarshaller;
import software.amazon.awssdk.services.kendra.transform.DisassociateEntitiesFromExperienceRequestMarshaller;
import software.amazon.awssdk.services.kendra.transform.DisassociatePersonasFromEntitiesRequestMarshaller;
import software.amazon.awssdk.services.kendra.transform.GetQuerySuggestionsRequestMarshaller;
import software.amazon.awssdk.services.kendra.transform.GetSnapshotsRequestMarshaller;
import software.amazon.awssdk.services.kendra.transform.ListAccessControlConfigurationsRequestMarshaller;
import software.amazon.awssdk.services.kendra.transform.ListDataSourceSyncJobsRequestMarshaller;
import software.amazon.awssdk.services.kendra.transform.ListDataSourcesRequestMarshaller;
import software.amazon.awssdk.services.kendra.transform.ListEntityPersonasRequestMarshaller;
import software.amazon.awssdk.services.kendra.transform.ListExperienceEntitiesRequestMarshaller;
import software.amazon.awssdk.services.kendra.transform.ListExperiencesRequestMarshaller;
import software.amazon.awssdk.services.kendra.transform.ListFaqsRequestMarshaller;
import software.amazon.awssdk.services.kendra.transform.ListFeaturedResultsSetsRequestMarshaller;
import software.amazon.awssdk.services.kendra.transform.ListGroupsOlderThanOrderingIdRequestMarshaller;
import software.amazon.awssdk.services.kendra.transform.ListIndicesRequestMarshaller;
import software.amazon.awssdk.services.kendra.transform.ListQuerySuggestionsBlockListsRequestMarshaller;
import software.amazon.awssdk.services.kendra.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.kendra.transform.ListThesauriRequestMarshaller;
import software.amazon.awssdk.services.kendra.transform.PutPrincipalMappingRequestMarshaller;
import software.amazon.awssdk.services.kendra.transform.QueryRequestMarshaller;
import software.amazon.awssdk.services.kendra.transform.RetrieveRequestMarshaller;
import software.amazon.awssdk.services.kendra.transform.StartDataSourceSyncJobRequestMarshaller;
import software.amazon.awssdk.services.kendra.transform.StopDataSourceSyncJobRequestMarshaller;
import software.amazon.awssdk.services.kendra.transform.SubmitFeedbackRequestMarshaller;
import software.amazon.awssdk.services.kendra.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.kendra.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.kendra.transform.UpdateAccessControlConfigurationRequestMarshaller;
import software.amazon.awssdk.services.kendra.transform.UpdateDataSourceRequestMarshaller;
import software.amazon.awssdk.services.kendra.transform.UpdateExperienceRequestMarshaller;
import software.amazon.awssdk.services.kendra.transform.UpdateFeaturedResultsSetRequestMarshaller;
import software.amazon.awssdk.services.kendra.transform.UpdateIndexRequestMarshaller;
import software.amazon.awssdk.services.kendra.transform.UpdateQuerySuggestionsBlockListRequestMarshaller;
import software.amazon.awssdk.services.kendra.transform.UpdateQuerySuggestionsConfigRequestMarshaller;
import software.amazon.awssdk.services.kendra.transform.UpdateThesaurusRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

/**
 * Internal implementation of {@link KendraAsyncClient}.
 *
 * @see KendraAsyncClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultKendraAsyncClient implements KendraAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultKendraAsyncClient.class);

    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder()
            .serviceProtocol(AwsServiceProtocol.AWS_JSON).build();

    private final AsyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultKendraAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option(SdkClientOption.SDK_CLIENT, this).build();
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    /**
     * <p>
     * Grants users or groups in your IAM Identity Center identity source access to your Amazon Kendra experience. You
     * can create an Amazon Kendra experience such as a search application. For more information on creating a search
     * application experience, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html">Building a search
     * experience with no code</a>.
     * </p>
     *
     * @param associateEntitiesToExperienceRequest
     * @return A Java Future containing the result of the AssociateEntitiesToExperience operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>ResourceAlreadyExistException The resource you want to use already exists. Please check you have
     *         provided the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.AssociateEntitiesToExperience
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/AssociateEntitiesToExperience"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AssociateEntitiesToExperienceResponse> associateEntitiesToExperience(
            AssociateEntitiesToExperienceRequest associateEntitiesToExperienceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(associateEntitiesToExperienceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                associateEntitiesToExperienceRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "kendra");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateEntitiesToExperience");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AssociateEntitiesToExperienceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AssociateEntitiesToExperienceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AssociateEntitiesToExperienceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AssociateEntitiesToExperienceRequest, AssociateEntitiesToExperienceResponse>()
                            .withOperationName("AssociateEntitiesToExperience").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AssociateEntitiesToExperienceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(associateEntitiesToExperienceRequest));
            CompletableFuture<AssociateEntitiesToExperienceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Defines the specific permissions of users or groups in your IAM Identity Center identity source with access to
     * your Amazon Kendra experience. You can create an Amazon Kendra experience such as a search application. For more
     * information on creating a search application experience, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html">Building a search
     * experience with no code</a>.
     * </p>
     *
     * @param associatePersonasToEntitiesRequest
     * @return A Java Future containing the result of the AssociatePersonasToEntities operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>ResourceAlreadyExistException The resource you want to use already exists. Please check you have
     *         provided the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.AssociatePersonasToEntities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/AssociatePersonasToEntities"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AssociatePersonasToEntitiesResponse> associatePersonasToEntities(
            AssociatePersonasToEntitiesRequest associatePersonasToEntitiesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(associatePersonasToEntitiesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, associatePersonasToEntitiesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "kendra");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociatePersonasToEntities");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AssociatePersonasToEntitiesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AssociatePersonasToEntitiesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AssociatePersonasToEntitiesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AssociatePersonasToEntitiesRequest, AssociatePersonasToEntitiesResponse>()
                            .withOperationName("AssociatePersonasToEntities").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AssociatePersonasToEntitiesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(associatePersonasToEntitiesRequest));
            CompletableFuture<AssociatePersonasToEntitiesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes one or more documents from an index. The documents must have been added with the
     * <code>BatchPutDocument</code> API.
     * </p>
     * <p>
     * The documents are deleted asynchronously. You can see the progress of the deletion by using Amazon Web Services
     * CloudWatch. Any error messages related to the processing of the batch are sent to your Amazon Web Services
     * CloudWatch log. You can also use the <code>BatchGetDocumentStatus</code> API to monitor the progress of deleting
     * your documents.
     * </p>
     * <p>
     * Deleting documents from an index using <code>BatchDeleteDocument</code> could take up to an hour or more,
     * depending on the number of documents you want to delete.
     * </p>
     *
     * @param batchDeleteDocumentRequest
     * @return A Java Future containing the result of the BatchDeleteDocument operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ConflictException A conflict occurred with the request. Please fix any inconsistences with your
     *         resources and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.BatchDeleteDocument
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/BatchDeleteDocument" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<BatchDeleteDocumentResponse> batchDeleteDocument(
            BatchDeleteDocumentRequest batchDeleteDocumentRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchDeleteDocumentRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, batchDeleteDocumentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "kendra");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchDeleteDocument");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<BatchDeleteDocumentResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, BatchDeleteDocumentResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<BatchDeleteDocumentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<BatchDeleteDocumentRequest, BatchDeleteDocumentResponse>()
                            .withOperationName("BatchDeleteDocument").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new BatchDeleteDocumentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(batchDeleteDocumentRequest));
            CompletableFuture<BatchDeleteDocumentResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes one or more sets of featured results. Features results are placed above all other results for certain
     * queries. If there's an exact match of a query, then one or more specific documents are featured in the search
     * results.
     * </p>
     *
     * @param batchDeleteFeaturedResultsSetRequest
     * @return A Java Future containing the result of the BatchDeleteFeaturedResultsSet operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.BatchDeleteFeaturedResultsSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/BatchDeleteFeaturedResultsSet"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<BatchDeleteFeaturedResultsSetResponse> batchDeleteFeaturedResultsSet(
            BatchDeleteFeaturedResultsSetRequest batchDeleteFeaturedResultsSetRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchDeleteFeaturedResultsSetRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                batchDeleteFeaturedResultsSetRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "kendra");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchDeleteFeaturedResultsSet");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<BatchDeleteFeaturedResultsSetResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, BatchDeleteFeaturedResultsSetResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<BatchDeleteFeaturedResultsSetResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<BatchDeleteFeaturedResultsSetRequest, BatchDeleteFeaturedResultsSetResponse>()
                            .withOperationName("BatchDeleteFeaturedResultsSet").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new BatchDeleteFeaturedResultsSetRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(batchDeleteFeaturedResultsSetRequest));
            CompletableFuture<BatchDeleteFeaturedResultsSetResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the indexing status for one or more documents submitted with the <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/API_BatchPutDocument.html"> BatchPutDocument</a> API.
     * </p>
     * <p>
     * When you use the <code>BatchPutDocument</code> API, documents are indexed asynchronously. You can use the
     * <code>BatchGetDocumentStatus</code> API to get the current status of a list of documents so that you can
     * determine if they have been successfully indexed.
     * </p>
     * <p>
     * You can also use the <code>BatchGetDocumentStatus</code> API to check the status of the <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/API_BatchDeleteDocument.html"> BatchDeleteDocument</a> API.
     * When a document is deleted from the index, Amazon Kendra returns <code>NOT_FOUND</code> as the status.
     * </p>
     *
     * @param batchGetDocumentStatusRequest
     * @return A Java Future containing the result of the BatchGetDocumentStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ConflictException A conflict occurred with the request. Please fix any inconsistences with your
     *         resources and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.BatchGetDocumentStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/BatchGetDocumentStatus" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<BatchGetDocumentStatusResponse> batchGetDocumentStatus(
            BatchGetDocumentStatusRequest batchGetDocumentStatusRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchGetDocumentStatusRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, batchGetDocumentStatusRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "kendra");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchGetDocumentStatus");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<BatchGetDocumentStatusResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, BatchGetDocumentStatusResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<BatchGetDocumentStatusResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<BatchGetDocumentStatusRequest, BatchGetDocumentStatusResponse>()
                            .withOperationName("BatchGetDocumentStatus").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new BatchGetDocumentStatusRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(batchGetDocumentStatusRequest));
            CompletableFuture<BatchGetDocumentStatusResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Adds one or more documents to an index.
     * </p>
     * <p>
     * The <code>BatchPutDocument</code> API enables you to ingest inline documents or a set of documents stored in an
     * Amazon S3 bucket. Use this API to ingest your text and unstructured text into an index, add custom attributes to
     * the documents, and to attach an access control list to the documents added to the index.
     * </p>
     * <p>
     * The documents are indexed asynchronously. You can see the progress of the batch using Amazon Web Services
     * CloudWatch. Any error messages related to processing the batch are sent to your Amazon Web Services CloudWatch
     * log. You can also use the <code>BatchGetDocumentStatus</code> API to monitor the progress of indexing your
     * documents.
     * </p>
     * <p>
     * For an example of ingesting inline documents using Python and Java SDKs, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/in-adding-binary-doc.html">Adding files directly to an
     * index</a>.
     * </p>
     *
     * @param batchPutDocumentRequest
     * @return A Java Future containing the result of the BatchPutDocument operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ConflictException A conflict occurred with the request. Please fix any inconsistences with your
     *         resources and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>ServiceQuotaExceededException You have exceeded the set limits for your Amazon Kendra service. Please
     *         see <a href="https://docs.aws.amazon.com/kendra/latest/dg/quotas.html">Quotas</a> for more information,
     *         or contact <a href="http://aws.amazon.com/contact-us/">Support</a> to inquire about an increase of
     *         limits.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.BatchPutDocument
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/BatchPutDocument" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<BatchPutDocumentResponse> batchPutDocument(BatchPutDocumentRequest batchPutDocumentRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchPutDocumentRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, batchPutDocumentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "kendra");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchPutDocument");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<BatchPutDocumentResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, BatchPutDocumentResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<BatchPutDocumentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<BatchPutDocumentRequest, BatchPutDocumentResponse>()
                            .withOperationName("BatchPutDocument").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new BatchPutDocumentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(batchPutDocumentRequest));
            CompletableFuture<BatchPutDocumentResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Clears existing query suggestions from an index.
     * </p>
     * <p>
     * This deletes existing suggestions only, not the queries in the query log. After you clear suggestions, Amazon
     * Kendra learns new suggestions based on new queries added to the query log from the time you cleared suggestions.
     * If you do not see any new suggestions, then please allow Amazon Kendra to collect enough queries to learn new
     * suggestions.
     * </p>
     * <p>
     * <code>ClearQuerySuggestions</code> is currently not supported in the Amazon Web Services GovCloud (US-West)
     * region.
     * </p>
     *
     * @param clearQuerySuggestionsRequest
     * @return A Java Future containing the result of the ClearQuerySuggestions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>ConflictException A conflict occurred with the request. Please fix any inconsistences with your
     *         resources and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.ClearQuerySuggestions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/ClearQuerySuggestions" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ClearQuerySuggestionsResponse> clearQuerySuggestions(
            ClearQuerySuggestionsRequest clearQuerySuggestionsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(clearQuerySuggestionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, clearQuerySuggestionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "kendra");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ClearQuerySuggestions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ClearQuerySuggestionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ClearQuerySuggestionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ClearQuerySuggestionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ClearQuerySuggestionsRequest, ClearQuerySuggestionsResponse>()
                            .withOperationName("ClearQuerySuggestions").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ClearQuerySuggestionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(clearQuerySuggestionsRequest));
            CompletableFuture<ClearQuerySuggestionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an access configuration for your documents. This includes user and group access information for your
     * documents. This is useful for user context filtering, where search results are filtered based on the user or
     * their group access to documents.
     * </p>
     * <p>
     * You can use this to re-configure your existing document level access control without indexing all of your
     * documents again. For example, your index contains top-secret company documents that only certain employees or
     * users should access. One of these users leaves the company or switches to a team that should be blocked from
     * accessing top-secret documents. The user still has access to top-secret documents because the user had access
     * when your documents were previously indexed. You can create a specific access control configuration for the user
     * with deny access. You can later update the access control configuration to allow access if the user returns to
     * the company and re-joins the 'top-secret' team. You can re-configure access control for your documents as
     * circumstances change.
     * </p>
     * <p>
     * To apply your access control configuration to certain documents, you call the <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/API_BatchPutDocument.html">BatchPutDocument</a> API with the
     * <code>AccessControlConfigurationId</code> included in the <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/API_Document.html">Document</a> object. If you use an S3
     * bucket as a data source, you update the <code>.metadata.json</code> with the
     * <code>AccessControlConfigurationId</code> and synchronize your data source. Amazon Kendra currently only supports
     * access control configuration for S3 data sources and documents indexed using the <code>BatchPutDocument</code>
     * API.
     * </p>
     *
     * @param createAccessControlConfigurationRequest
     * @return A Java Future containing the result of the CreateAccessControlConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException You have exceeded the set limits for your Amazon Kendra service. Please
     *         see <a href="https://docs.aws.amazon.com/kendra/latest/dg/quotas.html">Quotas</a> for more information,
     *         or contact <a href="http://aws.amazon.com/contact-us/">Support</a> to inquire about an increase of
     *         limits.</li>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>ConflictException A conflict occurred with the request. Please fix any inconsistences with your
     *         resources and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.CreateAccessControlConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/CreateAccessControlConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateAccessControlConfigurationResponse> createAccessControlConfiguration(
            CreateAccessControlConfigurationRequest createAccessControlConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createAccessControlConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createAccessControlConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "kendra");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateAccessControlConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateAccessControlConfigurationResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, CreateAccessControlConfigurationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateAccessControlConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateAccessControlConfigurationRequest, CreateAccessControlConfigurationResponse>()
                            .withOperationName("CreateAccessControlConfiguration").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateAccessControlConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createAccessControlConfigurationRequest));
            CompletableFuture<CreateAccessControlConfigurationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a data source connector that you want to use with an Amazon Kendra index.
     * </p>
     * <p>
     * You specify a name, data source connector type and description for your data source. You also specify
     * configuration information for the data source connector.
     * </p>
     * <p>
     * <code>CreateDataSource</code> is a synchronous operation. The operation returns 200 if the data source was
     * successfully created. Otherwise, an exception is raised.
     * </p>
     * <p>
     * For an example of creating an index and data source using the Python SDK, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/gs-python.html">Getting started with Python SDK</a>. For an
     * example of creating an index and data source using the Java SDK, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/gs-java.html">Getting started with Java SDK</a>.
     * </p>
     *
     * @param createDataSourceRequest
     * @return A Java Future containing the result of the CreateDataSource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ConflictException A conflict occurred with the request. Please fix any inconsistences with your
     *         resources and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>ResourceAlreadyExistException The resource you want to use already exists. Please check you have
     *         provided the correct resource and try again.</li>
     *         <li>ServiceQuotaExceededException You have exceeded the set limits for your Amazon Kendra service. Please
     *         see <a href="https://docs.aws.amazon.com/kendra/latest/dg/quotas.html">Quotas</a> for more information,
     *         or contact <a href="http://aws.amazon.com/contact-us/">Support</a> to inquire about an increase of
     *         limits.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.CreateDataSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/CreateDataSource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateDataSourceResponse> createDataSource(CreateDataSourceRequest createDataSourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createDataSourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createDataSourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "kendra");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDataSource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateDataSourceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateDataSourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateDataSourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateDataSourceRequest, CreateDataSourceResponse>()
                            .withOperationName("CreateDataSource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateDataSourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createDataSourceRequest));
            CompletableFuture<CreateDataSourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an Amazon Kendra experience such as a search application. For more information on creating a search
     * application experience, including using the Python and Java SDKs, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html">Building a search
     * experience with no code</a>.
     * </p>
     *
     * @param createExperienceRequest
     * @return A Java Future containing the result of the CreateExperience operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ConflictException A conflict occurred with the request. Please fix any inconsistences with your
     *         resources and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>ServiceQuotaExceededException You have exceeded the set limits for your Amazon Kendra service. Please
     *         see <a href="https://docs.aws.amazon.com/kendra/latest/dg/quotas.html">Quotas</a> for more information,
     *         or contact <a href="http://aws.amazon.com/contact-us/">Support</a> to inquire about an increase of
     *         limits.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.CreateExperience
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/CreateExperience" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateExperienceResponse> createExperience(CreateExperienceRequest createExperienceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createExperienceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createExperienceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "kendra");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateExperience");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateExperienceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateExperienceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateExperienceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateExperienceRequest, CreateExperienceResponse>()
                            .withOperationName("CreateExperience").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateExperienceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createExperienceRequest));
            CompletableFuture<CreateExperienceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a set of frequently ask questions (FAQs) using a specified FAQ file stored in an Amazon S3 bucket.
     * </p>
     * <p>
     * Adding FAQs to an index is an asynchronous operation.
     * </p>
     * <p>
     * For an example of adding an FAQ to an index using Python and Java SDKs, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/in-creating-faq.html#using-faq-file">Using your FAQ file</a>.
     * </p>
     *
     * @param createFaqRequest
     * @return A Java Future containing the result of the CreateFaq operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ConflictException A conflict occurred with the request. Please fix any inconsistences with your
     *         resources and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>ServiceQuotaExceededException You have exceeded the set limits for your Amazon Kendra service. Please
     *         see <a href="https://docs.aws.amazon.com/kendra/latest/dg/quotas.html">Quotas</a> for more information,
     *         or contact <a href="http://aws.amazon.com/contact-us/">Support</a> to inquire about an increase of
     *         limits.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.CreateFaq
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/CreateFaq" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateFaqResponse> createFaq(CreateFaqRequest createFaqRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createFaqRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createFaqRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "kendra");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateFaq");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateFaqResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateFaqResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateFaqResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateFaqRequest, CreateFaqResponse>().withOperationName("CreateFaq")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateFaqRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withMetricCollector(apiCallMetricCollector).withInput(createFaqRequest));
            CompletableFuture<CreateFaqResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a set of featured results to display at the top of the search results page. Featured results are placed
     * above all other results for certain queries. You map specific queries to specific documents for featuring in the
     * results. If a query contains an exact match, then one or more specific documents are featured in the search
     * results.
     * </p>
     * <p>
     * You can create up to 50 sets of featured results per index. You can request to increase this limit by contacting
     * <a href="http://aws.amazon.com/contact-us/">Support</a>.
     * </p>
     *
     * @param createFeaturedResultsSetRequest
     * @return A Java Future containing the result of the CreateFeaturedResultsSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>FeaturedResultsConflictException An error message with a list of conflicting queries used across
     *         different sets of featured results. This occurred with the request for a new featured results set. Check
     *         that the queries you specified for featured results are unique per featured results set for each index.</li>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>ConflictException A conflict occurred with the request. Please fix any inconsistences with your
     *         resources and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.CreateFeaturedResultsSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/CreateFeaturedResultsSet"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateFeaturedResultsSetResponse> createFeaturedResultsSet(
            CreateFeaturedResultsSetRequest createFeaturedResultsSetRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createFeaturedResultsSetRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createFeaturedResultsSetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "kendra");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateFeaturedResultsSet");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateFeaturedResultsSetResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateFeaturedResultsSetResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateFeaturedResultsSetResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateFeaturedResultsSetRequest, CreateFeaturedResultsSetResponse>()
                            .withOperationName("CreateFeaturedResultsSet").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateFeaturedResultsSetRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createFeaturedResultsSetRequest));
            CompletableFuture<CreateFeaturedResultsSetResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an Amazon Kendra index. Index creation is an asynchronous API. To determine if index creation has
     * completed, check the <code>Status</code> field returned from a call to <code>DescribeIndex</code>. The
     * <code>Status</code> field is set to <code>ACTIVE</code> when the index is ready to use.
     * </p>
     * <p>
     * Once the index is active, you can index your documents using the <code>BatchPutDocument</code> API or using one
     * of the supported <a href="https://docs.aws.amazon.com/kendra/latest/dg/data-sources.html">data sources</a>.
     * </p>
     * <p>
     * For an example of creating an index and data source using the Python SDK, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/gs-python.html">Getting started with Python SDK</a>. For an
     * example of creating an index and data source using the Java SDK, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/gs-java.html">Getting started with Java SDK</a>.
     * </p>
     *
     * @param createIndexRequest
     * @return A Java Future containing the result of the CreateIndex operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ResourceAlreadyExistException The resource you want to use already exists. Please check you have
     *         provided the correct resource and try again.</li>
     *         <li>ServiceQuotaExceededException You have exceeded the set limits for your Amazon Kendra service. Please
     *         see <a href="https://docs.aws.amazon.com/kendra/latest/dg/quotas.html">Quotas</a> for more information,
     *         or contact <a href="http://aws.amazon.com/contact-us/">Support</a> to inquire about an increase of
     *         limits.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>ConflictException A conflict occurred with the request. Please fix any inconsistences with your
     *         resources and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.CreateIndex
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/CreateIndex" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateIndexResponse> createIndex(CreateIndexRequest createIndexRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createIndexRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createIndexRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "kendra");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateIndex");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateIndexResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateIndexResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateIndexResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateIndexRequest, CreateIndexResponse>()
                            .withOperationName("CreateIndex").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateIndexRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createIndexRequest));
            CompletableFuture<CreateIndexResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a block list to exlcude certain queries from suggestions.
     * </p>
     * <p>
     * Any query that contains words or phrases specified in the block list is blocked or filtered out from being shown
     * as a suggestion.
     * </p>
     * <p>
     * You need to provide the file location of your block list text file in your S3 bucket. In your text file, enter
     * each block word or phrase on a separate line.
     * </p>
     * <p>
     * For information on the current quota limits for block lists, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/quotas.html">Quotas for Amazon Kendra</a>.
     * </p>
     * <p>
     * <code>CreateQuerySuggestionsBlockList</code> is currently not supported in the Amazon Web Services GovCloud
     * (US-West) region.
     * </p>
     * <p>
     * For an example of creating a block list for query suggestions using the Python SDK, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/query-suggestions.html#query-suggestions-blocklist">Query
     * suggestions block list</a>.
     * </p>
     *
     * @param createQuerySuggestionsBlockListRequest
     * @return A Java Future containing the result of the CreateQuerySuggestionsBlockList operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>ServiceQuotaExceededException You have exceeded the set limits for your Amazon Kendra service. Please
     *         see <a href="https://docs.aws.amazon.com/kendra/latest/dg/quotas.html">Quotas</a> for more information,
     *         or contact <a href="http://aws.amazon.com/contact-us/">Support</a> to inquire about an increase of
     *         limits.</li>
     *         <li>ConflictException A conflict occurred with the request. Please fix any inconsistences with your
     *         resources and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.CreateQuerySuggestionsBlockList
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/CreateQuerySuggestionsBlockList"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateQuerySuggestionsBlockListResponse> createQuerySuggestionsBlockList(
            CreateQuerySuggestionsBlockListRequest createQuerySuggestionsBlockListRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createQuerySuggestionsBlockListRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createQuerySuggestionsBlockListRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "kendra");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateQuerySuggestionsBlockList");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateQuerySuggestionsBlockListResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateQuerySuggestionsBlockListResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateQuerySuggestionsBlockListResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateQuerySuggestionsBlockListRequest, CreateQuerySuggestionsBlockListResponse>()
                            .withOperationName("CreateQuerySuggestionsBlockList").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateQuerySuggestionsBlockListRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createQuerySuggestionsBlockListRequest));
            CompletableFuture<CreateQuerySuggestionsBlockListResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a thesaurus for an index. The thesaurus contains a list of synonyms in Solr format.
     * </p>
     * <p>
     * For an example of adding a thesaurus file to an index, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/index-synonyms-adding-thesaurus-file.html">Adding custom
     * synonyms to an index</a>.
     * </p>
     *
     * @param createThesaurusRequest
     * @return A Java Future containing the result of the CreateThesaurus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ConflictException A conflict occurred with the request. Please fix any inconsistences with your
     *         resources and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>ServiceQuotaExceededException You have exceeded the set limits for your Amazon Kendra service. Please
     *         see <a href="https://docs.aws.amazon.com/kendra/latest/dg/quotas.html">Quotas</a> for more information,
     *         or contact <a href="http://aws.amazon.com/contact-us/">Support</a> to inquire about an increase of
     *         limits.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.CreateThesaurus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/CreateThesaurus" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateThesaurusResponse> createThesaurus(CreateThesaurusRequest createThesaurusRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createThesaurusRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createThesaurusRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "kendra");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateThesaurus");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateThesaurusResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateThesaurusResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateThesaurusResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateThesaurusRequest, CreateThesaurusResponse>()
                            .withOperationName("CreateThesaurus").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateThesaurusRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createThesaurusRequest));
            CompletableFuture<CreateThesaurusResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an access control configuration that you created for your documents in an index. This includes user and
     * group access information for your documents. This is useful for user context filtering, where search results are
     * filtered based on the user or their group access to documents.
     * </p>
     *
     * @param deleteAccessControlConfigurationRequest
     * @return A Java Future containing the result of the DeleteAccessControlConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>ConflictException A conflict occurred with the request. Please fix any inconsistences with your
     *         resources and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.DeleteAccessControlConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/DeleteAccessControlConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteAccessControlConfigurationResponse> deleteAccessControlConfiguration(
            DeleteAccessControlConfigurationRequest deleteAccessControlConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteAccessControlConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteAccessControlConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "kendra");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteAccessControlConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteAccessControlConfigurationResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DeleteAccessControlConfigurationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteAccessControlConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteAccessControlConfigurationRequest, DeleteAccessControlConfigurationResponse>()
                            .withOperationName("DeleteAccessControlConfiguration").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteAccessControlConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteAccessControlConfigurationRequest));
            CompletableFuture<DeleteAccessControlConfigurationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an Amazon Kendra data source connector. An exception is not thrown if the data source is already being
     * deleted. While the data source is being deleted, the <code>Status</code> field returned by a call to the
     * <code>DescribeDataSource</code> API is set to <code>DELETING</code>. For more information, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/delete-data-source.html">Deleting Data Sources</a>.
     * </p>
     * <p>
     * Deleting an entire data source or re-syncing your index after deleting specific documents from a data source
     * could take up to an hour or more, depending on the number of documents you want to delete.
     * </p>
     *
     * @param deleteDataSourceRequest
     * @return A Java Future containing the result of the DeleteDataSource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ConflictException A conflict occurred with the request. Please fix any inconsistences with your
     *         resources and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.DeleteDataSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/DeleteDataSource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteDataSourceResponse> deleteDataSource(DeleteDataSourceRequest deleteDataSourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteDataSourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteDataSourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "kendra");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDataSource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteDataSourceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteDataSourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteDataSourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteDataSourceRequest, DeleteDataSourceResponse>()
                            .withOperationName("DeleteDataSource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteDataSourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteDataSourceRequest));
            CompletableFuture<DeleteDataSourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes your Amazon Kendra experience such as a search application. For more information on creating a search
     * application experience, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html">Building a search
     * experience with no code</a>.
     * </p>
     *
     * @param deleteExperienceRequest
     * @return A Java Future containing the result of the DeleteExperience operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ConflictException A conflict occurred with the request. Please fix any inconsistences with your
     *         resources and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.DeleteExperience
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/DeleteExperience" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteExperienceResponse> deleteExperience(DeleteExperienceRequest deleteExperienceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteExperienceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteExperienceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "kendra");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteExperience");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteExperienceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteExperienceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteExperienceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteExperienceRequest, DeleteExperienceResponse>()
                            .withOperationName("DeleteExperience").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteExperienceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteExperienceRequest));
            CompletableFuture<DeleteExperienceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes an FAQ from an index.
     * </p>
     *
     * @param deleteFaqRequest
     * @return A Java Future containing the result of the DeleteFaq operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ConflictException A conflict occurred with the request. Please fix any inconsistences with your
     *         resources and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.DeleteFaq
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/DeleteFaq" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteFaqResponse> deleteFaq(DeleteFaqRequest deleteFaqRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteFaqRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteFaqRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "kendra");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteFaq");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteFaqResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteFaqResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteFaqResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteFaqRequest, DeleteFaqResponse>().withOperationName("DeleteFaq")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteFaqRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteFaqRequest));
            CompletableFuture<DeleteFaqResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an Amazon Kendra index. An exception is not thrown if the index is already being deleted. While the index
     * is being deleted, the <code>Status</code> field returned by a call to the <code>DescribeIndex</code> API is set
     * to <code>DELETING</code>.
     * </p>
     *
     * @param deleteIndexRequest
     * @return A Java Future containing the result of the DeleteIndex operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ConflictException A conflict occurred with the request. Please fix any inconsistences with your
     *         resources and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.DeleteIndex
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/DeleteIndex" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteIndexResponse> deleteIndex(DeleteIndexRequest deleteIndexRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteIndexRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteIndexRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "kendra");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteIndex");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteIndexResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteIndexResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteIndexResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteIndexRequest, DeleteIndexResponse>()
                            .withOperationName("DeleteIndex").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteIndexRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteIndexRequest));
            CompletableFuture<DeleteIndexResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a group so that all users and sub groups that belong to the group can no longer access documents only
     * available to that group.
     * </p>
     * <p>
     * For example, after deleting the group "Summer Interns", all interns who belonged to that group no longer see
     * intern-only documents in their search results.
     * </p>
     * <p>
     * If you want to delete or replace users or sub groups of a group, you need to use the
     * <code>PutPrincipalMapping</code> operation. For example, if a user in the group "Engineering" leaves the
     * engineering team and another user takes their place, you provide an updated list of users or sub groups that
     * belong to the "Engineering" group when calling <code>PutPrincipalMapping</code>. You can update your internal
     * list of users or sub groups and input this list when calling <code>PutPrincipalMapping</code>.
     * </p>
     * <p>
     * <code>DeletePrincipalMapping</code> is currently not supported in the Amazon Web Services GovCloud (US-West)
     * region.
     * </p>
     *
     * @param deletePrincipalMappingRequest
     * @return A Java Future containing the result of the DeletePrincipalMapping operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ConflictException A conflict occurred with the request. Please fix any inconsistences with your
     *         resources and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.DeletePrincipalMapping
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/DeletePrincipalMapping" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeletePrincipalMappingResponse> deletePrincipalMapping(
            DeletePrincipalMappingRequest deletePrincipalMappingRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deletePrincipalMappingRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deletePrincipalMappingRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "kendra");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeletePrincipalMapping");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeletePrincipalMappingResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeletePrincipalMappingResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeletePrincipalMappingResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeletePrincipalMappingRequest, DeletePrincipalMappingResponse>()
                            .withOperationName("DeletePrincipalMapping").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeletePrincipalMappingRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deletePrincipalMappingRequest));
            CompletableFuture<DeletePrincipalMappingResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a block list used for query suggestions for an index.
     * </p>
     * <p>
     * A deleted block list might not take effect right away. Amazon Kendra needs to refresh the entire suggestions list
     * to add back the queries that were previously blocked.
     * </p>
     * <p>
     * <code>DeleteQuerySuggestionsBlockList</code> is currently not supported in the Amazon Web Services GovCloud
     * (US-West) region.
     * </p>
     *
     * @param deleteQuerySuggestionsBlockListRequest
     * @return A Java Future containing the result of the DeleteQuerySuggestionsBlockList operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>ConflictException A conflict occurred with the request. Please fix any inconsistences with your
     *         resources and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.DeleteQuerySuggestionsBlockList
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/DeleteQuerySuggestionsBlockList"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteQuerySuggestionsBlockListResponse> deleteQuerySuggestionsBlockList(
            DeleteQuerySuggestionsBlockListRequest deleteQuerySuggestionsBlockListRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteQuerySuggestionsBlockListRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteQuerySuggestionsBlockListRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "kendra");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteQuerySuggestionsBlockList");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteQuerySuggestionsBlockListResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteQuerySuggestionsBlockListResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteQuerySuggestionsBlockListResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteQuerySuggestionsBlockListRequest, DeleteQuerySuggestionsBlockListResponse>()
                            .withOperationName("DeleteQuerySuggestionsBlockList").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteQuerySuggestionsBlockListRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteQuerySuggestionsBlockListRequest));
            CompletableFuture<DeleteQuerySuggestionsBlockListResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an Amazon Kendra thesaurus.
     * </p>
     *
     * @param deleteThesaurusRequest
     * @return A Java Future containing the result of the DeleteThesaurus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ConflictException A conflict occurred with the request. Please fix any inconsistences with your
     *         resources and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.DeleteThesaurus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/DeleteThesaurus" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteThesaurusResponse> deleteThesaurus(DeleteThesaurusRequest deleteThesaurusRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteThesaurusRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteThesaurusRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "kendra");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteThesaurus");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteThesaurusResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteThesaurusResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteThesaurusResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteThesaurusRequest, DeleteThesaurusResponse>()
                            .withOperationName("DeleteThesaurus").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteThesaurusRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteThesaurusRequest));
            CompletableFuture<DeleteThesaurusResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about an access control configuration that you created for your documents in an index. This
     * includes user and group access information for your documents. This is useful for user context filtering, where
     * search results are filtered based on the user or their group access to documents.
     * </p>
     *
     * @param describeAccessControlConfigurationRequest
     * @return A Java Future containing the result of the DescribeAccessControlConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.DescribeAccessControlConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/DescribeAccessControlConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeAccessControlConfigurationResponse> describeAccessControlConfiguration(
            DescribeAccessControlConfigurationRequest describeAccessControlConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeAccessControlConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeAccessControlConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "kendra");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeAccessControlConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeAccessControlConfigurationResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DescribeAccessControlConfigurationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeAccessControlConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeAccessControlConfigurationRequest, DescribeAccessControlConfigurationResponse>()
                            .withOperationName("DescribeAccessControlConfiguration").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeAccessControlConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeAccessControlConfigurationRequest));
            CompletableFuture<DescribeAccessControlConfigurationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about an Amazon Kendra data source connector.
     * </p>
     *
     * @param describeDataSourceRequest
     * @return A Java Future containing the result of the DescribeDataSource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.DescribeDataSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/DescribeDataSource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeDataSourceResponse> describeDataSource(DescribeDataSourceRequest describeDataSourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeDataSourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeDataSourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "kendra");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDataSource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeDataSourceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeDataSourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeDataSourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeDataSourceRequest, DescribeDataSourceResponse>()
                            .withOperationName("DescribeDataSource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeDataSourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeDataSourceRequest));
            CompletableFuture<DescribeDataSourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about your Amazon Kendra experience such as a search application. For more information on
     * creating a search application experience, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html">Building a search
     * experience with no code</a>.
     * </p>
     *
     * @param describeExperienceRequest
     * @return A Java Future containing the result of the DescribeExperience operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.DescribeExperience
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/DescribeExperience" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeExperienceResponse> describeExperience(DescribeExperienceRequest describeExperienceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeExperienceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeExperienceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "kendra");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeExperience");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeExperienceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeExperienceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeExperienceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeExperienceRequest, DescribeExperienceResponse>()
                            .withOperationName("DescribeExperience").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeExperienceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeExperienceRequest));
            CompletableFuture<DescribeExperienceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about an FAQ list.
     * </p>
     *
     * @param describeFaqRequest
     * @return A Java Future containing the result of the DescribeFaq operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.DescribeFaq
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/DescribeFaq" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeFaqResponse> describeFaq(DescribeFaqRequest describeFaqRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeFaqRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeFaqRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "kendra");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeFaq");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeFaqResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DescribeFaqResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeFaqResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeFaqRequest, DescribeFaqResponse>()
                            .withOperationName("DescribeFaq").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeFaqRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeFaqRequest));
            CompletableFuture<DescribeFaqResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about a set of featured results. Features results are placed above all other results for certain
     * queries. If there's an exact match of a query, then one or more specific documents are featured in the search
     * results.
     * </p>
     *
     * @param describeFeaturedResultsSetRequest
     * @return A Java Future containing the result of the DescribeFeaturedResultsSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.DescribeFeaturedResultsSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/DescribeFeaturedResultsSet"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeFeaturedResultsSetResponse> describeFeaturedResultsSet(
            DescribeFeaturedResultsSetRequest describeFeaturedResultsSetRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeFeaturedResultsSetRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeFeaturedResultsSetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "kendra");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeFeaturedResultsSet");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeFeaturedResultsSetResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeFeaturedResultsSetResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeFeaturedResultsSetResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeFeaturedResultsSetRequest, DescribeFeaturedResultsSetResponse>()
                            .withOperationName("DescribeFeaturedResultsSet").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeFeaturedResultsSetRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeFeaturedResultsSetRequest));
            CompletableFuture<DescribeFeaturedResultsSetResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about an Amazon Kendra index.
     * </p>
     *
     * @param describeIndexRequest
     * @return A Java Future containing the result of the DescribeIndex operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.DescribeIndex
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/DescribeIndex" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeIndexResponse> describeIndex(DescribeIndexRequest describeIndexRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeIndexRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeIndexRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "kendra");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeIndex");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeIndexResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DescribeIndexResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeIndexResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeIndexRequest, DescribeIndexResponse>()
                            .withOperationName("DescribeIndex").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeIndexRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeIndexRequest));
            CompletableFuture<DescribeIndexResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the processing of <code>PUT</code> and <code>DELETE</code> actions for mapping users to their groups.
     * This includes information on the status of actions currently processing or yet to be processed, when actions were
     * last updated, when actions were received by Amazon Kendra, the latest action that should process and apply after
     * other actions, and useful error messages if an action could not be processed.
     * </p>
     * <p>
     * <code>DescribePrincipalMapping</code> is currently not supported in the Amazon Web Services GovCloud (US-West)
     * region.
     * </p>
     *
     * @param describePrincipalMappingRequest
     * @return A Java Future containing the result of the DescribePrincipalMapping operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.DescribePrincipalMapping
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/DescribePrincipalMapping"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribePrincipalMappingResponse> describePrincipalMapping(
            DescribePrincipalMappingRequest describePrincipalMappingRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describePrincipalMappingRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describePrincipalMappingRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "kendra");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribePrincipalMapping");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribePrincipalMappingResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribePrincipalMappingResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribePrincipalMappingResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribePrincipalMappingRequest, DescribePrincipalMappingResponse>()
                            .withOperationName("DescribePrincipalMapping").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribePrincipalMappingRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describePrincipalMappingRequest));
            CompletableFuture<DescribePrincipalMappingResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about a block list used for query suggestions for an index.
     * </p>
     * <p>
     * This is used to check the current settings that are applied to a block list.
     * </p>
     * <p>
     * <code>DescribeQuerySuggestionsBlockList</code> is currently not supported in the Amazon Web Services GovCloud
     * (US-West) region.
     * </p>
     *
     * @param describeQuerySuggestionsBlockListRequest
     * @return A Java Future containing the result of the DescribeQuerySuggestionsBlockList operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.DescribeQuerySuggestionsBlockList
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/DescribeQuerySuggestionsBlockList"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeQuerySuggestionsBlockListResponse> describeQuerySuggestionsBlockList(
            DescribeQuerySuggestionsBlockListRequest describeQuerySuggestionsBlockListRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeQuerySuggestionsBlockListRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeQuerySuggestionsBlockListRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "kendra");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeQuerySuggestionsBlockList");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeQuerySuggestionsBlockListResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DescribeQuerySuggestionsBlockListResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeQuerySuggestionsBlockListResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeQuerySuggestionsBlockListRequest, DescribeQuerySuggestionsBlockListResponse>()
                            .withOperationName("DescribeQuerySuggestionsBlockList").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeQuerySuggestionsBlockListRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeQuerySuggestionsBlockListRequest));
            CompletableFuture<DescribeQuerySuggestionsBlockListResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information on the settings of query suggestions for an index.
     * </p>
     * <p>
     * This is used to check the current settings applied to query suggestions.
     * </p>
     * <p>
     * <code>DescribeQuerySuggestionsConfig</code> is currently not supported in the Amazon Web Services GovCloud
     * (US-West) region.
     * </p>
     *
     * @param describeQuerySuggestionsConfigRequest
     * @return A Java Future containing the result of the DescribeQuerySuggestionsConfig operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.DescribeQuerySuggestionsConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/DescribeQuerySuggestionsConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeQuerySuggestionsConfigResponse> describeQuerySuggestionsConfig(
            DescribeQuerySuggestionsConfigRequest describeQuerySuggestionsConfigRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeQuerySuggestionsConfigRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeQuerySuggestionsConfigRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "kendra");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeQuerySuggestionsConfig");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeQuerySuggestionsConfigResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeQuerySuggestionsConfigResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeQuerySuggestionsConfigResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeQuerySuggestionsConfigRequest, DescribeQuerySuggestionsConfigResponse>()
                            .withOperationName("DescribeQuerySuggestionsConfig").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeQuerySuggestionsConfigRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeQuerySuggestionsConfigRequest));
            CompletableFuture<DescribeQuerySuggestionsConfigResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about an Amazon Kendra thesaurus.
     * </p>
     *
     * @param describeThesaurusRequest
     * @return A Java Future containing the result of the DescribeThesaurus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.DescribeThesaurus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/DescribeThesaurus" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeThesaurusResponse> describeThesaurus(DescribeThesaurusRequest describeThesaurusRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeThesaurusRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeThesaurusRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "kendra");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeThesaurus");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeThesaurusResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeThesaurusResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeThesaurusResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeThesaurusRequest, DescribeThesaurusResponse>()
                            .withOperationName("DescribeThesaurus").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeThesaurusRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeThesaurusRequest));
            CompletableFuture<DescribeThesaurusResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Prevents users or groups in your IAM Identity Center identity source from accessing your Amazon Kendra
     * experience. You can create an Amazon Kendra experience such as a search application. For more information on
     * creating a search application experience, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html">Building a search
     * experience with no code</a>.
     * </p>
     *
     * @param disassociateEntitiesFromExperienceRequest
     * @return A Java Future containing the result of the DisassociateEntitiesFromExperience operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.DisassociateEntitiesFromExperience
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/DisassociateEntitiesFromExperience"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DisassociateEntitiesFromExperienceResponse> disassociateEntitiesFromExperience(
            DisassociateEntitiesFromExperienceRequest disassociateEntitiesFromExperienceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(disassociateEntitiesFromExperienceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                disassociateEntitiesFromExperienceRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "kendra");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisassociateEntitiesFromExperience");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DisassociateEntitiesFromExperienceResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DisassociateEntitiesFromExperienceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DisassociateEntitiesFromExperienceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DisassociateEntitiesFromExperienceRequest, DisassociateEntitiesFromExperienceResponse>()
                            .withOperationName("DisassociateEntitiesFromExperience").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DisassociateEntitiesFromExperienceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(disassociateEntitiesFromExperienceRequest));
            CompletableFuture<DisassociateEntitiesFromExperienceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes the specific permissions of users or groups in your IAM Identity Center identity source with access to
     * your Amazon Kendra experience. You can create an Amazon Kendra experience such as a search application. For more
     * information on creating a search application experience, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html">Building a search
     * experience with no code</a>.
     * </p>
     *
     * @param disassociatePersonasFromEntitiesRequest
     * @return A Java Future containing the result of the DisassociatePersonasFromEntities operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.DisassociatePersonasFromEntities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/DisassociatePersonasFromEntities"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DisassociatePersonasFromEntitiesResponse> disassociatePersonasFromEntities(
            DisassociatePersonasFromEntitiesRequest disassociatePersonasFromEntitiesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(disassociatePersonasFromEntitiesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                disassociatePersonasFromEntitiesRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "kendra");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisassociatePersonasFromEntities");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DisassociatePersonasFromEntitiesResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DisassociatePersonasFromEntitiesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DisassociatePersonasFromEntitiesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DisassociatePersonasFromEntitiesRequest, DisassociatePersonasFromEntitiesResponse>()
                            .withOperationName("DisassociatePersonasFromEntities").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DisassociatePersonasFromEntitiesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(disassociatePersonasFromEntitiesRequest));
            CompletableFuture<DisassociatePersonasFromEntitiesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Fetches the queries that are suggested to your users.
     * </p>
     * <p>
     * <code>GetQuerySuggestions</code> is currently not supported in the Amazon Web Services GovCloud (US-West) region.
     * </p>
     *
     * @param getQuerySuggestionsRequest
     * @return A Java Future containing the result of the GetQuerySuggestions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>ServiceQuotaExceededException You have exceeded the set limits for your Amazon Kendra service. Please
     *         see <a href="https://docs.aws.amazon.com/kendra/latest/dg/quotas.html">Quotas</a> for more information,
     *         or contact <a href="http://aws.amazon.com/contact-us/">Support</a> to inquire about an increase of
     *         limits.</li>
     *         <li>ConflictException A conflict occurred with the request. Please fix any inconsistences with your
     *         resources and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.GetQuerySuggestions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/GetQuerySuggestions" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetQuerySuggestionsResponse> getQuerySuggestions(
            GetQuerySuggestionsRequest getQuerySuggestionsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getQuerySuggestionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getQuerySuggestionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "kendra");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetQuerySuggestions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetQuerySuggestionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetQuerySuggestionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetQuerySuggestionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetQuerySuggestionsRequest, GetQuerySuggestionsResponse>()
                            .withOperationName("GetQuerySuggestions").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetQuerySuggestionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getQuerySuggestionsRequest));
            CompletableFuture<GetQuerySuggestionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves search metrics data. The data provides a snapshot of how your users interact with your search
     * application and how effective the application is.
     * </p>
     *
     * @param getSnapshotsRequest
     * @return A Java Future containing the result of the GetSnapshots operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The input to the request is not valid. Please provide the correct input and
     *         try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.GetSnapshots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/GetSnapshots" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetSnapshotsResponse> getSnapshots(GetSnapshotsRequest getSnapshotsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getSnapshotsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getSnapshotsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "kendra");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetSnapshots");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetSnapshotsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetSnapshotsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetSnapshotsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetSnapshotsRequest, GetSnapshotsResponse>()
                            .withOperationName("GetSnapshots").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetSnapshotsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getSnapshotsRequest));
            CompletableFuture<GetSnapshotsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists one or more access control configurations for an index. This includes user and group access information for
     * your documents. This is useful for user context filtering, where search results are filtered based on the user or
     * their group access to documents.
     * </p>
     *
     * @param listAccessControlConfigurationsRequest
     * @return A Java Future containing the result of the ListAccessControlConfigurations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.ListAccessControlConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/ListAccessControlConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListAccessControlConfigurationsResponse> listAccessControlConfigurations(
            ListAccessControlConfigurationsRequest listAccessControlConfigurationsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listAccessControlConfigurationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listAccessControlConfigurationsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "kendra");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAccessControlConfigurations");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListAccessControlConfigurationsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListAccessControlConfigurationsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListAccessControlConfigurationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListAccessControlConfigurationsRequest, ListAccessControlConfigurationsResponse>()
                            .withOperationName("ListAccessControlConfigurations").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListAccessControlConfigurationsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listAccessControlConfigurationsRequest));
            CompletableFuture<ListAccessControlConfigurationsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets statistics about synchronizing a data source connector.
     * </p>
     *
     * @param listDataSourceSyncJobsRequest
     * @return A Java Future containing the result of the ListDataSourceSyncJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>ConflictException A conflict occurred with the request. Please fix any inconsistences with your
     *         resources and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.ListDataSourceSyncJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/ListDataSourceSyncJobs" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListDataSourceSyncJobsResponse> listDataSourceSyncJobs(
            ListDataSourceSyncJobsRequest listDataSourceSyncJobsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listDataSourceSyncJobsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listDataSourceSyncJobsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "kendra");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListDataSourceSyncJobs");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListDataSourceSyncJobsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListDataSourceSyncJobsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListDataSourceSyncJobsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListDataSourceSyncJobsRequest, ListDataSourceSyncJobsResponse>()
                            .withOperationName("ListDataSourceSyncJobs").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListDataSourceSyncJobsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listDataSourceSyncJobsRequest));
            CompletableFuture<ListDataSourceSyncJobsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the data source connectors that you have created.
     * </p>
     *
     * @param listDataSourcesRequest
     * @return A Java Future containing the result of the ListDataSources operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.ListDataSources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/ListDataSources" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListDataSourcesResponse> listDataSources(ListDataSourcesRequest listDataSourcesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listDataSourcesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listDataSourcesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "kendra");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListDataSources");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListDataSourcesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListDataSourcesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListDataSourcesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListDataSourcesRequest, ListDataSourcesResponse>()
                            .withOperationName("ListDataSources").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListDataSourcesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listDataSourcesRequest));
            CompletableFuture<ListDataSourcesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists specific permissions of users and groups with access to your Amazon Kendra experience.
     * </p>
     *
     * @param listEntityPersonasRequest
     * @return A Java Future containing the result of the ListEntityPersonas operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.ListEntityPersonas
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/ListEntityPersonas" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListEntityPersonasResponse> listEntityPersonas(ListEntityPersonasRequest listEntityPersonasRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listEntityPersonasRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listEntityPersonasRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "kendra");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListEntityPersonas");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListEntityPersonasResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListEntityPersonasResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListEntityPersonasResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListEntityPersonasRequest, ListEntityPersonasResponse>()
                            .withOperationName("ListEntityPersonas").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListEntityPersonasRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listEntityPersonasRequest));
            CompletableFuture<ListEntityPersonasResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists users or groups in your IAM Identity Center identity source that are granted access to your Amazon Kendra
     * experience. You can create an Amazon Kendra experience such as a search application. For more information on
     * creating a search application experience, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html">Building a search
     * experience with no code</a>.
     * </p>
     *
     * @param listExperienceEntitiesRequest
     * @return A Java Future containing the result of the ListExperienceEntities operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.ListExperienceEntities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/ListExperienceEntities" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListExperienceEntitiesResponse> listExperienceEntities(
            ListExperienceEntitiesRequest listExperienceEntitiesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listExperienceEntitiesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listExperienceEntitiesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "kendra");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListExperienceEntities");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListExperienceEntitiesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListExperienceEntitiesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListExperienceEntitiesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListExperienceEntitiesRequest, ListExperienceEntitiesResponse>()
                            .withOperationName("ListExperienceEntities").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListExperienceEntitiesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listExperienceEntitiesRequest));
            CompletableFuture<ListExperienceEntitiesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists one or more Amazon Kendra experiences. You can create an Amazon Kendra experience such as a search
     * application. For more information on creating a search application experience, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html">Building a search
     * experience with no code</a>.
     * </p>
     *
     * @param listExperiencesRequest
     * @return A Java Future containing the result of the ListExperiences operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.ListExperiences
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/ListExperiences" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListExperiencesResponse> listExperiences(ListExperiencesRequest listExperiencesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listExperiencesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listExperiencesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "kendra");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListExperiences");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListExperiencesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListExperiencesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListExperiencesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListExperiencesRequest, ListExperiencesResponse>()
                            .withOperationName("ListExperiences").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListExperiencesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listExperiencesRequest));
            CompletableFuture<ListExperiencesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a list of FAQ lists associated with an index.
     * </p>
     *
     * @param listFaqsRequest
     * @return A Java Future containing the result of the ListFaqs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.ListFaqs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/ListFaqs" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListFaqsResponse> listFaqs(ListFaqsRequest listFaqsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listFaqsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listFaqsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "kendra");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListFaqs");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListFaqsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListFaqsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListFaqsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListFaqsRequest, ListFaqsResponse>().withOperationName("ListFaqs")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListFaqsRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withMetricCollector(apiCallMetricCollector).withInput(listFaqsRequest));
            CompletableFuture<ListFaqsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists all your sets of featured results for a given index. Features results are placed above all other results
     * for certain queries. If there's an exact match of a query, then one or more specific documents are featured in
     * the search results.
     * </p>
     *
     * @param listFeaturedResultsSetsRequest
     * @return A Java Future containing the result of the ListFeaturedResultsSets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.ListFeaturedResultsSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/ListFeaturedResultsSets"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListFeaturedResultsSetsResponse> listFeaturedResultsSets(
            ListFeaturedResultsSetsRequest listFeaturedResultsSetsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listFeaturedResultsSetsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listFeaturedResultsSetsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "kendra");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListFeaturedResultsSets");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListFeaturedResultsSetsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListFeaturedResultsSetsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListFeaturedResultsSetsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListFeaturedResultsSetsRequest, ListFeaturedResultsSetsResponse>()
                            .withOperationName("ListFeaturedResultsSets").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListFeaturedResultsSetsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listFeaturedResultsSetsRequest));
            CompletableFuture<ListFeaturedResultsSetsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Provides a list of groups that are mapped to users before a given ordering or timestamp identifier.
     * </p>
     * <p>
     * <code>ListGroupsOlderThanOrderingId</code> is currently not supported in the Amazon Web Services GovCloud
     * (US-West) region.
     * </p>
     *
     * @param listGroupsOlderThanOrderingIdRequest
     * @return A Java Future containing the result of the ListGroupsOlderThanOrderingId operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>ConflictException A conflict occurred with the request. Please fix any inconsistences with your
     *         resources and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.ListGroupsOlderThanOrderingId
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/ListGroupsOlderThanOrderingId"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListGroupsOlderThanOrderingIdResponse> listGroupsOlderThanOrderingId(
            ListGroupsOlderThanOrderingIdRequest listGroupsOlderThanOrderingIdRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listGroupsOlderThanOrderingIdRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listGroupsOlderThanOrderingIdRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "kendra");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListGroupsOlderThanOrderingId");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListGroupsOlderThanOrderingIdResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListGroupsOlderThanOrderingIdResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListGroupsOlderThanOrderingIdResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListGroupsOlderThanOrderingIdRequest, ListGroupsOlderThanOrderingIdResponse>()
                            .withOperationName("ListGroupsOlderThanOrderingId").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListGroupsOlderThanOrderingIdRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listGroupsOlderThanOrderingIdRequest));
            CompletableFuture<ListGroupsOlderThanOrderingIdResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the Amazon Kendra indexes that you created.
     * </p>
     *
     * @param listIndicesRequest
     * @return A Java Future containing the result of the ListIndices operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.ListIndices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/ListIndices" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListIndicesResponse> listIndices(ListIndicesRequest listIndicesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listIndicesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listIndicesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "kendra");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListIndices");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListIndicesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListIndicesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListIndicesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListIndicesRequest, ListIndicesResponse>()
                            .withOperationName("ListIndices").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListIndicesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listIndicesRequest));
            CompletableFuture<ListIndicesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the block lists used for query suggestions for an index.
     * </p>
     * <p>
     * For information on the current quota limits for block lists, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/quotas.html">Quotas for Amazon Kendra</a>.
     * </p>
     * <p>
     * <code>ListQuerySuggestionsBlockLists</code> is currently not supported in the Amazon Web Services GovCloud
     * (US-West) region.
     * </p>
     *
     * @param listQuerySuggestionsBlockListsRequest
     * @return A Java Future containing the result of the ListQuerySuggestionsBlockLists operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.ListQuerySuggestionsBlockLists
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/ListQuerySuggestionsBlockLists"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListQuerySuggestionsBlockListsResponse> listQuerySuggestionsBlockLists(
            ListQuerySuggestionsBlockListsRequest listQuerySuggestionsBlockListsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listQuerySuggestionsBlockListsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listQuerySuggestionsBlockListsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "kendra");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListQuerySuggestionsBlockLists");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListQuerySuggestionsBlockListsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListQuerySuggestionsBlockListsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListQuerySuggestionsBlockListsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListQuerySuggestionsBlockListsRequest, ListQuerySuggestionsBlockListsResponse>()
                            .withOperationName("ListQuerySuggestionsBlockLists").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListQuerySuggestionsBlockListsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listQuerySuggestionsBlockListsRequest));
            CompletableFuture<ListQuerySuggestionsBlockListsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a list of tags associated with a specified resource. Indexes, FAQs, and data sources can have tags
     * associated with them.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ResourceUnavailableException The resource you want to use isn't available. Please check you have
     *         provided the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listTagsForResourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "kendra");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTagsForResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListTagsForResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListTagsForResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListTagsForResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListTagsForResourceRequest, ListTagsForResourceResponse>()
                            .withOperationName("ListTagsForResource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListTagsForResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listTagsForResourceRequest));
            CompletableFuture<ListTagsForResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the thesauri for an index.
     * </p>
     *
     * @param listThesauriRequest
     * @return A Java Future containing the result of the ListThesauri operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.ListThesauri
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/ListThesauri" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListThesauriResponse> listThesauri(ListThesauriRequest listThesauriRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listThesauriRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listThesauriRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "kendra");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListThesauri");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListThesauriResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListThesauriResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListThesauriResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListThesauriRequest, ListThesauriResponse>()
                            .withOperationName("ListThesauri").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListThesauriRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listThesauriRequest));
            CompletableFuture<ListThesauriResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Maps users to their groups so that you only need to provide the user ID when you issue the query.
     * </p>
     * <p>
     * You can also map sub groups to groups. For example, the group "Company Intellectual Property Teams" includes sub
     * groups "Research" and "Engineering". These sub groups include their own list of users or people who work in these
     * teams. Only users who work in research and engineering, and therefore belong in the intellectual property group,
     * can see top-secret company documents in their search results.
     * </p>
     * <p>
     * This is useful for user context filtering, where search results are filtered based on the user or their group
     * access to documents. For more information, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/user-context-filter.html">Filtering on user context</a>.
     * </p>
     * <p>
     * If more than five <code>PUT</code> actions for a group are currently processing, a validation exception is
     * thrown.
     * </p>
     *
     * @param putPrincipalMappingRequest
     * @return A Java Future containing the result of the PutPrincipalMapping operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ConflictException A conflict occurred with the request. Please fix any inconsistences with your
     *         resources and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>ServiceQuotaExceededException You have exceeded the set limits for your Amazon Kendra service. Please
     *         see <a href="https://docs.aws.amazon.com/kendra/latest/dg/quotas.html">Quotas</a> for more information,
     *         or contact <a href="http://aws.amazon.com/contact-us/">Support</a> to inquire about an increase of
     *         limits.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.PutPrincipalMapping
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/PutPrincipalMapping" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<PutPrincipalMappingResponse> putPrincipalMapping(
            PutPrincipalMappingRequest putPrincipalMappingRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putPrincipalMappingRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putPrincipalMappingRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "kendra");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutPrincipalMapping");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PutPrincipalMappingResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, PutPrincipalMappingResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<PutPrincipalMappingResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutPrincipalMappingRequest, PutPrincipalMappingResponse>()
                            .withOperationName("PutPrincipalMapping").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new PutPrincipalMappingRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(putPrincipalMappingRequest));
            CompletableFuture<PutPrincipalMappingResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Searches an index given an input query.
     * </p>
     * <note>
     * <p>
     * If you are working with large language models (LLMs) or implementing retrieval augmented generation (RAG)
     * systems, you can use Amazon Kendra's <a
     * href="https://docs.aws.amazon.com/kendra/latest/APIReference/API_Retrieve.html">Retrieve</a> API, which can
     * return longer semantically relevant passages. We recommend using the <code>Retrieve</code> API instead of filing
     * a service limit increase to increase the <code>Query</code> API document excerpt length.
     * </p>
     * </note>
     * <p>
     * You can configure boosting or relevance tuning at the query level to override boosting at the index level, filter
     * based on document fields/attributes and faceted search, and filter based on the user or their group access to
     * documents. You can also include certain fields in the response that might provide useful additional information.
     * </p>
     * <p>
     * A query response contains three types of results.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Relevant suggested answers. The answers can be either a text excerpt or table excerpt. The answer can be
     * highlighted in the excerpt.
     * </p>
     * </li>
     * <li>
     * <p>
     * Matching FAQs or questions-answer from your FAQ file.
     * </p>
     * </li>
     * <li>
     * <p>
     * Relevant documents. This result type includes an excerpt of the document with the document title. The searched
     * terms can be highlighted in the excerpt.
     * </p>
     * </li>
     * </ul>
     * <p>
     * You can specify that the query return only one type of result using the <code>QueryResultTypeFilter</code>
     * parameter. Each query returns the 100 most relevant results. If you filter result type to only question-answers,
     * a maximum of four results are returned. If you filter result type to only answers, a maximum of three results are
     * returned.
     * </p>
     *
     * @param queryRequest
     * @return A Java Future containing the result of the Query operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ConflictException A conflict occurred with the request. Please fix any inconsistences with your
     *         resources and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>ServiceQuotaExceededException You have exceeded the set limits for your Amazon Kendra service. Please
     *         see <a href="https://docs.aws.amazon.com/kendra/latest/dg/quotas.html">Quotas</a> for more information,
     *         or contact <a href="http://aws.amazon.com/contact-us/">Support</a> to inquire about an increase of
     *         limits.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.Query
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/Query" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<QueryResponse> query(QueryRequest queryRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(queryRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, queryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "kendra");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "Query");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<QueryResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    QueryResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<QueryResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<QueryRequest, QueryResponse>().withOperationName("Query")
                            .withProtocolMetadata(protocolMetadata).withMarshaller(new QueryRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(queryRequest));
            CompletableFuture<QueryResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves relevant passages or text excerpts given an input query.
     * </p>
     * <p>
     * This API is similar to the <a
     * href="https://docs.aws.amazon.com/kendra/latest/APIReference/API_Query.html">Query</a> API. However, by default,
     * the <code>Query</code> API only returns excerpt passages of up to 100 token words. With the <code>Retrieve</code>
     * API, you can retrieve longer passages of up to 200 token words and up to 100 semantically relevant passages. This
     * doesn't include question-answer or FAQ type responses from your index. The passages are text excerpts that can be
     * semantically extracted from multiple documents and multiple parts of the same document. If in extreme cases your
     * documents produce zero passages using the <code>Retrieve</code> API, you can alternatively use the
     * <code>Query</code> API and its types of responses.
     * </p>
     * <p>
     * You can also do the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Override boosting at the index level
     * </p>
     * </li>
     * <li>
     * <p>
     * Filter based on document fields or attributes
     * </p>
     * </li>
     * <li>
     * <p>
     * Filter based on the user or their group access to documents
     * </p>
     * </li>
     * <li>
     * <p>
     * View the confidence score bucket for a retrieved passage result. The confidence bucket provides a relative
     * ranking that indicates how confident Amazon Kendra is that the response is relevant to the query.
     * </p>
     * <note>
     * <p>
     * Confidence score buckets are currently available only for English.
     * </p>
     * </note></li>
     * </ul>
     * <p>
     * You can also include certain fields in the response that might provide useful additional information.
     * </p>
     * <p>
     * The <code>Retrieve</code> API shares the number of <a
     * href="https://docs.aws.amazon.com/kendra/latest/APIReference/API_CapacityUnitsConfiguration.html">query capacity
     * units</a> that you set for your index. For more information on what's included in a single capacity unit and the
     * default base capacity for an index, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/adjusting-capacity.html">Adjusting capacity</a>.
     * </p>
     *
     * @param retrieveRequest
     * @return A Java Future containing the result of the Retrieve operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ConflictException A conflict occurred with the request. Please fix any inconsistences with your
     *         resources and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>ServiceQuotaExceededException You have exceeded the set limits for your Amazon Kendra service. Please
     *         see <a href="https://docs.aws.amazon.com/kendra/latest/dg/quotas.html">Quotas</a> for more information,
     *         or contact <a href="http://aws.amazon.com/contact-us/">Support</a> to inquire about an increase of
     *         limits.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.Retrieve
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/Retrieve" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<RetrieveResponse> retrieve(RetrieveRequest retrieveRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(retrieveRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, retrieveRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "kendra");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "Retrieve");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<RetrieveResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    RetrieveResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<RetrieveResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<RetrieveRequest, RetrieveResponse>().withOperationName("Retrieve")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new RetrieveRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withMetricCollector(apiCallMetricCollector).withInput(retrieveRequest));
            CompletableFuture<RetrieveResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Starts a synchronization job for a data source connector. If a synchronization job is already in progress, Amazon
     * Kendra returns a <code>ResourceInUseException</code> exception.
     * </p>
     * <p>
     * Re-syncing your data source with your index after modifying, adding, or deleting documents from your data source
     * respository could take up to an hour or more, depending on the number of documents to sync.
     * </p>
     *
     * @param startDataSourceSyncJobRequest
     * @return A Java Future containing the result of the StartDataSourceSyncJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>ResourceInUseException The resource you want to use is currently in use. Please check you have
     *         provided the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>ConflictException A conflict occurred with the request. Please fix any inconsistences with your
     *         resources and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.StartDataSourceSyncJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/StartDataSourceSyncJob" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<StartDataSourceSyncJobResponse> startDataSourceSyncJob(
            StartDataSourceSyncJobRequest startDataSourceSyncJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startDataSourceSyncJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startDataSourceSyncJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "kendra");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartDataSourceSyncJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StartDataSourceSyncJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StartDataSourceSyncJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<StartDataSourceSyncJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StartDataSourceSyncJobRequest, StartDataSourceSyncJobResponse>()
                            .withOperationName("StartDataSourceSyncJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new StartDataSourceSyncJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(startDataSourceSyncJobRequest));
            CompletableFuture<StartDataSourceSyncJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Stops a synchronization job that is currently running. You can't stop a scheduled synchronization job.
     * </p>
     *
     * @param stopDataSourceSyncJobRequest
     * @return A Java Future containing the result of the StopDataSourceSyncJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.StopDataSourceSyncJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/StopDataSourceSyncJob" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<StopDataSourceSyncJobResponse> stopDataSourceSyncJob(
            StopDataSourceSyncJobRequest stopDataSourceSyncJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(stopDataSourceSyncJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, stopDataSourceSyncJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "kendra");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StopDataSourceSyncJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StopDataSourceSyncJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StopDataSourceSyncJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<StopDataSourceSyncJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StopDataSourceSyncJobRequest, StopDataSourceSyncJobResponse>()
                            .withOperationName("StopDataSourceSyncJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new StopDataSourceSyncJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(stopDataSourceSyncJobRequest));
            CompletableFuture<StopDataSourceSyncJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Enables you to provide feedback to Amazon Kendra to improve the performance of your index.
     * </p>
     * <p>
     * <code>SubmitFeedback</code> is currently not supported in the Amazon Web Services GovCloud (US-West) region.
     * </p>
     *
     * @param submitFeedbackRequest
     * @return A Java Future containing the result of the SubmitFeedback operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ResourceUnavailableException The resource you want to use isn't available. Please check you have
     *         provided the correct resource and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.SubmitFeedback
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/SubmitFeedback" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<SubmitFeedbackResponse> submitFeedback(SubmitFeedbackRequest submitFeedbackRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(submitFeedbackRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, submitFeedbackRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "kendra");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SubmitFeedback");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<SubmitFeedbackResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, SubmitFeedbackResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<SubmitFeedbackResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<SubmitFeedbackRequest, SubmitFeedbackResponse>()
                            .withOperationName("SubmitFeedback").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new SubmitFeedbackRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(submitFeedbackRequest));
            CompletableFuture<SubmitFeedbackResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Adds the specified tag to the specified index, FAQ, or data source resource. If the tag already exists, the
     * existing value is replaced with the new value.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ResourceUnavailableException The resource you want to use isn't available. Please check you have
     *         provided the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, tagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "kendra");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<TagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    TagResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<TagResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<TagResourceRequest, TagResourceResponse>()
                            .withOperationName("TagResource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new TagResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(tagResourceRequest));
            CompletableFuture<TagResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes a tag from an index, FAQ, or a data source.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ResourceUnavailableException The resource you want to use isn't available. Please check you have
     *         provided the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, untagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "kendra");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UntagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UntagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UntagResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UntagResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UntagResourceRequest, UntagResourceResponse>()
                            .withOperationName("UntagResource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UntagResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(untagResourceRequest));
            CompletableFuture<UntagResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates an access control configuration for your documents in an index. This includes user and group access
     * information for your documents. This is useful for user context filtering, where search results are filtered
     * based on the user or their group access to documents.
     * </p>
     * <p>
     * You can update an access control configuration you created without indexing all of your documents again. For
     * example, your index contains top-secret company documents that only certain employees or users should access. You
     * created an 'allow' access control configuration for one user who recently joined the 'top-secret' team, switching
     * from a team with 'deny' access to top-secret documents. However, the user suddenly returns to their previous team
     * and should no longer have access to top secret documents. You can update the access control configuration to
     * re-configure access control for your documents as circumstances change.
     * </p>
     * <p>
     * You call the <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/API_BatchPutDocument.html">BatchPutDocument</a> API to apply
     * the updated access control configuration, with the <code>AccessControlConfigurationId</code> included in the <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/API_Document.html">Document</a> object. If you use an S3
     * bucket as a data source, you synchronize your data source to apply the <code>AccessControlConfigurationId</code>
     * in the <code>.metadata.json</code> file. Amazon Kendra currently only supports access control configuration for
     * S3 data sources and documents indexed using the <code>BatchPutDocument</code> API.
     * </p>
     *
     * @param updateAccessControlConfigurationRequest
     * @return A Java Future containing the result of the UpdateAccessControlConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>ConflictException A conflict occurred with the request. Please fix any inconsistences with your
     *         resources and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>ServiceQuotaExceededException You have exceeded the set limits for your Amazon Kendra service. Please
     *         see <a href="https://docs.aws.amazon.com/kendra/latest/dg/quotas.html">Quotas</a> for more information,
     *         or contact <a href="http://aws.amazon.com/contact-us/">Support</a> to inquire about an increase of
     *         limits.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.UpdateAccessControlConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/UpdateAccessControlConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateAccessControlConfigurationResponse> updateAccessControlConfiguration(
            UpdateAccessControlConfigurationRequest updateAccessControlConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateAccessControlConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                updateAccessControlConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "kendra");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateAccessControlConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateAccessControlConfigurationResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, UpdateAccessControlConfigurationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateAccessControlConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateAccessControlConfigurationRequest, UpdateAccessControlConfigurationResponse>()
                            .withOperationName("UpdateAccessControlConfiguration").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateAccessControlConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateAccessControlConfigurationRequest));
            CompletableFuture<UpdateAccessControlConfigurationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates an Amazon Kendra data source connector.
     * </p>
     *
     * @param updateDataSourceRequest
     * @return A Java Future containing the result of the UpdateDataSource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ConflictException A conflict occurred with the request. Please fix any inconsistences with your
     *         resources and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.UpdateDataSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/UpdateDataSource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateDataSourceResponse> updateDataSource(UpdateDataSourceRequest updateDataSourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateDataSourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateDataSourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "kendra");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateDataSource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateDataSourceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateDataSourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateDataSourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateDataSourceRequest, UpdateDataSourceResponse>()
                            .withOperationName("UpdateDataSource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateDataSourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateDataSourceRequest));
            CompletableFuture<UpdateDataSourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates your Amazon Kendra experience such as a search application. For more information on creating a search
     * application experience, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html">Building a search
     * experience with no code</a>.
     * </p>
     *
     * @param updateExperienceRequest
     * @return A Java Future containing the result of the UpdateExperience operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ConflictException A conflict occurred with the request. Please fix any inconsistences with your
     *         resources and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.UpdateExperience
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/UpdateExperience" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateExperienceResponse> updateExperience(UpdateExperienceRequest updateExperienceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateExperienceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateExperienceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "kendra");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateExperience");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateExperienceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateExperienceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateExperienceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateExperienceRequest, UpdateExperienceResponse>()
                            .withOperationName("UpdateExperience").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateExperienceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateExperienceRequest));
            CompletableFuture<UpdateExperienceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates a set of featured results. Features results are placed above all other results for certain queries. You
     * map specific queries to specific documents for featuring in the results. If a query contains an exact match of a
     * query, then one or more specific documents are featured in the search results.
     * </p>
     *
     * @param updateFeaturedResultsSetRequest
     * @return A Java Future containing the result of the UpdateFeaturedResultsSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>FeaturedResultsConflictException An error message with a list of conflicting queries used across
     *         different sets of featured results. This occurred with the request for a new featured results set. Check
     *         that the queries you specified for featured results are unique per featured results set for each index.</li>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.UpdateFeaturedResultsSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/UpdateFeaturedResultsSet"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateFeaturedResultsSetResponse> updateFeaturedResultsSet(
            UpdateFeaturedResultsSetRequest updateFeaturedResultsSetRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateFeaturedResultsSetRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateFeaturedResultsSetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "kendra");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateFeaturedResultsSet");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateFeaturedResultsSetResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateFeaturedResultsSetResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateFeaturedResultsSetResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateFeaturedResultsSetRequest, UpdateFeaturedResultsSetResponse>()
                            .withOperationName("UpdateFeaturedResultsSet").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateFeaturedResultsSetRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateFeaturedResultsSetRequest));
            CompletableFuture<UpdateFeaturedResultsSetResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates an Amazon Kendra index.
     * </p>
     *
     * @param updateIndexRequest
     * @return A Java Future containing the result of the UpdateIndex operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ConflictException A conflict occurred with the request. Please fix any inconsistences with your
     *         resources and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>ServiceQuotaExceededException You have exceeded the set limits for your Amazon Kendra service. Please
     *         see <a href="https://docs.aws.amazon.com/kendra/latest/dg/quotas.html">Quotas</a> for more information,
     *         or contact <a href="http://aws.amazon.com/contact-us/">Support</a> to inquire about an increase of
     *         limits.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.UpdateIndex
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/UpdateIndex" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateIndexResponse> updateIndex(UpdateIndexRequest updateIndexRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateIndexRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateIndexRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "kendra");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateIndex");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateIndexResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UpdateIndexResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateIndexResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateIndexRequest, UpdateIndexResponse>()
                            .withOperationName("UpdateIndex").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateIndexRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateIndexRequest));
            CompletableFuture<UpdateIndexResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates a block list used for query suggestions for an index.
     * </p>
     * <p>
     * Updates to a block list might not take effect right away. Amazon Kendra needs to refresh the entire suggestions
     * list to apply any updates to the block list. Other changes not related to the block list apply immediately.
     * </p>
     * <p>
     * If a block list is updating, then you need to wait for the first update to finish before submitting another
     * update.
     * </p>
     * <p>
     * Amazon Kendra supports partial updates, so you only need to provide the fields you want to update.
     * </p>
     * <p>
     * <code>UpdateQuerySuggestionsBlockList</code> is currently not supported in the Amazon Web Services GovCloud
     * (US-West) region.
     * </p>
     *
     * @param updateQuerySuggestionsBlockListRequest
     * @return A Java Future containing the result of the UpdateQuerySuggestionsBlockList operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>ConflictException A conflict occurred with the request. Please fix any inconsistences with your
     *         resources and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.UpdateQuerySuggestionsBlockList
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/UpdateQuerySuggestionsBlockList"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateQuerySuggestionsBlockListResponse> updateQuerySuggestionsBlockList(
            UpdateQuerySuggestionsBlockListRequest updateQuerySuggestionsBlockListRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateQuerySuggestionsBlockListRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                updateQuerySuggestionsBlockListRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "kendra");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateQuerySuggestionsBlockList");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateQuerySuggestionsBlockListResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateQuerySuggestionsBlockListResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateQuerySuggestionsBlockListResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateQuerySuggestionsBlockListRequest, UpdateQuerySuggestionsBlockListResponse>()
                            .withOperationName("UpdateQuerySuggestionsBlockList").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateQuerySuggestionsBlockListRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateQuerySuggestionsBlockListRequest));
            CompletableFuture<UpdateQuerySuggestionsBlockListResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the settings of query suggestions for an index.
     * </p>
     * <p>
     * Amazon Kendra supports partial updates, so you only need to provide the fields you want to update.
     * </p>
     * <p>
     * If an update is currently processing, you need to wait for the update to finish before making another update.
     * </p>
     * <p>
     * Updates to query suggestions settings might not take effect right away. The time for your updated settings to
     * take effect depends on the updates made and the number of search queries in your index.
     * </p>
     * <p>
     * You can still enable/disable query suggestions at any time.
     * </p>
     * <p>
     * <code>UpdateQuerySuggestionsConfig</code> is currently not supported in the Amazon Web Services GovCloud
     * (US-West) region.
     * </p>
     *
     * @param updateQuerySuggestionsConfigRequest
     * @return A Java Future containing the result of the UpdateQuerySuggestionsConfig operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ConflictException A conflict occurred with the request. Please fix any inconsistences with your
     *         resources and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.UpdateQuerySuggestionsConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/UpdateQuerySuggestionsConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateQuerySuggestionsConfigResponse> updateQuerySuggestionsConfig(
            UpdateQuerySuggestionsConfigRequest updateQuerySuggestionsConfigRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateQuerySuggestionsConfigRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateQuerySuggestionsConfigRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "kendra");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateQuerySuggestionsConfig");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateQuerySuggestionsConfigResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateQuerySuggestionsConfigResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateQuerySuggestionsConfigResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateQuerySuggestionsConfigRequest, UpdateQuerySuggestionsConfigResponse>()
                            .withOperationName("UpdateQuerySuggestionsConfig").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateQuerySuggestionsConfigRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateQuerySuggestionsConfigRequest));
            CompletableFuture<UpdateQuerySuggestionsConfigResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates a thesaurus for an index.
     * </p>
     *
     * @param updateThesaurusRequest
     * @return A Java Future containing the result of the UpdateThesaurus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra service.
     *         Please provide the correct input and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn’t exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>ConflictException A conflict occurred with the request. Please fix any inconsistences with your
     *         resources and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraAsyncClient.UpdateThesaurus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/UpdateThesaurus" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateThesaurusResponse> updateThesaurus(UpdateThesaurusRequest updateThesaurusRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateThesaurusRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateThesaurusRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "kendra");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateThesaurus");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateThesaurusResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateThesaurusResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateThesaurusResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateThesaurusRequest, UpdateThesaurusResponse>()
                            .withOperationName("UpdateThesaurus").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateThesaurusRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateThesaurusRequest));
            CompletableFuture<UpdateThesaurusResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public final KendraServiceClientConfiguration serviceClientConfiguration() {
        return new KendraServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder
                .clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(KendraException::builder)
                .protocol(AwsJsonProtocol.AWS_JSON)
                .protocolVersion("1.1")
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidRequestException")
                                .exceptionBuilderSupplier(InvalidRequestException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException")
                                .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InternalServerException")
                                .exceptionBuilderSupplier(InternalServerException::builder).httpStatusCode(500).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceNotFoundException")
                                .exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceUnavailableException")
                                .exceptionBuilderSupplier(ResourceUnavailableException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ValidationException")
                                .exceptionBuilderSupplier(ValidationException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceInUseException")
                                .exceptionBuilderSupplier(ResourceInUseException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ThrottlingException")
                                .exceptionBuilderSupplier(ThrottlingException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("FeaturedResultsConflictException")
                                .exceptionBuilderSupplier(FeaturedResultsConflictException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AccessDeniedException")
                                .exceptionBuilderSupplier(AccessDeniedException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ConflictException")
                                .exceptionBuilderSupplier(ConflictException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceAlreadyExistException")
                                .exceptionBuilderSupplier(ResourceAlreadyExistException::builder).httpStatusCode(400).build());
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option(SdkClientOption.RETRY_STRATEGY, AwsRetryStrategy.forRetryMode(retryMode));
        } else {
            Consumer<RetryStrategy.Builder<?, ?>> configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder<?, ?> defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option(SdkClientOption.RETRY_STRATEGY, defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option(SdkClientOption.RETRY_STRATEGY, retryStrategy);
                }
            }
        }
        configuration.option(SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option(SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option(SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List<SdkPlugin> plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        if (plugins.isEmpty()) {
            return configuration.build();
        }
        KendraServiceClientConfigurationBuilder serviceConfigBuilder = new KendraServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient(serviceConfigBuilder);
        }
        updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    @Override
    public void close() {
        clientHandler.close();
    }
}
