/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An attribute returned from an index query.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AdditionalResultAttribute implements SdkPojo, Serializable,
        ToCopyableBuilder<AdditionalResultAttribute.Builder, AdditionalResultAttribute> {
    private static final SdkField<String> KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Key")
            .getter(getter(AdditionalResultAttribute::key)).setter(setter(Builder::key))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Key").build()).build();

    private static final SdkField<String> VALUE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ValueType").getter(getter(AdditionalResultAttribute::valueTypeAsString))
            .setter(setter(Builder::valueType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValueType").build()).build();

    private static final SdkField<AdditionalResultAttributeValue> VALUE_FIELD = SdkField
            .<AdditionalResultAttributeValue> builder(MarshallingType.SDK_POJO).memberName("Value")
            .getter(getter(AdditionalResultAttribute::value)).setter(setter(Builder::value))
            .constructor(AdditionalResultAttributeValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_FIELD, VALUE_TYPE_FIELD,
            VALUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String key;

    private final String valueType;

    private final AdditionalResultAttributeValue value;

    private AdditionalResultAttribute(BuilderImpl builder) {
        this.key = builder.key;
        this.valueType = builder.valueType;
        this.value = builder.value;
    }

    /**
     * <p>
     * The key that identifies the attribute.
     * </p>
     * 
     * @return The key that identifies the attribute.
     */
    public final String key() {
        return key;
    }

    /**
     * <p>
     * The data type of the <code>Value</code> property.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #valueType} will
     * return {@link AdditionalResultAttributeValueType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #valueTypeAsString}.
     * </p>
     * 
     * @return The data type of the <code>Value</code> property.
     * @see AdditionalResultAttributeValueType
     */
    public final AdditionalResultAttributeValueType valueType() {
        return AdditionalResultAttributeValueType.fromValue(valueType);
    }

    /**
     * <p>
     * The data type of the <code>Value</code> property.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #valueType} will
     * return {@link AdditionalResultAttributeValueType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #valueTypeAsString}.
     * </p>
     * 
     * @return The data type of the <code>Value</code> property.
     * @see AdditionalResultAttributeValueType
     */
    public final String valueTypeAsString() {
        return valueType;
    }

    /**
     * <p>
     * An object that contains the attribute value.
     * </p>
     * 
     * @return An object that contains the attribute value.
     */
    public final AdditionalResultAttributeValue value() {
        return value;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(key());
        hashCode = 31 * hashCode + Objects.hashCode(valueTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AdditionalResultAttribute)) {
            return false;
        }
        AdditionalResultAttribute other = (AdditionalResultAttribute) obj;
        return Objects.equals(key(), other.key()) && Objects.equals(valueTypeAsString(), other.valueTypeAsString())
                && Objects.equals(value(), other.value());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AdditionalResultAttribute").add("Key", key()).add("ValueType", valueTypeAsString())
                .add("Value", value()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Key":
            return Optional.ofNullable(clazz.cast(key()));
        case "ValueType":
            return Optional.ofNullable(clazz.cast(valueTypeAsString()));
        case "Value":
            return Optional.ofNullable(clazz.cast(value()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AdditionalResultAttribute, T> g) {
        return obj -> g.apply((AdditionalResultAttribute) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AdditionalResultAttribute> {
        /**
         * <p>
         * The key that identifies the attribute.
         * </p>
         * 
         * @param key
         *        The key that identifies the attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder key(String key);

        /**
         * <p>
         * The data type of the <code>Value</code> property.
         * </p>
         * 
         * @param valueType
         *        The data type of the <code>Value</code> property.
         * @see AdditionalResultAttributeValueType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AdditionalResultAttributeValueType
         */
        Builder valueType(String valueType);

        /**
         * <p>
         * The data type of the <code>Value</code> property.
         * </p>
         * 
         * @param valueType
         *        The data type of the <code>Value</code> property.
         * @see AdditionalResultAttributeValueType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AdditionalResultAttributeValueType
         */
        Builder valueType(AdditionalResultAttributeValueType valueType);

        /**
         * <p>
         * An object that contains the attribute value.
         * </p>
         * 
         * @param value
         *        An object that contains the attribute value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(AdditionalResultAttributeValue value);

        /**
         * <p>
         * An object that contains the attribute value.
         * </p>
         * This is a convenience method that creates an instance of the {@link AdditionalResultAttributeValue.Builder}
         * avoiding the need to create one manually via {@link AdditionalResultAttributeValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AdditionalResultAttributeValue.Builder#build()} is called
         * immediately and its result is passed to {@link #value(AdditionalResultAttributeValue)}.
         * 
         * @param value
         *        a consumer that will call methods on {@link AdditionalResultAttributeValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #value(AdditionalResultAttributeValue)
         */
        default Builder value(Consumer<AdditionalResultAttributeValue.Builder> value) {
            return value(AdditionalResultAttributeValue.builder().applyMutation(value).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String key;

        private String valueType;

        private AdditionalResultAttributeValue value;

        private BuilderImpl() {
        }

        private BuilderImpl(AdditionalResultAttribute model) {
            key(model.key);
            valueType(model.valueType);
            value(model.value);
        }

        public final String getKey() {
            return key;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final String getValueType() {
            return valueType;
        }

        public final void setValueType(String valueType) {
            this.valueType = valueType;
        }

        @Override
        public final Builder valueType(String valueType) {
            this.valueType = valueType;
            return this;
        }

        @Override
        public final Builder valueType(AdditionalResultAttributeValueType valueType) {
            this.valueType(valueType == null ? null : valueType.toString());
            return this;
        }

        public final AdditionalResultAttributeValue.Builder getValue() {
            return value != null ? value.toBuilder() : null;
        }

        public final void setValue(AdditionalResultAttributeValue.BuilderImpl value) {
            this.value = value != null ? value.build() : null;
        }

        @Override
        public final Builder value(AdditionalResultAttributeValue value) {
            this.value = value;
            return this;
        }

        @Override
        public AdditionalResultAttribute build() {
            return new AdditionalResultAttribute(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
