/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kendra.model.FeaturedResultsSetSummary;
import software.amazon.awssdk.services.kendra.model.FeaturedResultsSetSummaryItemsCopier;
import software.amazon.awssdk.services.kendra.model.KendraResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListFeaturedResultsSetsResponse
extends KendraResponse
implements ToCopyableBuilder<Builder, ListFeaturedResultsSetsResponse> {
    private static final SdkField<List<FeaturedResultsSetSummary>> FEATURED_RESULTS_SET_SUMMARY_ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FeaturedResultsSetSummaryItems").getter(ListFeaturedResultsSetsResponse.getter(ListFeaturedResultsSetsResponse::featuredResultsSetSummaryItems)).setter(ListFeaturedResultsSetsResponse.setter(Builder::featuredResultsSetSummaryItems)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeaturedResultsSetSummaryItems").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FeaturedResultsSetSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListFeaturedResultsSetsResponse.getter(ListFeaturedResultsSetsResponse::nextToken)).setter(ListFeaturedResultsSetsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FEATURED_RESULTS_SET_SUMMARY_ITEMS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("FeaturedResultsSetSummaryItems", FEATURED_RESULTS_SET_SUMMARY_ITEMS_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<FeaturedResultsSetSummary> featuredResultsSetSummaryItems;
    private final String nextToken;

    private ListFeaturedResultsSetsResponse(BuilderImpl builder) {
        super(builder);
        this.featuredResultsSetSummaryItems = builder.featuredResultsSetSummaryItems;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasFeaturedResultsSetSummaryItems() {
        return this.featuredResultsSetSummaryItems != null && !(this.featuredResultsSetSummaryItems instanceof SdkAutoConstructList);
    }

    public final List<FeaturedResultsSetSummary> featuredResultsSetSummaryItems() {
        return this.featuredResultsSetSummaryItems;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFeaturedResultsSetSummaryItems() ? this.featuredResultsSetSummaryItems() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFeaturedResultsSetsResponse)) {
            return false;
        }
        ListFeaturedResultsSetsResponse other = (ListFeaturedResultsSetsResponse)((Object)obj);
        return this.hasFeaturedResultsSetSummaryItems() == other.hasFeaturedResultsSetSummaryItems() && Objects.equals(this.featuredResultsSetSummaryItems(), other.featuredResultsSetSummaryItems()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListFeaturedResultsSetsResponse").add("FeaturedResultsSetSummaryItems", this.hasFeaturedResultsSetSummaryItems() ? this.featuredResultsSetSummaryItems() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FeaturedResultsSetSummaryItems": {
                return Optional.ofNullable(clazz.cast(this.featuredResultsSetSummaryItems()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListFeaturedResultsSetsResponse, T> g) {
        return obj -> g.apply((ListFeaturedResultsSetsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KendraResponse.BuilderImpl
    implements Builder {
        private List<FeaturedResultsSetSummary> featuredResultsSetSummaryItems = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListFeaturedResultsSetsResponse model) {
            super(model);
            this.featuredResultsSetSummaryItems(model.featuredResultsSetSummaryItems);
            this.nextToken(model.nextToken);
        }

        public final List<FeaturedResultsSetSummary.Builder> getFeaturedResultsSetSummaryItems() {
            List<FeaturedResultsSetSummary.Builder> result = FeaturedResultsSetSummaryItemsCopier.copyToBuilder(this.featuredResultsSetSummaryItems);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFeaturedResultsSetSummaryItems(Collection<FeaturedResultsSetSummary.BuilderImpl> featuredResultsSetSummaryItems) {
            this.featuredResultsSetSummaryItems = FeaturedResultsSetSummaryItemsCopier.copyFromBuilder(featuredResultsSetSummaryItems);
        }

        @Override
        public final Builder featuredResultsSetSummaryItems(Collection<FeaturedResultsSetSummary> featuredResultsSetSummaryItems) {
            this.featuredResultsSetSummaryItems = FeaturedResultsSetSummaryItemsCopier.copy(featuredResultsSetSummaryItems);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder featuredResultsSetSummaryItems(FeaturedResultsSetSummary ... featuredResultsSetSummaryItems) {
            this.featuredResultsSetSummaryItems(Arrays.asList(featuredResultsSetSummaryItems));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder featuredResultsSetSummaryItems(Consumer<FeaturedResultsSetSummary.Builder> ... featuredResultsSetSummaryItems) {
            this.featuredResultsSetSummaryItems(Stream.of(featuredResultsSetSummaryItems).map(c -> (FeaturedResultsSetSummary)((FeaturedResultsSetSummary.Builder)FeaturedResultsSetSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListFeaturedResultsSetsResponse build() {
            return new ListFeaturedResultsSetsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends KendraResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListFeaturedResultsSetsResponse> {
        public Builder featuredResultsSetSummaryItems(Collection<FeaturedResultsSetSummary> var1);

        public Builder featuredResultsSetSummaryItems(FeaturedResultsSetSummary ... var1);

        public Builder featuredResultsSetSummaryItems(Consumer<FeaturedResultsSetSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

