/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kendra.model.DataSourceInclusionsExclusionsStringsCopier;
import software.amazon.awssdk.services.kendra.model.DataSourceToIndexFieldMapping;
import software.amazon.awssdk.services.kendra.model.DataSourceToIndexFieldMappingListCopier;
import software.amazon.awssdk.services.kendra.model.ExcludeMimeTypesListCopier;
import software.amazon.awssdk.services.kendra.model.ExcludeSharedDrivesListCopier;
import software.amazon.awssdk.services.kendra.model.ExcludeUserAccountsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GoogleDriveConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GoogleDriveConfiguration> {
    private static final SdkField<String> SECRET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SecretArn").getter(GoogleDriveConfiguration.getter(GoogleDriveConfiguration::secretArn)).setter(GoogleDriveConfiguration.setter(Builder::secretArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretArn").build()}).build();
    private static final SdkField<List<String>> INCLUSION_PATTERNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InclusionPatterns").getter(GoogleDriveConfiguration.getter(GoogleDriveConfiguration::inclusionPatterns)).setter(GoogleDriveConfiguration.setter(Builder::inclusionPatterns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InclusionPatterns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> EXCLUSION_PATTERNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ExclusionPatterns").getter(GoogleDriveConfiguration.getter(GoogleDriveConfiguration::exclusionPatterns)).setter(GoogleDriveConfiguration.setter(Builder::exclusionPatterns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExclusionPatterns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<DataSourceToIndexFieldMapping>> FIELD_MAPPINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FieldMappings").getter(GoogleDriveConfiguration.getter(GoogleDriveConfiguration::fieldMappings)).setter(GoogleDriveConfiguration.setter(Builder::fieldMappings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldMappings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DataSourceToIndexFieldMapping::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> EXCLUDE_MIME_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ExcludeMimeTypes").getter(GoogleDriveConfiguration.getter(GoogleDriveConfiguration::excludeMimeTypes)).setter(GoogleDriveConfiguration.setter(Builder::excludeMimeTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExcludeMimeTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> EXCLUDE_USER_ACCOUNTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ExcludeUserAccounts").getter(GoogleDriveConfiguration.getter(GoogleDriveConfiguration::excludeUserAccounts)).setter(GoogleDriveConfiguration.setter(Builder::excludeUserAccounts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExcludeUserAccounts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> EXCLUDE_SHARED_DRIVES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ExcludeSharedDrives").getter(GoogleDriveConfiguration.getter(GoogleDriveConfiguration::excludeSharedDrives)).setter(GoogleDriveConfiguration.setter(Builder::excludeSharedDrives)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExcludeSharedDrives").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SECRET_ARN_FIELD, INCLUSION_PATTERNS_FIELD, EXCLUSION_PATTERNS_FIELD, FIELD_MAPPINGS_FIELD, EXCLUDE_MIME_TYPES_FIELD, EXCLUDE_USER_ACCOUNTS_FIELD, EXCLUDE_SHARED_DRIVES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("SecretArn", SECRET_ARN_FIELD);
            this.put("InclusionPatterns", INCLUSION_PATTERNS_FIELD);
            this.put("ExclusionPatterns", EXCLUSION_PATTERNS_FIELD);
            this.put("FieldMappings", FIELD_MAPPINGS_FIELD);
            this.put("ExcludeMimeTypes", EXCLUDE_MIME_TYPES_FIELD);
            this.put("ExcludeUserAccounts", EXCLUDE_USER_ACCOUNTS_FIELD);
            this.put("ExcludeSharedDrives", EXCLUDE_SHARED_DRIVES_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String secretArn;
    private final List<String> inclusionPatterns;
    private final List<String> exclusionPatterns;
    private final List<DataSourceToIndexFieldMapping> fieldMappings;
    private final List<String> excludeMimeTypes;
    private final List<String> excludeUserAccounts;
    private final List<String> excludeSharedDrives;

    private GoogleDriveConfiguration(BuilderImpl builder) {
        this.secretArn = builder.secretArn;
        this.inclusionPatterns = builder.inclusionPatterns;
        this.exclusionPatterns = builder.exclusionPatterns;
        this.fieldMappings = builder.fieldMappings;
        this.excludeMimeTypes = builder.excludeMimeTypes;
        this.excludeUserAccounts = builder.excludeUserAccounts;
        this.excludeSharedDrives = builder.excludeSharedDrives;
    }

    public final String secretArn() {
        return this.secretArn;
    }

    public final boolean hasInclusionPatterns() {
        return this.inclusionPatterns != null && !(this.inclusionPatterns instanceof SdkAutoConstructList);
    }

    public final List<String> inclusionPatterns() {
        return this.inclusionPatterns;
    }

    public final boolean hasExclusionPatterns() {
        return this.exclusionPatterns != null && !(this.exclusionPatterns instanceof SdkAutoConstructList);
    }

    public final List<String> exclusionPatterns() {
        return this.exclusionPatterns;
    }

    public final boolean hasFieldMappings() {
        return this.fieldMappings != null && !(this.fieldMappings instanceof SdkAutoConstructList);
    }

    public final List<DataSourceToIndexFieldMapping> fieldMappings() {
        return this.fieldMappings;
    }

    public final boolean hasExcludeMimeTypes() {
        return this.excludeMimeTypes != null && !(this.excludeMimeTypes instanceof SdkAutoConstructList);
    }

    public final List<String> excludeMimeTypes() {
        return this.excludeMimeTypes;
    }

    public final boolean hasExcludeUserAccounts() {
        return this.excludeUserAccounts != null && !(this.excludeUserAccounts instanceof SdkAutoConstructList);
    }

    public final List<String> excludeUserAccounts() {
        return this.excludeUserAccounts;
    }

    public final boolean hasExcludeSharedDrives() {
        return this.excludeSharedDrives != null && !(this.excludeSharedDrives instanceof SdkAutoConstructList);
    }

    public final List<String> excludeSharedDrives() {
        return this.excludeSharedDrives;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.secretArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInclusionPatterns() ? this.inclusionPatterns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExclusionPatterns() ? this.exclusionPatterns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFieldMappings() ? this.fieldMappings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExcludeMimeTypes() ? this.excludeMimeTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExcludeUserAccounts() ? this.excludeUserAccounts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExcludeSharedDrives() ? this.excludeSharedDrives() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GoogleDriveConfiguration)) {
            return false;
        }
        GoogleDriveConfiguration other = (GoogleDriveConfiguration)obj;
        return Objects.equals(this.secretArn(), other.secretArn()) && this.hasInclusionPatterns() == other.hasInclusionPatterns() && Objects.equals(this.inclusionPatterns(), other.inclusionPatterns()) && this.hasExclusionPatterns() == other.hasExclusionPatterns() && Objects.equals(this.exclusionPatterns(), other.exclusionPatterns()) && this.hasFieldMappings() == other.hasFieldMappings() && Objects.equals(this.fieldMappings(), other.fieldMappings()) && this.hasExcludeMimeTypes() == other.hasExcludeMimeTypes() && Objects.equals(this.excludeMimeTypes(), other.excludeMimeTypes()) && this.hasExcludeUserAccounts() == other.hasExcludeUserAccounts() && Objects.equals(this.excludeUserAccounts(), other.excludeUserAccounts()) && this.hasExcludeSharedDrives() == other.hasExcludeSharedDrives() && Objects.equals(this.excludeSharedDrives(), other.excludeSharedDrives());
    }

    public final String toString() {
        return ToString.builder((String)"GoogleDriveConfiguration").add("SecretArn", (Object)this.secretArn()).add("InclusionPatterns", this.hasInclusionPatterns() ? this.inclusionPatterns() : null).add("ExclusionPatterns", this.hasExclusionPatterns() ? this.exclusionPatterns() : null).add("FieldMappings", this.hasFieldMappings() ? this.fieldMappings() : null).add("ExcludeMimeTypes", this.hasExcludeMimeTypes() ? this.excludeMimeTypes() : null).add("ExcludeUserAccounts", this.hasExcludeUserAccounts() ? this.excludeUserAccounts() : null).add("ExcludeSharedDrives", this.hasExcludeSharedDrives() ? this.excludeSharedDrives() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SecretArn": {
                return Optional.ofNullable(clazz.cast(this.secretArn()));
            }
            case "InclusionPatterns": {
                return Optional.ofNullable(clazz.cast(this.inclusionPatterns()));
            }
            case "ExclusionPatterns": {
                return Optional.ofNullable(clazz.cast(this.exclusionPatterns()));
            }
            case "FieldMappings": {
                return Optional.ofNullable(clazz.cast(this.fieldMappings()));
            }
            case "ExcludeMimeTypes": {
                return Optional.ofNullable(clazz.cast(this.excludeMimeTypes()));
            }
            case "ExcludeUserAccounts": {
                return Optional.ofNullable(clazz.cast(this.excludeUserAccounts()));
            }
            case "ExcludeSharedDrives": {
                return Optional.ofNullable(clazz.cast(this.excludeSharedDrives()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GoogleDriveConfiguration, T> g) {
        return obj -> g.apply((GoogleDriveConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String secretArn;
        private List<String> inclusionPatterns = DefaultSdkAutoConstructList.getInstance();
        private List<String> exclusionPatterns = DefaultSdkAutoConstructList.getInstance();
        private List<DataSourceToIndexFieldMapping> fieldMappings = DefaultSdkAutoConstructList.getInstance();
        private List<String> excludeMimeTypes = DefaultSdkAutoConstructList.getInstance();
        private List<String> excludeUserAccounts = DefaultSdkAutoConstructList.getInstance();
        private List<String> excludeSharedDrives = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GoogleDriveConfiguration model) {
            this.secretArn(model.secretArn);
            this.inclusionPatterns(model.inclusionPatterns);
            this.exclusionPatterns(model.exclusionPatterns);
            this.fieldMappings(model.fieldMappings);
            this.excludeMimeTypes(model.excludeMimeTypes);
            this.excludeUserAccounts(model.excludeUserAccounts);
            this.excludeSharedDrives(model.excludeSharedDrives);
        }

        public final String getSecretArn() {
            return this.secretArn;
        }

        public final void setSecretArn(String secretArn) {
            this.secretArn = secretArn;
        }

        @Override
        public final Builder secretArn(String secretArn) {
            this.secretArn = secretArn;
            return this;
        }

        public final Collection<String> getInclusionPatterns() {
            if (this.inclusionPatterns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.inclusionPatterns;
        }

        public final void setInclusionPatterns(Collection<String> inclusionPatterns) {
            this.inclusionPatterns = DataSourceInclusionsExclusionsStringsCopier.copy(inclusionPatterns);
        }

        @Override
        public final Builder inclusionPatterns(Collection<String> inclusionPatterns) {
            this.inclusionPatterns = DataSourceInclusionsExclusionsStringsCopier.copy(inclusionPatterns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inclusionPatterns(String ... inclusionPatterns) {
            this.inclusionPatterns(Arrays.asList(inclusionPatterns));
            return this;
        }

        public final Collection<String> getExclusionPatterns() {
            if (this.exclusionPatterns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.exclusionPatterns;
        }

        public final void setExclusionPatterns(Collection<String> exclusionPatterns) {
            this.exclusionPatterns = DataSourceInclusionsExclusionsStringsCopier.copy(exclusionPatterns);
        }

        @Override
        public final Builder exclusionPatterns(Collection<String> exclusionPatterns) {
            this.exclusionPatterns = DataSourceInclusionsExclusionsStringsCopier.copy(exclusionPatterns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exclusionPatterns(String ... exclusionPatterns) {
            this.exclusionPatterns(Arrays.asList(exclusionPatterns));
            return this;
        }

        public final List<DataSourceToIndexFieldMapping.Builder> getFieldMappings() {
            List<DataSourceToIndexFieldMapping.Builder> result = DataSourceToIndexFieldMappingListCopier.copyToBuilder(this.fieldMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFieldMappings(Collection<DataSourceToIndexFieldMapping.BuilderImpl> fieldMappings) {
            this.fieldMappings = DataSourceToIndexFieldMappingListCopier.copyFromBuilder(fieldMappings);
        }

        @Override
        public final Builder fieldMappings(Collection<DataSourceToIndexFieldMapping> fieldMappings) {
            this.fieldMappings = DataSourceToIndexFieldMappingListCopier.copy(fieldMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fieldMappings(DataSourceToIndexFieldMapping ... fieldMappings) {
            this.fieldMappings(Arrays.asList(fieldMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fieldMappings(Consumer<DataSourceToIndexFieldMapping.Builder> ... fieldMappings) {
            this.fieldMappings(Stream.of(fieldMappings).map(c -> (DataSourceToIndexFieldMapping)((DataSourceToIndexFieldMapping.Builder)DataSourceToIndexFieldMapping.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getExcludeMimeTypes() {
            if (this.excludeMimeTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.excludeMimeTypes;
        }

        public final void setExcludeMimeTypes(Collection<String> excludeMimeTypes) {
            this.excludeMimeTypes = ExcludeMimeTypesListCopier.copy(excludeMimeTypes);
        }

        @Override
        public final Builder excludeMimeTypes(Collection<String> excludeMimeTypes) {
            this.excludeMimeTypes = ExcludeMimeTypesListCopier.copy(excludeMimeTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder excludeMimeTypes(String ... excludeMimeTypes) {
            this.excludeMimeTypes(Arrays.asList(excludeMimeTypes));
            return this;
        }

        public final Collection<String> getExcludeUserAccounts() {
            if (this.excludeUserAccounts instanceof SdkAutoConstructList) {
                return null;
            }
            return this.excludeUserAccounts;
        }

        public final void setExcludeUserAccounts(Collection<String> excludeUserAccounts) {
            this.excludeUserAccounts = ExcludeUserAccountsListCopier.copy(excludeUserAccounts);
        }

        @Override
        public final Builder excludeUserAccounts(Collection<String> excludeUserAccounts) {
            this.excludeUserAccounts = ExcludeUserAccountsListCopier.copy(excludeUserAccounts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder excludeUserAccounts(String ... excludeUserAccounts) {
            this.excludeUserAccounts(Arrays.asList(excludeUserAccounts));
            return this;
        }

        public final Collection<String> getExcludeSharedDrives() {
            if (this.excludeSharedDrives instanceof SdkAutoConstructList) {
                return null;
            }
            return this.excludeSharedDrives;
        }

        public final void setExcludeSharedDrives(Collection<String> excludeSharedDrives) {
            this.excludeSharedDrives = ExcludeSharedDrivesListCopier.copy(excludeSharedDrives);
        }

        @Override
        public final Builder excludeSharedDrives(Collection<String> excludeSharedDrives) {
            this.excludeSharedDrives = ExcludeSharedDrivesListCopier.copy(excludeSharedDrives);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder excludeSharedDrives(String ... excludeSharedDrives) {
            this.excludeSharedDrives(Arrays.asList(excludeSharedDrives));
            return this;
        }

        public GoogleDriveConfiguration build() {
            return new GoogleDriveConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GoogleDriveConfiguration> {
        public Builder secretArn(String var1);

        public Builder inclusionPatterns(Collection<String> var1);

        public Builder inclusionPatterns(String ... var1);

        public Builder exclusionPatterns(Collection<String> var1);

        public Builder exclusionPatterns(String ... var1);

        public Builder fieldMappings(Collection<DataSourceToIndexFieldMapping> var1);

        public Builder fieldMappings(DataSourceToIndexFieldMapping ... var1);

        public Builder fieldMappings(Consumer<DataSourceToIndexFieldMapping.Builder> ... var1);

        public Builder excludeMimeTypes(Collection<String> var1);

        public Builder excludeMimeTypes(String ... var1);

        public Builder excludeUserAccounts(Collection<String> var1);

        public Builder excludeUserAccounts(String ... var1);

        public Builder excludeSharedDrives(Collection<String> var1);

        public Builder excludeSharedDrives(String ... var1);
    }
}

