/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssociatePersonasToEntitiesRequest extends KendraRequest implements
        ToCopyableBuilder<AssociatePersonasToEntitiesRequest.Builder, AssociatePersonasToEntitiesRequest> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(AssociatePersonasToEntitiesRequest::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> INDEX_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IndexId").getter(getter(AssociatePersonasToEntitiesRequest::indexId)).setter(setter(Builder::indexId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexId").build()).build();

    private static final SdkField<List<EntityPersonaConfiguration>> PERSONAS_FIELD = SdkField
            .<List<EntityPersonaConfiguration>> builder(MarshallingType.LIST)
            .memberName("Personas")
            .getter(getter(AssociatePersonasToEntitiesRequest::personas))
            .setter(setter(Builder::personas))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Personas").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EntityPersonaConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(EntityPersonaConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, INDEX_ID_FIELD,
            PERSONAS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String id;

    private final String indexId;

    private final List<EntityPersonaConfiguration> personas;

    private AssociatePersonasToEntitiesRequest(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.indexId = builder.indexId;
        this.personas = builder.personas;
    }

    /**
     * <p>
     * The identifier of your Amazon Kendra experience.
     * </p>
     * 
     * @return The identifier of your Amazon Kendra experience.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The identifier of the index for your Amazon Kendra experience.
     * </p>
     * 
     * @return The identifier of the index for your Amazon Kendra experience.
     */
    public final String indexId() {
        return indexId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Personas property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasPersonas() {
        return personas != null && !(personas instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The personas that define the specific permissions of users or groups in your IAM Identity Center identity source.
     * The available personas or access roles are <code>Owner</code> and <code>Viewer</code>. For more information on
     * these personas, see <a href=
     * "https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html#access-search-experience"
     * >Providing access to your search page</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPersonas} method.
     * </p>
     * 
     * @return The personas that define the specific permissions of users or groups in your IAM Identity Center identity
     *         source. The available personas or access roles are <code>Owner</code> and <code>Viewer</code>. For more
     *         information on these personas, see <a href=
     *         "https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html#access-search-experience"
     *         >Providing access to your search page</a>.
     */
    public final List<EntityPersonaConfiguration> personas() {
        return personas;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(indexId());
        hashCode = 31 * hashCode + Objects.hashCode(hasPersonas() ? personas() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociatePersonasToEntitiesRequest)) {
            return false;
        }
        AssociatePersonasToEntitiesRequest other = (AssociatePersonasToEntitiesRequest) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(indexId(), other.indexId())
                && hasPersonas() == other.hasPersonas() && Objects.equals(personas(), other.personas());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssociatePersonasToEntitiesRequest").add("Id", id()).add("IndexId", indexId())
                .add("Personas", hasPersonas() ? personas() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "IndexId":
            return Optional.ofNullable(clazz.cast(indexId()));
        case "Personas":
            return Optional.ofNullable(clazz.cast(personas()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Id", ID_FIELD);
        map.put("IndexId", INDEX_ID_FIELD);
        map.put("Personas", PERSONAS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssociatePersonasToEntitiesRequest, T> g) {
        return obj -> g.apply((AssociatePersonasToEntitiesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KendraRequest.Builder, SdkPojo, CopyableBuilder<Builder, AssociatePersonasToEntitiesRequest> {
        /**
         * <p>
         * The identifier of your Amazon Kendra experience.
         * </p>
         * 
         * @param id
         *        The identifier of your Amazon Kendra experience.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The identifier of the index for your Amazon Kendra experience.
         * </p>
         * 
         * @param indexId
         *        The identifier of the index for your Amazon Kendra experience.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexId(String indexId);

        /**
         * <p>
         * The personas that define the specific permissions of users or groups in your IAM Identity Center identity
         * source. The available personas or access roles are <code>Owner</code> and <code>Viewer</code>. For more
         * information on these personas, see <a href=
         * "https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html#access-search-experience"
         * >Providing access to your search page</a>.
         * </p>
         * 
         * @param personas
         *        The personas that define the specific permissions of users or groups in your IAM Identity Center
         *        identity source. The available personas or access roles are <code>Owner</code> and <code>Viewer</code>
         *        . For more information on these personas, see <a href=
         *        "https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html#access-search-experience"
         *        >Providing access to your search page</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder personas(Collection<EntityPersonaConfiguration> personas);

        /**
         * <p>
         * The personas that define the specific permissions of users or groups in your IAM Identity Center identity
         * source. The available personas or access roles are <code>Owner</code> and <code>Viewer</code>. For more
         * information on these personas, see <a href=
         * "https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html#access-search-experience"
         * >Providing access to your search page</a>.
         * </p>
         * 
         * @param personas
         *        The personas that define the specific permissions of users or groups in your IAM Identity Center
         *        identity source. The available personas or access roles are <code>Owner</code> and <code>Viewer</code>
         *        . For more information on these personas, see <a href=
         *        "https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html#access-search-experience"
         *        >Providing access to your search page</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder personas(EntityPersonaConfiguration... personas);

        /**
         * <p>
         * The personas that define the specific permissions of users or groups in your IAM Identity Center identity
         * source. The available personas or access roles are <code>Owner</code> and <code>Viewer</code>. For more
         * information on these personas, see <a href=
         * "https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html#access-search-experience"
         * >Providing access to your search page</a>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.kendra.model.EntityPersonaConfiguration.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.kendra.model.EntityPersonaConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.kendra.model.EntityPersonaConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #personas(List<EntityPersonaConfiguration>)}.
         * 
         * @param personas
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.kendra.model.EntityPersonaConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #personas(java.util.Collection<EntityPersonaConfiguration>)
         */
        Builder personas(Consumer<EntityPersonaConfiguration.Builder>... personas);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends KendraRequest.BuilderImpl implements Builder {
        private String id;

        private String indexId;

        private List<EntityPersonaConfiguration> personas = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AssociatePersonasToEntitiesRequest model) {
            super(model);
            id(model.id);
            indexId(model.indexId);
            personas(model.personas);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getIndexId() {
            return indexId;
        }

        public final void setIndexId(String indexId) {
            this.indexId = indexId;
        }

        @Override
        public final Builder indexId(String indexId) {
            this.indexId = indexId;
            return this;
        }

        public final List<EntityPersonaConfiguration.Builder> getPersonas() {
            List<EntityPersonaConfiguration.Builder> result = EntityPersonaConfigurationListCopier.copyToBuilder(this.personas);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPersonas(Collection<EntityPersonaConfiguration.BuilderImpl> personas) {
            this.personas = EntityPersonaConfigurationListCopier.copyFromBuilder(personas);
        }

        @Override
        public final Builder personas(Collection<EntityPersonaConfiguration> personas) {
            this.personas = EntityPersonaConfigurationListCopier.copy(personas);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder personas(EntityPersonaConfiguration... personas) {
            personas(Arrays.asList(personas));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder personas(Consumer<EntityPersonaConfiguration.Builder>... personas) {
            personas(Stream.of(personas).map(c -> EntityPersonaConfiguration.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociatePersonasToEntitiesRequest build() {
            return new AssociatePersonasToEntitiesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
