/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides the configuration information for the document fields/attributes that you want to base query suggestions on.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AttributeSuggestionsGetConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<AttributeSuggestionsGetConfig.Builder, AttributeSuggestionsGetConfig> {
    private static final SdkField<List<String>> SUGGESTION_ATTRIBUTES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SuggestionAttributes")
            .getter(getter(AttributeSuggestionsGetConfig::suggestionAttributes))
            .setter(setter(Builder::suggestionAttributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SuggestionAttributes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> ADDITIONAL_RESPONSE_ATTRIBUTES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AdditionalResponseAttributes")
            .getter(getter(AttributeSuggestionsGetConfig::additionalResponseAttributes))
            .setter(setter(Builder::additionalResponseAttributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalResponseAttributes")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<AttributeFilter> ATTRIBUTE_FILTER_FIELD = SdkField
            .<AttributeFilter> builder(MarshallingType.SDK_POJO).memberName("AttributeFilter")
            .getter(getter(AttributeSuggestionsGetConfig::attributeFilter)).setter(setter(Builder::attributeFilter))
            .constructor(AttributeFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeFilter").build()).build();

    private static final SdkField<UserContext> USER_CONTEXT_FIELD = SdkField.<UserContext> builder(MarshallingType.SDK_POJO)
            .memberName("UserContext").getter(getter(AttributeSuggestionsGetConfig::userContext))
            .setter(setter(Builder::userContext)).constructor(UserContext::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserContext").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUGGESTION_ATTRIBUTES_FIELD,
            ADDITIONAL_RESPONSE_ATTRIBUTES_FIELD, ATTRIBUTE_FILTER_FIELD, USER_CONTEXT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> suggestionAttributes;

    private final List<String> additionalResponseAttributes;

    private final AttributeFilter attributeFilter;

    private final UserContext userContext;

    private AttributeSuggestionsGetConfig(BuilderImpl builder) {
        this.suggestionAttributes = builder.suggestionAttributes;
        this.additionalResponseAttributes = builder.additionalResponseAttributes;
        this.attributeFilter = builder.attributeFilter;
        this.userContext = builder.userContext;
    }

    /**
     * For responses, this returns true if the service returned a value for the SuggestionAttributes property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSuggestionAttributes() {
        return suggestionAttributes != null && !(suggestionAttributes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of document field/attribute keys or field names to use for query suggestions. If the content within any
     * of the fields match what your user starts typing as their query, then the field content is returned as a query
     * suggestion.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSuggestionAttributes} method.
     * </p>
     * 
     * @return The list of document field/attribute keys or field names to use for query suggestions. If the content
     *         within any of the fields match what your user starts typing as their query, then the field content is
     *         returned as a query suggestion.
     */
    public final List<String> suggestionAttributes() {
        return suggestionAttributes;
    }

    /**
     * For responses, this returns true if the service returned a value for the AdditionalResponseAttributes property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAdditionalResponseAttributes() {
        return additionalResponseAttributes != null && !(additionalResponseAttributes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of additional document field/attribute keys or field names to include in the response. You can use
     * additional fields to provide extra information in the response. Additional fields are not used to based
     * suggestions on.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAdditionalResponseAttributes} method.
     * </p>
     * 
     * @return The list of additional document field/attribute keys or field names to include in the response. You can
     *         use additional fields to provide extra information in the response. Additional fields are not used to
     *         based suggestions on.
     */
    public final List<String> additionalResponseAttributes() {
        return additionalResponseAttributes;
    }

    /**
     * <p>
     * Filters the search results based on document fields/attributes.
     * </p>
     * 
     * @return Filters the search results based on document fields/attributes.
     */
    public final AttributeFilter attributeFilter() {
        return attributeFilter;
    }

    /**
     * <p>
     * Applies user context filtering so that only users who are given access to certain documents see these document in
     * their search results.
     * </p>
     * 
     * @return Applies user context filtering so that only users who are given access to certain documents see these
     *         document in their search results.
     */
    public final UserContext userContext() {
        return userContext;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasSuggestionAttributes() ? suggestionAttributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAdditionalResponseAttributes() ? additionalResponseAttributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(attributeFilter());
        hashCode = 31 * hashCode + Objects.hashCode(userContext());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttributeSuggestionsGetConfig)) {
            return false;
        }
        AttributeSuggestionsGetConfig other = (AttributeSuggestionsGetConfig) obj;
        return hasSuggestionAttributes() == other.hasSuggestionAttributes()
                && Objects.equals(suggestionAttributes(), other.suggestionAttributes())
                && hasAdditionalResponseAttributes() == other.hasAdditionalResponseAttributes()
                && Objects.equals(additionalResponseAttributes(), other.additionalResponseAttributes())
                && Objects.equals(attributeFilter(), other.attributeFilter())
                && Objects.equals(userContext(), other.userContext());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AttributeSuggestionsGetConfig")
                .add("SuggestionAttributes", hasSuggestionAttributes() ? suggestionAttributes() : null)
                .add("AdditionalResponseAttributes", hasAdditionalResponseAttributes() ? additionalResponseAttributes() : null)
                .add("AttributeFilter", attributeFilter()).add("UserContext", userContext()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SuggestionAttributes":
            return Optional.ofNullable(clazz.cast(suggestionAttributes()));
        case "AdditionalResponseAttributes":
            return Optional.ofNullable(clazz.cast(additionalResponseAttributes()));
        case "AttributeFilter":
            return Optional.ofNullable(clazz.cast(attributeFilter()));
        case "UserContext":
            return Optional.ofNullable(clazz.cast(userContext()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SuggestionAttributes", SUGGESTION_ATTRIBUTES_FIELD);
        map.put("AdditionalResponseAttributes", ADDITIONAL_RESPONSE_ATTRIBUTES_FIELD);
        map.put("AttributeFilter", ATTRIBUTE_FILTER_FIELD);
        map.put("UserContext", USER_CONTEXT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AttributeSuggestionsGetConfig, T> g) {
        return obj -> g.apply((AttributeSuggestionsGetConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AttributeSuggestionsGetConfig> {
        /**
         * <p>
         * The list of document field/attribute keys or field names to use for query suggestions. If the content within
         * any of the fields match what your user starts typing as their query, then the field content is returned as a
         * query suggestion.
         * </p>
         * 
         * @param suggestionAttributes
         *        The list of document field/attribute keys or field names to use for query suggestions. If the content
         *        within any of the fields match what your user starts typing as their query, then the field content is
         *        returned as a query suggestion.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder suggestionAttributes(Collection<String> suggestionAttributes);

        /**
         * <p>
         * The list of document field/attribute keys or field names to use for query suggestions. If the content within
         * any of the fields match what your user starts typing as their query, then the field content is returned as a
         * query suggestion.
         * </p>
         * 
         * @param suggestionAttributes
         *        The list of document field/attribute keys or field names to use for query suggestions. If the content
         *        within any of the fields match what your user starts typing as their query, then the field content is
         *        returned as a query suggestion.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder suggestionAttributes(String... suggestionAttributes);

        /**
         * <p>
         * The list of additional document field/attribute keys or field names to include in the response. You can use
         * additional fields to provide extra information in the response. Additional fields are not used to based
         * suggestions on.
         * </p>
         * 
         * @param additionalResponseAttributes
         *        The list of additional document field/attribute keys or field names to include in the response. You
         *        can use additional fields to provide extra information in the response. Additional fields are not used
         *        to based suggestions on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalResponseAttributes(Collection<String> additionalResponseAttributes);

        /**
         * <p>
         * The list of additional document field/attribute keys or field names to include in the response. You can use
         * additional fields to provide extra information in the response. Additional fields are not used to based
         * suggestions on.
         * </p>
         * 
         * @param additionalResponseAttributes
         *        The list of additional document field/attribute keys or field names to include in the response. You
         *        can use additional fields to provide extra information in the response. Additional fields are not used
         *        to based suggestions on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalResponseAttributes(String... additionalResponseAttributes);

        /**
         * <p>
         * Filters the search results based on document fields/attributes.
         * </p>
         * 
         * @param attributeFilter
         *        Filters the search results based on document fields/attributes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeFilter(AttributeFilter attributeFilter);

        /**
         * <p>
         * Filters the search results based on document fields/attributes.
         * </p>
         * This is a convenience method that creates an instance of the {@link AttributeFilter.Builder} avoiding the
         * need to create one manually via {@link AttributeFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AttributeFilter.Builder#build()} is called immediately and its
         * result is passed to {@link #attributeFilter(AttributeFilter)}.
         * 
         * @param attributeFilter
         *        a consumer that will call methods on {@link AttributeFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attributeFilter(AttributeFilter)
         */
        default Builder attributeFilter(Consumer<AttributeFilter.Builder> attributeFilter) {
            return attributeFilter(AttributeFilter.builder().applyMutation(attributeFilter).build());
        }

        /**
         * <p>
         * Applies user context filtering so that only users who are given access to certain documents see these
         * document in their search results.
         * </p>
         * 
         * @param userContext
         *        Applies user context filtering so that only users who are given access to certain documents see these
         *        document in their search results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userContext(UserContext userContext);

        /**
         * <p>
         * Applies user context filtering so that only users who are given access to certain documents see these
         * document in their search results.
         * </p>
         * This is a convenience method that creates an instance of the {@link UserContext.Builder} avoiding the need to
         * create one manually via {@link UserContext#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UserContext.Builder#build()} is called immediately and its result
         * is passed to {@link #userContext(UserContext)}.
         * 
         * @param userContext
         *        a consumer that will call methods on {@link UserContext.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #userContext(UserContext)
         */
        default Builder userContext(Consumer<UserContext.Builder> userContext) {
            return userContext(UserContext.builder().applyMutation(userContext).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private List<String> suggestionAttributes = DefaultSdkAutoConstructList.getInstance();

        private List<String> additionalResponseAttributes = DefaultSdkAutoConstructList.getInstance();

        private AttributeFilter attributeFilter;

        private UserContext userContext;

        private BuilderImpl() {
        }

        private BuilderImpl(AttributeSuggestionsGetConfig model) {
            suggestionAttributes(model.suggestionAttributes);
            additionalResponseAttributes(model.additionalResponseAttributes);
            attributeFilter(model.attributeFilter);
            userContext(model.userContext);
        }

        public final Collection<String> getSuggestionAttributes() {
            if (suggestionAttributes instanceof SdkAutoConstructList) {
                return null;
            }
            return suggestionAttributes;
        }

        public final void setSuggestionAttributes(Collection<String> suggestionAttributes) {
            this.suggestionAttributes = DocumentAttributeKeyListCopier.copy(suggestionAttributes);
        }

        @Override
        public final Builder suggestionAttributes(Collection<String> suggestionAttributes) {
            this.suggestionAttributes = DocumentAttributeKeyListCopier.copy(suggestionAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder suggestionAttributes(String... suggestionAttributes) {
            suggestionAttributes(Arrays.asList(suggestionAttributes));
            return this;
        }

        public final Collection<String> getAdditionalResponseAttributes() {
            if (additionalResponseAttributes instanceof SdkAutoConstructList) {
                return null;
            }
            return additionalResponseAttributes;
        }

        public final void setAdditionalResponseAttributes(Collection<String> additionalResponseAttributes) {
            this.additionalResponseAttributes = DocumentAttributeKeyListCopier.copy(additionalResponseAttributes);
        }

        @Override
        public final Builder additionalResponseAttributes(Collection<String> additionalResponseAttributes) {
            this.additionalResponseAttributes = DocumentAttributeKeyListCopier.copy(additionalResponseAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalResponseAttributes(String... additionalResponseAttributes) {
            additionalResponseAttributes(Arrays.asList(additionalResponseAttributes));
            return this;
        }

        public final AttributeFilter.Builder getAttributeFilter() {
            return attributeFilter != null ? attributeFilter.toBuilder() : null;
        }

        public final void setAttributeFilter(AttributeFilter.BuilderImpl attributeFilter) {
            this.attributeFilter = attributeFilter != null ? attributeFilter.build() : null;
        }

        @Override
        public final Builder attributeFilter(AttributeFilter attributeFilter) {
            this.attributeFilter = attributeFilter;
            return this;
        }

        public final UserContext.Builder getUserContext() {
            return userContext != null ? userContext.toBuilder() : null;
        }

        public final void setUserContext(UserContext.BuilderImpl userContext) {
            this.userContext = userContext != null ? userContext.build() : null;
        }

        @Override
        public final Builder userContext(UserContext userContext) {
            this.userContext = userContext;
            return this;
        }

        @Override
        public AttributeSuggestionsGetConfig build() {
            return new AttributeSuggestionsGetConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
