/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides the configuration information to connect to websites that require user authentication.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AuthenticationConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<AuthenticationConfiguration.Builder, AuthenticationConfiguration> {
    private static final SdkField<List<BasicAuthenticationConfiguration>> BASIC_AUTHENTICATION_FIELD = SdkField
            .<List<BasicAuthenticationConfiguration>> builder(MarshallingType.LIST)
            .memberName("BasicAuthentication")
            .getter(getter(AuthenticationConfiguration::basicAuthentication))
            .setter(setter(Builder::basicAuthentication))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BasicAuthentication").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BasicAuthenticationConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(BasicAuthenticationConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BASIC_AUTHENTICATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<BasicAuthenticationConfiguration> basicAuthentication;

    private AuthenticationConfiguration(BuilderImpl builder) {
        this.basicAuthentication = builder.basicAuthentication;
    }

    /**
     * For responses, this returns true if the service returned a value for the BasicAuthentication property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasBasicAuthentication() {
        return basicAuthentication != null && !(basicAuthentication instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of configuration information that's required to connect to and crawl a website host using basic
     * authentication credentials.
     * </p>
     * <p>
     * The list includes the name and port number of the website host.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBasicAuthentication} method.
     * </p>
     * 
     * @return The list of configuration information that's required to connect to and crawl a website host using basic
     *         authentication credentials.</p>
     *         <p>
     *         The list includes the name and port number of the website host.
     */
    public final List<BasicAuthenticationConfiguration> basicAuthentication() {
        return basicAuthentication;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasBasicAuthentication() ? basicAuthentication() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuthenticationConfiguration)) {
            return false;
        }
        AuthenticationConfiguration other = (AuthenticationConfiguration) obj;
        return hasBasicAuthentication() == other.hasBasicAuthentication()
                && Objects.equals(basicAuthentication(), other.basicAuthentication());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AuthenticationConfiguration")
                .add("BasicAuthentication", hasBasicAuthentication() ? basicAuthentication() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BasicAuthentication":
            return Optional.ofNullable(clazz.cast(basicAuthentication()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("BasicAuthentication", BASIC_AUTHENTICATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AuthenticationConfiguration, T> g) {
        return obj -> g.apply((AuthenticationConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AuthenticationConfiguration> {
        /**
         * <p>
         * The list of configuration information that's required to connect to and crawl a website host using basic
         * authentication credentials.
         * </p>
         * <p>
         * The list includes the name and port number of the website host.
         * </p>
         * 
         * @param basicAuthentication
         *        The list of configuration information that's required to connect to and crawl a website host using
         *        basic authentication credentials.</p>
         *        <p>
         *        The list includes the name and port number of the website host.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder basicAuthentication(Collection<BasicAuthenticationConfiguration> basicAuthentication);

        /**
         * <p>
         * The list of configuration information that's required to connect to and crawl a website host using basic
         * authentication credentials.
         * </p>
         * <p>
         * The list includes the name and port number of the website host.
         * </p>
         * 
         * @param basicAuthentication
         *        The list of configuration information that's required to connect to and crawl a website host using
         *        basic authentication credentials.</p>
         *        <p>
         *        The list includes the name and port number of the website host.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder basicAuthentication(BasicAuthenticationConfiguration... basicAuthentication);

        /**
         * <p>
         * The list of configuration information that's required to connect to and crawl a website host using basic
         * authentication credentials.
         * </p>
         * <p>
         * The list includes the name and port number of the website host.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.kendra.model.BasicAuthenticationConfiguration.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.kendra.model.BasicAuthenticationConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.kendra.model.BasicAuthenticationConfiguration.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #basicAuthentication(List<BasicAuthenticationConfiguration>)}.
         * 
         * @param basicAuthentication
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.kendra.model.BasicAuthenticationConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #basicAuthentication(java.util.Collection<BasicAuthenticationConfiguration>)
         */
        Builder basicAuthentication(Consumer<BasicAuthenticationConfiguration.Builder>... basicAuthentication);
    }

    static final class BuilderImpl implements Builder {
        private List<BasicAuthenticationConfiguration> basicAuthentication = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AuthenticationConfiguration model) {
            basicAuthentication(model.basicAuthentication);
        }

        public final List<BasicAuthenticationConfiguration.Builder> getBasicAuthentication() {
            List<BasicAuthenticationConfiguration.Builder> result = BasicAuthenticationConfigurationListCopier
                    .copyToBuilder(this.basicAuthentication);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBasicAuthentication(Collection<BasicAuthenticationConfiguration.BuilderImpl> basicAuthentication) {
            this.basicAuthentication = BasicAuthenticationConfigurationListCopier.copyFromBuilder(basicAuthentication);
        }

        @Override
        public final Builder basicAuthentication(Collection<BasicAuthenticationConfiguration> basicAuthentication) {
            this.basicAuthentication = BasicAuthenticationConfigurationListCopier.copy(basicAuthentication);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder basicAuthentication(BasicAuthenticationConfiguration... basicAuthentication) {
            basicAuthentication(Arrays.asList(basicAuthentication));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder basicAuthentication(Consumer<BasicAuthenticationConfiguration.Builder>... basicAuthentication) {
            basicAuthentication(Stream.of(basicAuthentication)
                    .map(c -> BasicAuthenticationConfiguration.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public AuthenticationConfiguration build() {
            return new AuthenticationConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
