/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides the configuration information to connect to Box as your data source.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BoxConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<BoxConfiguration.Builder, BoxConfiguration> {
    private static final SdkField<String> ENTERPRISE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EnterpriseId").getter(getter(BoxConfiguration::enterpriseId)).setter(setter(Builder::enterpriseId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnterpriseId").build()).build();

    private static final SdkField<String> SECRET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SecretArn").getter(getter(BoxConfiguration::secretArn)).setter(setter(Builder::secretArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretArn").build()).build();

    private static final SdkField<Boolean> USE_CHANGE_LOG_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("UseChangeLog").getter(getter(BoxConfiguration::useChangeLog)).setter(setter(Builder::useChangeLog))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UseChangeLog").build()).build();

    private static final SdkField<Boolean> CRAWL_COMMENTS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("CrawlComments").getter(getter(BoxConfiguration::crawlComments)).setter(setter(Builder::crawlComments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CrawlComments").build()).build();

    private static final SdkField<Boolean> CRAWL_TASKS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("CrawlTasks").getter(getter(BoxConfiguration::crawlTasks)).setter(setter(Builder::crawlTasks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CrawlTasks").build()).build();

    private static final SdkField<Boolean> CRAWL_WEB_LINKS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("CrawlWebLinks").getter(getter(BoxConfiguration::crawlWebLinks)).setter(setter(Builder::crawlWebLinks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CrawlWebLinks").build()).build();

    private static final SdkField<List<DataSourceToIndexFieldMapping>> FILE_FIELD_MAPPINGS_FIELD = SdkField
            .<List<DataSourceToIndexFieldMapping>> builder(MarshallingType.LIST)
            .memberName("FileFieldMappings")
            .getter(getter(BoxConfiguration::fileFieldMappings))
            .setter(setter(Builder::fileFieldMappings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileFieldMappings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DataSourceToIndexFieldMapping> builder(MarshallingType.SDK_POJO)
                                            .constructor(DataSourceToIndexFieldMapping::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<DataSourceToIndexFieldMapping>> TASK_FIELD_MAPPINGS_FIELD = SdkField
            .<List<DataSourceToIndexFieldMapping>> builder(MarshallingType.LIST)
            .memberName("TaskFieldMappings")
            .getter(getter(BoxConfiguration::taskFieldMappings))
            .setter(setter(Builder::taskFieldMappings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskFieldMappings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DataSourceToIndexFieldMapping> builder(MarshallingType.SDK_POJO)
                                            .constructor(DataSourceToIndexFieldMapping::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<DataSourceToIndexFieldMapping>> COMMENT_FIELD_MAPPINGS_FIELD = SdkField
            .<List<DataSourceToIndexFieldMapping>> builder(MarshallingType.LIST)
            .memberName("CommentFieldMappings")
            .getter(getter(BoxConfiguration::commentFieldMappings))
            .setter(setter(Builder::commentFieldMappings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CommentFieldMappings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DataSourceToIndexFieldMapping> builder(MarshallingType.SDK_POJO)
                                            .constructor(DataSourceToIndexFieldMapping::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<DataSourceToIndexFieldMapping>> WEB_LINK_FIELD_MAPPINGS_FIELD = SdkField
            .<List<DataSourceToIndexFieldMapping>> builder(MarshallingType.LIST)
            .memberName("WebLinkFieldMappings")
            .getter(getter(BoxConfiguration::webLinkFieldMappings))
            .setter(setter(Builder::webLinkFieldMappings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WebLinkFieldMappings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DataSourceToIndexFieldMapping> builder(MarshallingType.SDK_POJO)
                                            .constructor(DataSourceToIndexFieldMapping::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> INCLUSION_PATTERNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("InclusionPatterns")
            .getter(getter(BoxConfiguration::inclusionPatterns))
            .setter(setter(Builder::inclusionPatterns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InclusionPatterns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> EXCLUSION_PATTERNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ExclusionPatterns")
            .getter(getter(BoxConfiguration::exclusionPatterns))
            .setter(setter(Builder::exclusionPatterns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExclusionPatterns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<DataSourceVpcConfiguration> VPC_CONFIGURATION_FIELD = SdkField
            .<DataSourceVpcConfiguration> builder(MarshallingType.SDK_POJO).memberName("VpcConfiguration")
            .getter(getter(BoxConfiguration::vpcConfiguration)).setter(setter(Builder::vpcConfiguration))
            .constructor(DataSourceVpcConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcConfiguration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTERPRISE_ID_FIELD,
            SECRET_ARN_FIELD, USE_CHANGE_LOG_FIELD, CRAWL_COMMENTS_FIELD, CRAWL_TASKS_FIELD, CRAWL_WEB_LINKS_FIELD,
            FILE_FIELD_MAPPINGS_FIELD, TASK_FIELD_MAPPINGS_FIELD, COMMENT_FIELD_MAPPINGS_FIELD, WEB_LINK_FIELD_MAPPINGS_FIELD,
            INCLUSION_PATTERNS_FIELD, EXCLUSION_PATTERNS_FIELD, VPC_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String enterpriseId;

    private final String secretArn;

    private final Boolean useChangeLog;

    private final Boolean crawlComments;

    private final Boolean crawlTasks;

    private final Boolean crawlWebLinks;

    private final List<DataSourceToIndexFieldMapping> fileFieldMappings;

    private final List<DataSourceToIndexFieldMapping> taskFieldMappings;

    private final List<DataSourceToIndexFieldMapping> commentFieldMappings;

    private final List<DataSourceToIndexFieldMapping> webLinkFieldMappings;

    private final List<String> inclusionPatterns;

    private final List<String> exclusionPatterns;

    private final DataSourceVpcConfiguration vpcConfiguration;

    private BoxConfiguration(BuilderImpl builder) {
        this.enterpriseId = builder.enterpriseId;
        this.secretArn = builder.secretArn;
        this.useChangeLog = builder.useChangeLog;
        this.crawlComments = builder.crawlComments;
        this.crawlTasks = builder.crawlTasks;
        this.crawlWebLinks = builder.crawlWebLinks;
        this.fileFieldMappings = builder.fileFieldMappings;
        this.taskFieldMappings = builder.taskFieldMappings;
        this.commentFieldMappings = builder.commentFieldMappings;
        this.webLinkFieldMappings = builder.webLinkFieldMappings;
        this.inclusionPatterns = builder.inclusionPatterns;
        this.exclusionPatterns = builder.exclusionPatterns;
        this.vpcConfiguration = builder.vpcConfiguration;
    }

    /**
     * <p>
     * The identifier of the Box Enterprise platform. You can find the enterprise ID in the Box Developer Console
     * settings or when you create an app in Box and download your authentication credentials. For example,
     * <i>801234567</i>.
     * </p>
     * 
     * @return The identifier of the Box Enterprise platform. You can find the enterprise ID in the Box Developer
     *         Console settings or when you create an app in Box and download your authentication credentials. For
     *         example, <i>801234567</i>.
     */
    public final String enterpriseId() {
        return enterpriseId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of an Secrets Manager secret that contains the key-value pairs required to connect
     * to your Box platform. The secret must contain a JSON structure with the following keys:
     * </p>
     * <ul>
     * <li>
     * <p>
     * clientID—The identifier of the client OAuth 2.0 authentication application created in Box.
     * </p>
     * </li>
     * <li>
     * <p>
     * clientSecret—A set of characters known only to the OAuth 2.0 authentication application created in Box.
     * </p>
     * </li>
     * <li>
     * <p>
     * publicKeyId—The identifier of the public key contained within an identity certificate.
     * </p>
     * </li>
     * <li>
     * <p>
     * privateKey—A set of characters that make up an encryption key.
     * </p>
     * </li>
     * <li>
     * <p>
     * passphrase—A set of characters that act like a password.
     * </p>
     * </li>
     * </ul>
     * <p>
     * You create an application in Box to generate the keys or credentials required for the secret. For more
     * information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/data-source-box.html">Using a Box data
     * source</a>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of an Secrets Manager secret that contains the key-value pairs required to
     *         connect to your Box platform. The secret must contain a JSON structure with the following keys:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         clientID—The identifier of the client OAuth 2.0 authentication application created in Box.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         clientSecret—A set of characters known only to the OAuth 2.0 authentication application created in Box.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         publicKeyId—The identifier of the public key contained within an identity certificate.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         privateKey—A set of characters that make up an encryption key.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         passphrase—A set of characters that act like a password.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         You create an application in Box to generate the keys or credentials required for the secret. For more
     *         information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/data-source-box.html">Using a Box
     *         data source</a>.
     */
    public final String secretArn() {
        return secretArn;
    }

    /**
     * <p>
     * <code>TRUE</code> to use the Slack change log to determine which documents require updating in the index.
     * Depending on the data source change log's size, it may take longer for Amazon Kendra to use the change log than
     * to scan all of your documents.
     * </p>
     * 
     * @return <code>TRUE</code> to use the Slack change log to determine which documents require updating in the index.
     *         Depending on the data source change log's size, it may take longer for Amazon Kendra to use the change
     *         log than to scan all of your documents.
     */
    public final Boolean useChangeLog() {
        return useChangeLog;
    }

    /**
     * <p>
     * <code>TRUE</code> to index comments.
     * </p>
     * 
     * @return <code>TRUE</code> to index comments.
     */
    public final Boolean crawlComments() {
        return crawlComments;
    }

    /**
     * <p>
     * <code>TRUE</code> to index the contents of tasks.
     * </p>
     * 
     * @return <code>TRUE</code> to index the contents of tasks.
     */
    public final Boolean crawlTasks() {
        return crawlTasks;
    }

    /**
     * <p>
     * <code>TRUE</code> to index web links.
     * </p>
     * 
     * @return <code>TRUE</code> to index web links.
     */
    public final Boolean crawlWebLinks() {
        return crawlWebLinks;
    }

    /**
     * For responses, this returns true if the service returned a value for the FileFieldMappings property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFileFieldMappings() {
        return fileFieldMappings != null && !(fileFieldMappings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>DataSourceToIndexFieldMapping</code> objects that map attributes or field names of Box files to
     * Amazon Kendra index field names. To create custom fields, use the <code>UpdateIndex</code> API before you map to
     * Box fields. For more information, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a>. The Box
     * field names must exist in your Box custom metadata.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFileFieldMappings} method.
     * </p>
     * 
     * @return A list of <code>DataSourceToIndexFieldMapping</code> objects that map attributes or field names of Box
     *         files to Amazon Kendra index field names. To create custom fields, use the <code>UpdateIndex</code> API
     *         before you map to Box fields. For more information, see <a
     *         href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a>.
     *         The Box field names must exist in your Box custom metadata.
     */
    public final List<DataSourceToIndexFieldMapping> fileFieldMappings() {
        return fileFieldMappings;
    }

    /**
     * For responses, this returns true if the service returned a value for the TaskFieldMappings property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTaskFieldMappings() {
        return taskFieldMappings != null && !(taskFieldMappings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>DataSourceToIndexFieldMapping</code> objects that map attributes or field names of Box tasks to
     * Amazon Kendra index field names. To create custom fields, use the <code>UpdateIndex</code> API before you map to
     * Box fields. For more information, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a>. The Box
     * field names must exist in your Box custom metadata.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTaskFieldMappings} method.
     * </p>
     * 
     * @return A list of <code>DataSourceToIndexFieldMapping</code> objects that map attributes or field names of Box
     *         tasks to Amazon Kendra index field names. To create custom fields, use the <code>UpdateIndex</code> API
     *         before you map to Box fields. For more information, see <a
     *         href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a>.
     *         The Box field names must exist in your Box custom metadata.
     */
    public final List<DataSourceToIndexFieldMapping> taskFieldMappings() {
        return taskFieldMappings;
    }

    /**
     * For responses, this returns true if the service returned a value for the CommentFieldMappings property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCommentFieldMappings() {
        return commentFieldMappings != null && !(commentFieldMappings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>DataSourceToIndexFieldMapping</code> objects that map attributes or field names of Box comments
     * to Amazon Kendra index field names. To create custom fields, use the <code>UpdateIndex</code> API before you map
     * to Box fields. For more information, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a>. The Box
     * field names must exist in your Box custom metadata.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCommentFieldMappings} method.
     * </p>
     * 
     * @return A list of <code>DataSourceToIndexFieldMapping</code> objects that map attributes or field names of Box
     *         comments to Amazon Kendra index field names. To create custom fields, use the <code>UpdateIndex</code>
     *         API before you map to Box fields. For more information, see <a
     *         href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a>.
     *         The Box field names must exist in your Box custom metadata.
     */
    public final List<DataSourceToIndexFieldMapping> commentFieldMappings() {
        return commentFieldMappings;
    }

    /**
     * For responses, this returns true if the service returned a value for the WebLinkFieldMappings property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasWebLinkFieldMappings() {
        return webLinkFieldMappings != null && !(webLinkFieldMappings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>DataSourceToIndexFieldMapping</code> objects that map attributes or field names of Box web links
     * to Amazon Kendra index field names. To create custom fields, use the <code>UpdateIndex</code> API before you map
     * to Box fields. For more information, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a>. The Box
     * field names must exist in your Box custom metadata.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasWebLinkFieldMappings} method.
     * </p>
     * 
     * @return A list of <code>DataSourceToIndexFieldMapping</code> objects that map attributes or field names of Box
     *         web links to Amazon Kendra index field names. To create custom fields, use the <code>UpdateIndex</code>
     *         API before you map to Box fields. For more information, see <a
     *         href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a>.
     *         The Box field names must exist in your Box custom metadata.
     */
    public final List<DataSourceToIndexFieldMapping> webLinkFieldMappings() {
        return webLinkFieldMappings;
    }

    /**
     * For responses, this returns true if the service returned a value for the InclusionPatterns property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInclusionPatterns() {
        return inclusionPatterns != null && !(inclusionPatterns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of regular expression patterns to include certain files and folders in your Box platform. Files and
     * folders that match the patterns are included in the index. Files and folders that don't match the patterns are
     * excluded from the index. If a file or folder matches both an inclusion and exclusion pattern, the exclusion
     * pattern takes precedence and the file or folder isn't included in the index.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInclusionPatterns} method.
     * </p>
     * 
     * @return A list of regular expression patterns to include certain files and folders in your Box platform. Files
     *         and folders that match the patterns are included in the index. Files and folders that don't match the
     *         patterns are excluded from the index. If a file or folder matches both an inclusion and exclusion
     *         pattern, the exclusion pattern takes precedence and the file or folder isn't included in the index.
     */
    public final List<String> inclusionPatterns() {
        return inclusionPatterns;
    }

    /**
     * For responses, this returns true if the service returned a value for the ExclusionPatterns property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasExclusionPatterns() {
        return exclusionPatterns != null && !(exclusionPatterns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of regular expression patterns to exclude certain files and folders from your Box platform. Files and
     * folders that match the patterns are excluded from the index.Files and folders that don't match the patterns are
     * included in the index. If a file or folder matches both an inclusion and exclusion pattern, the exclusion pattern
     * takes precedence and the file or folder isn't included in the index.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasExclusionPatterns} method.
     * </p>
     * 
     * @return A list of regular expression patterns to exclude certain files and folders from your Box platform. Files
     *         and folders that match the patterns are excluded from the index.Files and folders that don't match the
     *         patterns are included in the index. If a file or folder matches both an inclusion and exclusion pattern,
     *         the exclusion pattern takes precedence and the file or folder isn't included in the index.
     */
    public final List<String> exclusionPatterns() {
        return exclusionPatterns;
    }

    /**
     * <p>
     * Configuration information for an Amazon VPC to connect to your Box. For more information, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/vpc-configuration.html">Configuring a VPC</a>.
     * </p>
     * 
     * @return Configuration information for an Amazon VPC to connect to your Box. For more information, see <a
     *         href="https://docs.aws.amazon.com/kendra/latest/dg/vpc-configuration.html">Configuring a VPC</a>.
     */
    public final DataSourceVpcConfiguration vpcConfiguration() {
        return vpcConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(enterpriseId());
        hashCode = 31 * hashCode + Objects.hashCode(secretArn());
        hashCode = 31 * hashCode + Objects.hashCode(useChangeLog());
        hashCode = 31 * hashCode + Objects.hashCode(crawlComments());
        hashCode = 31 * hashCode + Objects.hashCode(crawlTasks());
        hashCode = 31 * hashCode + Objects.hashCode(crawlWebLinks());
        hashCode = 31 * hashCode + Objects.hashCode(hasFileFieldMappings() ? fileFieldMappings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTaskFieldMappings() ? taskFieldMappings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasCommentFieldMappings() ? commentFieldMappings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasWebLinkFieldMappings() ? webLinkFieldMappings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasInclusionPatterns() ? inclusionPatterns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasExclusionPatterns() ? exclusionPatterns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(vpcConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BoxConfiguration)) {
            return false;
        }
        BoxConfiguration other = (BoxConfiguration) obj;
        return Objects.equals(enterpriseId(), other.enterpriseId()) && Objects.equals(secretArn(), other.secretArn())
                && Objects.equals(useChangeLog(), other.useChangeLog()) && Objects.equals(crawlComments(), other.crawlComments())
                && Objects.equals(crawlTasks(), other.crawlTasks()) && Objects.equals(crawlWebLinks(), other.crawlWebLinks())
                && hasFileFieldMappings() == other.hasFileFieldMappings()
                && Objects.equals(fileFieldMappings(), other.fileFieldMappings())
                && hasTaskFieldMappings() == other.hasTaskFieldMappings()
                && Objects.equals(taskFieldMappings(), other.taskFieldMappings())
                && hasCommentFieldMappings() == other.hasCommentFieldMappings()
                && Objects.equals(commentFieldMappings(), other.commentFieldMappings())
                && hasWebLinkFieldMappings() == other.hasWebLinkFieldMappings()
                && Objects.equals(webLinkFieldMappings(), other.webLinkFieldMappings())
                && hasInclusionPatterns() == other.hasInclusionPatterns()
                && Objects.equals(inclusionPatterns(), other.inclusionPatterns())
                && hasExclusionPatterns() == other.hasExclusionPatterns()
                && Objects.equals(exclusionPatterns(), other.exclusionPatterns())
                && Objects.equals(vpcConfiguration(), other.vpcConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BoxConfiguration").add("EnterpriseId", enterpriseId()).add("SecretArn", secretArn())
                .add("UseChangeLog", useChangeLog()).add("CrawlComments", crawlComments()).add("CrawlTasks", crawlTasks())
                .add("CrawlWebLinks", crawlWebLinks())
                .add("FileFieldMappings", hasFileFieldMappings() ? fileFieldMappings() : null)
                .add("TaskFieldMappings", hasTaskFieldMappings() ? taskFieldMappings() : null)
                .add("CommentFieldMappings", hasCommentFieldMappings() ? commentFieldMappings() : null)
                .add("WebLinkFieldMappings", hasWebLinkFieldMappings() ? webLinkFieldMappings() : null)
                .add("InclusionPatterns", hasInclusionPatterns() ? inclusionPatterns() : null)
                .add("ExclusionPatterns", hasExclusionPatterns() ? exclusionPatterns() : null)
                .add("VpcConfiguration", vpcConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EnterpriseId":
            return Optional.ofNullable(clazz.cast(enterpriseId()));
        case "SecretArn":
            return Optional.ofNullable(clazz.cast(secretArn()));
        case "UseChangeLog":
            return Optional.ofNullable(clazz.cast(useChangeLog()));
        case "CrawlComments":
            return Optional.ofNullable(clazz.cast(crawlComments()));
        case "CrawlTasks":
            return Optional.ofNullable(clazz.cast(crawlTasks()));
        case "CrawlWebLinks":
            return Optional.ofNullable(clazz.cast(crawlWebLinks()));
        case "FileFieldMappings":
            return Optional.ofNullable(clazz.cast(fileFieldMappings()));
        case "TaskFieldMappings":
            return Optional.ofNullable(clazz.cast(taskFieldMappings()));
        case "CommentFieldMappings":
            return Optional.ofNullable(clazz.cast(commentFieldMappings()));
        case "WebLinkFieldMappings":
            return Optional.ofNullable(clazz.cast(webLinkFieldMappings()));
        case "InclusionPatterns":
            return Optional.ofNullable(clazz.cast(inclusionPatterns()));
        case "ExclusionPatterns":
            return Optional.ofNullable(clazz.cast(exclusionPatterns()));
        case "VpcConfiguration":
            return Optional.ofNullable(clazz.cast(vpcConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("EnterpriseId", ENTERPRISE_ID_FIELD);
        map.put("SecretArn", SECRET_ARN_FIELD);
        map.put("UseChangeLog", USE_CHANGE_LOG_FIELD);
        map.put("CrawlComments", CRAWL_COMMENTS_FIELD);
        map.put("CrawlTasks", CRAWL_TASKS_FIELD);
        map.put("CrawlWebLinks", CRAWL_WEB_LINKS_FIELD);
        map.put("FileFieldMappings", FILE_FIELD_MAPPINGS_FIELD);
        map.put("TaskFieldMappings", TASK_FIELD_MAPPINGS_FIELD);
        map.put("CommentFieldMappings", COMMENT_FIELD_MAPPINGS_FIELD);
        map.put("WebLinkFieldMappings", WEB_LINK_FIELD_MAPPINGS_FIELD);
        map.put("InclusionPatterns", INCLUSION_PATTERNS_FIELD);
        map.put("ExclusionPatterns", EXCLUSION_PATTERNS_FIELD);
        map.put("VpcConfiguration", VPC_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BoxConfiguration, T> g) {
        return obj -> g.apply((BoxConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BoxConfiguration> {
        /**
         * <p>
         * The identifier of the Box Enterprise platform. You can find the enterprise ID in the Box Developer Console
         * settings or when you create an app in Box and download your authentication credentials. For example,
         * <i>801234567</i>.
         * </p>
         * 
         * @param enterpriseId
         *        The identifier of the Box Enterprise platform. You can find the enterprise ID in the Box Developer
         *        Console settings or when you create an app in Box and download your authentication credentials. For
         *        example, <i>801234567</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enterpriseId(String enterpriseId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of an Secrets Manager secret that contains the key-value pairs required to
         * connect to your Box platform. The secret must contain a JSON structure with the following keys:
         * </p>
         * <ul>
         * <li>
         * <p>
         * clientID—The identifier of the client OAuth 2.0 authentication application created in Box.
         * </p>
         * </li>
         * <li>
         * <p>
         * clientSecret—A set of characters known only to the OAuth 2.0 authentication application created in Box.
         * </p>
         * </li>
         * <li>
         * <p>
         * publicKeyId—The identifier of the public key contained within an identity certificate.
         * </p>
         * </li>
         * <li>
         * <p>
         * privateKey—A set of characters that make up an encryption key.
         * </p>
         * </li>
         * <li>
         * <p>
         * passphrase—A set of characters that act like a password.
         * </p>
         * </li>
         * </ul>
         * <p>
         * You create an application in Box to generate the keys or credentials required for the secret. For more
         * information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/data-source-box.html">Using a Box data
         * source</a>.
         * </p>
         * 
         * @param secretArn
         *        The Amazon Resource Name (ARN) of an Secrets Manager secret that contains the key-value pairs required
         *        to connect to your Box platform. The secret must contain a JSON structure with the following keys:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        clientID—The identifier of the client OAuth 2.0 authentication application created in Box.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        clientSecret—A set of characters known only to the OAuth 2.0 authentication application created in
         *        Box.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        publicKeyId—The identifier of the public key contained within an identity certificate.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        privateKey—A set of characters that make up an encryption key.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        passphrase—A set of characters that act like a password.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        You create an application in Box to generate the keys or credentials required for the secret. For more
         *        information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/data-source-box.html">Using a
         *        Box data source</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secretArn(String secretArn);

        /**
         * <p>
         * <code>TRUE</code> to use the Slack change log to determine which documents require updating in the index.
         * Depending on the data source change log's size, it may take longer for Amazon Kendra to use the change log
         * than to scan all of your documents.
         * </p>
         * 
         * @param useChangeLog
         *        <code>TRUE</code> to use the Slack change log to determine which documents require updating in the
         *        index. Depending on the data source change log's size, it may take longer for Amazon Kendra to use the
         *        change log than to scan all of your documents.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder useChangeLog(Boolean useChangeLog);

        /**
         * <p>
         * <code>TRUE</code> to index comments.
         * </p>
         * 
         * @param crawlComments
         *        <code>TRUE</code> to index comments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder crawlComments(Boolean crawlComments);

        /**
         * <p>
         * <code>TRUE</code> to index the contents of tasks.
         * </p>
         * 
         * @param crawlTasks
         *        <code>TRUE</code> to index the contents of tasks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder crawlTasks(Boolean crawlTasks);

        /**
         * <p>
         * <code>TRUE</code> to index web links.
         * </p>
         * 
         * @param crawlWebLinks
         *        <code>TRUE</code> to index web links.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder crawlWebLinks(Boolean crawlWebLinks);

        /**
         * <p>
         * A list of <code>DataSourceToIndexFieldMapping</code> objects that map attributes or field names of Box files
         * to Amazon Kendra index field names. To create custom fields, use the <code>UpdateIndex</code> API before you
         * map to Box fields. For more information, see <a
         * href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a>. The
         * Box field names must exist in your Box custom metadata.
         * </p>
         * 
         * @param fileFieldMappings
         *        A list of <code>DataSourceToIndexFieldMapping</code> objects that map attributes or field names of Box
         *        files to Amazon Kendra index field names. To create custom fields, use the <code>UpdateIndex</code>
         *        API before you map to Box fields. For more information, see <a
         *        href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a>.
         *        The Box field names must exist in your Box custom metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileFieldMappings(Collection<DataSourceToIndexFieldMapping> fileFieldMappings);

        /**
         * <p>
         * A list of <code>DataSourceToIndexFieldMapping</code> objects that map attributes or field names of Box files
         * to Amazon Kendra index field names. To create custom fields, use the <code>UpdateIndex</code> API before you
         * map to Box fields. For more information, see <a
         * href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a>. The
         * Box field names must exist in your Box custom metadata.
         * </p>
         * 
         * @param fileFieldMappings
         *        A list of <code>DataSourceToIndexFieldMapping</code> objects that map attributes or field names of Box
         *        files to Amazon Kendra index field names. To create custom fields, use the <code>UpdateIndex</code>
         *        API before you map to Box fields. For more information, see <a
         *        href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a>.
         *        The Box field names must exist in your Box custom metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileFieldMappings(DataSourceToIndexFieldMapping... fileFieldMappings);

        /**
         * <p>
         * A list of <code>DataSourceToIndexFieldMapping</code> objects that map attributes or field names of Box files
         * to Amazon Kendra index field names. To create custom fields, use the <code>UpdateIndex</code> API before you
         * map to Box fields. For more information, see <a
         * href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a>. The
         * Box field names must exist in your Box custom metadata.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.kendra.model.DataSourceToIndexFieldMapping.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.kendra.model.DataSourceToIndexFieldMapping#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.kendra.model.DataSourceToIndexFieldMapping.Builder#build()} is called
         * immediately and its result is passed to {@link #fileFieldMappings(List<DataSourceToIndexFieldMapping>)}.
         * 
         * @param fileFieldMappings
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.kendra.model.DataSourceToIndexFieldMapping.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fileFieldMappings(java.util.Collection<DataSourceToIndexFieldMapping>)
         */
        Builder fileFieldMappings(Consumer<DataSourceToIndexFieldMapping.Builder>... fileFieldMappings);

        /**
         * <p>
         * A list of <code>DataSourceToIndexFieldMapping</code> objects that map attributes or field names of Box tasks
         * to Amazon Kendra index field names. To create custom fields, use the <code>UpdateIndex</code> API before you
         * map to Box fields. For more information, see <a
         * href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a>. The
         * Box field names must exist in your Box custom metadata.
         * </p>
         * 
         * @param taskFieldMappings
         *        A list of <code>DataSourceToIndexFieldMapping</code> objects that map attributes or field names of Box
         *        tasks to Amazon Kendra index field names. To create custom fields, use the <code>UpdateIndex</code>
         *        API before you map to Box fields. For more information, see <a
         *        href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a>.
         *        The Box field names must exist in your Box custom metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskFieldMappings(Collection<DataSourceToIndexFieldMapping> taskFieldMappings);

        /**
         * <p>
         * A list of <code>DataSourceToIndexFieldMapping</code> objects that map attributes or field names of Box tasks
         * to Amazon Kendra index field names. To create custom fields, use the <code>UpdateIndex</code> API before you
         * map to Box fields. For more information, see <a
         * href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a>. The
         * Box field names must exist in your Box custom metadata.
         * </p>
         * 
         * @param taskFieldMappings
         *        A list of <code>DataSourceToIndexFieldMapping</code> objects that map attributes or field names of Box
         *        tasks to Amazon Kendra index field names. To create custom fields, use the <code>UpdateIndex</code>
         *        API before you map to Box fields. For more information, see <a
         *        href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a>.
         *        The Box field names must exist in your Box custom metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskFieldMappings(DataSourceToIndexFieldMapping... taskFieldMappings);

        /**
         * <p>
         * A list of <code>DataSourceToIndexFieldMapping</code> objects that map attributes or field names of Box tasks
         * to Amazon Kendra index field names. To create custom fields, use the <code>UpdateIndex</code> API before you
         * map to Box fields. For more information, see <a
         * href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a>. The
         * Box field names must exist in your Box custom metadata.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.kendra.model.DataSourceToIndexFieldMapping.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.kendra.model.DataSourceToIndexFieldMapping#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.kendra.model.DataSourceToIndexFieldMapping.Builder#build()} is called
         * immediately and its result is passed to {@link #taskFieldMappings(List<DataSourceToIndexFieldMapping>)}.
         * 
         * @param taskFieldMappings
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.kendra.model.DataSourceToIndexFieldMapping.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #taskFieldMappings(java.util.Collection<DataSourceToIndexFieldMapping>)
         */
        Builder taskFieldMappings(Consumer<DataSourceToIndexFieldMapping.Builder>... taskFieldMappings);

        /**
         * <p>
         * A list of <code>DataSourceToIndexFieldMapping</code> objects that map attributes or field names of Box
         * comments to Amazon Kendra index field names. To create custom fields, use the <code>UpdateIndex</code> API
         * before you map to Box fields. For more information, see <a
         * href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a>. The
         * Box field names must exist in your Box custom metadata.
         * </p>
         * 
         * @param commentFieldMappings
         *        A list of <code>DataSourceToIndexFieldMapping</code> objects that map attributes or field names of Box
         *        comments to Amazon Kendra index field names. To create custom fields, use the <code>UpdateIndex</code>
         *        API before you map to Box fields. For more information, see <a
         *        href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a>.
         *        The Box field names must exist in your Box custom metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder commentFieldMappings(Collection<DataSourceToIndexFieldMapping> commentFieldMappings);

        /**
         * <p>
         * A list of <code>DataSourceToIndexFieldMapping</code> objects that map attributes or field names of Box
         * comments to Amazon Kendra index field names. To create custom fields, use the <code>UpdateIndex</code> API
         * before you map to Box fields. For more information, see <a
         * href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a>. The
         * Box field names must exist in your Box custom metadata.
         * </p>
         * 
         * @param commentFieldMappings
         *        A list of <code>DataSourceToIndexFieldMapping</code> objects that map attributes or field names of Box
         *        comments to Amazon Kendra index field names. To create custom fields, use the <code>UpdateIndex</code>
         *        API before you map to Box fields. For more information, see <a
         *        href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a>.
         *        The Box field names must exist in your Box custom metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder commentFieldMappings(DataSourceToIndexFieldMapping... commentFieldMappings);

        /**
         * <p>
         * A list of <code>DataSourceToIndexFieldMapping</code> objects that map attributes or field names of Box
         * comments to Amazon Kendra index field names. To create custom fields, use the <code>UpdateIndex</code> API
         * before you map to Box fields. For more information, see <a
         * href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a>. The
         * Box field names must exist in your Box custom metadata.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.kendra.model.DataSourceToIndexFieldMapping.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.kendra.model.DataSourceToIndexFieldMapping#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.kendra.model.DataSourceToIndexFieldMapping.Builder#build()} is called
         * immediately and its result is passed to {@link #commentFieldMappings(List<DataSourceToIndexFieldMapping>)}.
         * 
         * @param commentFieldMappings
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.kendra.model.DataSourceToIndexFieldMapping.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #commentFieldMappings(java.util.Collection<DataSourceToIndexFieldMapping>)
         */
        Builder commentFieldMappings(Consumer<DataSourceToIndexFieldMapping.Builder>... commentFieldMappings);

        /**
         * <p>
         * A list of <code>DataSourceToIndexFieldMapping</code> objects that map attributes or field names of Box web
         * links to Amazon Kendra index field names. To create custom fields, use the <code>UpdateIndex</code> API
         * before you map to Box fields. For more information, see <a
         * href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a>. The
         * Box field names must exist in your Box custom metadata.
         * </p>
         * 
         * @param webLinkFieldMappings
         *        A list of <code>DataSourceToIndexFieldMapping</code> objects that map attributes or field names of Box
         *        web links to Amazon Kendra index field names. To create custom fields, use the
         *        <code>UpdateIndex</code> API before you map to Box fields. For more information, see <a
         *        href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a>.
         *        The Box field names must exist in your Box custom metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder webLinkFieldMappings(Collection<DataSourceToIndexFieldMapping> webLinkFieldMappings);

        /**
         * <p>
         * A list of <code>DataSourceToIndexFieldMapping</code> objects that map attributes or field names of Box web
         * links to Amazon Kendra index field names. To create custom fields, use the <code>UpdateIndex</code> API
         * before you map to Box fields. For more information, see <a
         * href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a>. The
         * Box field names must exist in your Box custom metadata.
         * </p>
         * 
         * @param webLinkFieldMappings
         *        A list of <code>DataSourceToIndexFieldMapping</code> objects that map attributes or field names of Box
         *        web links to Amazon Kendra index field names. To create custom fields, use the
         *        <code>UpdateIndex</code> API before you map to Box fields. For more information, see <a
         *        href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a>.
         *        The Box field names must exist in your Box custom metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder webLinkFieldMappings(DataSourceToIndexFieldMapping... webLinkFieldMappings);

        /**
         * <p>
         * A list of <code>DataSourceToIndexFieldMapping</code> objects that map attributes or field names of Box web
         * links to Amazon Kendra index field names. To create custom fields, use the <code>UpdateIndex</code> API
         * before you map to Box fields. For more information, see <a
         * href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a>. The
         * Box field names must exist in your Box custom metadata.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.kendra.model.DataSourceToIndexFieldMapping.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.kendra.model.DataSourceToIndexFieldMapping#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.kendra.model.DataSourceToIndexFieldMapping.Builder#build()} is called
         * immediately and its result is passed to {@link #webLinkFieldMappings(List<DataSourceToIndexFieldMapping>)}.
         * 
         * @param webLinkFieldMappings
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.kendra.model.DataSourceToIndexFieldMapping.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #webLinkFieldMappings(java.util.Collection<DataSourceToIndexFieldMapping>)
         */
        Builder webLinkFieldMappings(Consumer<DataSourceToIndexFieldMapping.Builder>... webLinkFieldMappings);

        /**
         * <p>
         * A list of regular expression patterns to include certain files and folders in your Box platform. Files and
         * folders that match the patterns are included in the index. Files and folders that don't match the patterns
         * are excluded from the index. If a file or folder matches both an inclusion and exclusion pattern, the
         * exclusion pattern takes precedence and the file or folder isn't included in the index.
         * </p>
         * 
         * @param inclusionPatterns
         *        A list of regular expression patterns to include certain files and folders in your Box platform. Files
         *        and folders that match the patterns are included in the index. Files and folders that don't match the
         *        patterns are excluded from the index. If a file or folder matches both an inclusion and exclusion
         *        pattern, the exclusion pattern takes precedence and the file or folder isn't included in the index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inclusionPatterns(Collection<String> inclusionPatterns);

        /**
         * <p>
         * A list of regular expression patterns to include certain files and folders in your Box platform. Files and
         * folders that match the patterns are included in the index. Files and folders that don't match the patterns
         * are excluded from the index. If a file or folder matches both an inclusion and exclusion pattern, the
         * exclusion pattern takes precedence and the file or folder isn't included in the index.
         * </p>
         * 
         * @param inclusionPatterns
         *        A list of regular expression patterns to include certain files and folders in your Box platform. Files
         *        and folders that match the patterns are included in the index. Files and folders that don't match the
         *        patterns are excluded from the index. If a file or folder matches both an inclusion and exclusion
         *        pattern, the exclusion pattern takes precedence and the file or folder isn't included in the index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inclusionPatterns(String... inclusionPatterns);

        /**
         * <p>
         * A list of regular expression patterns to exclude certain files and folders from your Box platform. Files and
         * folders that match the patterns are excluded from the index.Files and folders that don't match the patterns
         * are included in the index. If a file or folder matches both an inclusion and exclusion pattern, the exclusion
         * pattern takes precedence and the file or folder isn't included in the index.
         * </p>
         * 
         * @param exclusionPatterns
         *        A list of regular expression patterns to exclude certain files and folders from your Box platform.
         *        Files and folders that match the patterns are excluded from the index.Files and folders that don't
         *        match the patterns are included in the index. If a file or folder matches both an inclusion and
         *        exclusion pattern, the exclusion pattern takes precedence and the file or folder isn't included in the
         *        index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exclusionPatterns(Collection<String> exclusionPatterns);

        /**
         * <p>
         * A list of regular expression patterns to exclude certain files and folders from your Box platform. Files and
         * folders that match the patterns are excluded from the index.Files and folders that don't match the patterns
         * are included in the index. If a file or folder matches both an inclusion and exclusion pattern, the exclusion
         * pattern takes precedence and the file or folder isn't included in the index.
         * </p>
         * 
         * @param exclusionPatterns
         *        A list of regular expression patterns to exclude certain files and folders from your Box platform.
         *        Files and folders that match the patterns are excluded from the index.Files and folders that don't
         *        match the patterns are included in the index. If a file or folder matches both an inclusion and
         *        exclusion pattern, the exclusion pattern takes precedence and the file or folder isn't included in the
         *        index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exclusionPatterns(String... exclusionPatterns);

        /**
         * <p>
         * Configuration information for an Amazon VPC to connect to your Box. For more information, see <a
         * href="https://docs.aws.amazon.com/kendra/latest/dg/vpc-configuration.html">Configuring a VPC</a>.
         * </p>
         * 
         * @param vpcConfiguration
         *        Configuration information for an Amazon VPC to connect to your Box. For more information, see <a
         *        href="https://docs.aws.amazon.com/kendra/latest/dg/vpc-configuration.html">Configuring a VPC</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcConfiguration(DataSourceVpcConfiguration vpcConfiguration);

        /**
         * <p>
         * Configuration information for an Amazon VPC to connect to your Box. For more information, see <a
         * href="https://docs.aws.amazon.com/kendra/latest/dg/vpc-configuration.html">Configuring a VPC</a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataSourceVpcConfiguration.Builder}
         * avoiding the need to create one manually via {@link DataSourceVpcConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataSourceVpcConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #vpcConfiguration(DataSourceVpcConfiguration)}.
         * 
         * @param vpcConfiguration
         *        a consumer that will call methods on {@link DataSourceVpcConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcConfiguration(DataSourceVpcConfiguration)
         */
        default Builder vpcConfiguration(Consumer<DataSourceVpcConfiguration.Builder> vpcConfiguration) {
            return vpcConfiguration(DataSourceVpcConfiguration.builder().applyMutation(vpcConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String enterpriseId;

        private String secretArn;

        private Boolean useChangeLog;

        private Boolean crawlComments;

        private Boolean crawlTasks;

        private Boolean crawlWebLinks;

        private List<DataSourceToIndexFieldMapping> fileFieldMappings = DefaultSdkAutoConstructList.getInstance();

        private List<DataSourceToIndexFieldMapping> taskFieldMappings = DefaultSdkAutoConstructList.getInstance();

        private List<DataSourceToIndexFieldMapping> commentFieldMappings = DefaultSdkAutoConstructList.getInstance();

        private List<DataSourceToIndexFieldMapping> webLinkFieldMappings = DefaultSdkAutoConstructList.getInstance();

        private List<String> inclusionPatterns = DefaultSdkAutoConstructList.getInstance();

        private List<String> exclusionPatterns = DefaultSdkAutoConstructList.getInstance();

        private DataSourceVpcConfiguration vpcConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(BoxConfiguration model) {
            enterpriseId(model.enterpriseId);
            secretArn(model.secretArn);
            useChangeLog(model.useChangeLog);
            crawlComments(model.crawlComments);
            crawlTasks(model.crawlTasks);
            crawlWebLinks(model.crawlWebLinks);
            fileFieldMappings(model.fileFieldMappings);
            taskFieldMappings(model.taskFieldMappings);
            commentFieldMappings(model.commentFieldMappings);
            webLinkFieldMappings(model.webLinkFieldMappings);
            inclusionPatterns(model.inclusionPatterns);
            exclusionPatterns(model.exclusionPatterns);
            vpcConfiguration(model.vpcConfiguration);
        }

        public final String getEnterpriseId() {
            return enterpriseId;
        }

        public final void setEnterpriseId(String enterpriseId) {
            this.enterpriseId = enterpriseId;
        }

        @Override
        public final Builder enterpriseId(String enterpriseId) {
            this.enterpriseId = enterpriseId;
            return this;
        }

        public final String getSecretArn() {
            return secretArn;
        }

        public final void setSecretArn(String secretArn) {
            this.secretArn = secretArn;
        }

        @Override
        public final Builder secretArn(String secretArn) {
            this.secretArn = secretArn;
            return this;
        }

        public final Boolean getUseChangeLog() {
            return useChangeLog;
        }

        public final void setUseChangeLog(Boolean useChangeLog) {
            this.useChangeLog = useChangeLog;
        }

        @Override
        public final Builder useChangeLog(Boolean useChangeLog) {
            this.useChangeLog = useChangeLog;
            return this;
        }

        public final Boolean getCrawlComments() {
            return crawlComments;
        }

        public final void setCrawlComments(Boolean crawlComments) {
            this.crawlComments = crawlComments;
        }

        @Override
        public final Builder crawlComments(Boolean crawlComments) {
            this.crawlComments = crawlComments;
            return this;
        }

        public final Boolean getCrawlTasks() {
            return crawlTasks;
        }

        public final void setCrawlTasks(Boolean crawlTasks) {
            this.crawlTasks = crawlTasks;
        }

        @Override
        public final Builder crawlTasks(Boolean crawlTasks) {
            this.crawlTasks = crawlTasks;
            return this;
        }

        public final Boolean getCrawlWebLinks() {
            return crawlWebLinks;
        }

        public final void setCrawlWebLinks(Boolean crawlWebLinks) {
            this.crawlWebLinks = crawlWebLinks;
        }

        @Override
        public final Builder crawlWebLinks(Boolean crawlWebLinks) {
            this.crawlWebLinks = crawlWebLinks;
            return this;
        }

        public final List<DataSourceToIndexFieldMapping.Builder> getFileFieldMappings() {
            List<DataSourceToIndexFieldMapping.Builder> result = DataSourceToIndexFieldMappingListCopier
                    .copyToBuilder(this.fileFieldMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFileFieldMappings(Collection<DataSourceToIndexFieldMapping.BuilderImpl> fileFieldMappings) {
            this.fileFieldMappings = DataSourceToIndexFieldMappingListCopier.copyFromBuilder(fileFieldMappings);
        }

        @Override
        public final Builder fileFieldMappings(Collection<DataSourceToIndexFieldMapping> fileFieldMappings) {
            this.fileFieldMappings = DataSourceToIndexFieldMappingListCopier.copy(fileFieldMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fileFieldMappings(DataSourceToIndexFieldMapping... fileFieldMappings) {
            fileFieldMappings(Arrays.asList(fileFieldMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fileFieldMappings(Consumer<DataSourceToIndexFieldMapping.Builder>... fileFieldMappings) {
            fileFieldMappings(Stream.of(fileFieldMappings)
                    .map(c -> DataSourceToIndexFieldMapping.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<DataSourceToIndexFieldMapping.Builder> getTaskFieldMappings() {
            List<DataSourceToIndexFieldMapping.Builder> result = DataSourceToIndexFieldMappingListCopier
                    .copyToBuilder(this.taskFieldMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTaskFieldMappings(Collection<DataSourceToIndexFieldMapping.BuilderImpl> taskFieldMappings) {
            this.taskFieldMappings = DataSourceToIndexFieldMappingListCopier.copyFromBuilder(taskFieldMappings);
        }

        @Override
        public final Builder taskFieldMappings(Collection<DataSourceToIndexFieldMapping> taskFieldMappings) {
            this.taskFieldMappings = DataSourceToIndexFieldMappingListCopier.copy(taskFieldMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder taskFieldMappings(DataSourceToIndexFieldMapping... taskFieldMappings) {
            taskFieldMappings(Arrays.asList(taskFieldMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder taskFieldMappings(Consumer<DataSourceToIndexFieldMapping.Builder>... taskFieldMappings) {
            taskFieldMappings(Stream.of(taskFieldMappings)
                    .map(c -> DataSourceToIndexFieldMapping.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<DataSourceToIndexFieldMapping.Builder> getCommentFieldMappings() {
            List<DataSourceToIndexFieldMapping.Builder> result = DataSourceToIndexFieldMappingListCopier
                    .copyToBuilder(this.commentFieldMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCommentFieldMappings(Collection<DataSourceToIndexFieldMapping.BuilderImpl> commentFieldMappings) {
            this.commentFieldMappings = DataSourceToIndexFieldMappingListCopier.copyFromBuilder(commentFieldMappings);
        }

        @Override
        public final Builder commentFieldMappings(Collection<DataSourceToIndexFieldMapping> commentFieldMappings) {
            this.commentFieldMappings = DataSourceToIndexFieldMappingListCopier.copy(commentFieldMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder commentFieldMappings(DataSourceToIndexFieldMapping... commentFieldMappings) {
            commentFieldMappings(Arrays.asList(commentFieldMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder commentFieldMappings(Consumer<DataSourceToIndexFieldMapping.Builder>... commentFieldMappings) {
            commentFieldMappings(Stream.of(commentFieldMappings)
                    .map(c -> DataSourceToIndexFieldMapping.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<DataSourceToIndexFieldMapping.Builder> getWebLinkFieldMappings() {
            List<DataSourceToIndexFieldMapping.Builder> result = DataSourceToIndexFieldMappingListCopier
                    .copyToBuilder(this.webLinkFieldMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setWebLinkFieldMappings(Collection<DataSourceToIndexFieldMapping.BuilderImpl> webLinkFieldMappings) {
            this.webLinkFieldMappings = DataSourceToIndexFieldMappingListCopier.copyFromBuilder(webLinkFieldMappings);
        }

        @Override
        public final Builder webLinkFieldMappings(Collection<DataSourceToIndexFieldMapping> webLinkFieldMappings) {
            this.webLinkFieldMappings = DataSourceToIndexFieldMappingListCopier.copy(webLinkFieldMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder webLinkFieldMappings(DataSourceToIndexFieldMapping... webLinkFieldMappings) {
            webLinkFieldMappings(Arrays.asList(webLinkFieldMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder webLinkFieldMappings(Consumer<DataSourceToIndexFieldMapping.Builder>... webLinkFieldMappings) {
            webLinkFieldMappings(Stream.of(webLinkFieldMappings)
                    .map(c -> DataSourceToIndexFieldMapping.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getInclusionPatterns() {
            if (inclusionPatterns instanceof SdkAutoConstructList) {
                return null;
            }
            return inclusionPatterns;
        }

        public final void setInclusionPatterns(Collection<String> inclusionPatterns) {
            this.inclusionPatterns = DataSourceInclusionsExclusionsStringsCopier.copy(inclusionPatterns);
        }

        @Override
        public final Builder inclusionPatterns(Collection<String> inclusionPatterns) {
            this.inclusionPatterns = DataSourceInclusionsExclusionsStringsCopier.copy(inclusionPatterns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inclusionPatterns(String... inclusionPatterns) {
            inclusionPatterns(Arrays.asList(inclusionPatterns));
            return this;
        }

        public final Collection<String> getExclusionPatterns() {
            if (exclusionPatterns instanceof SdkAutoConstructList) {
                return null;
            }
            return exclusionPatterns;
        }

        public final void setExclusionPatterns(Collection<String> exclusionPatterns) {
            this.exclusionPatterns = DataSourceInclusionsExclusionsStringsCopier.copy(exclusionPatterns);
        }

        @Override
        public final Builder exclusionPatterns(Collection<String> exclusionPatterns) {
            this.exclusionPatterns = DataSourceInclusionsExclusionsStringsCopier.copy(exclusionPatterns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exclusionPatterns(String... exclusionPatterns) {
            exclusionPatterns(Arrays.asList(exclusionPatterns));
            return this;
        }

        public final DataSourceVpcConfiguration.Builder getVpcConfiguration() {
            return vpcConfiguration != null ? vpcConfiguration.toBuilder() : null;
        }

        public final void setVpcConfiguration(DataSourceVpcConfiguration.BuilderImpl vpcConfiguration) {
            this.vpcConfiguration = vpcConfiguration != null ? vpcConfiguration.build() : null;
        }

        @Override
        public final Builder vpcConfiguration(DataSourceVpcConfiguration vpcConfiguration) {
            this.vpcConfiguration = vpcConfiguration;
            return this;
        }

        @Override
        public BoxConfiguration build() {
            return new BoxConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
