/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides details about a collapsed group of search results.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CollapsedResultDetail implements SdkPojo, Serializable,
        ToCopyableBuilder<CollapsedResultDetail.Builder, CollapsedResultDetail> {
    private static final SdkField<DocumentAttribute> DOCUMENT_ATTRIBUTE_FIELD = SdkField
            .<DocumentAttribute> builder(MarshallingType.SDK_POJO).memberName("DocumentAttribute")
            .getter(getter(CollapsedResultDetail::documentAttribute)).setter(setter(Builder::documentAttribute))
            .constructor(DocumentAttribute::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentAttribute").build()).build();

    private static final SdkField<List<ExpandedResultItem>> EXPANDED_RESULTS_FIELD = SdkField
            .<List<ExpandedResultItem>> builder(MarshallingType.LIST)
            .memberName("ExpandedResults")
            .getter(getter(CollapsedResultDetail::expandedResults))
            .setter(setter(Builder::expandedResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpandedResults").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ExpandedResultItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(ExpandedResultItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOCUMENT_ATTRIBUTE_FIELD,
            EXPANDED_RESULTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final DocumentAttribute documentAttribute;

    private final List<ExpandedResultItem> expandedResults;

    private CollapsedResultDetail(BuilderImpl builder) {
        this.documentAttribute = builder.documentAttribute;
        this.expandedResults = builder.expandedResults;
    }

    /**
     * <p>
     * The value of the document attribute that results are collapsed on.
     * </p>
     * 
     * @return The value of the document attribute that results are collapsed on.
     */
    public final DocumentAttribute documentAttribute() {
        return documentAttribute;
    }

    /**
     * For responses, this returns true if the service returned a value for the ExpandedResults property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasExpandedResults() {
        return expandedResults != null && !(expandedResults instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of results in the collapsed group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasExpandedResults} method.
     * </p>
     * 
     * @return A list of results in the collapsed group.
     */
    public final List<ExpandedResultItem> expandedResults() {
        return expandedResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(documentAttribute());
        hashCode = 31 * hashCode + Objects.hashCode(hasExpandedResults() ? expandedResults() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CollapsedResultDetail)) {
            return false;
        }
        CollapsedResultDetail other = (CollapsedResultDetail) obj;
        return Objects.equals(documentAttribute(), other.documentAttribute())
                && hasExpandedResults() == other.hasExpandedResults()
                && Objects.equals(expandedResults(), other.expandedResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CollapsedResultDetail").add("DocumentAttribute", documentAttribute())
                .add("ExpandedResults", hasExpandedResults() ? expandedResults() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DocumentAttribute":
            return Optional.ofNullable(clazz.cast(documentAttribute()));
        case "ExpandedResults":
            return Optional.ofNullable(clazz.cast(expandedResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DocumentAttribute", DOCUMENT_ATTRIBUTE_FIELD);
        map.put("ExpandedResults", EXPANDED_RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CollapsedResultDetail, T> g) {
        return obj -> g.apply((CollapsedResultDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CollapsedResultDetail> {
        /**
         * <p>
         * The value of the document attribute that results are collapsed on.
         * </p>
         * 
         * @param documentAttribute
         *        The value of the document attribute that results are collapsed on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentAttribute(DocumentAttribute documentAttribute);

        /**
         * <p>
         * The value of the document attribute that results are collapsed on.
         * </p>
         * This is a convenience method that creates an instance of the {@link DocumentAttribute.Builder} avoiding the
         * need to create one manually via {@link DocumentAttribute#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DocumentAttribute.Builder#build()} is called immediately and its
         * result is passed to {@link #documentAttribute(DocumentAttribute)}.
         * 
         * @param documentAttribute
         *        a consumer that will call methods on {@link DocumentAttribute.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #documentAttribute(DocumentAttribute)
         */
        default Builder documentAttribute(Consumer<DocumentAttribute.Builder> documentAttribute) {
            return documentAttribute(DocumentAttribute.builder().applyMutation(documentAttribute).build());
        }

        /**
         * <p>
         * A list of results in the collapsed group.
         * </p>
         * 
         * @param expandedResults
         *        A list of results in the collapsed group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expandedResults(Collection<ExpandedResultItem> expandedResults);

        /**
         * <p>
         * A list of results in the collapsed group.
         * </p>
         * 
         * @param expandedResults
         *        A list of results in the collapsed group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expandedResults(ExpandedResultItem... expandedResults);

        /**
         * <p>
         * A list of results in the collapsed group.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.kendra.model.ExpandedResultItem.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.kendra.model.ExpandedResultItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.kendra.model.ExpandedResultItem.Builder#build()} is called immediately
         * and its result is passed to {@link #expandedResults(List<ExpandedResultItem>)}.
         * 
         * @param expandedResults
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.kendra.model.ExpandedResultItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #expandedResults(java.util.Collection<ExpandedResultItem>)
         */
        Builder expandedResults(Consumer<ExpandedResultItem.Builder>... expandedResults);
    }

    static final class BuilderImpl implements Builder {
        private DocumentAttribute documentAttribute;

        private List<ExpandedResultItem> expandedResults = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CollapsedResultDetail model) {
            documentAttribute(model.documentAttribute);
            expandedResults(model.expandedResults);
        }

        public final DocumentAttribute.Builder getDocumentAttribute() {
            return documentAttribute != null ? documentAttribute.toBuilder() : null;
        }

        public final void setDocumentAttribute(DocumentAttribute.BuilderImpl documentAttribute) {
            this.documentAttribute = documentAttribute != null ? documentAttribute.build() : null;
        }

        @Override
        public final Builder documentAttribute(DocumentAttribute documentAttribute) {
            this.documentAttribute = documentAttribute;
            return this;
        }

        public final List<ExpandedResultItem.Builder> getExpandedResults() {
            List<ExpandedResultItem.Builder> result = ExpandedResultListCopier.copyToBuilder(this.expandedResults);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setExpandedResults(Collection<ExpandedResultItem.BuilderImpl> expandedResults) {
            this.expandedResults = ExpandedResultListCopier.copyFromBuilder(expandedResults);
        }

        @Override
        public final Builder expandedResults(Collection<ExpandedResultItem> expandedResults) {
            this.expandedResults = ExpandedResultListCopier.copy(expandedResults);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder expandedResults(ExpandedResultItem... expandedResults) {
            expandedResults(Arrays.asList(expandedResults));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder expandedResults(Consumer<ExpandedResultItem.Builder>... expandedResults) {
            expandedResults(Stream.of(expandedResults).map(c -> ExpandedResultItem.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public CollapsedResultDetail build() {
            return new CollapsedResultDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
