/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a conflicting query used across different sets of featured results. When you create a featured
 * results set, you must check that the queries are unique per featured results set for each index.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConflictingItem implements SdkPojo, Serializable, ToCopyableBuilder<ConflictingItem.Builder, ConflictingItem> {
    private static final SdkField<String> QUERY_TEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("QueryText").getter(getter(ConflictingItem::queryText)).setter(setter(Builder::queryText))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryText").build()).build();

    private static final SdkField<String> SET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SetName").getter(getter(ConflictingItem::setName)).setter(setter(Builder::setName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SetName").build()).build();

    private static final SdkField<String> SET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("SetId")
            .getter(getter(ConflictingItem::setId)).setter(setter(Builder::setId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SetId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUERY_TEXT_FIELD,
            SET_NAME_FIELD, SET_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String queryText;

    private final String setName;

    private final String setId;

    private ConflictingItem(BuilderImpl builder) {
        this.queryText = builder.queryText;
        this.setName = builder.setName;
        this.setId = builder.setId;
    }

    /**
     * <p>
     * The text of the conflicting query.
     * </p>
     * 
     * @return The text of the conflicting query.
     */
    public final String queryText() {
        return queryText;
    }

    /**
     * <p>
     * The name for the set of featured results that the conflicting query belongs to.
     * </p>
     * 
     * @return The name for the set of featured results that the conflicting query belongs to.
     */
    public final String setName() {
        return setName;
    }

    /**
     * <p>
     * The identifier of the set of featured results that the conflicting query belongs to.
     * </p>
     * 
     * @return The identifier of the set of featured results that the conflicting query belongs to.
     */
    public final String setId() {
        return setId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(queryText());
        hashCode = 31 * hashCode + Objects.hashCode(setName());
        hashCode = 31 * hashCode + Objects.hashCode(setId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConflictingItem)) {
            return false;
        }
        ConflictingItem other = (ConflictingItem) obj;
        return Objects.equals(queryText(), other.queryText()) && Objects.equals(setName(), other.setName())
                && Objects.equals(setId(), other.setId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConflictingItem").add("QueryText", queryText()).add("SetName", setName()).add("SetId", setId())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "QueryText":
            return Optional.ofNullable(clazz.cast(queryText()));
        case "SetName":
            return Optional.ofNullable(clazz.cast(setName()));
        case "SetId":
            return Optional.ofNullable(clazz.cast(setId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("QueryText", QUERY_TEXT_FIELD);
        map.put("SetName", SET_NAME_FIELD);
        map.put("SetId", SET_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConflictingItem, T> g) {
        return obj -> g.apply((ConflictingItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConflictingItem> {
        /**
         * <p>
         * The text of the conflicting query.
         * </p>
         * 
         * @param queryText
         *        The text of the conflicting query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryText(String queryText);

        /**
         * <p>
         * The name for the set of featured results that the conflicting query belongs to.
         * </p>
         * 
         * @param setName
         *        The name for the set of featured results that the conflicting query belongs to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder setName(String setName);

        /**
         * <p>
         * The identifier of the set of featured results that the conflicting query belongs to.
         * </p>
         * 
         * @param setId
         *        The identifier of the set of featured results that the conflicting query belongs to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder setId(String setId);
    }

    static final class BuilderImpl implements Builder {
        private String queryText;

        private String setName;

        private String setId;

        private BuilderImpl() {
        }

        private BuilderImpl(ConflictingItem model) {
            queryText(model.queryText);
            setName(model.setName);
            setId(model.setId);
        }

        public final String getQueryText() {
            return queryText;
        }

        public final void setQueryText(String queryText) {
            this.queryText = queryText;
        }

        @Override
        public final Builder queryText(String queryText) {
            this.queryText = queryText;
            return this;
        }

        public final String getSetName() {
            return setName;
        }

        public final void setSetName(String setName) {
            this.setName = setName;
        }

        @Override
        @Transient
        public final Builder setName(String setName) {
            this.setName = setName;
            return this;
        }

        public final String getSetId() {
            return setId;
        }

        public final void setSetId(String setId) {
            this.setId = setId;
        }

        @Override
        @Transient
        public final Builder setId(String setId) {
            this.setId = setId;
            return this;
        }

        @Override
        public ConflictingItem build() {
            return new ConflictingItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
