/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration of blog settings for the Confluence data source. Blogs are always indexed unless filtered from the
 * index by the <code>ExclusionPatterns</code> or <code>InclusionPatterns</code> fields in the
 * <code>ConfluenceConfiguration</code> object.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConfluenceBlogConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ConfluenceBlogConfiguration.Builder, ConfluenceBlogConfiguration> {
    private static final SdkField<List<ConfluenceBlogToIndexFieldMapping>> BLOG_FIELD_MAPPINGS_FIELD = SdkField
            .<List<ConfluenceBlogToIndexFieldMapping>> builder(MarshallingType.LIST)
            .memberName("BlogFieldMappings")
            .getter(getter(ConfluenceBlogConfiguration::blogFieldMappings))
            .setter(setter(Builder::blogFieldMappings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlogFieldMappings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ConfluenceBlogToIndexFieldMapping> builder(MarshallingType.SDK_POJO)
                                            .constructor(ConfluenceBlogToIndexFieldMapping::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BLOG_FIELD_MAPPINGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<ConfluenceBlogToIndexFieldMapping> blogFieldMappings;

    private ConfluenceBlogConfiguration(BuilderImpl builder) {
        this.blogFieldMappings = builder.blogFieldMappings;
    }

    /**
     * For responses, this returns true if the service returned a value for the BlogFieldMappings property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasBlogFieldMappings() {
        return blogFieldMappings != null && !(blogFieldMappings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Maps attributes or field names of Confluence blogs to Amazon Kendra index field names. To create custom fields,
     * use the <code>UpdateIndex</code> API before you map to Confluence fields. For more information, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a>. The
     * Confluence data source field names must exist in your Confluence custom metadata.
     * </p>
     * <p>
     * If you specify the <code>BlogFieldMappings</code> parameter, you must specify at least one field mapping.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBlogFieldMappings} method.
     * </p>
     * 
     * @return Maps attributes or field names of Confluence blogs to Amazon Kendra index field names. To create custom
     *         fields, use the <code>UpdateIndex</code> API before you map to Confluence fields. For more information,
     *         see <a href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source
     *         fields</a>. The Confluence data source field names must exist in your Confluence custom metadata.</p>
     *         <p>
     *         If you specify the <code>BlogFieldMappings</code> parameter, you must specify at least one field mapping.
     */
    public final List<ConfluenceBlogToIndexFieldMapping> blogFieldMappings() {
        return blogFieldMappings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasBlogFieldMappings() ? blogFieldMappings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfluenceBlogConfiguration)) {
            return false;
        }
        ConfluenceBlogConfiguration other = (ConfluenceBlogConfiguration) obj;
        return hasBlogFieldMappings() == other.hasBlogFieldMappings()
                && Objects.equals(blogFieldMappings(), other.blogFieldMappings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConfluenceBlogConfiguration")
                .add("BlogFieldMappings", hasBlogFieldMappings() ? blogFieldMappings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BlogFieldMappings":
            return Optional.ofNullable(clazz.cast(blogFieldMappings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("BlogFieldMappings", BLOG_FIELD_MAPPINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConfluenceBlogConfiguration, T> g) {
        return obj -> g.apply((ConfluenceBlogConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConfluenceBlogConfiguration> {
        /**
         * <p>
         * Maps attributes or field names of Confluence blogs to Amazon Kendra index field names. To create custom
         * fields, use the <code>UpdateIndex</code> API before you map to Confluence fields. For more information, see
         * <a href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a>. The
         * Confluence data source field names must exist in your Confluence custom metadata.
         * </p>
         * <p>
         * If you specify the <code>BlogFieldMappings</code> parameter, you must specify at least one field mapping.
         * </p>
         * 
         * @param blogFieldMappings
         *        Maps attributes or field names of Confluence blogs to Amazon Kendra index field names. To create
         *        custom fields, use the <code>UpdateIndex</code> API before you map to Confluence fields. For more
         *        information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping
         *        data source fields</a>. The Confluence data source field names must exist in your Confluence custom
         *        metadata.</p>
         *        <p>
         *        If you specify the <code>BlogFieldMappings</code> parameter, you must specify at least one field
         *        mapping.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blogFieldMappings(Collection<ConfluenceBlogToIndexFieldMapping> blogFieldMappings);

        /**
         * <p>
         * Maps attributes or field names of Confluence blogs to Amazon Kendra index field names. To create custom
         * fields, use the <code>UpdateIndex</code> API before you map to Confluence fields. For more information, see
         * <a href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a>. The
         * Confluence data source field names must exist in your Confluence custom metadata.
         * </p>
         * <p>
         * If you specify the <code>BlogFieldMappings</code> parameter, you must specify at least one field mapping.
         * </p>
         * 
         * @param blogFieldMappings
         *        Maps attributes or field names of Confluence blogs to Amazon Kendra index field names. To create
         *        custom fields, use the <code>UpdateIndex</code> API before you map to Confluence fields. For more
         *        information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping
         *        data source fields</a>. The Confluence data source field names must exist in your Confluence custom
         *        metadata.</p>
         *        <p>
         *        If you specify the <code>BlogFieldMappings</code> parameter, you must specify at least one field
         *        mapping.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blogFieldMappings(ConfluenceBlogToIndexFieldMapping... blogFieldMappings);

        /**
         * <p>
         * Maps attributes or field names of Confluence blogs to Amazon Kendra index field names. To create custom
         * fields, use the <code>UpdateIndex</code> API before you map to Confluence fields. For more information, see
         * <a href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a>. The
         * Confluence data source field names must exist in your Confluence custom metadata.
         * </p>
         * <p>
         * If you specify the <code>BlogFieldMappings</code> parameter, you must specify at least one field mapping.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.kendra.model.ConfluenceBlogToIndexFieldMapping.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.kendra.model.ConfluenceBlogToIndexFieldMapping#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.kendra.model.ConfluenceBlogToIndexFieldMapping.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #blogFieldMappings(List<ConfluenceBlogToIndexFieldMapping>)}.
         * 
         * @param blogFieldMappings
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.kendra.model.ConfluenceBlogToIndexFieldMapping.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #blogFieldMappings(java.util.Collection<ConfluenceBlogToIndexFieldMapping>)
         */
        Builder blogFieldMappings(Consumer<ConfluenceBlogToIndexFieldMapping.Builder>... blogFieldMappings);
    }

    static final class BuilderImpl implements Builder {
        private List<ConfluenceBlogToIndexFieldMapping> blogFieldMappings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ConfluenceBlogConfiguration model) {
            blogFieldMappings(model.blogFieldMappings);
        }

        public final List<ConfluenceBlogToIndexFieldMapping.Builder> getBlogFieldMappings() {
            List<ConfluenceBlogToIndexFieldMapping.Builder> result = ConfluenceBlogFieldMappingsListCopier
                    .copyToBuilder(this.blogFieldMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBlogFieldMappings(Collection<ConfluenceBlogToIndexFieldMapping.BuilderImpl> blogFieldMappings) {
            this.blogFieldMappings = ConfluenceBlogFieldMappingsListCopier.copyFromBuilder(blogFieldMappings);
        }

        @Override
        public final Builder blogFieldMappings(Collection<ConfluenceBlogToIndexFieldMapping> blogFieldMappings) {
            this.blogFieldMappings = ConfluenceBlogFieldMappingsListCopier.copy(blogFieldMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blogFieldMappings(ConfluenceBlogToIndexFieldMapping... blogFieldMappings) {
            blogFieldMappings(Arrays.asList(blogFieldMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blogFieldMappings(Consumer<ConfluenceBlogToIndexFieldMapping.Builder>... blogFieldMappings) {
            blogFieldMappings(Stream.of(blogFieldMappings)
                    .map(c -> ConfluenceBlogToIndexFieldMapping.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ConfluenceBlogConfiguration build() {
            return new ConfluenceBlogConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
