/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Maps attributes or field names of Confluence blog to Amazon Kendra index field names. To create custom fields, use
 * the <code>UpdateIndex</code> API before you map to Confluence fields. For more information, see <a
 * href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a>. The Confluence
 * data source field names must exist in your Confluence custom metadata.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConfluenceBlogToIndexFieldMapping implements SdkPojo, Serializable,
        ToCopyableBuilder<ConfluenceBlogToIndexFieldMapping.Builder, ConfluenceBlogToIndexFieldMapping> {
    private static final SdkField<String> DATA_SOURCE_FIELD_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataSourceFieldName").getter(getter(ConfluenceBlogToIndexFieldMapping::dataSourceFieldNameAsString))
            .setter(setter(Builder::dataSourceFieldName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSourceFieldName").build())
            .build();

    private static final SdkField<String> DATE_FIELD_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DateFieldFormat").getter(getter(ConfluenceBlogToIndexFieldMapping::dateFieldFormat))
            .setter(setter(Builder::dateFieldFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DateFieldFormat").build()).build();

    private static final SdkField<String> INDEX_FIELD_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IndexFieldName").getter(getter(ConfluenceBlogToIndexFieldMapping::indexFieldName))
            .setter(setter(Builder::indexFieldName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexFieldName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SOURCE_FIELD_NAME_FIELD,
            DATE_FIELD_FORMAT_FIELD, INDEX_FIELD_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String dataSourceFieldName;

    private final String dateFieldFormat;

    private final String indexFieldName;

    private ConfluenceBlogToIndexFieldMapping(BuilderImpl builder) {
        this.dataSourceFieldName = builder.dataSourceFieldName;
        this.dateFieldFormat = builder.dateFieldFormat;
        this.indexFieldName = builder.indexFieldName;
    }

    /**
     * <p>
     * The name of the field in the data source.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #dataSourceFieldName} will return {@link ConfluenceBlogFieldName#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #dataSourceFieldNameAsString}.
     * </p>
     * 
     * @return The name of the field in the data source.
     * @see ConfluenceBlogFieldName
     */
    public final ConfluenceBlogFieldName dataSourceFieldName() {
        return ConfluenceBlogFieldName.fromValue(dataSourceFieldName);
    }

    /**
     * <p>
     * The name of the field in the data source.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #dataSourceFieldName} will return {@link ConfluenceBlogFieldName#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #dataSourceFieldNameAsString}.
     * </p>
     * 
     * @return The name of the field in the data source.
     * @see ConfluenceBlogFieldName
     */
    public final String dataSourceFieldNameAsString() {
        return dataSourceFieldName;
    }

    /**
     * <p>
     * The format for date fields in the data source. If the field specified in <code>DataSourceFieldName</code> is a
     * date field you must specify the date format. If the field is not a date field, an exception is thrown.
     * </p>
     * 
     * @return The format for date fields in the data source. If the field specified in <code>DataSourceFieldName</code>
     *         is a date field you must specify the date format. If the field is not a date field, an exception is
     *         thrown.
     */
    public final String dateFieldFormat() {
        return dateFieldFormat;
    }

    /**
     * <p>
     * The name of the index field to map to the Confluence data source field. The index field type must match the
     * Confluence field type.
     * </p>
     * 
     * @return The name of the index field to map to the Confluence data source field. The index field type must match
     *         the Confluence field type.
     */
    public final String indexFieldName() {
        return indexFieldName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dataSourceFieldNameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(dateFieldFormat());
        hashCode = 31 * hashCode + Objects.hashCode(indexFieldName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfluenceBlogToIndexFieldMapping)) {
            return false;
        }
        ConfluenceBlogToIndexFieldMapping other = (ConfluenceBlogToIndexFieldMapping) obj;
        return Objects.equals(dataSourceFieldNameAsString(), other.dataSourceFieldNameAsString())
                && Objects.equals(dateFieldFormat(), other.dateFieldFormat())
                && Objects.equals(indexFieldName(), other.indexFieldName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConfluenceBlogToIndexFieldMapping").add("DataSourceFieldName", dataSourceFieldNameAsString())
                .add("DateFieldFormat", dateFieldFormat()).add("IndexFieldName", indexFieldName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DataSourceFieldName":
            return Optional.ofNullable(clazz.cast(dataSourceFieldNameAsString()));
        case "DateFieldFormat":
            return Optional.ofNullable(clazz.cast(dateFieldFormat()));
        case "IndexFieldName":
            return Optional.ofNullable(clazz.cast(indexFieldName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DataSourceFieldName", DATA_SOURCE_FIELD_NAME_FIELD);
        map.put("DateFieldFormat", DATE_FIELD_FORMAT_FIELD);
        map.put("IndexFieldName", INDEX_FIELD_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConfluenceBlogToIndexFieldMapping, T> g) {
        return obj -> g.apply((ConfluenceBlogToIndexFieldMapping) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConfluenceBlogToIndexFieldMapping> {
        /**
         * <p>
         * The name of the field in the data source.
         * </p>
         * 
         * @param dataSourceFieldName
         *        The name of the field in the data source.
         * @see ConfluenceBlogFieldName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConfluenceBlogFieldName
         */
        Builder dataSourceFieldName(String dataSourceFieldName);

        /**
         * <p>
         * The name of the field in the data source.
         * </p>
         * 
         * @param dataSourceFieldName
         *        The name of the field in the data source.
         * @see ConfluenceBlogFieldName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConfluenceBlogFieldName
         */
        Builder dataSourceFieldName(ConfluenceBlogFieldName dataSourceFieldName);

        /**
         * <p>
         * The format for date fields in the data source. If the field specified in <code>DataSourceFieldName</code> is
         * a date field you must specify the date format. If the field is not a date field, an exception is thrown.
         * </p>
         * 
         * @param dateFieldFormat
         *        The format for date fields in the data source. If the field specified in
         *        <code>DataSourceFieldName</code> is a date field you must specify the date format. If the field is not
         *        a date field, an exception is thrown.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dateFieldFormat(String dateFieldFormat);

        /**
         * <p>
         * The name of the index field to map to the Confluence data source field. The index field type must match the
         * Confluence field type.
         * </p>
         * 
         * @param indexFieldName
         *        The name of the index field to map to the Confluence data source field. The index field type must
         *        match the Confluence field type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexFieldName(String indexFieldName);
    }

    static final class BuilderImpl implements Builder {
        private String dataSourceFieldName;

        private String dateFieldFormat;

        private String indexFieldName;

        private BuilderImpl() {
        }

        private BuilderImpl(ConfluenceBlogToIndexFieldMapping model) {
            dataSourceFieldName(model.dataSourceFieldName);
            dateFieldFormat(model.dateFieldFormat);
            indexFieldName(model.indexFieldName);
        }

        public final String getDataSourceFieldName() {
            return dataSourceFieldName;
        }

        public final void setDataSourceFieldName(String dataSourceFieldName) {
            this.dataSourceFieldName = dataSourceFieldName;
        }

        @Override
        public final Builder dataSourceFieldName(String dataSourceFieldName) {
            this.dataSourceFieldName = dataSourceFieldName;
            return this;
        }

        @Override
        public final Builder dataSourceFieldName(ConfluenceBlogFieldName dataSourceFieldName) {
            this.dataSourceFieldName(dataSourceFieldName == null ? null : dataSourceFieldName.toString());
            return this;
        }

        public final String getDateFieldFormat() {
            return dateFieldFormat;
        }

        public final void setDateFieldFormat(String dateFieldFormat) {
            this.dateFieldFormat = dateFieldFormat;
        }

        @Override
        public final Builder dateFieldFormat(String dateFieldFormat) {
            this.dateFieldFormat = dateFieldFormat;
            return this;
        }

        public final String getIndexFieldName() {
            return indexFieldName;
        }

        public final void setIndexFieldName(String indexFieldName) {
            this.indexFieldName = indexFieldName;
        }

        @Override
        public final Builder indexFieldName(String indexFieldName) {
            this.indexFieldName = indexFieldName;
            return this;
        }

        @Override
        public ConfluenceBlogToIndexFieldMapping build() {
            return new ConfluenceBlogToIndexFieldMapping(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
