/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateFaqRequest extends KendraRequest implements
        ToCopyableBuilder<CreateFaqRequest.Builder, CreateFaqRequest> {
    private static final SdkField<String> INDEX_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IndexId").getter(getter(CreateFaqRequest::indexId)).setter(setter(Builder::indexId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreateFaqRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CreateFaqRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<S3Path> S3_PATH_FIELD = SdkField.<S3Path> builder(MarshallingType.SDK_POJO)
            .memberName("S3Path").getter(getter(CreateFaqRequest::s3Path)).setter(setter(Builder::s3Path))
            .constructor(S3Path::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Path").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(CreateFaqRequest::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateFaqRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> FILE_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FileFormat").getter(getter(CreateFaqRequest::fileFormatAsString)).setter(setter(Builder::fileFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileFormat").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(CreateFaqRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> LANGUAGE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LanguageCode").getter(getter(CreateFaqRequest::languageCode)).setter(setter(Builder::languageCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LanguageCode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INDEX_ID_FIELD, NAME_FIELD,
            DESCRIPTION_FIELD, S3_PATH_FIELD, ROLE_ARN_FIELD, TAGS_FIELD, FILE_FORMAT_FIELD, CLIENT_TOKEN_FIELD,
            LANGUAGE_CODE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String indexId;

    private final String name;

    private final String description;

    private final S3Path s3Path;

    private final String roleArn;

    private final List<Tag> tags;

    private final String fileFormat;

    private final String clientToken;

    private final String languageCode;

    private CreateFaqRequest(BuilderImpl builder) {
        super(builder);
        this.indexId = builder.indexId;
        this.name = builder.name;
        this.description = builder.description;
        this.s3Path = builder.s3Path;
        this.roleArn = builder.roleArn;
        this.tags = builder.tags;
        this.fileFormat = builder.fileFormat;
        this.clientToken = builder.clientToken;
        this.languageCode = builder.languageCode;
    }

    /**
     * <p>
     * The identifier of the index for the FAQ.
     * </p>
     * 
     * @return The identifier of the index for the FAQ.
     */
    public final String indexId() {
        return indexId;
    }

    /**
     * <p>
     * A name for the FAQ.
     * </p>
     * 
     * @return A name for the FAQ.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * A description for the FAQ.
     * </p>
     * 
     * @return A description for the FAQ.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The path to the FAQ file in S3.
     * </p>
     * 
     * @return The path to the FAQ file in S3.
     */
    public final S3Path s3Path() {
        return s3Path;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of an IAM role with permission to access the S3 bucket that contains the FAQ file.
     * For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html">IAM access roles
     * for Amazon Kendra</a>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of an IAM role with permission to access the S3 bucket that contains the
     *         FAQ file. For more information, see <a
     *         href="https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html">IAM access roles for Amazon
     *         Kendra</a>.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of key-value pairs that identify the FAQ. You can use the tags to identify and organize your resources and
     * to control access to resources.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A list of key-value pairs that identify the FAQ. You can use the tags to identify and organize your
     *         resources and to control access to resources.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * The format of the FAQ input file. You can choose between a basic CSV format, a CSV format that includes customs
     * attributes in a header, and a JSON format that includes custom attributes.
     * </p>
     * <p>
     * The default format is CSV.
     * </p>
     * <p>
     * The format must match the format of the file stored in the S3 bucket identified in the <code>S3Path</code>
     * parameter.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/in-creating-faq.html">Adding
     * questions and answers</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fileFormat} will
     * return {@link FaqFileFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #fileFormatAsString}.
     * </p>
     * 
     * @return The format of the FAQ input file. You can choose between a basic CSV format, a CSV format that includes
     *         customs attributes in a header, and a JSON format that includes custom attributes.</p>
     *         <p>
     *         The default format is CSV.
     *         </p>
     *         <p>
     *         The format must match the format of the file stored in the S3 bucket identified in the
     *         <code>S3Path</code> parameter.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/kendra/latest/dg/in-creating-faq.html">Adding questions and
     *         answers</a>.
     * @see FaqFileFormat
     */
    public final FaqFileFormat fileFormat() {
        return FaqFileFormat.fromValue(fileFormat);
    }

    /**
     * <p>
     * The format of the FAQ input file. You can choose between a basic CSV format, a CSV format that includes customs
     * attributes in a header, and a JSON format that includes custom attributes.
     * </p>
     * <p>
     * The default format is CSV.
     * </p>
     * <p>
     * The format must match the format of the file stored in the S3 bucket identified in the <code>S3Path</code>
     * parameter.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/in-creating-faq.html">Adding
     * questions and answers</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fileFormat} will
     * return {@link FaqFileFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #fileFormatAsString}.
     * </p>
     * 
     * @return The format of the FAQ input file. You can choose between a basic CSV format, a CSV format that includes
     *         customs attributes in a header, and a JSON format that includes custom attributes.</p>
     *         <p>
     *         The default format is CSV.
     *         </p>
     *         <p>
     *         The format must match the format of the file stored in the S3 bucket identified in the
     *         <code>S3Path</code> parameter.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/kendra/latest/dg/in-creating-faq.html">Adding questions and
     *         answers</a>.
     * @see FaqFileFormat
     */
    public final String fileFormatAsString() {
        return fileFormat;
    }

    /**
     * <p>
     * A token that you provide to identify the request to create a FAQ. Multiple calls to the
     * <code>CreateFaqRequest</code> API with the same client token will create only one FAQ.
     * </p>
     * 
     * @return A token that you provide to identify the request to create a FAQ. Multiple calls to the
     *         <code>CreateFaqRequest</code> API with the same client token will create only one FAQ.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The code for a language. This allows you to support a language for the FAQ document. English is supported by
     * default. For more information on supported languages, including their codes, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/in-adding-languages.html">Adding documents in languages other
     * than English</a>.
     * </p>
     * 
     * @return The code for a language. This allows you to support a language for the FAQ document. English is supported
     *         by default. For more information on supported languages, including their codes, see <a
     *         href="https://docs.aws.amazon.com/kendra/latest/dg/in-adding-languages.html">Adding documents in
     *         languages other than English</a>.
     */
    public final String languageCode() {
        return languageCode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(indexId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(s3Path());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(fileFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(languageCode());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateFaqRequest)) {
            return false;
        }
        CreateFaqRequest other = (CreateFaqRequest) obj;
        return Objects.equals(indexId(), other.indexId()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description()) && Objects.equals(s3Path(), other.s3Path())
                && Objects.equals(roleArn(), other.roleArn()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(fileFormatAsString(), other.fileFormatAsString())
                && Objects.equals(clientToken(), other.clientToken()) && Objects.equals(languageCode(), other.languageCode());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateFaqRequest").add("IndexId", indexId()).add("Name", name())
                .add("Description", description()).add("S3Path", s3Path()).add("RoleArn", roleArn())
                .add("Tags", hasTags() ? tags() : null).add("FileFormat", fileFormatAsString()).add("ClientToken", clientToken())
                .add("LanguageCode", languageCode()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IndexId":
            return Optional.ofNullable(clazz.cast(indexId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "S3Path":
            return Optional.ofNullable(clazz.cast(s3Path()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "FileFormat":
            return Optional.ofNullable(clazz.cast(fileFormatAsString()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "LanguageCode":
            return Optional.ofNullable(clazz.cast(languageCode()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("IndexId", INDEX_ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("S3Path", S3_PATH_FIELD);
        map.put("RoleArn", ROLE_ARN_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("FileFormat", FILE_FORMAT_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("LanguageCode", LANGUAGE_CODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateFaqRequest, T> g) {
        return obj -> g.apply((CreateFaqRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KendraRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateFaqRequest> {
        /**
         * <p>
         * The identifier of the index for the FAQ.
         * </p>
         * 
         * @param indexId
         *        The identifier of the index for the FAQ.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexId(String indexId);

        /**
         * <p>
         * A name for the FAQ.
         * </p>
         * 
         * @param name
         *        A name for the FAQ.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A description for the FAQ.
         * </p>
         * 
         * @param description
         *        A description for the FAQ.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The path to the FAQ file in S3.
         * </p>
         * 
         * @param s3Path
         *        The path to the FAQ file in S3.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Path(S3Path s3Path);

        /**
         * <p>
         * The path to the FAQ file in S3.
         * </p>
         * This is a convenience method that creates an instance of the {@link S3Path.Builder} avoiding the need to
         * create one manually via {@link S3Path#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3Path.Builder#build()} is called immediately and its result is
         * passed to {@link #s3Path(S3Path)}.
         * 
         * @param s3Path
         *        a consumer that will call methods on {@link S3Path.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3Path(S3Path)
         */
        default Builder s3Path(Consumer<S3Path.Builder> s3Path) {
            return s3Path(S3Path.builder().applyMutation(s3Path).build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) of an IAM role with permission to access the S3 bucket that contains the FAQ
         * file. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html">IAM
         * access roles for Amazon Kendra</a>.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of an IAM role with permission to access the S3 bucket that contains
         *        the FAQ file. For more information, see <a
         *        href="https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html">IAM access roles for Amazon
         *        Kendra</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * A list of key-value pairs that identify the FAQ. You can use the tags to identify and organize your resources
         * and to control access to resources.
         * </p>
         * 
         * @param tags
         *        A list of key-value pairs that identify the FAQ. You can use the tags to identify and organize your
         *        resources and to control access to resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * A list of key-value pairs that identify the FAQ. You can use the tags to identify and organize your resources
         * and to control access to resources.
         * </p>
         * 
         * @param tags
         *        A list of key-value pairs that identify the FAQ. You can use the tags to identify and organize your
         *        resources and to control access to resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * A list of key-value pairs that identify the FAQ. You can use the tags to identify and organize your resources
         * and to control access to resources.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.kendra.model.Tag.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.kendra.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.kendra.model.Tag.Builder#build()}
         * is called immediately and its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.kendra.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * The format of the FAQ input file. You can choose between a basic CSV format, a CSV format that includes
         * customs attributes in a header, and a JSON format that includes custom attributes.
         * </p>
         * <p>
         * The default format is CSV.
         * </p>
         * <p>
         * The format must match the format of the file stored in the S3 bucket identified in the <code>S3Path</code>
         * parameter.
         * </p>
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/in-creating-faq.html">Adding
         * questions and answers</a>.
         * </p>
         * 
         * @param fileFormat
         *        The format of the FAQ input file. You can choose between a basic CSV format, a CSV format that
         *        includes customs attributes in a header, and a JSON format that includes custom attributes.</p>
         *        <p>
         *        The default format is CSV.
         *        </p>
         *        <p>
         *        The format must match the format of the file stored in the S3 bucket identified in the
         *        <code>S3Path</code> parameter.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/kendra/latest/dg/in-creating-faq.html">Adding questions and
         *        answers</a>.
         * @see FaqFileFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FaqFileFormat
         */
        Builder fileFormat(String fileFormat);

        /**
         * <p>
         * The format of the FAQ input file. You can choose between a basic CSV format, a CSV format that includes
         * customs attributes in a header, and a JSON format that includes custom attributes.
         * </p>
         * <p>
         * The default format is CSV.
         * </p>
         * <p>
         * The format must match the format of the file stored in the S3 bucket identified in the <code>S3Path</code>
         * parameter.
         * </p>
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/in-creating-faq.html">Adding
         * questions and answers</a>.
         * </p>
         * 
         * @param fileFormat
         *        The format of the FAQ input file. You can choose between a basic CSV format, a CSV format that
         *        includes customs attributes in a header, and a JSON format that includes custom attributes.</p>
         *        <p>
         *        The default format is CSV.
         *        </p>
         *        <p>
         *        The format must match the format of the file stored in the S3 bucket identified in the
         *        <code>S3Path</code> parameter.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/kendra/latest/dg/in-creating-faq.html">Adding questions and
         *        answers</a>.
         * @see FaqFileFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FaqFileFormat
         */
        Builder fileFormat(FaqFileFormat fileFormat);

        /**
         * <p>
         * A token that you provide to identify the request to create a FAQ. Multiple calls to the
         * <code>CreateFaqRequest</code> API with the same client token will create only one FAQ.
         * </p>
         * 
         * @param clientToken
         *        A token that you provide to identify the request to create a FAQ. Multiple calls to the
         *        <code>CreateFaqRequest</code> API with the same client token will create only one FAQ.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The code for a language. This allows you to support a language for the FAQ document. English is supported by
         * default. For more information on supported languages, including their codes, see <a
         * href="https://docs.aws.amazon.com/kendra/latest/dg/in-adding-languages.html">Adding documents in languages
         * other than English</a>.
         * </p>
         * 
         * @param languageCode
         *        The code for a language. This allows you to support a language for the FAQ document. English is
         *        supported by default. For more information on supported languages, including their codes, see <a
         *        href="https://docs.aws.amazon.com/kendra/latest/dg/in-adding-languages.html">Adding documents in
         *        languages other than English</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder languageCode(String languageCode);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends KendraRequest.BuilderImpl implements Builder {
        private String indexId;

        private String name;

        private String description;

        private S3Path s3Path;

        private String roleArn;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private String fileFormat;

        private String clientToken;

        private String languageCode;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateFaqRequest model) {
            super(model);
            indexId(model.indexId);
            name(model.name);
            description(model.description);
            s3Path(model.s3Path);
            roleArn(model.roleArn);
            tags(model.tags);
            fileFormat(model.fileFormat);
            clientToken(model.clientToken);
            languageCode(model.languageCode);
        }

        public final String getIndexId() {
            return indexId;
        }

        public final void setIndexId(String indexId) {
            this.indexId = indexId;
        }

        @Override
        public final Builder indexId(String indexId) {
            this.indexId = indexId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final S3Path.Builder getS3Path() {
            return s3Path != null ? s3Path.toBuilder() : null;
        }

        public final void setS3Path(S3Path.BuilderImpl s3Path) {
            this.s3Path = s3Path != null ? s3Path.build() : null;
        }

        @Override
        public final Builder s3Path(S3Path s3Path) {
            this.s3Path = s3Path;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getFileFormat() {
            return fileFormat;
        }

        public final void setFileFormat(String fileFormat) {
            this.fileFormat = fileFormat;
        }

        @Override
        public final Builder fileFormat(String fileFormat) {
            this.fileFormat = fileFormat;
            return this;
        }

        @Override
        public final Builder fileFormat(FaqFileFormat fileFormat) {
            this.fileFormat(fileFormat == null ? null : fileFormat.toString());
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getLanguageCode() {
            return languageCode;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        @Override
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateFaqRequest build() {
            return new CreateFaqRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
