/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateFeaturedResultsSetResponse extends KendraResponse implements
        ToCopyableBuilder<CreateFeaturedResultsSetResponse.Builder, CreateFeaturedResultsSetResponse> {
    private static final SdkField<FeaturedResultsSet> FEATURED_RESULTS_SET_FIELD = SdkField
            .<FeaturedResultsSet> builder(MarshallingType.SDK_POJO).memberName("FeaturedResultsSet")
            .getter(getter(CreateFeaturedResultsSetResponse::featuredResultsSet)).setter(setter(Builder::featuredResultsSet))
            .constructor(FeaturedResultsSet::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeaturedResultsSet").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FEATURED_RESULTS_SET_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final FeaturedResultsSet featuredResultsSet;

    private CreateFeaturedResultsSetResponse(BuilderImpl builder) {
        super(builder);
        this.featuredResultsSet = builder.featuredResultsSet;
    }

    /**
     * <p>
     * Information on the set of featured results. This includes the identifier of the featured results set, whether the
     * featured results set is active or inactive, when the featured results set was created, and more.
     * </p>
     * 
     * @return Information on the set of featured results. This includes the identifier of the featured results set,
     *         whether the featured results set is active or inactive, when the featured results set was created, and
     *         more.
     */
    public final FeaturedResultsSet featuredResultsSet() {
        return featuredResultsSet;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(featuredResultsSet());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateFeaturedResultsSetResponse)) {
            return false;
        }
        CreateFeaturedResultsSetResponse other = (CreateFeaturedResultsSetResponse) obj;
        return Objects.equals(featuredResultsSet(), other.featuredResultsSet());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateFeaturedResultsSetResponse").add("FeaturedResultsSet", featuredResultsSet()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FeaturedResultsSet":
            return Optional.ofNullable(clazz.cast(featuredResultsSet()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FeaturedResultsSet", FEATURED_RESULTS_SET_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateFeaturedResultsSetResponse, T> g) {
        return obj -> g.apply((CreateFeaturedResultsSetResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KendraResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateFeaturedResultsSetResponse> {
        /**
         * <p>
         * Information on the set of featured results. This includes the identifier of the featured results set, whether
         * the featured results set is active or inactive, when the featured results set was created, and more.
         * </p>
         * 
         * @param featuredResultsSet
         *        Information on the set of featured results. This includes the identifier of the featured results set,
         *        whether the featured results set is active or inactive, when the featured results set was created, and
         *        more.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder featuredResultsSet(FeaturedResultsSet featuredResultsSet);

        /**
         * <p>
         * Information on the set of featured results. This includes the identifier of the featured results set, whether
         * the featured results set is active or inactive, when the featured results set was created, and more.
         * </p>
         * This is a convenience method that creates an instance of the {@link FeaturedResultsSet.Builder} avoiding the
         * need to create one manually via {@link FeaturedResultsSet#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FeaturedResultsSet.Builder#build()} is called immediately and its
         * result is passed to {@link #featuredResultsSet(FeaturedResultsSet)}.
         * 
         * @param featuredResultsSet
         *        a consumer that will call methods on {@link FeaturedResultsSet.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #featuredResultsSet(FeaturedResultsSet)
         */
        default Builder featuredResultsSet(Consumer<FeaturedResultsSet.Builder> featuredResultsSet) {
            return featuredResultsSet(FeaturedResultsSet.builder().applyMutation(featuredResultsSet).build());
        }
    }

    static final class BuilderImpl extends KendraResponse.BuilderImpl implements Builder {
        private FeaturedResultsSet featuredResultsSet;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateFeaturedResultsSetResponse model) {
            super(model);
            featuredResultsSet(model.featuredResultsSet);
        }

        public final FeaturedResultsSet.Builder getFeaturedResultsSet() {
            return featuredResultsSet != null ? featuredResultsSet.toBuilder() : null;
        }

        public final void setFeaturedResultsSet(FeaturedResultsSet.BuilderImpl featuredResultsSet) {
            this.featuredResultsSet = featuredResultsSet != null ? featuredResultsSet.build() : null;
        }

        @Override
        public final Builder featuredResultsSet(FeaturedResultsSet featuredResultsSet) {
            this.featuredResultsSet = featuredResultsSet;
            return this;
        }

        @Override
        public CreateFeaturedResultsSetResponse build() {
            return new CreateFeaturedResultsSetResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
