/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Data source information for user context filtering.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataSourceGroup implements SdkPojo, Serializable, ToCopyableBuilder<DataSourceGroup.Builder, DataSourceGroup> {
    private static final SdkField<String> GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GroupId").getter(getter(DataSourceGroup::groupId)).setter(setter(Builder::groupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupId").build()).build();

    private static final SdkField<String> DATA_SOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataSourceId").getter(getter(DataSourceGroup::dataSourceId)).setter(setter(Builder::dataSourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSourceId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_ID_FIELD,
            DATA_SOURCE_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String groupId;

    private final String dataSourceId;

    private DataSourceGroup(BuilderImpl builder) {
        this.groupId = builder.groupId;
        this.dataSourceId = builder.dataSourceId;
    }

    /**
     * <p>
     * The identifier of the group you want to add to your list of groups. This is for filtering search results based on
     * the groups' access to documents.
     * </p>
     * 
     * @return The identifier of the group you want to add to your list of groups. This is for filtering search results
     *         based on the groups' access to documents.
     */
    public final String groupId() {
        return groupId;
    }

    /**
     * <p>
     * The identifier of the data source group you want to add to your list of data source groups. This is for filtering
     * search results based on the groups' access to documents in that data source.
     * </p>
     * 
     * @return The identifier of the data source group you want to add to your list of data source groups. This is for
     *         filtering search results based on the groups' access to documents in that data source.
     */
    public final String dataSourceId() {
        return dataSourceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(groupId());
        hashCode = 31 * hashCode + Objects.hashCode(dataSourceId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataSourceGroup)) {
            return false;
        }
        DataSourceGroup other = (DataSourceGroup) obj;
        return Objects.equals(groupId(), other.groupId()) && Objects.equals(dataSourceId(), other.dataSourceId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataSourceGroup").add("GroupId", groupId()).add("DataSourceId", dataSourceId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GroupId":
            return Optional.ofNullable(clazz.cast(groupId()));
        case "DataSourceId":
            return Optional.ofNullable(clazz.cast(dataSourceId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("GroupId", GROUP_ID_FIELD);
        map.put("DataSourceId", DATA_SOURCE_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataSourceGroup, T> g) {
        return obj -> g.apply((DataSourceGroup) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataSourceGroup> {
        /**
         * <p>
         * The identifier of the group you want to add to your list of groups. This is for filtering search results
         * based on the groups' access to documents.
         * </p>
         * 
         * @param groupId
         *        The identifier of the group you want to add to your list of groups. This is for filtering search
         *        results based on the groups' access to documents.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupId(String groupId);

        /**
         * <p>
         * The identifier of the data source group you want to add to your list of data source groups. This is for
         * filtering search results based on the groups' access to documents in that data source.
         * </p>
         * 
         * @param dataSourceId
         *        The identifier of the data source group you want to add to your list of data source groups. This is
         *        for filtering search results based on the groups' access to documents in that data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSourceId(String dataSourceId);
    }

    static final class BuilderImpl implements Builder {
        private String groupId;

        private String dataSourceId;

        private BuilderImpl() {
        }

        private BuilderImpl(DataSourceGroup model) {
            groupId(model.groupId);
            dataSourceId(model.dataSourceId);
        }

        public final String getGroupId() {
            return groupId;
        }

        public final void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        @Override
        public final Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public final String getDataSourceId() {
            return dataSourceId;
        }

        public final void setDataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
        }

        @Override
        public final Builder dataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
            return this;
        }

        @Override
        public DataSourceGroup build() {
            return new DataSourceGroup(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
