/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeletePrincipalMappingRequest extends KendraRequest implements
        ToCopyableBuilder<DeletePrincipalMappingRequest.Builder, DeletePrincipalMappingRequest> {
    private static final SdkField<String> INDEX_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IndexId").getter(getter(DeletePrincipalMappingRequest::indexId)).setter(setter(Builder::indexId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexId").build()).build();

    private static final SdkField<String> DATA_SOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataSourceId").getter(getter(DeletePrincipalMappingRequest::dataSourceId))
            .setter(setter(Builder::dataSourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSourceId").build()).build();

    private static final SdkField<String> GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GroupId").getter(getter(DeletePrincipalMappingRequest::groupId)).setter(setter(Builder::groupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupId").build()).build();

    private static final SdkField<Long> ORDERING_ID_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("OrderingId").getter(getter(DeletePrincipalMappingRequest::orderingId))
            .setter(setter(Builder::orderingId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrderingId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INDEX_ID_FIELD,
            DATA_SOURCE_ID_FIELD, GROUP_ID_FIELD, ORDERING_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String indexId;

    private final String dataSourceId;

    private final String groupId;

    private final Long orderingId;

    private DeletePrincipalMappingRequest(BuilderImpl builder) {
        super(builder);
        this.indexId = builder.indexId;
        this.dataSourceId = builder.dataSourceId;
        this.groupId = builder.groupId;
        this.orderingId = builder.orderingId;
    }

    /**
     * <p>
     * The identifier of the index you want to delete a group from.
     * </p>
     * 
     * @return The identifier of the index you want to delete a group from.
     */
    public final String indexId() {
        return indexId;
    }

    /**
     * <p>
     * The identifier of the data source you want to delete a group from.
     * </p>
     * <p>
     * A group can be tied to multiple data sources. You can delete a group from accessing documents in a certain data
     * source. For example, the groups "Research", "Engineering", and "Sales and Marketing" are all tied to the
     * company's documents stored in the data sources Confluence and Salesforce. You want to delete "Research" and
     * "Engineering" groups from Salesforce, so that these groups cannot access customer-related documents stored in
     * Salesforce. Only "Sales and Marketing" should access documents in the Salesforce data source.
     * </p>
     * 
     * @return The identifier of the data source you want to delete a group from.</p>
     *         <p>
     *         A group can be tied to multiple data sources. You can delete a group from accessing documents in a
     *         certain data source. For example, the groups "Research", "Engineering", and "Sales and Marketing" are all
     *         tied to the company's documents stored in the data sources Confluence and Salesforce. You want to delete
     *         "Research" and "Engineering" groups from Salesforce, so that these groups cannot access customer-related
     *         documents stored in Salesforce. Only "Sales and Marketing" should access documents in the Salesforce data
     *         source.
     */
    public final String dataSourceId() {
        return dataSourceId;
    }

    /**
     * <p>
     * The identifier of the group you want to delete.
     * </p>
     * 
     * @return The identifier of the group you want to delete.
     */
    public final String groupId() {
        return groupId;
    }

    /**
     * <p>
     * The timestamp identifier you specify to ensure Amazon Kendra does not override the latest <code>DELETE</code>
     * action with previous actions. The highest number ID, which is the ordering ID, is the latest action you want to
     * process and apply on top of other actions with lower number IDs. This prevents previous actions with lower number
     * IDs from possibly overriding the latest action.
     * </p>
     * <p>
     * The ordering ID can be the Unix time of the last update you made to a group members list. You would then provide
     * this list when calling <code>PutPrincipalMapping</code>. This ensures your <code>DELETE</code> action for that
     * updated group with the latest members list doesn't get overwritten by earlier <code>DELETE</code> actions for the
     * same group which are yet to be processed.
     * </p>
     * <p>
     * The default ordering ID is the current Unix time in milliseconds that the action was received by Amazon Kendra.
     * </p>
     * 
     * @return The timestamp identifier you specify to ensure Amazon Kendra does not override the latest
     *         <code>DELETE</code> action with previous actions. The highest number ID, which is the ordering ID, is the
     *         latest action you want to process and apply on top of other actions with lower number IDs. This prevents
     *         previous actions with lower number IDs from possibly overriding the latest action.</p>
     *         <p>
     *         The ordering ID can be the Unix time of the last update you made to a group members list. You would then
     *         provide this list when calling <code>PutPrincipalMapping</code>. This ensures your <code>DELETE</code>
     *         action for that updated group with the latest members list doesn't get overwritten by earlier
     *         <code>DELETE</code> actions for the same group which are yet to be processed.
     *         </p>
     *         <p>
     *         The default ordering ID is the current Unix time in milliseconds that the action was received by Amazon
     *         Kendra.
     */
    public final Long orderingId() {
        return orderingId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(indexId());
        hashCode = 31 * hashCode + Objects.hashCode(dataSourceId());
        hashCode = 31 * hashCode + Objects.hashCode(groupId());
        hashCode = 31 * hashCode + Objects.hashCode(orderingId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeletePrincipalMappingRequest)) {
            return false;
        }
        DeletePrincipalMappingRequest other = (DeletePrincipalMappingRequest) obj;
        return Objects.equals(indexId(), other.indexId()) && Objects.equals(dataSourceId(), other.dataSourceId())
                && Objects.equals(groupId(), other.groupId()) && Objects.equals(orderingId(), other.orderingId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeletePrincipalMappingRequest").add("IndexId", indexId()).add("DataSourceId", dataSourceId())
                .add("GroupId", groupId()).add("OrderingId", orderingId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IndexId":
            return Optional.ofNullable(clazz.cast(indexId()));
        case "DataSourceId":
            return Optional.ofNullable(clazz.cast(dataSourceId()));
        case "GroupId":
            return Optional.ofNullable(clazz.cast(groupId()));
        case "OrderingId":
            return Optional.ofNullable(clazz.cast(orderingId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("IndexId", INDEX_ID_FIELD);
        map.put("DataSourceId", DATA_SOURCE_ID_FIELD);
        map.put("GroupId", GROUP_ID_FIELD);
        map.put("OrderingId", ORDERING_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeletePrincipalMappingRequest, T> g) {
        return obj -> g.apply((DeletePrincipalMappingRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KendraRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeletePrincipalMappingRequest> {
        /**
         * <p>
         * The identifier of the index you want to delete a group from.
         * </p>
         * 
         * @param indexId
         *        The identifier of the index you want to delete a group from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexId(String indexId);

        /**
         * <p>
         * The identifier of the data source you want to delete a group from.
         * </p>
         * <p>
         * A group can be tied to multiple data sources. You can delete a group from accessing documents in a certain
         * data source. For example, the groups "Research", "Engineering", and "Sales and Marketing" are all tied to the
         * company's documents stored in the data sources Confluence and Salesforce. You want to delete "Research" and
         * "Engineering" groups from Salesforce, so that these groups cannot access customer-related documents stored in
         * Salesforce. Only "Sales and Marketing" should access documents in the Salesforce data source.
         * </p>
         * 
         * @param dataSourceId
         *        The identifier of the data source you want to delete a group from.</p>
         *        <p>
         *        A group can be tied to multiple data sources. You can delete a group from accessing documents in a
         *        certain data source. For example, the groups "Research", "Engineering", and "Sales and Marketing" are
         *        all tied to the company's documents stored in the data sources Confluence and Salesforce. You want to
         *        delete "Research" and "Engineering" groups from Salesforce, so that these groups cannot access
         *        customer-related documents stored in Salesforce. Only "Sales and Marketing" should access documents in
         *        the Salesforce data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSourceId(String dataSourceId);

        /**
         * <p>
         * The identifier of the group you want to delete.
         * </p>
         * 
         * @param groupId
         *        The identifier of the group you want to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupId(String groupId);

        /**
         * <p>
         * The timestamp identifier you specify to ensure Amazon Kendra does not override the latest <code>DELETE</code>
         * action with previous actions. The highest number ID, which is the ordering ID, is the latest action you want
         * to process and apply on top of other actions with lower number IDs. This prevents previous actions with lower
         * number IDs from possibly overriding the latest action.
         * </p>
         * <p>
         * The ordering ID can be the Unix time of the last update you made to a group members list. You would then
         * provide this list when calling <code>PutPrincipalMapping</code>. This ensures your <code>DELETE</code> action
         * for that updated group with the latest members list doesn't get overwritten by earlier <code>DELETE</code>
         * actions for the same group which are yet to be processed.
         * </p>
         * <p>
         * The default ordering ID is the current Unix time in milliseconds that the action was received by Amazon
         * Kendra.
         * </p>
         * 
         * @param orderingId
         *        The timestamp identifier you specify to ensure Amazon Kendra does not override the latest
         *        <code>DELETE</code> action with previous actions. The highest number ID, which is the ordering ID, is
         *        the latest action you want to process and apply on top of other actions with lower number IDs. This
         *        prevents previous actions with lower number IDs from possibly overriding the latest action.</p>
         *        <p>
         *        The ordering ID can be the Unix time of the last update you made to a group members list. You would
         *        then provide this list when calling <code>PutPrincipalMapping</code>. This ensures your
         *        <code>DELETE</code> action for that updated group with the latest members list doesn't get overwritten
         *        by earlier <code>DELETE</code> actions for the same group which are yet to be processed.
         *        </p>
         *        <p>
         *        The default ordering ID is the current Unix time in milliseconds that the action was received by
         *        Amazon Kendra.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder orderingId(Long orderingId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends KendraRequest.BuilderImpl implements Builder {
        private String indexId;

        private String dataSourceId;

        private String groupId;

        private Long orderingId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeletePrincipalMappingRequest model) {
            super(model);
            indexId(model.indexId);
            dataSourceId(model.dataSourceId);
            groupId(model.groupId);
            orderingId(model.orderingId);
        }

        public final String getIndexId() {
            return indexId;
        }

        public final void setIndexId(String indexId) {
            this.indexId = indexId;
        }

        @Override
        public final Builder indexId(String indexId) {
            this.indexId = indexId;
            return this;
        }

        public final String getDataSourceId() {
            return dataSourceId;
        }

        public final void setDataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
        }

        @Override
        public final Builder dataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
            return this;
        }

        public final String getGroupId() {
            return groupId;
        }

        public final void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        @Override
        public final Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public final Long getOrderingId() {
            return orderingId;
        }

        public final void setOrderingId(Long orderingId) {
            this.orderingId = orderingId;
        }

        @Override
        public final Builder orderingId(Long orderingId) {
            this.orderingId = orderingId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeletePrincipalMappingRequest build() {
            return new DeletePrincipalMappingRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
